"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KeyEquivalence = void 0;

/*
 * Wazuh app - Wazuh CSV column keys
 * Copyright (C) 2015-2022 Wazuh, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Find more information about this on the LICENSE file.
 */
const KeyEquivalence = {
  id: 'ID',
  timestamp: 'Timestamp',
  url: 'URL',
  version: 'Version',
  'os.name': 'OS name',
  'os.version': 'OS version',
  'os.arch': 'OS version architecture',
  'os.build': 'OS version build',
  'os.codename': 'OS code name',
  'os.major': 'OS version major',
  'os.minor': 'OS version minor',
  'os.platform': 'OS platform',
  'os.uname': 'OS uname',
  status: 'Status',
  group: 'Group',
  ip: 'IP',
  description: 'Description',
  tag: 'Tag',
  level: 'Level',
  conf_sum: 'Group checksum',
  merged_sum: 'Configuration checksum',
  hash: 'Checksum',
  filename: 'File',
  file: 'File',
  gdpr: 'GDPR',
  pci: 'PCI',
  hipaa: 'HIPAA',
  'nist-800-53': 'NIST 800-53',
  cis: 'CIS',
  event: 'Event',
  groups: 'Groups',
  name: 'Name',
  count: 'Count',
  'details.program_name': 'Program name',
  'details.order': 'Order',
  vendor: 'Vendor',
  type: 'Type',
  architecture: 'Architecture',
  node_name: 'Node',
  dateAdd: 'Registration date',
  manager_host: 'Manager',
  manager: 'Manager',
  lastKeepAlive: 'Last keep alive',
  os: 'OS',
  path: 'Path',
  details: 'Details',
  position: 'Position',
  configSum: 'Group checksum',
  mergedSum: 'Configuration checksum',
  key: 'Key',
  scan_id: 'Scan ID',
  format: 'Format',
  scan_time: 'Scan date',
  state: 'State',
  mac: 'MAC',
  gateway: 'Gateway',
  dhcp: 'DHCP',
  iface: 'Interface',
  broadcast: 'Broadcast',
  proto: 'Protocol',
  address: 'Address',
  protocol: 'Protocol',
  netmask: 'Netmask',
  'local.ip': 'Local IP',
  'remote.ip': 'Remote IP',
  'local.port': 'Local port',
  'remote.port': 'Remote port',
  euser: 'Effective user',
  egroup: 'Effective group',
  vm_size: 'VM size',
  processor: 'Processor',
  session: 'Session',
  tty: 'TTY',
  pid: 'PID',
  ppid: 'Parent PID',
  argvs: 'Argvs',
  nice: 'Priority',
  size: 'Size',
  uname: 'User',
  gname: 'Group',
  perm: 'Permissions',
  inode: 'Inode',
  uid: 'User ID',
  gid: 'Group ID',
  mtime: 'Last modified',
  priority: 'Priority',
  cmd: 'Command',
  nlwp: 'NLWP',
  process: 'Process',
  md5: 'MD5',
  sha1: 'SHA1',
  sha256: 'SHA256',
  title: 'Title',
  remediation: 'Remediation',
  references: 'References',
  result: 'Result',
  directory: 'Path(s)',
  rationale: 'Rationale',
  registry: 'Registry',
  date: 'Date',
  value: 'Value',
  location: 'Location',
  mtu: 'MTU',
  attributes: 'Attributes',
  policy_id: 'Policy ID',
  policy_ID: 'Policy ID',
  compliance: 'Compliance',
  rules: 'Rules',
  reason: 'Reason',
  registerIP: 'Register IP',
  hotfix: 'Update code',
  'scan.time': 'Registered by Wazuh at'
};
exports.KeyEquivalence = KeyEquivalence;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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