"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ErrorHandler = ErrorHandler;

var _logger = require("../../lib/logger");

var _getConfiguration = require("../../lib/get-configuration");

const DEBUG = 'debug';
const INFO = 'info';
const ERROR = 'error';

function logLevel(level) {
  return level === DEBUG ? INFO : level;
}

;

function ErrorHandler(error, serverLogger) {
  const {
    ['logs.level']: logsLevel
  } = (0, _getConfiguration.getConfiguration)();
  const errorLevel = ErrorLevels[error.error] || ERROR;
  (0, _logger.log)('Cron-scheduler', error, errorLevel === ERROR ? INFO : errorLevel);

  try {
    if (errorLevel === DEBUG && logsLevel !== DEBUG) return;
    serverLogger[logLevel(errorLevel)](`${error instanceof Error ? error.toString() : JSON.stringify(error)}`);
  } catch (error) {
    serverLogger[logLevel(errorLevel)](`Message too long to show in console output, check the log file`);
  }
}

const ErrorLevels = {
  401: INFO,
  403: ERROR,
  409: DEBUG,
  3005: INFO,
  3013: DEBUG,
  10001: INFO,
  10002: DEBUG,
  10003: DEBUG,
  10004: DEBUG,
  10005: DEBUG,
  10006: DEBUG,
  10007: DEBUG
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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