"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.arrayType = exports.arraySourceType = exports.arraySourceIP = exports.arraySeverity = exports.arrayRules = exports.arrayResponseCode = exports.arrayQueryType = exports.arrayQueryName = exports.arrayProtocol = exports.arrayProject = exports.arrayLocation = exports.arrayAuthAnswer = void 0;

/*
 * Wazuh app - GCP sample data
 * Copyright (C) 2015-2022 Wazuh, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Find more information about this on the LICENSE file.
 */
// GCP
const arrayAuthAnswer = ["true", "false"];
exports.arrayAuthAnswer = arrayAuthAnswer;
const arrayProtocol = ['UDP', 'TCP'];
exports.arrayProtocol = arrayProtocol;
const arrayQueryName = ['185.5.205.124.in-addr.arpa.', '98.72.244.104.in-addr.arpa.', 'mirrors.advancedhosters.com.', '41.212.95.203.in-addr.arpa', '41.212.95.203.in-addr.arpa.'];
exports.arrayQueryName = arrayQueryName;
const arrayQueryType = ['PTR', 'PTR', 'PTR', 'PTR', 'PTR', 'A'];
exports.arrayQueryType = arrayQueryType;
const arrayResponseCode = ['NXDOMAIN', 'NOERROR', 'WARNING', 'CRITICAL', 'ALERT', 'EMERGENCY', 'SERVFAIL', 'INFO', 'SUCCESS', 'BADTRUNC', 'BADNAME', 'NOTAUTH'];
exports.arrayResponseCode = arrayResponseCode;
const arraySourceIP = ['163.172.0.0', '1.33.213.199', '83.32.0.0', '154.84.246.205', '75.142.129.202', '171.197.217.149', '77.38.119.17'];
exports.arraySourceIP = arraySourceIP;
const arrayLocation = ['europe-west1', 'us-central1', 'asia-east1', 'australia-southeast1', 'us-west1', 'us-west3', 'us-west2', 'us-west4', 'us-east1', 'us-east2', 'us-east3', 'southamerica-east1'];
exports.arrayLocation = arrayLocation;
const arrayProject = ['wazuh-dev', 'wazuh-prod', 'wazuh-test'];
exports.arrayProject = arrayProject;
const arraySourceType = ['gce-vm', 'internet'];
exports.arraySourceType = arraySourceType;
const arraySeverity = ['ERROR', 'INFO', 'NOTICE', 'CRITICAL', 'EMERGENCY', 'ALERT'];
exports.arraySeverity = arraySeverity;
const arrayType = ['dns_query', 'app_script_function', 'generic_task'];
exports.arrayType = arrayType;
const arrayRules = [{
  level: 12,
  description: "Unable to process query due to a problem with the name server",
  id: "65007",
  firedtimes: 2,
  mail: true,
  groups: ["gcp"]
}, {
  level: 5,
  description: "GCP notice event",
  id: "65001",
  firedtimes: 1,
  mail: true,
  groups: ["gcp"]
}, {
  level: 3,
  description: "DNS external query",
  id: "65032",
  firedtimes: 1,
  mail: true,
  groups: ["gcp"]
}, {
  level: 5,
  description: "GCP warning event from VM 531339229531.instance-1 with source IP 83.32.0.0 from europe-west1",
  id: "65034",
  firedtimes: 1,
  mail: true,
  groups: ["gcp"]
}, {
  level: 9,
  description: "GCP critical event from VM 531339229531.instance-1 with source IP 83.32.0.0 from europe-west1",
  id: "65036",
  firedtimes: 4,
  mail: true,
  groups: ["gcp"]
}, {
  level: 11,
  description: "GCP alert event from VM 531339229531.instance-1 with source IP 83.32.0.0 from europe-west1",
  id: "65037",
  firedtimes: 1,
  mail: true,
  groups: ["gcp"]
}, {
  level: 12,
  description: "GCP emergency event from VM 531339229531.instance-1 with source IP 83.32.0.0 from europe-west1",
  id: "65038",
  firedtimes: 2,
  mail: true,
  groups: ["gcp"]
}, {
  level: 5,
  description: "GCP notice event with source IP 83.32.0.0 from europe-west1 with response code NXDOMAIN",
  id: "65010",
  firedtimes: 2,
  mail: true,
  groups: ["gcp"]
}];
exports.arrayRules = arrayRules;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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