"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initialWazuhConfig = void 0;

var _constants = require("../../common/constants");

/*
 * Wazuh app - Initial basic configuration file
 * Copyright (C) 2015-2022 Wazuh, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Find more information about this on the LICENSE file.
 */
const initialWazuhConfig = `---
#
# Wazuh app - App configuration file
# Copyright (C) 2015-2022 Wazuh, Inc.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Find more information about this on the LICENSE file.
#
# ======================== Wazuh app configuration file ========================
#
# Please check the documentation for more information on configuration options:
# https://documentation.wazuh.com/current/installation-guide/index.html
#
# Also, you can check our repository:
# https://github.com/wazuh/wazuh-kibana-app
#
# ------------------------------- Disable roles -------------------------------
#
# Defines which Elasticsearch roles disable Wazuh
# disabled_roles: 
#      - wazuh_disabled
#
# ------------------------------- Index patterns -------------------------------
#
# Default index pattern to use.
#pattern: wazuh-alerts-*
#
# ----------------------------------- Checks -----------------------------------
#
# Defines which checks must to be consider by the healthcheck
# step once the Wazuh app starts. Values must to be true or false.
#checks.pattern : true
#checks.template: true
#checks.fields  : true
#checks.api     : true
#checks.setup   : true
#checks.metaFields: true
#checks.timeFilter: true
#checks.maxBuckets: true
#
# --------------------------------- Extensions ---------------------------------
#
# Defines which extensions should be activated when you add a new API entry.
# You can change them after Wazuh app starts.
# Values must to be true or false.
#extensions.pci       : true
#extensions.gdpr      : true
#extensions.hipaa     : true
#extensions.nist      : true
#extensions.tsc       : true
#extensions.audit     : true
#extensions.oscap     : false
#extensions.ciscat    : false
#extensions.aws       : false
#extensions.gcp       : false
#extensions.virustotal: false
#extensions.osquery   : false
#extensions.docker    : false
#
# ---------------------------------- Timeout ----------------------------------
#
# Defines maximum timeout to be used on the Wazuh app requests.
# It will be ignored if it is bellow 1500.
# It means milliseconds before we consider a request as failed.
# Default: 20000
#timeout: 20000
#
# -------------------------------- API selector --------------------------------
#
# Defines if the user is allowed to change the selected
# API directly from the Wazuh app top menu.
# Default: true
#api.selector: true
#
# --------------------------- Index pattern selector ---------------------------
#
# Defines if the user is allowed to change the selected
# index pattern directly from the Wazuh app top menu.
# Default: true
#ip.selector: true
#
# List of index patterns to be ignored
#ip.ignore: []
#
# -------------------------------- X-Pack RBAC ---------------------------------
#
# Custom setting to enable/disable built-in X-Pack RBAC security capabilities.
# Default: enabled
#xpack.rbac.enabled: true
#
# ------------------------------ wazuh-monitoring ------------------------------
#
# Custom setting to enable/disable wazuh-monitoring indices.
# Values: true, false, worker
# If worker is given as value, the app will show the Agents status
# visualization but won't insert data on wazuh-monitoring indices.
# Default: true
#wazuh.monitoring.enabled: true
#
# Custom setting to set the frequency for wazuh-monitoring indices cron task.
# Default: 900 (s)
#wazuh.monitoring.frequency: 900
#
# Configure wazuh-monitoring-* indices shards and replicas.
#wazuh.monitoring.shards: ${_constants.WAZUH_MONITORING_DEFAULT_INDICES_SHARDS}
#wazuh.monitoring.replicas: ${_constants.WAZUH_MONITORING_DEFAULT_INDICES_REPLICAS}
#
# Configure wazuh-monitoring-* indices custom creation interval.
# Values: h (hourly), d (daily), w (weekly), m (monthly)
# Default: w
#wazuh.monitoring.creation: w
#
# Default index pattern to use for Wazuh monitoring
#wazuh.monitoring.pattern: wazuh-monitoring-*
#
# --------------------------------- wazuh-cron ----------------------------------
#
# Customize the index prefix of predefined jobs
# This change is not retroactive, if you change it new indexes will be created
# cron.prefix: wazuh
#
# --------------------------------- wazuh-sample-alerts -------------------------
#
# Customize the index name prefix of sample alerts
# This change is not retroactive, if you change it new indexes will be created
# It should match with a valid index template to avoid unknown fields on
# dashboards
#alerts.sample.prefix: wazuh-alerts-4.x-
#
# ------------------------------ wazuh-statistics -------------------------------
#
# Custom setting to enable/disable statistics tasks.
#cron.statistics.status: true
#
# Enter the ID of the APIs you want to save data from, leave this empty to run
# the task on all configured APIs
#cron.statistics.apis: []
#
# Define the frequency of task execution using cron schedule expressions
#cron.statistics.interval: 0 */5 * * * *
#
# Define the name of the index in which the documents are to be saved.
#cron.statistics.index.name: statistics
#
# Define the interval in which the index will be created
#cron.statistics.index.creation: w
#
# Configure statistics indices shards and replicas.
#cron.statistics.shards: ${_constants.WAZUH_STATISTICS_DEFAULT_INDICES_SHARDS}
#cron.statistics.replicas: ${_constants.WAZUH_STATISTICS_DEFAULT_INDICES_REPLICAS}
#
# ------------------------------ wazuh-logo-customization -------------------------------
#
#Define the name of the app logo saved in the path ${_constants.ASSETS_BASE_URL_PREFIX}
#customization.logo.app: ''
#
#Define the name of the sidebar logo saved in the path ${_constants.ASSETS_BASE_URL_PREFIX}
#customization.logo.sidebar: ''
#
#Define the name of the health-check logo saved in the path ${_constants.ASSETS_BASE_URL_PREFIX}
#customization.logo.healthcheck: ''
#
#Define the name of the reports logo (.png) saved in the path ${_constants.ASSETS_BASE_URL_PREFIX}
#customization.logo.reports: ''
#
# ---------------------------- Hide manager alerts ------------------------------
# Hide the alerts of the manager in all dashboards and discover
#hideManagerAlerts: false
#
# ------------------------------- App logging level -----------------------------
# Set the logging level for the Wazuh App log files.
# Default value: info
# Allowed values: info, debug
#logs.level: info
#
# -------------------------------- Enrollment DNS -------------------------------
# Set the variable WAZUH_REGISTRATION_SERVER in agents deployment.
# Default value: ''
#enrollment.dns: ''
#
# Wazuh registration password
# Default value: ''
#enrollment.password: ''
#-------------------------------- API entries -----------------------------------
#The following configuration is the default structure to define an API entry.
#
#hosts:
#  - <id>:
      # URL
      # API url
      # url: http(s)://<url>

      # Port
      # API port
      # port: <port>

      # Username
      # API user's username
      # username: <username>

      # Password
      # API user's password
      # password: <password>

      # Run as
      # Define how the app user gets his/her app permissions.
      # Values:
      #   - true: use his/her authentication context. Require Wazuh API user allows run_as.
      #   - false or not defined: get same permissions of Wazuh API user.
      # run_as: <true|false>
hosts:
  - default:
     url: https://localhost
     port: 55000
     username: wazuh-wui
     password: wazuh-wui
     run_as: false
`;
exports.initialWazuhConfig = initialWazuhConfig;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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