"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.XpackFactory = void 0;

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _constants = require("../../../../common/constants");

class XpackFactory {
  constructor(security) {
    (0, _defineProperty2.default)(this, "platform", _constants.WAZUH_SECURITY_PLUGIN_XPACK_SECURITY);
    this.security = security;
  }

  async getCurrentUser(request) {
    try {
      const authContext = await this.security.authc.getCurrentUser(request);
      if (!authContext) return {
        username: 'elastic',
        authContext: {
          username: 'elastic'
        }
      };
      const username = this.getUserName(authContext);
      return {
        username,
        authContext
      };
    } catch (error) {
      throw error;
    }
  }

  getUserName(authContext) {
    return authContext['username'];
  }

}

exports.XpackFactory = XpackFactory;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInhwYWNrLWZhY3RvcnkudHMiXSwibmFtZXMiOlsiWHBhY2tGYWN0b3J5IiwiY29uc3RydWN0b3IiLCJzZWN1cml0eSIsIldBWlVIX1NFQ1VSSVRZX1BMVUdJTl9YUEFDS19TRUNVUklUWSIsImdldEN1cnJlbnRVc2VyIiwicmVxdWVzdCIsImF1dGhDb250ZXh0IiwiYXV0aGMiLCJ1c2VybmFtZSIsImdldFVzZXJOYW1lIiwiZXJyb3IiXSwibWFwcGluZ3MiOiI7Ozs7Ozs7Ozs7O0FBR0E7O0FBRU8sTUFBTUEsWUFBTixDQUErQztBQUVwREMsRUFBQUEsV0FBVyxDQUFTQyxRQUFULEVBQXdDO0FBQUEsb0RBRGhDQywrQ0FDZ0M7QUFBQSxTQUEvQkQsUUFBK0IsR0FBL0JBLFFBQStCO0FBQUU7O0FBRWpDLFFBQWRFLGNBQWMsQ0FBQ0MsT0FBRCxFQUF5QjtBQUMzQyxRQUFJO0FBQ0YsWUFBTUMsV0FBVyxHQUFHLE1BQU0sS0FBS0osUUFBTCxDQUFjSyxLQUFkLENBQW9CSCxjQUFwQixDQUFtQ0MsT0FBbkMsQ0FBMUI7QUFDQSxVQUFHLENBQUNDLFdBQUosRUFBaUIsT0FBTztBQUFDRSxRQUFBQSxRQUFRLEVBQUUsU0FBWDtBQUFzQkYsUUFBQUEsV0FBVyxFQUFFO0FBQUVFLFVBQUFBLFFBQVEsRUFBRTtBQUFaO0FBQW5DLE9BQVA7QUFDakIsWUFBTUEsUUFBUSxHQUFHLEtBQUtDLFdBQUwsQ0FBaUJILFdBQWpCLENBQWpCO0FBQ0EsYUFBTztBQUFDRSxRQUFBQSxRQUFEO0FBQVdGLFFBQUFBO0FBQVgsT0FBUDtBQUNELEtBTEQsQ0FLRSxPQUFPSSxLQUFQLEVBQWM7QUFDZCxZQUFNQSxLQUFOO0FBQ0Q7QUFDRjs7QUFFREQsRUFBQUEsV0FBVyxDQUFDSCxXQUFELEVBQWtCO0FBQzNCLFdBQU9BLFdBQVcsQ0FBQyxVQUFELENBQWxCO0FBQ0Q7O0FBakJtRCIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IElTZWN1cml0eUZhY3RvcnkgfSBmcm9tICcuLi8nXG5pbXBvcnQgeyBTZWN1cml0eVBsdWdpblNldHVwIH0gZnJvbSAneC1wYWNrL3BsdWdpbnMvc2VjdXJpdHkvc2VydmVyJztcbmltcG9ydCB7IEtpYmFuYVJlcXVlc3QgfSBmcm9tICdzcmMvY29yZS9zZXJ2ZXInO1xuaW1wb3J0IHsgV0FaVUhfU0VDVVJJVFlfUExVR0lOX1hQQUNLX1NFQ1VSSVRZIH0gZnJvbSAnLi4vLi4vLi4vLi4vY29tbW9uL2NvbnN0YW50cyc7XG5cbmV4cG9ydCBjbGFzcyBYcGFja0ZhY3RvcnkgaW1wbGVtZW50cyBJU2VjdXJpdHlGYWN0b3J5IHtcbiAgcGxhdGZvcm06IHN0cmluZyA9IFdBWlVIX1NFQ1VSSVRZX1BMVUdJTl9YUEFDS19TRUNVUklUWTtcbiAgY29uc3RydWN0b3IocHJpdmF0ZSBzZWN1cml0eTogU2VjdXJpdHlQbHVnaW5TZXR1cCkge31cblxuICBhc3luYyBnZXRDdXJyZW50VXNlcihyZXF1ZXN0OiBLaWJhbmFSZXF1ZXN0KSB7XG4gICAgdHJ5IHtcbiAgICAgIGNvbnN0IGF1dGhDb250ZXh0ID0gYXdhaXQgdGhpcy5zZWN1cml0eS5hdXRoYy5nZXRDdXJyZW50VXNlcihyZXF1ZXN0KTtcbiAgICAgIGlmKCFhdXRoQ29udGV4dCkgcmV0dXJuIHt1c2VybmFtZTogJ2VsYXN0aWMnLCBhdXRoQ29udGV4dDogeyB1c2VybmFtZTogJ2VsYXN0aWMnfX07XG4gICAgICBjb25zdCB1c2VybmFtZSA9IHRoaXMuZ2V0VXNlck5hbWUoYXV0aENvbnRleHQpO1xuICAgICAgcmV0dXJuIHt1c2VybmFtZSwgYXV0aENvbnRleHR9O1xuICAgIH0gY2F0Y2ggKGVycm9yKSB7XG4gICAgICB0aHJvdyBlcnJvcjsgXG4gICAgfVxuICB9XG5cbiAgZ2V0VXNlck5hbWUoYXV0aENvbnRleHQ6YW55KSB7XG4gICAgcmV0dXJuIGF1dGhDb250ZXh0Wyd1c2VybmFtZSddO1xuICB9XG59Il19