"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.tscRequirementsFile = void 0;

/*
 * Wazuh app - Module for TSC requirements
 * Copyright (C) 2015-2022 Wazuh, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Find more information about this on the LICENSE file.
 */
const tscRequirementsFile = {
  'A1.1': 'The entity maintains, monitors, and evaluates current processing capacity and use of system components (infrastructure, data, and software) to manage capacity demand and to enable the implementation of additional capacity to help meet its objectives.',
  'A1.2': 'The entity authorizes, designs, develops or acquires, implements, operates, approves, maintains, and monitors environmental protections, software, data backup processes, and recovery infrastructure to meet its objectives.',
  'CC5.1': 'The entity selects and develops control activities that contribute to the mitigation of risks to the achievement of objectives to acceptable levels.',
  'CC5.2': 'The entity also selects and develops general control activities over technology to support the achievement of objectives.',
  'CC6.1': "The entity implements logical access security software, infrastructure, and architectures over protected information assets to protect them from security events to meet the entity's objectives.",
  'CC6.2': 'Prior to issuing system credentials and granting system access, the entity registers and authorizes new internal and external users whose access is administered by the entity. For those users whose access is administered by the entity, user system credentials are removed when user access is no longer authorized.',
  'CC6.3': 'The entity authorizes, modifies, or removes access to data, software, functions, and other protected information assets based on roles, responsibilities, or the system design and changes, giving consideration to the concepts of least privilege and segregation of duties, to meet the entity’s objectives.',
  'CC6.4': 'The entity restricts physical access to facilities and protected information assets (for example, data center facilities, backup media storage, and other sensitive locations) to authorized personnel to meet the entity’s objectives',
  'CC6.6': 'The entity implements logical access security measures to protect against threats from sources outside its system boundaries.',
  'CC6.7': 'The entity restricts the transmission, movement, and removal of information to authorized internal and external users and processes, and protects it during transmission, movement, or removal to meet the entity’s objectives.',
  'CC6.8': 'The entity implements controls to prevent or detect and act upon the introduction of unauthorized or malicious software to meet the entity’s objectives.',
  'CC7.1': 'To meet its objectives, the entity uses detection and monitoring procedures to identify (1) changes to configurations that result in the introduction of new vulnerabilities, and (2) susceptibilities to newly discovered vulnerabilities.',
  'CC7.2': "The entity monitors system components and the operation of those components for anomalies that are indicative of malicious acts, natural disasters, and errors affecting the entity's ability to meet its objectives; anomalies are analyzed to determine whether they represent security events.",
  'CC7.3': 'The entity evaluates security events to determine whether they could or have resulted in a failure of the entity to meet its objectives (security incidents) and, if so, takes actions to prevent or address such failures.',
  'CC7.4': 'The entity responds to identified security incidents by executing a defined incident-response program to understand, contain, remediate, and communicate security incidents, as appropriate.',
  'CC8.1': 'The entity authorizes, designs, develops or acquires, configures, documents, tests, approves, and implements changes to infrastructure, data, software, and procedures to meet its objectives',
  'PI1.4': 'The entity implements policies and procedures to make available or deliver output completely, accurately, and timely in accordance with specifications to meet the entity’s objectives.',
  'PI1.5': 'The entity implements policies and procedures to store inputs, items in processing, and outputs completely, accurately, and timely in accordance with system specifications to meet the entity’s objectives.'
};
exports.tscRequirementsFile = tscRequirementsFile;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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