"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WAZUH_STATISTICS_DEFAULT_PREFIX = exports.WAZUH_STATISTICS_DEFAULT_NAME = exports.WAZUH_STATISTICS_DEFAULT_INDICES_SHARDS = exports.WAZUH_STATISTICS_DEFAULT_INDICES_REPLICAS = exports.WAZUH_STATISTICS_DEFAULT_FREQUENCY = exports.WAZUH_STATISTICS_DEFAULT_CRON_FREQ = exports.WAZUH_STATISTICS_DEFAULT_CREATION = exports.WAZUH_SECURITY_PLUGIN_XPACK_SECURITY = exports.WAZUH_SECURITY_PLUGIN_OPEN_DISTRO_FOR_ELASTICSEARCH = exports.WAZUH_SECURITY_PLUGINS = exports.WAZUH_SAMPLE_ALERT_PREFIX = exports.WAZUH_SAMPLE_ALERTS_INDEX_SHARDS = exports.WAZUH_SAMPLE_ALERTS_INDEX_REPLICAS = exports.WAZUH_SAMPLE_ALERTS_DEFAULT_NUMBER_ALERTS = exports.WAZUH_SAMPLE_ALERTS_CATEGORY_THREAT_DETECTION = exports.WAZUH_SAMPLE_ALERTS_CATEGORY_SECURITY = exports.WAZUH_SAMPLE_ALERTS_CATEGORY_AUDITING_POLICY_MONITORING = exports.WAZUH_SAMPLE_ALERTS_CATEGORIES_TYPE_ALERTS = exports.WAZUH_ROLE_ADMINISTRATOR_NAME = exports.WAZUH_ROLE_ADMINISTRATOR_ID = exports.WAZUH_QUEUE_CRON_FREQ = exports.WAZUH_PLUGIN_PLATFORM_TEMPLATE_NAME = exports.WAZUH_PLUGIN_PLATFORM_SETTING_TIME_FILTER = exports.WAZUH_PLUGIN_PLATFORM_SETTING_METAFIELDS = exports.WAZUH_PLUGIN_PLATFORM_SETTING_MAX_BUCKETS = exports.WAZUH_MONITORING_TEMPLATE_NAME = exports.WAZUH_MONITORING_PREFIX = exports.WAZUH_MONITORING_PATTERN = exports.WAZUH_MONITORING_DEFAULT_INDICES_SHARDS = exports.WAZUH_MONITORING_DEFAULT_INDICES_REPLICAS = exports.WAZUH_MONITORING_DEFAULT_FREQUENCY = exports.WAZUH_MONITORING_DEFAULT_ENABLED = exports.WAZUH_MONITORING_DEFAULT_CRON_FREQ = exports.WAZUH_MONITORING_DEFAULT_CREATION = exports.WAZUH_MODULES_ID = exports.WAZUH_MENU_TOOLS_SECTIONS_ID = exports.WAZUH_MENU_SETTINGS_SECTIONS_ID = exports.WAZUH_MENU_SECURITY_SECTIONS_ID = exports.WAZUH_MENU_MANAGEMENT_SECTIONS_ID = exports.WAZUH_LINK_SLACK = exports.WAZUH_LINK_GOOGLE_GROUPS = exports.WAZUH_LINK_GITHUB = exports.WAZUH_INDEX_TYPE_STATISTICS = exports.WAZUH_INDEX_TYPE_MONITORING = exports.WAZUH_INDEX_TYPE_ALERTS = exports.WAZUH_ERROR_DAEMONS_NOT_READY = exports.WAZUH_DEFAULT_APP_CONFIG = exports.WAZUH_DATA_PLUGIN_PLATFORM_BASE_ABSOLUTE_PATH = exports.WAZUH_DATA_LOGS_RAW_PATH = exports.WAZUH_DATA_LOGS_RAW_FILENAME = exports.WAZUH_DATA_LOGS_PLAIN_PATH = exports.WAZUH_DATA_LOGS_PLAIN_FILENAME = exports.WAZUH_DATA_LOGS_DIRECTORY_PATH = exports.WAZUH_DATA_DOWNLOADS_REPORTS_DIRECTORY_PATH = exports.WAZUH_DATA_DOWNLOADS_DIRECTORY_PATH = exports.WAZUH_DATA_CONFIG_REGISTRY_PATH = exports.WAZUH_DATA_CONFIG_DIRECTORY_PATH = exports.WAZUH_DATA_CONFIG_APP_PATH = exports.WAZUH_DATA_ABSOLUTE_PATH = exports.WAZUH_CONFIGURATION_SETTINGS_NEED_RESTART = exports.WAZUH_CONFIGURATION_SETTINGS_NEED_RELOAD = exports.WAZUH_CONFIGURATION_SETTINGS_NEED_HEALTH_CHECK = exports.WAZUH_CONFIGURATION_CACHE_TIME = exports.WAZUH_API_RESERVED_ID_LOWER_THAN = exports.WAZUH_ALERTS_PREFIX = exports.WAZUH_ALERTS_PATTERN = exports.WAZUH_AGENTS_OS_TYPE = exports.UI_TOAST_COLOR = exports.UI_ORDER_AGENT_STATUS = exports.UI_LOGGER_LEVELS = exports.UI_LABEL_NAME_AGENT_STATUS = exports.UI_COLOR_AGENT_STATUS = exports.REPORTS_PRIMARY_COLOR = exports.REPORTS_PAGE_HEADER_TEXT = exports.REPORTS_PAGE_FOOTER_TEXT = exports.REPORTS_LOGO_IMAGE_ASSETS_RELATIVE_PATH = exports.PLUGIN_VERSION_SHORT = exports.PLUGIN_VERSION = exports.PLUGIN_PLATFORM_WAZUH_DOCUMENTATION_URL_PATH_UPGRADE_PLATFORM = exports.PLUGIN_PLATFORM_WAZUH_DOCUMENTATION_URL_PATH_TROUBLESHOOTING = exports.PLUGIN_PLATFORM_WAZUH_DOCUMENTATION_URL_PATH_APP_CONFIGURATION = exports.PLUGIN_PLATFORM_URL_GUIDE_TITLE = exports.PLUGIN_PLATFORM_URL_GUIDE = exports.PLUGIN_PLATFORM_SETTING_NAME_TIME_FILTER = exports.PLUGIN_PLATFORM_SETTING_NAME_METAFIELDS = exports.PLUGIN_PLATFORM_SETTING_NAME_MAX_BUCKETS = exports.PLUGIN_PLATFORM_REQUEST_HEADERS = exports.PLUGIN_PLATFORM_NAME = exports.PLUGIN_PLATFORM_INSTALLATION_USER_GROUP = exports.PLUGIN_PLATFORM_INSTALLATION_USER = exports.PLUGIN_PLATFORM_BASE_INSTALLATION_PATH = exports.MAX_MB_LOG_FILES = exports.HEALTH_CHECK_REDIRECTION_TIME = exports.HEALTH_CHECK = exports.ELASTIC_NAME = exports.DOCUMENTATION_WEB_BASE_URL = exports.AUTHORIZED_AGENTS = exports.ASSETS_PUBLIC_URL = exports.ASSETS_BASE_URL_PREFIX = exports.API_NAME_AGENT_STATUS = void 0;
exports.WAZUH_UI_LOGS_RAW_PATH = exports.WAZUH_UI_LOGS_RAW_FILENAME = exports.WAZUH_UI_LOGS_PLAIN_PATH = exports.WAZUH_UI_LOGS_PLAIN_FILENAME = exports.WAZUH_STATISTICS_TEMPLATE_NAME = exports.WAZUH_STATISTICS_PATTERN = exports.WAZUH_STATISTICS_DEFAULT_STATUS = exports.WAZUH_STATISTICS_DEFAULT_PREFIX = exports.WAZUH_STATISTICS_DEFAULT_NAME = exports.WAZUH_STATISTICS_DEFAULT_INDICES_SHARDS = exports.WAZUH_STATISTICS_DEFAULT_INDICES_REPLICAS = exports.WAZUH_STATISTICS_DEFAULT_FREQUENCY = exports.WAZUH_STATISTICS_DEFAULT_CRON_FREQ = exports.WAZUH_STATISTICS_DEFAULT_CREATION = exports.WAZUH_SECURITY_PLUGIN_XPACK_SECURITY = exports.WAZUH_SECURITY_PLUGIN_OPEN_DISTRO_FOR_ELASTICSEARCH = exports.WAZUH_SECURITY_PLUGINS = exports.WAZUH_SAMPLE_ALERT_PREFIX = exports.WAZUH_SAMPLE_ALERTS_INDEX_SHARDS = exports.WAZUH_SAMPLE_ALERTS_INDEX_REPLICAS = exports.WAZUH_SAMPLE_ALERTS_DEFAULT_NUMBER_ALERTS = exports.WAZUH_SAMPLE_ALERTS_CATEGORY_THREAT_DETECTION = exports.WAZUH_SAMPLE_ALERTS_CATEGORY_SECURITY = exports.WAZUH_SAMPLE_ALERTS_CATEGORY_AUDITING_POLICY_MONITORING = exports.WAZUH_SAMPLE_ALERTS_CATEGORIES_TYPE_ALERTS = exports.WAZUH_ROLE_ADMINISTRATOR_NAME = exports.WAZUH_ROLE_ADMINISTRATOR_ID = exports.WAZUH_QUEUE_CRON_FREQ = exports.WAZUH_PLUGIN_PLATFORM_TEMPLATE_NAME = exports.WAZUH_PLUGIN_PLATFORM_SETTING_TIME_FILTER = exports.WAZUH_PLUGIN_PLATFORM_SETTING_METAFIELDS = exports.WAZUH_PLUGIN_PLATFORM_SETTING_MAX_BUCKETS = exports.WAZUH_MONITORING_TEMPLATE_NAME = exports.WAZUH_MONITORING_PREFIX = exports.WAZUH_MONITORING_PATTERN = exports.WAZUH_MONITORING_DEFAULT_INDICES_SHARDS = exports.WAZUH_MONITORING_DEFAULT_INDICES_REPLICAS = exports.WAZUH_MONITORING_DEFAULT_FREQUENCY = exports.WAZUH_MONITORING_DEFAULT_ENABLED = exports.WAZUH_MONITORING_DEFAULT_CRON_FREQ = exports.WAZUH_MONITORING_DEFAULT_CREATION = exports.WAZUH_MODULES_ID = exports.WAZUH_MENU_TOOLS_SECTIONS_ID = exports.WAZUH_MENU_SETTINGS_SECTIONS_ID = exports.WAZUH_MENU_SECURITY_SECTIONS_ID = exports.WAZUH_MENU_MANAGEMENT_SECTIONS_ID = exports.WAZUH_LINK_SLACK = exports.WAZUH_LINK_GOOGLE_GROUPS = exports.WAZUH_LINK_GITHUB = exports.WAZUH_INDEX_TYPE_STATISTICS = exports.WAZUH_INDEX_TYPE_MONITORING = exports.WAZUH_INDEX_TYPE_ALERTS = exports.WAZUH_ERROR_DAEMONS_NOT_READY = exports.WAZUH_DEFAULT_APP_CONFIG = exports.WAZUH_DATA_PLUGIN_PLATFORM_BASE_ABSOLUTE_PATH = exports.WAZUH_DATA_LOGS_RAW_PATH = exports.WAZUH_DATA_LOGS_RAW_FILENAME = exports.WAZUH_DATA_LOGS_PLAIN_PATH = exports.WAZUH_DATA_LOGS_PLAIN_FILENAME = exports.WAZUH_DATA_LOGS_DIRECTORY_PATH = exports.WAZUH_DATA_DOWNLOADS_REPORTS_DIRECTORY_PATH = exports.WAZUH_DATA_DOWNLOADS_DIRECTORY_PATH = exports.WAZUH_DATA_CONFIG_REGISTRY_PATH = exports.WAZUH_DATA_CONFIG_DIRECTORY_PATH = exports.WAZUH_DATA_CONFIG_APP_PATH = exports.WAZUH_DATA_ABSOLUTE_PATH = exports.WAZUH_CONFIGURATION_SETTINGS_NEED_RESTART = exports.WAZUH_CONFIGURATION_SETTINGS_NEED_RELOAD = exports.WAZUH_CONFIGURATION_SETTINGS_NEED_HEALTH_CHECK = exports.WAZUH_CONFIGURATION_CACHE_TIME = exports.WAZUH_API_RESERVED_ID_LOWER_THAN = exports.WAZUH_ALERTS_PREFIX = exports.WAZUH_ALERTS_PATTERN = exports.WAZUH_AGENTS_OS_TYPE = exports.UI_TOAST_COLOR = exports.UI_ORDER_AGENT_STATUS = exports.UI_LOGGER_LEVELS = exports.UI_LABEL_NAME_AGENT_STATUS = exports.UI_COLOR_AGENT_STATUS = exports.REPORTS_PRIMARY_COLOR = exports.REPORTS_PAGE_HEADER_TEXT = exports.REPORTS_PAGE_FOOTER_TEXT = exports.REPORTS_LOGO_IMAGE_ASSETS_RELATIVE_PATH = exports.PLUGIN_VERSION_SHORT = exports.PLUGIN_VERSION = exports.PLUGIN_PLATFORM_WAZUH_DOCUMENTATION_URL_PATH_UPGRADE_PLATFORM = exports.PLUGIN_PLATFORM_WAZUH_DOCUMENTATION_URL_PATH_TROUBLESHOOTING = exports.PLUGIN_PLATFORM_WAZUH_DOCUMENTATION_URL_PATH_APP_CONFIGURATION = exports.PLUGIN_PLATFORM_URL_GUIDE_TITLE = exports.PLUGIN_PLATFORM_URL_GUIDE = exports.PLUGIN_PLATFORM_SETTING_NAME_TIME_FILTER = exports.PLUGIN_PLATFORM_SETTING_NAME_METAFIELDS = exports.PLUGIN_PLATFORM_SETTING_NAME_MAX_BUCKETS = exports.PLUGIN_PLATFORM_REQUEST_HEADERS = exports.PLUGIN_PLATFORM_NAME = exports.PLUGIN_PLATFORM_INSTALLATION_USER_GROUP = exports.PLUGIN_PLATFORM_INSTALLATION_USER = exports.PLUGIN_PLATFORM_BASE_INSTALLATION_PATH = exports.MAX_MB_LOG_FILES = exports.HEALTH_CHECK_REDIRECTION_TIME = exports.HEALTH_CHECK = exports.ELASTIC_NAME = exports.DOCUMENTATION_WEB_BASE_URL = exports.AUTHORIZED_AGENTS = exports.ASSETS_PUBLIC_URL = exports.ASSETS_BASE_URL_PREFIX = exports.API_NAME_AGENT_STATUS = void 0;

var _path = _interopRequireDefault(require("path"));

var _package = require("../package.json");

/*
 * Wazuh app - Wazuh Constants file
 * Copyright (C) 2015-2022 Wazuh, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Find more information about this on the LICENSE file.
 */
// Plugin
const PLUGIN_VERSION = _package.version;
exports.PLUGIN_VERSION = PLUGIN_VERSION;

const PLUGIN_VERSION_SHORT = _package.version.split('.').splice(0, 2).join('.'); // Index patterns - Wazuh alerts


exports.PLUGIN_VERSION_SHORT = PLUGIN_VERSION_SHORT;
const WAZUH_INDEX_TYPE_ALERTS = 'alerts';
exports.WAZUH_INDEX_TYPE_ALERTS = WAZUH_INDEX_TYPE_ALERTS;
const WAZUH_ALERTS_PREFIX = 'wazuh-alerts-';
exports.WAZUH_ALERTS_PREFIX = WAZUH_ALERTS_PREFIX;
const WAZUH_ALERTS_PATTERN = 'wazuh-alerts-*'; // Job - Wazuh monitoring

exports.WAZUH_ALERTS_PATTERN = WAZUH_ALERTS_PATTERN;
const WAZUH_INDEX_TYPE_MONITORING = "monitoring";
exports.WAZUH_INDEX_TYPE_MONITORING = WAZUH_INDEX_TYPE_MONITORING;
const WAZUH_MONITORING_PREFIX = "wazuh-monitoring-";
exports.WAZUH_MONITORING_PREFIX = WAZUH_MONITORING_PREFIX;
const WAZUH_MONITORING_PATTERN = "wazuh-monitoring-*";
exports.WAZUH_MONITORING_PATTERN = WAZUH_MONITORING_PATTERN;
const WAZUH_MONITORING_TEMPLATE_NAME = "wazuh-agent";
exports.WAZUH_MONITORING_TEMPLATE_NAME = WAZUH_MONITORING_TEMPLATE_NAME;
const WAZUH_MONITORING_DEFAULT_INDICES_SHARDS = 1;
exports.WAZUH_MONITORING_DEFAULT_INDICES_SHARDS = WAZUH_MONITORING_DEFAULT_INDICES_SHARDS;
const WAZUH_MONITORING_DEFAULT_INDICES_REPLICAS = 0;
exports.WAZUH_MONITORING_DEFAULT_INDICES_REPLICAS = WAZUH_MONITORING_DEFAULT_INDICES_REPLICAS;
const WAZUH_MONITORING_DEFAULT_CREATION = 'w';
exports.WAZUH_MONITORING_DEFAULT_CREATION = WAZUH_MONITORING_DEFAULT_CREATION;
const WAZUH_MONITORING_DEFAULT_ENABLED = true;
exports.WAZUH_MONITORING_DEFAULT_ENABLED = WAZUH_MONITORING_DEFAULT_ENABLED;
const WAZUH_MONITORING_DEFAULT_FREQUENCY = 900;
exports.WAZUH_MONITORING_DEFAULT_FREQUENCY = WAZUH_MONITORING_DEFAULT_FREQUENCY;
const WAZUH_MONITORING_DEFAULT_CRON_FREQ = '0 * * * * *'; // Job - Wazuh statistics

exports.WAZUH_MONITORING_DEFAULT_CRON_FREQ = WAZUH_MONITORING_DEFAULT_CRON_FREQ;
const WAZUH_INDEX_TYPE_STATISTICS = "statistics";
exports.WAZUH_INDEX_TYPE_STATISTICS = WAZUH_INDEX_TYPE_STATISTICS;
const WAZUH_STATISTICS_DEFAULT_PREFIX = "wazuh";
exports.WAZUH_STATISTICS_DEFAULT_PREFIX = WAZUH_STATISTICS_DEFAULT_PREFIX;
const WAZUH_STATISTICS_DEFAULT_NAME = "statistics";
exports.WAZUH_STATISTICS_DEFAULT_NAME = WAZUH_STATISTICS_DEFAULT_NAME;
const WAZUH_STATISTICS_PATTERN = `${WAZUH_STATISTICS_DEFAULT_PREFIX}-${WAZUH_STATISTICS_DEFAULT_NAME}-*`;
exports.WAZUH_STATISTICS_PATTERN = WAZUH_STATISTICS_PATTERN;
const WAZUH_STATISTICS_TEMPLATE_NAME = `${WAZUH_STATISTICS_DEFAULT_PREFIX}-${WAZUH_STATISTICS_DEFAULT_NAME}`;
exports.WAZUH_STATISTICS_TEMPLATE_NAME = WAZUH_STATISTICS_TEMPLATE_NAME;
const WAZUH_STATISTICS_DEFAULT_INDICES_SHARDS = 1;
exports.WAZUH_STATISTICS_DEFAULT_INDICES_SHARDS = WAZUH_STATISTICS_DEFAULT_INDICES_SHARDS;
const WAZUH_STATISTICS_DEFAULT_INDICES_REPLICAS = 0;
exports.WAZUH_STATISTICS_DEFAULT_INDICES_REPLICAS = WAZUH_STATISTICS_DEFAULT_INDICES_REPLICAS;
const WAZUH_STATISTICS_DEFAULT_CREATION = 'w';
exports.WAZUH_STATISTICS_DEFAULT_CREATION = WAZUH_STATISTICS_DEFAULT_CREATION;
const WAZUH_STATISTICS_DEFAULT_STATUS = true;
exports.WAZUH_STATISTICS_DEFAULT_STATUS = WAZUH_STATISTICS_DEFAULT_STATUS;
const WAZUH_STATISTICS_DEFAULT_FREQUENCY = 900;
exports.WAZUH_STATISTICS_DEFAULT_FREQUENCY = WAZUH_STATISTICS_DEFAULT_FREQUENCY;
const WAZUH_STATISTICS_DEFAULT_CRON_FREQ = '0 */5 * * * *'; // Job - Wazuh initialize

exports.WAZUH_STATISTICS_DEFAULT_CRON_FREQ = WAZUH_STATISTICS_DEFAULT_CRON_FREQ;
const WAZUH_PLUGIN_PLATFORM_TEMPLATE_NAME = 'wazuh-kibana'; // Permissions

exports.WAZUH_PLUGIN_PLATFORM_TEMPLATE_NAME = WAZUH_PLUGIN_PLATFORM_TEMPLATE_NAME;
const WAZUH_ROLE_ADMINISTRATOR_ID = 1;
exports.WAZUH_ROLE_ADMINISTRATOR_ID = WAZUH_ROLE_ADMINISTRATOR_ID;
const WAZUH_ROLE_ADMINISTRATOR_NAME = 'administrator'; // Sample data

exports.WAZUH_ROLE_ADMINISTRATOR_NAME = WAZUH_ROLE_ADMINISTRATOR_NAME;
const WAZUH_SAMPLE_ALERT_PREFIX = 'wazuh-alerts-4.x-';
exports.WAZUH_SAMPLE_ALERT_PREFIX = WAZUH_SAMPLE_ALERT_PREFIX;
const WAZUH_SAMPLE_ALERTS_INDEX_SHARDS = 1;
exports.WAZUH_SAMPLE_ALERTS_INDEX_SHARDS = WAZUH_SAMPLE_ALERTS_INDEX_SHARDS;
const WAZUH_SAMPLE_ALERTS_INDEX_REPLICAS = 0;
exports.WAZUH_SAMPLE_ALERTS_INDEX_REPLICAS = WAZUH_SAMPLE_ALERTS_INDEX_REPLICAS;
const WAZUH_SAMPLE_ALERTS_CATEGORY_SECURITY = 'security';
exports.WAZUH_SAMPLE_ALERTS_CATEGORY_SECURITY = WAZUH_SAMPLE_ALERTS_CATEGORY_SECURITY;
const WAZUH_SAMPLE_ALERTS_CATEGORY_AUDITING_POLICY_MONITORING = 'auditing-policy-monitoring';
exports.WAZUH_SAMPLE_ALERTS_CATEGORY_AUDITING_POLICY_MONITORING = WAZUH_SAMPLE_ALERTS_CATEGORY_AUDITING_POLICY_MONITORING;
const WAZUH_SAMPLE_ALERTS_CATEGORY_THREAT_DETECTION = 'threat-detection';
exports.WAZUH_SAMPLE_ALERTS_CATEGORY_THREAT_DETECTION = WAZUH_SAMPLE_ALERTS_CATEGORY_THREAT_DETECTION;
const WAZUH_SAMPLE_ALERTS_DEFAULT_NUMBER_ALERTS = 3000;
exports.WAZUH_SAMPLE_ALERTS_DEFAULT_NUMBER_ALERTS = WAZUH_SAMPLE_ALERTS_DEFAULT_NUMBER_ALERTS;
const WAZUH_SAMPLE_ALERTS_CATEGORIES_TYPE_ALERTS = {
  [WAZUH_SAMPLE_ALERTS_CATEGORY_SECURITY]: [{
    syscheck: true
  }, {
    aws: true
  }, {
    office: true
  }, {
    gcp: true
  }, {
    authentication: true
  }, {
    ssh: true
  }, {
    apache: true,
    alerts: 2000
  }, {
    web: true
  }, {
    windows: {
      service_control_manager: true
    },
    alerts: 1000
  }, {
    github: true
  }],
  [WAZUH_SAMPLE_ALERTS_CATEGORY_AUDITING_POLICY_MONITORING]: [{
    rootcheck: true
  }, {
    audit: true
  }, {
    openscap: true
  }, {
    ciscat: true
  }],
  [WAZUH_SAMPLE_ALERTS_CATEGORY_THREAT_DETECTION]: [{
    vulnerabilities: true
  }, {
    virustotal: true
  }, {
    osquery: true
  }, {
    docker: true
  }, {
    mitre: true
  }]
}; // Security

exports.WAZUH_SAMPLE_ALERTS_CATEGORIES_TYPE_ALERTS = WAZUH_SAMPLE_ALERTS_CATEGORIES_TYPE_ALERTS;
const WAZUH_SECURITY_PLUGIN_XPACK_SECURITY = 'X-Pack Security';
exports.WAZUH_SECURITY_PLUGIN_XPACK_SECURITY = WAZUH_SECURITY_PLUGIN_XPACK_SECURITY;
const WAZUH_SECURITY_PLUGIN_OPEN_DISTRO_FOR_ELASTICSEARCH = 'Open Distro for Elasticsearch';
exports.WAZUH_SECURITY_PLUGIN_OPEN_DISTRO_FOR_ELASTICSEARCH = WAZUH_SECURITY_PLUGIN_OPEN_DISTRO_FOR_ELASTICSEARCH;
const WAZUH_SECURITY_PLUGINS = [WAZUH_SECURITY_PLUGIN_XPACK_SECURITY, WAZUH_SECURITY_PLUGIN_OPEN_DISTRO_FOR_ELASTICSEARCH]; // App configuration

exports.WAZUH_SECURITY_PLUGINS = WAZUH_SECURITY_PLUGINS;
const WAZUH_CONFIGURATION_CACHE_TIME = 10000; // time in ms;

exports.WAZUH_CONFIGURATION_CACHE_TIME = WAZUH_CONFIGURATION_CACHE_TIME;
const WAZUH_CONFIGURATION_SETTINGS_NEED_RESTART = ['wazuh.monitoring.enabled', 'wazuh.monitoring.frequency', 'cron.statistics.interval', 'logs.level'];
exports.WAZUH_CONFIGURATION_SETTINGS_NEED_RESTART = WAZUH_CONFIGURATION_SETTINGS_NEED_RESTART;
const WAZUH_CONFIGURATION_SETTINGS_NEED_HEALTH_CHECK = ['pattern', 'wazuh.monitoring.replicas', 'wazuh.monitoring.creation', 'wazuh.monitoring.pattern', 'alerts.sample.prefix', 'cron.statistics.index.name', 'cron.statistics.index.creation', 'cron.statistics.index.shards', 'cron.statistics.index.replicas', 'wazuh.monitoring.shards'];
exports.WAZUH_CONFIGURATION_SETTINGS_NEED_HEALTH_CHECK = WAZUH_CONFIGURATION_SETTINGS_NEED_HEALTH_CHECK;
const WAZUH_CONFIGURATION_SETTINGS_NEED_RELOAD = ['hideManagerAlerts', 'customization.logo.sidebar']; // Reserved ids for Users/Role mapping

exports.WAZUH_CONFIGURATION_SETTINGS_NEED_RELOAD = WAZUH_CONFIGURATION_SETTINGS_NEED_RELOAD;
const WAZUH_API_RESERVED_ID_LOWER_THAN = 100; // Wazuh data path

exports.WAZUH_API_RESERVED_ID_LOWER_THAN = WAZUH_API_RESERVED_ID_LOWER_THAN;
const WAZUH_DATA_PLUGIN_PLATFORM_BASE_PATH = 'data';

const WAZUH_DATA_PLUGIN_PLATFORM_BASE_ABSOLUTE_PATH = _path.default.join(__dirname, '../../../', WAZUH_DATA_PLUGIN_PLATFORM_BASE_PATH);

exports.WAZUH_DATA_PLUGIN_PLATFORM_BASE_ABSOLUTE_PATH = WAZUH_DATA_PLUGIN_PLATFORM_BASE_ABSOLUTE_PATH;

const WAZUH_DATA_ABSOLUTE_PATH = _path.default.join(WAZUH_DATA_PLUGIN_PLATFORM_BASE_ABSOLUTE_PATH, 'wazuh'); // Wazuh data path - config


exports.WAZUH_DATA_ABSOLUTE_PATH = WAZUH_DATA_ABSOLUTE_PATH;

const WAZUH_DATA_CONFIG_DIRECTORY_PATH = _path.default.join(WAZUH_DATA_ABSOLUTE_PATH, 'config');

exports.WAZUH_DATA_CONFIG_DIRECTORY_PATH = WAZUH_DATA_CONFIG_DIRECTORY_PATH;

const WAZUH_DATA_CONFIG_APP_PATH = _path.default.join(WAZUH_DATA_CONFIG_DIRECTORY_PATH, 'wazuh.yml');

exports.WAZUH_DATA_CONFIG_APP_PATH = WAZUH_DATA_CONFIG_APP_PATH;

const WAZUH_DATA_CONFIG_REGISTRY_PATH = _path.default.join(WAZUH_DATA_CONFIG_DIRECTORY_PATH, 'wazuh-registry.json'); // Wazuh data path - logs


exports.WAZUH_DATA_CONFIG_REGISTRY_PATH = WAZUH_DATA_CONFIG_REGISTRY_PATH;
const MAX_MB_LOG_FILES = 100;
exports.MAX_MB_LOG_FILES = MAX_MB_LOG_FILES;

const WAZUH_DATA_LOGS_DIRECTORY_PATH = _path.default.join(WAZUH_DATA_ABSOLUTE_PATH, 'logs');

exports.WAZUH_DATA_LOGS_DIRECTORY_PATH = WAZUH_DATA_LOGS_DIRECTORY_PATH;
const WAZUH_DATA_LOGS_PLAIN_FILENAME = 'wazuhapp-plain.log';
exports.WAZUH_DATA_LOGS_PLAIN_FILENAME = WAZUH_DATA_LOGS_PLAIN_FILENAME;

const WAZUH_DATA_LOGS_PLAIN_PATH = _path.default.join(WAZUH_DATA_LOGS_DIRECTORY_PATH, WAZUH_DATA_LOGS_PLAIN_FILENAME);

exports.WAZUH_DATA_LOGS_PLAIN_PATH = WAZUH_DATA_LOGS_PLAIN_PATH;
const WAZUH_DATA_LOGS_RAW_FILENAME = 'wazuhapp.log';
exports.WAZUH_DATA_LOGS_RAW_FILENAME = WAZUH_DATA_LOGS_RAW_FILENAME;

const WAZUH_DATA_LOGS_RAW_PATH = _path.default.join(WAZUH_DATA_LOGS_DIRECTORY_PATH, WAZUH_DATA_LOGS_RAW_FILENAME); // Wazuh data path - UI logs


exports.WAZUH_DATA_LOGS_RAW_PATH = WAZUH_DATA_LOGS_RAW_PATH;
const WAZUH_UI_LOGS_PLAIN_FILENAME = 'wazuh-ui-plain.log';
exports.WAZUH_UI_LOGS_PLAIN_FILENAME = WAZUH_UI_LOGS_PLAIN_FILENAME;
const WAZUH_UI_LOGS_RAW_FILENAME = 'wazuh-ui.log';
exports.WAZUH_UI_LOGS_RAW_FILENAME = WAZUH_UI_LOGS_RAW_FILENAME;

const WAZUH_UI_LOGS_PLAIN_PATH = _path.default.join(WAZUH_DATA_LOGS_DIRECTORY_PATH, WAZUH_UI_LOGS_PLAIN_FILENAME);

exports.WAZUH_UI_LOGS_PLAIN_PATH = WAZUH_UI_LOGS_PLAIN_PATH;

const WAZUH_UI_LOGS_RAW_PATH = _path.default.join(WAZUH_DATA_LOGS_DIRECTORY_PATH, WAZUH_UI_LOGS_RAW_FILENAME); // Wazuh data path - downloads


exports.WAZUH_UI_LOGS_RAW_PATH = WAZUH_UI_LOGS_RAW_PATH;

const WAZUH_DATA_DOWNLOADS_DIRECTORY_PATH = _path.default.join(WAZUH_DATA_ABSOLUTE_PATH, 'downloads');

exports.WAZUH_DATA_DOWNLOADS_DIRECTORY_PATH = WAZUH_DATA_DOWNLOADS_DIRECTORY_PATH;

const WAZUH_DATA_DOWNLOADS_REPORTS_DIRECTORY_PATH = _path.default.join(WAZUH_DATA_DOWNLOADS_DIRECTORY_PATH, 'reports'); // Queue


exports.WAZUH_DATA_DOWNLOADS_REPORTS_DIRECTORY_PATH = WAZUH_DATA_DOWNLOADS_REPORTS_DIRECTORY_PATH;
const WAZUH_QUEUE_CRON_FREQ = '*/15 * * * * *'; // Every 15 seconds
// Default App Config

exports.WAZUH_QUEUE_CRON_FREQ = WAZUH_QUEUE_CRON_FREQ;
const WAZUH_DEFAULT_APP_CONFIG = {
  pattern: WAZUH_ALERTS_PATTERN,
  'checks.pattern': true,
  'checks.template': true,
  'checks.api': true,
  'checks.setup': true,
  'checks.fields': true,
  'checks.metaFields': true,
  'checks.maxBuckets': true,
  'checks.timeFilter': true,
  'extensions.pci': true,
  'extensions.gdpr': true,
  'extensions.hipaa': true,
  'extensions.nist': true,
  'extensions.tsc': true,
  'extensions.audit': true,
  'extensions.oscap': false,
  'extensions.ciscat': false,
  'extensions.aws': false,
  'extensions.office': false,
  'extensions.github': false,
  'extensions.gcp': false,
  'extensions.virustotal': false,
  'extensions.osquery': false,
  'extensions.docker': false,
  timeout: 20000,
  'ip.selector': true,
  'ip.ignore': [],
  'xpack.rbac.enabled': true,
  'wazuh.monitoring.enabled': WAZUH_MONITORING_DEFAULT_ENABLED,
  'wazuh.monitoring.frequency': WAZUH_MONITORING_DEFAULT_FREQUENCY,
  'wazuh.monitoring.shards': WAZUH_MONITORING_DEFAULT_INDICES_SHARDS,
  'wazuh.monitoring.replicas': WAZUH_MONITORING_DEFAULT_INDICES_REPLICAS,
  'wazuh.monitoring.creation': WAZUH_MONITORING_DEFAULT_CREATION,
  'wazuh.monitoring.pattern': WAZUH_MONITORING_PATTERN,
  'cron.prefix': WAZUH_STATISTICS_DEFAULT_PREFIX,
  'cron.statistics.status': WAZUH_STATISTICS_DEFAULT_STATUS,
  'cron.statistics.apis': [],
  'cron.statistics.interval': WAZUH_STATISTICS_DEFAULT_CRON_FREQ,
  'cron.statistics.index.name': WAZUH_STATISTICS_DEFAULT_NAME,
  'cron.statistics.index.creation': WAZUH_STATISTICS_DEFAULT_CREATION,
  'cron.statistics.index.shards': WAZUH_STATISTICS_DEFAULT_INDICES_SHARDS,
  'cron.statistics.index.replicas': WAZUH_STATISTICS_DEFAULT_INDICES_REPLICAS,
  'alerts.sample.prefix': WAZUH_SAMPLE_ALERT_PREFIX,
  hideManagerAlerts: false,
  'logs.level': 'info',
  'enrollment.dns': '',
  'enrollment.password': '',
  'customization.logo.app': '',
  'customization.logo.sidebar': '',
  'customization.logo.healthcheck': '',
  'customization.logo.reports': ''
}; // Wazuh errors

exports.WAZUH_DEFAULT_APP_CONFIG = WAZUH_DEFAULT_APP_CONFIG;
const WAZUH_ERROR_DAEMONS_NOT_READY = 'ERROR3099'; // Agents

exports.WAZUH_ERROR_DAEMONS_NOT_READY = WAZUH_ERROR_DAEMONS_NOT_READY;
let WAZUH_AGENTS_OS_TYPE;
exports.WAZUH_AGENTS_OS_TYPE = WAZUH_AGENTS_OS_TYPE;

(function (WAZUH_AGENTS_OS_TYPE) {
  WAZUH_AGENTS_OS_TYPE["WINDOWS"] = "windows";
  WAZUH_AGENTS_OS_TYPE["LINUX"] = "linux";
  WAZUH_AGENTS_OS_TYPE["SUNOS"] = "sunos";
  WAZUH_AGENTS_OS_TYPE["DARWIN"] = "darwin";
  WAZUH_AGENTS_OS_TYPE["OTHERS"] = "";
})(WAZUH_AGENTS_OS_TYPE || (exports.WAZUH_AGENTS_OS_TYPE = WAZUH_AGENTS_OS_TYPE = {}));

let WAZUH_MODULES_ID;
exports.WAZUH_MODULES_ID = WAZUH_MODULES_ID;

(function (WAZUH_MODULES_ID) {
  WAZUH_MODULES_ID["SECURITY_EVENTS"] = "general";
  WAZUH_MODULES_ID["INTEGRITY_MONITORING"] = "fim";
  WAZUH_MODULES_ID["AMAZON_WEB_SERVICES"] = "aws";
  WAZUH_MODULES_ID["OFFICE_365"] = "office";
  WAZUH_MODULES_ID["GOOGLE_CLOUD_PLATFORM"] = "gcp";
  WAZUH_MODULES_ID["POLICY_MONITORING"] = "pm";
  WAZUH_MODULES_ID["SECURITY_CONFIGURATION_ASSESSMENT"] = "sca";
  WAZUH_MODULES_ID["AUDITING"] = "audit";
  WAZUH_MODULES_ID["OPEN_SCAP"] = "oscap";
  WAZUH_MODULES_ID["VULNERABILITIES"] = "vuls";
  WAZUH_MODULES_ID["OSQUERY"] = "osquery";
  WAZUH_MODULES_ID["DOCKER"] = "docker";
  WAZUH_MODULES_ID["MITRE_ATTACK"] = "mitre";
  WAZUH_MODULES_ID["PCI_DSS"] = "pci";
  WAZUH_MODULES_ID["HIPAA"] = "hipaa";
  WAZUH_MODULES_ID["NIST_800_53"] = "nist";
  WAZUH_MODULES_ID["TSC"] = "tsc";
  WAZUH_MODULES_ID["CIS_CAT"] = "ciscat";
  WAZUH_MODULES_ID["VIRUSTOTAL"] = "virustotal";
  WAZUH_MODULES_ID["GDPR"] = "gdpr";
  WAZUH_MODULES_ID["GITHUB"] = "github";
})(WAZUH_MODULES_ID || (exports.WAZUH_MODULES_ID = WAZUH_MODULES_ID = {}));

;
let WAZUH_MENU_MANAGEMENT_SECTIONS_ID;
exports.WAZUH_MENU_MANAGEMENT_SECTIONS_ID = WAZUH_MENU_MANAGEMENT_SECTIONS_ID;

(function (WAZUH_MENU_MANAGEMENT_SECTIONS_ID) {
  WAZUH_MENU_MANAGEMENT_SECTIONS_ID["MANAGEMENT"] = "management";
  WAZUH_MENU_MANAGEMENT_SECTIONS_ID["ADMINISTRATION"] = "administration";
  WAZUH_MENU_MANAGEMENT_SECTIONS_ID["RULESET"] = "ruleset";
  WAZUH_MENU_MANAGEMENT_SECTIONS_ID["RULES"] = "rules";
  WAZUH_MENU_MANAGEMENT_SECTIONS_ID["DECODERS"] = "decoders";
  WAZUH_MENU_MANAGEMENT_SECTIONS_ID["CDB_LISTS"] = "lists";
  WAZUH_MENU_MANAGEMENT_SECTIONS_ID["GROUPS"] = "groups";
  WAZUH_MENU_MANAGEMENT_SECTIONS_ID["CONFIGURATION"] = "configuration";
  WAZUH_MENU_MANAGEMENT_SECTIONS_ID["STATUS_AND_REPORTS"] = "statusReports";
  WAZUH_MENU_MANAGEMENT_SECTIONS_ID["STATUS"] = "status";
  WAZUH_MENU_MANAGEMENT_SECTIONS_ID["CLUSTER"] = "monitoring";
  WAZUH_MENU_MANAGEMENT_SECTIONS_ID["LOGS"] = "logs";
  WAZUH_MENU_MANAGEMENT_SECTIONS_ID["REPORTING"] = "reporting";
  WAZUH_MENU_MANAGEMENT_SECTIONS_ID["STATISTICS"] = "statistics";
})(WAZUH_MENU_MANAGEMENT_SECTIONS_ID || (exports.WAZUH_MENU_MANAGEMENT_SECTIONS_ID = WAZUH_MENU_MANAGEMENT_SECTIONS_ID = {}));

;
let WAZUH_MENU_TOOLS_SECTIONS_ID;
exports.WAZUH_MENU_TOOLS_SECTIONS_ID = WAZUH_MENU_TOOLS_SECTIONS_ID;

(function (WAZUH_MENU_TOOLS_SECTIONS_ID) {
  WAZUH_MENU_TOOLS_SECTIONS_ID["API_CONSOLE"] = "devTools";
  WAZUH_MENU_TOOLS_SECTIONS_ID["RULESET_TEST"] = "logtest";
})(WAZUH_MENU_TOOLS_SECTIONS_ID || (exports.WAZUH_MENU_TOOLS_SECTIONS_ID = WAZUH_MENU_TOOLS_SECTIONS_ID = {}));

;
let WAZUH_MENU_SECURITY_SECTIONS_ID;
exports.WAZUH_MENU_SECURITY_SECTIONS_ID = WAZUH_MENU_SECURITY_SECTIONS_ID;

(function (WAZUH_MENU_SECURITY_SECTIONS_ID) {
  WAZUH_MENU_SECURITY_SECTIONS_ID["USERS"] = "users";
  WAZUH_MENU_SECURITY_SECTIONS_ID["ROLES"] = "roles";
  WAZUH_MENU_SECURITY_SECTIONS_ID["POLICIES"] = "policies";
  WAZUH_MENU_SECURITY_SECTIONS_ID["ROLES_MAPPING"] = "roleMapping";
})(WAZUH_MENU_SECURITY_SECTIONS_ID || (exports.WAZUH_MENU_SECURITY_SECTIONS_ID = WAZUH_MENU_SECURITY_SECTIONS_ID = {}));

;
let WAZUH_MENU_SETTINGS_SECTIONS_ID;
exports.WAZUH_MENU_SETTINGS_SECTIONS_ID = WAZUH_MENU_SETTINGS_SECTIONS_ID;

(function (WAZUH_MENU_SETTINGS_SECTIONS_ID) {
  WAZUH_MENU_SETTINGS_SECTIONS_ID["SETTINGS"] = "settings";
  WAZUH_MENU_SETTINGS_SECTIONS_ID["API_CONFIGURATION"] = "api";
  WAZUH_MENU_SETTINGS_SECTIONS_ID["MODULES"] = "modules";
  WAZUH_MENU_SETTINGS_SECTIONS_ID["SAMPLE_DATA"] = "sample_data";
  WAZUH_MENU_SETTINGS_SECTIONS_ID["CONFIGURATION"] = "configuration";
  WAZUH_MENU_SETTINGS_SECTIONS_ID["LOGS"] = "logs";
  WAZUH_MENU_SETTINGS_SECTIONS_ID["MISCELLANEOUS"] = "miscellaneous";
  WAZUH_MENU_SETTINGS_SECTIONS_ID["ABOUT"] = "about";
})(WAZUH_MENU_SETTINGS_SECTIONS_ID || (exports.WAZUH_MENU_SETTINGS_SECTIONS_ID = WAZUH_MENU_SETTINGS_SECTIONS_ID = {}));

;
const AUTHORIZED_AGENTS = 'authorized-agents'; // Wazuh links

exports.AUTHORIZED_AGENTS = AUTHORIZED_AGENTS;
const WAZUH_LINK_GITHUB = 'https://github.com/wazuh';
exports.WAZUH_LINK_GITHUB = WAZUH_LINK_GITHUB;
const WAZUH_LINK_GOOGLE_GROUPS = 'https://groups.google.com/forum/#!forum/wazuh';
exports.WAZUH_LINK_GOOGLE_GROUPS = WAZUH_LINK_GOOGLE_GROUPS;
const WAZUH_LINK_SLACK = 'https://wazuh.com/community/join-us-on-slack';
exports.WAZUH_LINK_SLACK = WAZUH_LINK_SLACK;
const HEALTH_CHECK = 'health-check'; // Health check

exports.HEALTH_CHECK = HEALTH_CHECK;
const HEALTH_CHECK_REDIRECTION_TIME = 300; //ms
// Plugin platform settings
// Default timeFilter set by the app

exports.HEALTH_CHECK_REDIRECTION_TIME = HEALTH_CHECK_REDIRECTION_TIME;
const WAZUH_PLUGIN_PLATFORM_SETTING_TIME_FILTER = {
  from: 'now-24h',
  to: 'now'
};
exports.WAZUH_PLUGIN_PLATFORM_SETTING_TIME_FILTER = WAZUH_PLUGIN_PLATFORM_SETTING_TIME_FILTER;
const PLUGIN_PLATFORM_SETTING_NAME_TIME_FILTER = 'timepicker:timeDefaults'; // Default maxBuckets set by the app

exports.PLUGIN_PLATFORM_SETTING_NAME_TIME_FILTER = PLUGIN_PLATFORM_SETTING_NAME_TIME_FILTER;
const WAZUH_PLUGIN_PLATFORM_SETTING_MAX_BUCKETS = 200000;
exports.WAZUH_PLUGIN_PLATFORM_SETTING_MAX_BUCKETS = WAZUH_PLUGIN_PLATFORM_SETTING_MAX_BUCKETS;
const PLUGIN_PLATFORM_SETTING_NAME_MAX_BUCKETS = 'timelion:max_buckets'; // Default metaFields set by the app

exports.PLUGIN_PLATFORM_SETTING_NAME_MAX_BUCKETS = PLUGIN_PLATFORM_SETTING_NAME_MAX_BUCKETS;
const WAZUH_PLUGIN_PLATFORM_SETTING_METAFIELDS = ['_source', '_index'];
exports.WAZUH_PLUGIN_PLATFORM_SETTING_METAFIELDS = WAZUH_PLUGIN_PLATFORM_SETTING_METAFIELDS;
const PLUGIN_PLATFORM_SETTING_NAME_METAFIELDS = 'metaFields'; // Logger

exports.PLUGIN_PLATFORM_SETTING_NAME_METAFIELDS = PLUGIN_PLATFORM_SETTING_NAME_METAFIELDS;
const UI_LOGGER_LEVELS = {
  WARNING: 'WARNING',
  INFO: 'INFO',
  ERROR: 'ERROR'
};
exports.UI_LOGGER_LEVELS = UI_LOGGER_LEVELS;
const UI_TOAST_COLOR = {
  SUCCESS: 'success',
  WARNING: 'warning',
  DANGER: 'danger'
}; // Assets

exports.UI_TOAST_COLOR = UI_TOAST_COLOR;
const ASSETS_BASE_URL_PREFIX = '/plugins/wazuh/assets/';
exports.ASSETS_BASE_URL_PREFIX = ASSETS_BASE_URL_PREFIX;
const ASSETS_PUBLIC_URL = '/plugins/wazuh/public/assets/'; // Reports

exports.ASSETS_PUBLIC_URL = ASSETS_PUBLIC_URL;
const REPORTS_LOGO_IMAGE_ASSETS_RELATIVE_PATH = 'images/logo_reports.png';
exports.REPORTS_LOGO_IMAGE_ASSETS_RELATIVE_PATH = REPORTS_LOGO_IMAGE_ASSETS_RELATIVE_PATH;
const REPORTS_PRIMARY_COLOR = '#256BD1';
exports.REPORTS_PRIMARY_COLOR = REPORTS_PRIMARY_COLOR;
const REPORTS_PAGE_FOOTER_TEXT = 'Copyright © 2022 Wazuh, Inc.';
exports.REPORTS_PAGE_FOOTER_TEXT = REPORTS_PAGE_FOOTER_TEXT;
const REPORTS_PAGE_HEADER_TEXT = 'info@wazuh.com\nhttps://wazuh.com'; // Plugin platform

exports.REPORTS_PAGE_HEADER_TEXT = REPORTS_PAGE_HEADER_TEXT;
const PLUGIN_PLATFORM_NAME = 'Kibana';
exports.PLUGIN_PLATFORM_NAME = PLUGIN_PLATFORM_NAME;
const PLUGIN_PLATFORM_BASE_INSTALLATION_PATH = '/usr/share/kibana/data/wazuh/';
exports.PLUGIN_PLATFORM_BASE_INSTALLATION_PATH = PLUGIN_PLATFORM_BASE_INSTALLATION_PATH;
const PLUGIN_PLATFORM_INSTALLATION_USER = 'kibana';
exports.PLUGIN_PLATFORM_INSTALLATION_USER = PLUGIN_PLATFORM_INSTALLATION_USER;
const PLUGIN_PLATFORM_INSTALLATION_USER_GROUP = 'kibana';
exports.PLUGIN_PLATFORM_INSTALLATION_USER_GROUP = PLUGIN_PLATFORM_INSTALLATION_USER_GROUP;
const PLUGIN_PLATFORM_WAZUH_DOCUMENTATION_URL_PATH_UPGRADE_PLATFORM = 'upgrade-guide';
exports.PLUGIN_PLATFORM_WAZUH_DOCUMENTATION_URL_PATH_UPGRADE_PLATFORM = PLUGIN_PLATFORM_WAZUH_DOCUMENTATION_URL_PATH_UPGRADE_PLATFORM;
const PLUGIN_PLATFORM_WAZUH_DOCUMENTATION_URL_PATH_TROUBLESHOOTING = 'user-manual/elasticsearch/troubleshooting.html';
exports.PLUGIN_PLATFORM_WAZUH_DOCUMENTATION_URL_PATH_TROUBLESHOOTING = PLUGIN_PLATFORM_WAZUH_DOCUMENTATION_URL_PATH_TROUBLESHOOTING;
const PLUGIN_PLATFORM_WAZUH_DOCUMENTATION_URL_PATH_APP_CONFIGURATION = 'user-manual/wazuh-dashboard/config-file.html';
exports.PLUGIN_PLATFORM_WAZUH_DOCUMENTATION_URL_PATH_APP_CONFIGURATION = PLUGIN_PLATFORM_WAZUH_DOCUMENTATION_URL_PATH_APP_CONFIGURATION;
const PLUGIN_PLATFORM_URL_GUIDE = 'https://www.elastic.co/guide/en/elasticsearch/reference/current/index.html';
exports.PLUGIN_PLATFORM_URL_GUIDE = PLUGIN_PLATFORM_URL_GUIDE;
const PLUGIN_PLATFORM_URL_GUIDE_TITLE = 'Elastic guide';
exports.PLUGIN_PLATFORM_URL_GUIDE_TITLE = PLUGIN_PLATFORM_URL_GUIDE_TITLE;
const PLUGIN_PLATFORM_REQUEST_HEADERS = {
  'kbn-xsrf': 'kibana'
}; // UI

exports.PLUGIN_PLATFORM_REQUEST_HEADERS = PLUGIN_PLATFORM_REQUEST_HEADERS;
const API_NAME_AGENT_STATUS = {
  ACTIVE: 'active',
  DISCONNECTED: 'disconnected',
  PENDING: 'pending',
  NEVER_CONNECTED: 'never_connected'
};
exports.API_NAME_AGENT_STATUS = API_NAME_AGENT_STATUS;
const UI_COLOR_AGENT_STATUS = {
  [API_NAME_AGENT_STATUS.ACTIVE]: '#007871',
  [API_NAME_AGENT_STATUS.DISCONNECTED]: '#BD271E',
  [API_NAME_AGENT_STATUS.PENDING]: '#FEC514',
  [API_NAME_AGENT_STATUS.NEVER_CONNECTED]: '#646A77',
  default: '#000000'
};
exports.UI_COLOR_AGENT_STATUS = UI_COLOR_AGENT_STATUS;
const UI_LABEL_NAME_AGENT_STATUS = {
  [API_NAME_AGENT_STATUS.ACTIVE]: 'Active',
  [API_NAME_AGENT_STATUS.DISCONNECTED]: 'Disconnected',
  [API_NAME_AGENT_STATUS.PENDING]: 'Pending',
  [API_NAME_AGENT_STATUS.NEVER_CONNECTED]: 'Never connected',
  default: 'Unknown'
};
exports.UI_LABEL_NAME_AGENT_STATUS = UI_LABEL_NAME_AGENT_STATUS;
const UI_ORDER_AGENT_STATUS = [API_NAME_AGENT_STATUS.ACTIVE, API_NAME_AGENT_STATUS.DISCONNECTED, API_NAME_AGENT_STATUS.PENDING, API_NAME_AGENT_STATUS.NEVER_CONNECTED]; // Documentation

exports.UI_ORDER_AGENT_STATUS = UI_ORDER_AGENT_STATUS;
const DOCUMENTATION_WEB_BASE_URL = "https://documentation.wazuh.com"; // Default Elasticsearch user name context

exports.DOCUMENTATION_WEB_BASE_URL = DOCUMENTATION_WEB_BASE_URL;
const ELASTIC_NAME = 'elastic';
exports.ELASTIC_NAME = ELASTIC_NAME;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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