"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KeyEquivalence = void 0;

/*
 * Wazuh app - Wazuh CSV column keys
 * Copyright (C) 2015-2022 Wazuh, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Find more information about this on the LICENSE file.
 */
const KeyEquivalence = {
  id: 'ID',
  timestamp: 'Timestamp',
  url: 'URL',
  version: 'Version',
  'os.name': 'OS name',
  'os.version': 'OS version',
  'os.arch': 'OS version architecture',
  'os.build': 'OS version build',
  'os.codename': 'OS code name',
  'os.major': 'OS version major',
  'os.minor': 'OS version minor',
  'os.platform': 'OS platform',
  'os.uname': 'OS uname',
  status: 'Status',
  group: 'Group',
  ip: 'IP',
  description: 'Description',
  tag: 'Tag',
  level: 'Level',
  conf_sum: 'Group checksum',
  merged_sum: 'Configuration checksum',
  hash: 'Checksum',
  filename: 'File',
  file: 'File',
  gdpr: 'GDPR',
  pci: 'PCI',
  hipaa: 'HIPAA',
  'nist-800-53': 'NIST 800-53',
  cis: 'CIS',
  event: 'Event',
  groups: 'Groups',
  name: 'Name',
  count: 'Count',
  'details.program_name': 'Program name',
  'details.order': 'Order',
  vendor: 'Vendor',
  type: 'Type',
  architecture: 'Architecture',
  node_name: 'Node',
  dateAdd: 'Registration date',
  manager: 'Manager',
  lastKeepAlive: 'Last keep alive',
  os: 'OS',
  path: 'Path',
  details: 'Details',
  position: 'Position',
  configSum: 'Group checksum',
  mergedSum: 'Configuration checksum',
  key: 'Key',
  scan_id: 'Scan ID',
  format: 'Format',
  scan_time: 'Scan date',
  state: 'State',
  mac: 'MAC',
  gateway: 'Gateway',
  dhcp: 'DHCP',
  iface: 'Interface',
  broadcast: 'Broadcast',
  proto: 'Protocol',
  address: 'Address',
  protocol: 'Protocol',
  netmask: 'Netmask',
  'local.ip': 'Local IP',
  'remote.ip': 'Remote IP',
  'local.port': 'Local port',
  'remote.port': 'Remote port',
  euser: 'Effective user',
  egroup: 'Effective group',
  vm_size: 'VM size',
  processor: 'Processor',
  session: 'Session',
  tty: 'TTY',
  pid: 'PID',
  ppid: 'Parent PID',
  argvs: 'Argvs',
  nice: 'Priority',
  size: 'Size',
  uname: 'User',
  gname: 'Group',
  perm: 'Permissions',
  inode: 'Inode',
  uid: 'User ID',
  gid: 'Group ID',
  mtime: 'Last modified',
  priority: 'Priority',
  cmd: 'Command',
  nlwp: 'NLWP',
  process: 'Process',
  md5: 'MD5',
  sha1: 'SHA1',
  sha256: 'SHA256',
  title: 'Title',
  remediation: 'Remediation',
  references: 'References',
  result: 'Result',
  directory: 'Path(s)',
  rationale: 'Rationale',
  registry: 'Registry',
  date: 'Date',
  value: 'Value',
  location: 'Location',
  mtu: 'MTU',
  attributes: 'Attributes',
  policy_id: 'Policy ID',
  policy_ID: 'Policy ID',
  compliance: 'Compliance',
  rules: 'Rules',
  reason: 'Reason',
  registerIP: 'Register IP',
  hotfix: 'Update code',
  'scan.time': 'Registered by Wazuh at'
};
exports.KeyEquivalence = KeyEquivalence;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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