"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.randomElements = exports.randomArrayItem = exports.Win_Hostnames = exports.Users = exports.Ports = exports.Paths = exports.IPs = exports.GeoLocation = exports.Agents = void 0;

/*
 * Wazuh app - Common data to generate 
 * Copyright (C) 2015-2022 Wazuh, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Find more information about this on the LICENSE file.
 */
// Common data
const IPs = ['141.98.81.37', '54.10.24.5', '187.80.4.18', '134.87.21.47', '40.220.102.15', '45.124.37.241', '45.75.196.15', '16.4.20.20'];
exports.IPs = IPs;
const Users = ["root", "ec2-user", "SYSTEM", "wazuh", "Administrators", "suricata", "LOCAL\ Service", "NETWORK\ Service"];
exports.Users = Users;
const Ports = ["22", "55047", "26874", "8905", "3014", "2222", "4547", "3475", "7558", "4277", "3527", "5784", "7854"];
exports.Ports = Ports;
const Win_Hostnames = ['Win_Server_01', 'Win_Server_02', 'Win_Server_03', 'Win_Server_04'];
exports.Win_Hostnames = Win_Hostnames;
const Paths = ["/home/user/sample", "/tmp/sample", "/etc/sample"]; // Agents

exports.Paths = Paths;
const Agents = [// { id: '000', name: 'master', ip: '120.17.47.10' }, 
{
  id: '001',
  name: 'RHEL7',
  ip: '187.54.247.68'
}, {
  id: '002',
  name: 'Amazon',
  ip: '145.80.240.15'
}, {
  id: '003',
  name: 'ip-10-0-0-180.us-west-1.compute.internal',
  ip: '10.0.0.180'
}, {
  id: '004',
  name: 'Ubuntu',
  ip: '47.204.15.21'
}, {
  id: '005',
  name: 'Centos',
  ip: '197.17.1.4'
}, {
  id: '006',
  name: 'Windows',
  ip: '207.45.34.78'
}, {
  id: '007',
  name: 'Debian',
  ip: '24.273.97.14'
}]; // Geolocation {country_name, location: {lat, lon }, region_name}

exports.Agents = Agents;
const GeoLocation = [{
  country_name: 'Spain',
  location: {
    lat: 37.1881714,
    lon: -3.6066699
  },
  region_name: 'Andalucía',
  city_name: 'Granada'
}, {
  country_name: 'France',
  location: {
    lat: 48.8534088,
    lon: 2.3487999
  },
  region_name: 'Paris',
  city_name: 'Paris'
}, {
  country_name: 'England',
  location: {
    lat: 51.5085297,
    lon: -0.12574
  },
  region_name: 'London',
  city_name: 'London'
}, {
  country_name: 'Germany',
  location: {
    lat: 52.524,
    lon: 13.411
  },
  region_name: 'Berlin',
  city_name: 'Berlin'
}, {
  country_name: 'United States of America',
  location: {
    lat: 40.7142715,
    lon: -74.0059662
  },
  region_name: 'New York',
  city_name: 'New York'
}, {
  country_name: 'Canada',
  location: {
    lat: 49.2496605,
    lon: -123.119339
  },
  region_name: 'Vancouver',
  city_name: 'Vancouver'
}, {
  country_name: 'Brasil',
  location: {
    lat: -22.9064198,
    lon: -43.1822319
  },
  region_name: 'Río de Janeiro',
  city_name: 'Río de Janeiro'
}, {
  country_name: 'India',
  location: {
    lat: 19.0728302,
    lon: 72.8826065
  },
  region_name: 'Bombay',
  city_name: 'Bombay'
}, {
  country_name: 'Australia',
  location: {
    lat: -33.8678513,
    lon: 151.2073212
  },
  region_name: 'Sydney',
  city_name: 'Sydney'
}, {
  country_name: 'China',
  location: {
    lat: 31.222,
    lon: 121.458
  },
  region_name: 'Shanghai',
  city_name: 'Shanghai'
}];
/**
 * Get a random element of an array
 * @param {[]} array - Array to get a randomized element
 * @returns {any} - Element randomized
 */

exports.GeoLocation = GeoLocation;

function randomStrItem(str) {
  let array = str.split('');
  return array[Math.floor(array.length * Math.random())];
}

const randomElements = (length, elements) => {
  let hash = '';

  for (let i = 0; i < length; i++) {
    hash += randomStrItem(elements);
  }

  return hash;
};

exports.randomElements = randomElements;

const randomArrayItem = array => {
  return array[Math.floor(array.length * Math.random())];
};

exports.randomArrayItem = randomArrayItem;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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