"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.type = exports.dataDocker = exports.actorAttributesName = exports.actorAttributesImage = exports.action = void 0;

var _common = require("./common");

/*
 * Wazuh app - Docker sample data
 * Copyright (C) 2015-2022 Wazuh, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Find more information about this on the LICENSE file.
 */
const actorAttributesImage = ["wazuh/wazuh:3.12.0-7.6.1", "docker.elastic.co/elasticsearch/elasticsearch:7.6.2", "docker.elastic.co/kibana/kibana:7.6.2", "nginx:latest"];
exports.actorAttributesImage = actorAttributesImage;
const type = ["container", "image", "volume", "network"];
exports.type = type;
const action = ["start", "stop", "pause", "unpause"];
exports.action = action;
const actorAttributesName = ["wonderful_page", "nostalgic_gates", "jovial_zuckerberg", "inspiring_jobs", "opening_torvalds", "gifted_bezos", "clever_wales", "laughing_tesla", "kind_nobel"]; // https://github.com/moby/moby/blob/5aa44cdf132788cc0cd28ce2393b44265dd400e9/pkg/namesgenerator/names-generator.go#L600

exports.actorAttributesName = actorAttributesName;
const stringRandom = 'abcdef0123456789';
const dataDocker = [{
  rule: {
    level: 3,
    description: "Docker: Network vagrant_default created",
    id: "87930",
    firedtimes: 1,
    mail: false,
    pci_dss: ["10.2.7"],
    groups: ["docker"]
  },
  data: {
    integration: "docker",
    docker: {
      Type: "network",
      Action: "create",
      Actor: {
        ID: (0, _common.randomElements)(64, stringRandom),
        Attributes: {
          name: "vagrant_default",
          type: "bridge"
        }
      },
      scope: "local",
      time: "1563354307",
      timeNano: "1563354307459382528.000000"
    }
  }
}, {
  rule: {
    level: 3,
    description: "Docker: Image or repository wazuh/wazuh pulled",
    id: "87932",
    firedtimes: 1,
    mail: false,
    groups: ["docker"],
    pci_dss: ["10.2.7"]
  },
  data: {
    integration: "docker",
    docker: {
      status: "pull",
      id: "wazuh/wazuh:3.9.2_7.1.1",
      Type: "image",
      Action: "pull",
      Actor: {
        ID: "wazuh/wazuh:3.9.2_7.1.1",
        Attributes: {
          name: "wazuh/wazuh"
        }
      },
      scope: "local",
      time: "1563354346",
      timeNano: "1563354346181027328.000000"
    }
  }
}, {
  rule: {
    firedtimes: 2,
    mail: false,
    level: 5,
    pci_dss: ["10.2.7"],
    description: "Docker: Started shell session in container nginx_container",
    groups: ["docker"],
    id: "87908",
    nist_800_53: ["AU.14"],
    gdpr: ["IV_32.2"]
  },
  data: {
    integration: "docker",
    docker: {
      Action: "exec_start: bash ",
      Type: "container",
      Actor: {
        Attributes: {
          image: "nginx",
          name: "nginx_container",
          maintainer: "NGINX Docker Maintainers <docker-maint@nginx.com>",
          execID: (0, _common.randomElements)(64, stringRandom)
        },
        ID: (0, _common.randomElements)(64, stringRandom)
      },
      timeNano: "1587404196804128000.000000",
      from: "nginx",
      time: "1587404196",
      status: "exec_start: bash "
    }
  }
}, {
  rule: {
    level: 3,
    description: "Docker: Error message",
    id: "86003",
    firedtimes: 1,
    mail: false,
    groups: ["docker", "docker-error"]
  },
  data: {
    docker: {
      level: "error",
      message: "Not continuing with pull after error: context canceled"
    }
  }
}, {
  rule: {
    level: 3,
    description: "Docker: Image or repository wazuh/wazuh-elasticsearch pulled",
    id: "87932",
    firedtimes: 2,
    mail: false,
    groups: ["docker"],
    pci_dss: ["10.2.7"]
  },
  data: {
    integration: "docker",
    docker: {
      status: "pull",
      id: "wazuh/wazuh-elasticsearch:3.9.2_7.1.1",
      Type: "image",
      Action: "pull",
      Actor: {
        ID: "wazuh/wazuh-elasticsearch:3.9.2_7.1.1",
        Attributes: {
          license: "Elastic License",
          name: "wazuh/wazuh-elasticsearch",
          org: {
            "label-schema": {
              "build-date": "20190305",
              license: "GPLv2",
              name: "elasticsearch",
              "schema-version": "1.0",
              url: "https://www.elastic.co/products/elasticsearch",
              "vcs-url": "https://github.com/elastic/elasticsearch",
              vendor: "Elastic",
              version: "7.1.1"
            }
          }
        }
      },
      scope: "local",
      time: "1563354404",
      timeNano: "1563354404067201536.000000"
    }
  }
}, {
  rule: {
    level: 3,
    description: "Docker: Image or repository wazuh/wazuh-kibana pulled",
    id: "87932",
    firedtimes: 3,
    mail: false,
    groups: ["docker"],
    pci_dss: ["10.2.7"]
  },
  data: {
    integration: "docker",
    docker: {
      status: "pull",
      id: "wazuh/wazuh-kibana:3.9.2_7.1.1",
      Type: "image",
      Action: "pull",
      Actor: {
        ID: "wazuh/wazuh-kibana:3.9.2_7.1.1",
        Attributes: {
          license: "Elastic License",
          name: "wazuh/wazuh-kibana",
          org: {
            "label-schema": {
              "build-date": "20190305",
              license: "GPLv2",
              name: "kibana",
              "schema-version": "1.0",
              url: "https://www.elastic.co/products/kibana",
              "vcs-url": "https://github.com/elastic/kibana",
              vendor: "Elastic",
              version: "7.1.1"
            }
          }
        }
      },
      scope: "local",
      time: "1563354404",
      timeNano: "1563354404067201536.000000"
    }
  }
}, {
  rule: {
    level: 3,
    description: "Docker: Image or repository wazuh/wazuh-nginx pulled",
    id: "87932",
    firedtimes: 3,
    mail: false,
    groups: ["docker"],
    pci_dss: ["10.2.7"]
  },
  data: {
    integration: "docker",
    docker: {
      status: "pull",
      id: "wazuh/wazuh-nginx:3.9.2_7.1.1",
      Type: "image",
      Action: "pull",
      Actor: {
        ID: "wazuh/wazuh-nginx:3.9.2_7.1.1",
        Attributes: {
          maintainer: "NGINX Docker Maintainers <docker-maint@nginx.com>",
          name: "wazuh/wazuh-nginx"
        }
      }
    },
    scope: "local",
    time: "1563354404",
    timeNano: "1563354404067201536.000000"
  }
}, {
  rule: {
    firedtimes: 1,
    mail: false,
    level: 3,
    description: "Docker: Network bridge connected",
    groups: ["docker"],
    id: "87928"
  },
  data: {
    integration: "docker",
    docker: {
      Action: "connect",
      Type: "network",
      Actor: {
        Attributes: {
          container: (0, _common.randomElements)(64, stringRandom),
          name: "bridge",
          type: "bridge"
        },
        ID: (0, _common.randomElements)(64, stringRandom)
      },
      scope: "local",
      timeNano: "1587084599776133888.000000",
      time: "1587084599"
    }
  }
}, {
  rule: {
    firedtimes: 1,
    mail: false,
    level: 3,
    description: "Docker: Container test_container started",
    groups: ["docker"],
    id: "87928"
  },
  data: {
    integration: "docker",
    docker: {
      Action: "start",
      Type: "container",
      Actor: {
        Attributes: {
          image: "nginx",
          name: "test_container",
          maintainer: "NGINX Docker Maintainers <docker-maint@nginx.com>"
        },
        ID: (0, _common.randomElements)(64, stringRandom)
      },
      scope: "local",
      timeNano: "1587084600046795264.000000",
      from: "nginx",
      time: "1587084600",
      status: "start"
    }
  }
}, {
  rule: {
    firedtimes: 1,
    mail: false,
    level: 3,
    description: "Docker: Container test_container received the action: die",
    groups: ["docker"],
    id: "87928",
    gdpr: ["IV_32.2"]
  },
  data: {
    integration: "docker",
    docker: {
      Action: "die",
      Type: "container",
      Actor: {
        Attributes: {
          image: "nginx",
          name: "test_container",
          exitCode: "0",
          maintainer: "NGINX Docker Maintainers <docker-maint@nginx.com>"
        },
        ID: (0, _common.randomElements)(64, stringRandom)
      },
      scope: "local",
      timeNano: "1587084648640092672.000000",
      from: "nginx",
      time: "1587084648",
      status: "die"
    }
  }
}, {
  rule: {
    firedtimes: 1,
    mail: false,
    level: 4,
    description: "Docker: Network bridge disconnected",
    groups: ["docker"],
    id: "87929",
    gdpr: ["IV_32.2"]
  },
  data: {
    integration: "docker",
    docker: {
      Action: "disconnect",
      Type: "network",
      Actor: {
        Attributes: {
          container: (0, _common.randomElements)(64, stringRandom),
          name: "bridge",
          type: "bridge"
        },
        ID: (0, _common.randomElements)(64, stringRandom)
      },
      scope: "local",
      timeNano: "1586460544485358336.000000",
      time: "1586460544"
    }
  }
}, {
  rule: {
    firedtimes: 1,
    mail: false,
    level: 7,
    description: "Docker: Container nginx_container received the action: kill",
    groups: ["docker"],
    id: "87924",
    gdpr: ["IV_32.2"]
  },
  data: {
    integration: "docker",
    docker: {
      Action: "kill",
      Type: "container",
      Actor: {
        Attributes: {
          image: "nginx",
          name: "nginx_container",
          signal: "15",
          maintainer: "NGINX Docker Maintainers <docker-maint@nginx.com>"
        },
        ID: (0, _common.randomElements)(64, stringRandom)
      },
      scope: "local",
      timeNano: "1586460544324527616.000000",
      from: "nginx",
      time: "1586460544",
      status: "kill"
    }
  }
}, {
  rule: {
    firedtimes: 2,
    mail: false,
    level: 3,
    description: "Docker: Container nginx_container stopped",
    groups: ["docker"],
    id: "87904",
    gdpr: ["IV_32.2"]
  },
  data: {
    integration: "docker",
    docker: {
      Action: "stop",
      Type: "container",
      Actor: {
        Attributes: {
          image: "nginx",
          name: "nginx_container",
          maintainer: "NGINX Docker Maintainers <docker-maint@nginx.com>"
        },
        ID: (0, _common.randomElements)(64, stringRandom)
      },
      scope: "local",
      timeNano: "1586461541373152000.000000",
      from: "nginx",
      time: "1586461541",
      status: "stop"
    }
  }
}, {
  rule: {
    firedtimes: 1,
    mail: false,
    level: 3,
    description: "Docker: Container nginx_container restarted",
    groups: ["docker"],
    id: "87909",
    gdpr: ["IV_32.2"]
  },
  data: {
    integration: "docker",
    docker: {
      Action: "restart",
      Type: "container",
      Actor: {
        Attributes: {
          image: "nginx",
          name: "nginx_container",
          maintainer: "NGINX Docker Maintainers <docker-maint@nginx.com>"
        },
        ID: (0, _common.randomElements)(64, stringRandom)
      },
      scope: "local",
      timeNano: "1586460544801840896.000000",
      from: "nginx",
      time: "1586460544",
      status: "restart"
    }
  }
}];
exports.dataDocker = dataDocker;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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