"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.scanProfileTitle = exports.scanContent = exports.location = exports.decoder = exports.data = exports.checkTitle = exports.checkSeverity = exports.checkResult = void 0;

/*
 * Wazuh app - OpenSCAP sample data
 * Copyright (C) 2015-2022 Wazuh, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Find more information about this on the LICENSE file.
 */
// OpenSCAP
const scanProfileTitle = ["xccdf_org.ssgproject.content_profile_standard", "xccdf_org.ssgproject.content_profile_pci-dss", "xccdf_org.ssgproject.content_profile_common", "xccdf_org.ssgproject.content_profile_anssi_np_nt28_minimal"];
exports.scanProfileTitle = scanProfileTitle;
const checkSeverity = ["low", "medium", "high"];
exports.checkSeverity = checkSeverity;
const checkResult = ["fail"];
exports.checkResult = checkResult;
const scanContent = ["ssg-centos-7-ds.xml", "ssg-centos-6-ds.xml", "ssg-rhel6-ds.xml", "ssg-ubuntu18-ds.xml", "ssg-debian-ds.xml", "ssg-fedora-ds.xml"];
exports.scanContent = scanContent;
const checkTitle = ["Record Attempts to Alter the localtime File", "Record Attempts to Alter Time Through clock_settime", "Ensure auditd Collects Unauthorized Access Attempts to Files (unsuccessful)", "Ensure auditd Collects System Administrator Actions", "Ensure auditd Collects File Deletion Events by User"];
exports.checkTitle = checkTitle;
const decoder = {
  parent: "oscap",
  name: "oscap"
};
exports.decoder = decoder;
const location = 'wodle_open-scap';
exports.location = location;
const data = [{
  // "input": {
  //   "type": "log"
  // },
  "data": {
    "oscap": {
      "scan": {
        "score": "99.814812",
        "profile": {
          "id": "No profile",
          "title": "No profile"
        },
        "id": "0001587604016",
        "content": "cve-redhat-7-ds.xml",
        "benchmark": {
          "id": "xccdf_com.redhat.rhsa_benchmark_generated-xccdf"
        }
      }
    }
  },
  "rule": {
    "firedtimes": 1,
    "mail": false,
    "level": 3,
    "pci_dss": ["2.2"],
    "description": "OpenSCAP Report overview.",
    "groups": ["oscap", "oscap-report"],
    "id": "81540",
    "nist_800_53": ["CM.1"]
  },
  "full_log": "oscap: msg: \"xccdf-overview\", scan-id: \"{data.oscap.scan.id}\", content: \"{data.oscap.scan.content}\", benchmark-id: \"{data.oscap.scan.benhmark.id}\", profile-id: \"{data.oscap.scan.profile.id}\", profile-title: \"{data.oscap.scan.profile.title}\", score: \"{data.oscap.scan.score}\"."
}, {
  "data": {
    "oscap": {
      "scan": {
        "score": "75.000000",
        "profile": {
          "id": "xccdf_org.ssgproject.content_profile_common",
          "title": "Common Profile for General-Purpose Systems"
        },
        "id": "0001587603934",
        "content": "ssg-rhel-7-ds.xml",
        "benchmark": {
          "id": "xccdf_org.ssgproject.content_benchmark_RHEL-7"
        }
      }
    }
  },
  "rule": {
    "firedtimes": 2,
    "mail": false,
    "level": 5,
    "pci_dss": ["2.2"],
    "description": "OpenSCAP Report overview: Score less than 80",
    "groups": ["oscap", "oscap-report"],
    "id": "81542",
    "nist_800_53": ["CM.1"]
  },
  "full_log": "oscap: msg: \"xccdf-overview\", scan-id: \"{data.oscap.scan.id}\", content: \"{data.oscap.scan.content}\", benchmark-id: \"{data.oscap.scan.benhmark.id}\", profile-id: \"{data.oscap.scan.profile.id}\", profile-title: \"{data.oscap.scan.profile.title}\", score: \"{data.oscap.scan.score}\".",
  "timestamp": "2020-04-23T01:06:56.060+0000"
}, {
  "data": {
    "oscap": {
      "scan": {
        "profile": {
          "id": "No profile",
          "title": "No profile"
        },
        "id": "0001587604016",
        "content": "cve-redhat-7-ds.xml",
        "benchmark": {
          "id": "xccdf_com.redhat.rhsa_benchmark_generated-xccdf"
        }
      },
      "check": {
        "result": "fail",
        "severity": "high",
        "identifiers": "CVE-2016-5195 (http://cve.mitre.org), CVE-2016-7039 (http://cve.mitre.org), CVE-2016-8666 (http://cve.mitre.org)",
        "oval": {
          "id": "oval:com.redhat.rhsa:def:20170372"
        },
        "id": "xccdf_com.redhat.rhsa_rule_oval-com.redhat.rhsa-def-20170372",
        "title": "RHSA-2017:0372: kernel-aarch64 security and bug fix update (Important)"
      }
    }
  },
  "rule": {
    "firedtimes": 3,
    "mail": false,
    "level": 9,
    "pci_dss": ["2.2"],
    "description": "OpenSCAP: RHSA-2017:0372: kernel-aarch64 security and bug fix update (Important) (not passed)",
    "groups": ["oscap", "oscap-result"],
    "id": "81531",
    "nist_800_53": ["CM.1"]
  }
}, {
  "data": {
    "oscap": {
      "scan": {
        "profile": {
          "id": "xccdf_org.ssgproject.content_profile_common",
          "title": "Common Profile for General-Purpose Systems"
        },
        "id": "0001587603934",
        "content": "ssg-rhel-7-ds.xml",
        "benchmark": {
          "id": "xccdf_org.ssgproject.content_benchmark_RHEL-7"
        }
      },
      "check": {
        "result": "fail",
        "severity": "low",
        "references": "RHEL-07-030700 (http://iase.disa.mil/stigs/os/unix-linux/Pages/index.aspx), AC-2(7)(b) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AC-17(7) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-1(b) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(a) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(c) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(d) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), iAU-3(1) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-12(a) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-12(c) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), IR-5 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), 126 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), 130 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), 135 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), 172 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), 2884 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), Req-10.2.2 (https://www.pcisecuritystandards.org/documents/PCI_DSS_v3-1.pdf), Req-10.2.5.b (https://www.pcisecuritystandards.org/documents/PCI_DSS_v3-1.pdf), SRG-OS-000037-GPOS-00015 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx), SRG-OS-000042-GPOS-00020 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx), SRG-OS-000392-GPOS-00172 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx), SRG-OS-000462-GPOS-00206 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx), SRG-OS-000471-GPOS-00215 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx), 5.4.1.1 (https://www.fbi.gov/file-repository/cjis-security-policy-v5_5_20160601-2-1.pdf), 3.1.7 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-171.pdf)",
        "identifiers": "CCE-27461-3 (https://nvd.nist.gov/cce/index.cfm)",
        "oval": {
          "id": "oval:ssg-audit_rules_sysadmin_actions:def:1"
        },
        "description": "At a minimum, the audit system should collect administrator actions for all users and root. If the auditd daemon is configured to use the augenrules program to read audit rules during daemon startup (the default), add the following line to a file with suffix .rules in the directory /etc/audit/rules.d: -w /etc/sudoers -p wa -k actions -w /etc/sudoers.d/ -p wa -k actions If the auditd daemon is configured to use the auditctl utility to read audit rules during daemon startup, add the following line to /etc/audit/audit.rules file: -w /etc/sudoers -p wa -k actions -w /etc/sudoers.d/ -p wa -k actions",
        "id": "xccdf_org.ssgproject.content_rule_audit_rules_sysadmin_actions",
        "title": "Ensure auditd Collects System Administrator Actions",
        "rationale": "The actions taken by system administrators should be audited to keep a record of what was executed on the system, as well as, for accountability purposes."
      }
    }
  },
  "rule": {
    "firedtimes": 41,
    "mail": false,
    "level": 5,
    "pci_dss": ["2.2"],
    "description": "OpenSCAP: Ensure auditd Collects System Administrator Actions (not passed)",
    "groups": ["oscap", "oscap-result"],
    "id": "81529",
    "nist_800_53": ["CM.1"]
  }
}, {
  "data": {
    "oscap": {
      "scan": {
        "profile": {
          "id": "xccdf_org.ssgproject.content_profile_common",
          "title": "Common Profile for General-Purpose Systems"
        },
        "id": "0001587603934",
        "content": "ssg-rhel-7-ds.xml",
        "benchmark": {
          "id": "xccdf_org.ssgproject.content_benchmark_RHEL-7"
        }
      },
      "check": {
        "result": "fail",
        "severity": "medium",
        "references": "AC-17(7) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-1(b) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(a) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(c) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(d) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-12(a) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-12(c) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), IR-5 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), Req-10.2.7 (https://www.pcisecuritystandards.org/documents/PCI_DSS_v3-1.pdf), 5.2.17 (https://benchmarks.cisecurity.org/tools2/linux/CIS_Red_Hat_Enterprise_Linux_7_Benchmark_v1.1.0.pdf), 172 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), 5.4.1.1 (https://www.fbi.gov/file-repository/cjis-security-policy-v5_5_20160601-2-1.pdf), 3.1.7 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-171.pdf)",
        "identifiers": "CCE-27129-6 (https://nvd.nist.gov/cce/index.cfm)",
        "oval": {
          "id": "oval:ssg-audit_rules_kernel_module_loading:def:1"
        },
        "description": "If the auditd daemon is configured to use the augenrules program to read audit rules during daemon startup (the default), add the following lines to a file with suffix .rules in the directory /etc/audit/rules.d to capture kernel module loading and unloading events, setting ARCH to either b32 or b64 as appropriate for your system: -w /usr/sbin/insmod -p x -k modules -w /usr/sbin/rmmod -p x -k modules -w /usr/sbin/modprobe -p x -k modules -a always,exit -F arch=ARCH -S init_module -S delete_module -k modules If the auditd daemon is configured to use the auditctl utility to read audit rules during daemon startup, add the following lines to /etc/audit/audit.rules file in order to capture kernel module loading and unloading events, setting ARCH to either b32 or b64 as appropriate for your system: -w /usr/sbin/insmod -p x -k modules -w /usr/sbin/rmmod -p x -k modules -w /usr/sbin/modprobe -p x -k modules -a always,exit -F arch=ARCH -S init_module -S delete_module -k modules",
        "id": "xccdf_org.ssgproject.content_rule_audit_rules_kernel_module_loading",
        "title": "Ensure auditd Collects Information on Kernel Module Loading and Unloading",
        "rationale": "The addition/removal of kernel modules can be used to alter the behavior of the kernel and potentially introduce malicious code into kernel space. It is important to have an audit trail of modules that have been introduced into the kernel."
      }
    }
  },
  "rule": {
    "firedtimes": 34,
    "mail": false,
    "level": 7,
    "pci_dss": ["2.2"],
    "description": "OpenSCAP: Ensure auditd Collects Information on Kernel Module Loading and Unloading (not passed)",
    "groups": ["oscap", "oscap-result"],
    "id": "81530",
    "nist_800_53": ["CM.1"]
  }
}, {
  "data": {
    "oscap": {
      "scan": {
        "profile": {
          "id": "xccdf_org.ssgproject.content_profile_common",
          "title": "Common Profile for General-Purpose Systems"
        },
        "id": "0001587603934",
        "content": "ssg-rhel-7-ds.xml",
        "benchmark": {
          "id": "xccdf_org.ssgproject.content_benchmark_RHEL-7"
        }
      },
      "check": {
        "result": "fail",
        "severity": "medium",
        "references": "AC-17(7) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-1(b) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(a) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(c) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(d) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-12(a) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-12(c) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), IR-5 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), Req-10.2.7 (https://www.pcisecuritystandards.org/documents/PCI_DSS_v3-1.pdf), 5.2.17 (https://benchmarks.cisecurity.org/tools2/linux/CIS_Red_Hat_Enterprise_Linux_7_Benchmark_v1.1.0.pdf), 172 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), 5.4.1.1 (https://www.fbi.gov/file-repository/cjis-security-policy-v5_5_20160601-2-1.pdf), 3.1.7 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-171.pdf)",
        "identifiers": "CCE-27129-6 (https://nvd.nist.gov/cce/index.cfm)",
        "oval": {
          "id": "oval:ssg-audit_rules_kernel_module_loading:def:1"
        },
        "description": "If the auditd daemon is configured to use the augenrules program to read audit rules during daemon startup (the default), add the following lines to a file with suffix .rules in the directory /etc/audit/rules.d to capture kernel module loading and unloading events, setting ARCH to either b32 or b64 as appropriate for your system: -w /usr/sbin/insmod -p x -k modules -w /usr/sbin/rmmod -p x -k modules -w /usr/sbin/modprobe -p x -k modules -a always,exit -F arch=ARCH -S init_module -S delete_module -k modules If the auditd daemon is configured to use the auditctl utility to read audit rules during daemon startup, add the following lines to /etc/audit/audit.rules file in order to capture kernel module loading and unloading events, setting ARCH to either b32 or b64 as appropriate for your system: -w /usr/sbin/insmod -p x -k modules -w /usr/sbin/rmmod -p x -k modules -w /usr/sbin/modprobe -p x -k modules -a always,exit -F arch=ARCH -S init_module -S delete_module -k modules",
        "id": "xccdf_org.ssgproject.content_rule_audit_rules_kernel_module_loading",
        "title": "Ensure auditd Collects Information on Kernel Module Loading and Unloading",
        "rationale": "The addition/removal of kernel modules can be used to alter the behavior of the kernel and potentially introduce malicious code into kernel space. It is important to have an audit trail of modules that have been introduced into the kernel."
      }
    }
  },
  "rule": {
    "firedtimes": 34,
    "mail": false,
    "level": 7,
    "pci_dss": ["2.2"],
    "description": "OpenSCAP: Ensure auditd Collects Information on Kernel Module Loading and Unloading (not passed)",
    "groups": ["oscap", "oscap-result"],
    "id": "81530",
    "nist_800_53": ["CM.1"]
  }
}, {
  "data": {
    "oscap": {
      "scan": {
        "profile": {
          "id": "xccdf_org.ssgproject.content_profile_common",
          "title": "Common Profile for General-Purpose Systems"
        },
        "id": "0001587603934",
        "content": "ssg-rhel-7-ds.xml",
        "benchmark": {
          "id": "xccdf_org.ssgproject.content_benchmark_RHEL-7"
        }
      },
      "check": {
        "result": "fail",
        "severity": "medium",
        "references": "AC-17(7) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-1(b) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(a) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(c) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(d) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-12(a) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-12(c) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), IR-5 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), Req-10.2.7 (https://www.pcisecuritystandards.org/documents/PCI_DSS_v3-1.pdf), 5.2.14 (https://benchmarks.cisecurity.org/tools2/linux/CIS_Red_Hat_Enterprise_Linux_7_Benchmark_v1.1.0.pdf), 366 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), 172 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), 2884 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), 5.4.1.1 (https://www.fbi.gov/file-repository/cjis-security-policy-v5_5_20160601-2-1.pdf), 3.1.7 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-171.pdf)",
        "identifiers": "CCE-27206-2 (https://nvd.nist.gov/cce/index.cfm)",
        "oval": {
          "id": "oval:ssg-audit_rules_file_deletion_events:def:1"
        },
        "description": "At a minimum the audit system should collect file deletion events for all users and root. If the auditd daemon is configured to use the augenrules program to read audit rules during daemon startup (the default), add the following line to a file with suffix .rules in the directory /etc/audit/rules.d, setting ARCH to either b32 or b64 as appropriate for your system: -a always,exit -F arch=ARCH -S rmdiri,unlink,unlinkat,rename,renameat -F auid>=1000 -F auid!=4294967295 -F key=delete If the auditd daemon is configured to use the auditctl utility to read audit rules during daemon startup, add the following line to /etc/audit/audit.rules file, setting ARCH to either b32 or b64 as appropriate for your system: -a always,exit -F arch=ARCH -S rmdir,unlink,unlinkat,rename -S renameat -F auid>=1000 -F auid!=4294967295 -F key=delete",
        "id": "xccdf_org.ssgproject.content_rule_audit_rules_file_deletion_events",
        "title": "Ensure auditd Collects File Deletion Events by User",
        "rationale": "Auditing file deletions will create an audit trail for files that are removed from the system. The audit trail could aid in system troubleshooting, as well as, detecting malicious processes that attempt to delete log files to conceal their presence."
      }
    }
  },
  "rule": {
    "firedtimes": 33,
    "mail": false,
    "level": 7,
    "pci_dss": ["2.2"],
    "description": "OpenSCAP: Ensure auditd Collects File Deletion Events by User (not passed)",
    "groups": ["oscap", "oscap-result"],
    "id": "81530",
    "nist_800_53": ["CM.1"]
  }
}, {
  "data": {
    "oscap": {
      "scan": {
        "profile": {
          "id": "xccdf_org.ssgproject.content_profile_common",
          "title": "Common Profile for General-Purpose Systems"
        },
        "id": "0001587603934",
        "content": "ssg-rhel-7-ds.xml",
        "benchmark": {
          "id": "xccdf_org.ssgproject.content_benchmark_RHEL-7"
        }
      },
      "check": {
        "result": "fail",
        "severity": "medium",
        "references": "RHEL-07-030740 (http://iase.disa.mil/stigs/os/unix-linux/Pages/index.aspx), AC-17(7) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-1(b) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(a) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(c) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(d) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-3(1) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-12(a) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-12(c) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), IR-5 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), 135 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), 2884 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), SRG-OS-000042-GPOS-00020 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx), SRG-OS-000392-GPOS-00172 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx), Req-10.2.7 (https://www.pcisecuritystandards.org/documents/PCI_DSS_v3-1.pdf), 5.2.13 (https://benchmarks.cisecurity.org/tools2/linux/CIS_Red_Hat_Enterprise_Linux_7_Benchmark_v1.1.0.pdf), 5.4.1.1 (https://www.fbi.gov/file-repository/cjis-security-policy-v5_5_20160601-2-1.pdf), 3.1.7 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-171.pdf)",
        "identifiers": "CCE-27447-2 (https://nvd.nist.gov/cce/index.cfm)",
        "oval": {
          "id": "oval:ssg-audit_rules_media_export:def:1"
        },
        "description": "At a minimum, the audit system should collect media exportation events for all users and root. If the auditd daemon is configured to use the augenrules program to read audit rules during daemon startup (the default), add the following line to a file with suffix .rules in the directory /etc/audit/rules.d, setting ARCH to either b32 or b64 as appropriate for your system: -a always,exit -F arch=ARCH -S mount -F auid>=1000 -F auid!=4294967295 -F key=export If the auditd daemon is configured to use the auditctl utility to read audit rules during daemon startup, add the following line to /etc/audit/audit.rules file, setting ARCH to either b32 or b64 as appropriate for your system: -a always,exit -F arch=ARCH -S mount -F auid>=1000 -F auid!=4294967295 -F key=export",
        "id": "xccdf_org.ssgproject.content_rule_audit_rules_media_export",
        "title": "Ensure auditd Collects Information on Exporting to Media (successful)",
        "rationale": "The unauthorized exportation of data to external media could result in an information leak where classified information, Privacy Act information, and intellectual property could be lost. An audit trail should be created each time a filesystem is mounted to help identify and guard against information loss."
      }
    }
  },
  "rule": {
    "firedtimes": 32,
    "mail": false,
    "level": 7,
    "pci_dss": ["2.2"],
    "description": "OpenSCAP: Ensure auditd Collects Information on Exporting to Media (successful) (not passed)",
    "groups": ["oscap", "oscap-result"],
    "id": "81530",
    "nist_800_53": ["CM.1"]
  }
}, {
  "data": {
    "oscap": {
      "scan": {
        "profile": {
          "id": "xccdf_org.ssgproject.content_profile_common",
          "title": "Common Profile for General-Purpose Systems"
        },
        "id": "0001587603934",
        "content": "ssg-rhel-7-ds.xml",
        "benchmark": {
          "id": "xccdf_org.ssgproject.content_benchmark_RHEL-7"
        }
      },
      "check": {
        "result": "fail",
        "severity": "medium",
        "references": "RHEL-07-030360 (http://iase.disa.mil/stigs/os/unix-linux/Pages/index.aspx), AC-17(7) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-1(b) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(a) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(c) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(d) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(4) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-6(9) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-12(a) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-12(c) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), IR-5 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), 2234 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), SRG-OS-000327-GPOS-00127 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx), Req-10.2.2 (https://www.pcisecuritystandards.org/documents/PCI_DSS_v3-1.pdf), 5.2.10 (https://benchmarks.cisecurity.org/tools2/linux/CIS_Red_Hat_Enterprise_Linux_7_Benchmark_v1.1.0.pdf), 5.4.1.1 (https://www.fbi.gov/file-repository/cjis-security-policy-v5_5_20160601-2-1.pdf), 3.1.7 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-171.pdf)",
        "identifiers": "CCE-27437-3 (https://nvd.nist.gov/cce/index.cfm)",
        "oval": {
          "id": "oval:ssg-audit_rules_privileged_commands:def:1"
        },
        "description": "At a minimum, the audit system should collect the execution of privileged commands for all users and root. To find the relevant setuid / setgid programs, run the following command for each local partition PART: $ sudo find PART -xdev -type f -perm -4000 -o -type f -perm -2000 2>/dev/null If the auditd daemon is configured to use the augenrules program to read audit rules during daemon startup (the default), add a line of the following form to a file with suffix .rules in the directory /etc/audit/rules.d for each setuid / setgid program on the system, replacing the SETUID_PROG_PATH part with the full path of that setuid / setgid program in the list: -a always,exit -F path=SETUID_PROG_PATH -F perm=x -F auid>=1000 -F auid!=4294967295 -F key=privileged If the auditd daemon is configured to use the auditctl utility to read audit rules during daemon startup, add a line of the following form to /etc/audit/audit.rules for each setuid / setgid program on the system, replacing the SETUID_PROG_PATH part with the full path of that setuid / setgid program in the list: -a always,exit -F path=SETUID_PROG_PATH -F perm=x -F auid>=1000 -F auid!=4294967295 -F key=privileged",
        "id": "xccdf_org.ssgproject.content_rule_audit_rules_privileged_commands",
        "title": "Ensure auditd Collects Information on the Use of Privileged Commands",
        "rationale": "Misuse of privileged functions, either intentionally or unintentionally by authorized users, or by unauthorized external entities that have compromised system accounts, is a serious and ongoing concern and can have significant adverse impacts on organizations. Auditing the use of privileged functions is one way to detect such misuse and identify the risk from insider and advanced persistent threast. Privileged programs are subject to escalation-of-privilege attacks, which attempt to subvert their normal role of providing some necessary but limited capability. As such, motivation exists to monitor these programs for unusual activity."
      }
    }
  },
  "rule": {
    "firedtimes": 31,
    "mail": false,
    "level": 7,
    "pci_dss": ["2.2"],
    "description": "OpenSCAP: Ensure auditd Collects Information on the Use of Privileged Commands (not passed)",
    "groups": ["oscap", "oscap-result"],
    "id": "81530",
    "nist_800_53": ["CM.1"]
  }
}, {
  "data": {
    "oscap": {
      "scan": {
        "profile": {
          "id": "xccdf_org.ssgproject.content_profile_common",
          "title": "Common Profile for General-Purpose Systems"
        },
        "id": "0001587603934",
        "content": "ssg-rhel-7-ds.xml",
        "benchmark": {
          "id": "xccdf_org.ssgproject.content_benchmark_RHEL-7"
        }
      },
      "check": {
        "result": "fail",
        "severity": "medium",
        "references": "AC-17(7) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-1(b) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(a) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(c) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(d) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-12(a) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-12(c) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), IR-5 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), 172 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), 2884 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), Req-10.2.4 (https://www.pcisecuritystandards.org/documents/PCI_DSS_v3-1.pdf), Req-10.2.1 (https://www.pcisecuritystandards.org/documents/PCI_DSS_v3-1.pdf), 5.2.10 (https://benchmarks.cisecurity.org/tools2/linux/CIS_Red_Hat_Enterprise_Linux_7_Benchmark_v1.1.0.pdf), 5.4.1.1 (https://www.fbi.gov/file-repository/cjis-security-policy-v5_5_20160601-2-1.pdf), 3.1.7 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-171.pdf)",
        "identifiers": "CCE-27347-4 (https://nvd.nist.gov/cce/index.cfm)",
        "oval": {
          "id": "oval:ssg-audit_rules_unsuccessful_file_modification:def:1"
        },
        "description": "At a minimum the audit system should collect unauthorized file accesses for all users and root. If the auditd daemon is configured to use the augenrules program to read audit rules during daemon startup (the default), add the following lines to a file with suffix .rules in the directory /etc/audit/rules.d: -a always,exit -F arch=b32 -S creat,open,openat,open_by_handle_at,truncate,ftruncate -F exit=-EACCES -F auid>=1000 -F auid!=4294967295 -F key=access -a always,exit -F arch=b32 -S creat,open,openat,open_by_handle_at,truncate,ftruncate -F exit=-EPERM -F auid>=1000 -F auid!=4294967295 -F key=access If the system is 64 bit then also add the following lines: -a always,exit -F arch=b64 -S creat,open,openat,open_by_handle_at,truncate,ftruncate -F exit=-EACCES -F auid>=1000 -F auid!=4294967295 -F key=access -a always,exit -F arch=b64 -S creat,open,openat,open_by_handle_at,truncate,ftruncate -F exit=-EPERM -F auid>=1000 -F auid!=4294967295 -F key=access If the auditd daemon is configured to use the auditctl utility to read audit rules during daemon startup, add the following lines to /etc/audit/audit.rules file: -a always,exit -F arch=b32 -S creat,open,openat,open_by_handle_at,truncate,ftruncate -F exit=-EACCES -F auid>=1000 -F auid!=4294967295 -F key=access -a always,exit -F arch=b32 -S creat,open,openat,open_by_handle_at,truncate,ftruncate -F exit=-EPERM -F auid>=1000 -F auid!=4294967295 -F key=access If the system is 64 bit then also add the following lines: -a always,exit -F arch=b64 -S creat,open,openat,open_by_handle_at,truncate,ftruncate -F exit=-EACCES -F auid>=1000 -F auid!=4294967295 -F key=access -a always,exit -F arch=b64 -S creat,open,openat,open_by_handle_at,truncate,ftruncate -F exit=-EPERM -F auid>=1000 -F auid!=4294967295 -F key=access",
        "id": "xccdf_org.ssgproject.content_rule_audit_rules_unsuccessful_file_modification",
        "title": "Ensure auditd Collects Unauthorized Access Attempts to Files (unsuccessful)",
        "rationale": "Unsuccessful attempts to access files could be an indicator of malicious activity on a system. Auditing these events could serve as evidence of potential system compromise."
      }
    }
  },
  "rule": {
    "firedtimes": 30,
    "mail": false,
    "level": 7,
    "pci_dss": ["2.2"],
    "description": "OpenSCAP: Ensure auditd Collects Unauthorized Access Attempts to Files (unsuccessful) (not passed)",
    "groups": ["oscap", "oscap-result"],
    "id": "81530",
    "nist_800_53": ["CM.1"]
  }
}, {
  "data": {
    "oscap": {
      "scan": {
        "profile": {
          "id": "xccdf_org.ssgproject.content_profile_common",
          "title": "Common Profile for General-Purpose Systems"
        },
        "id": "0001587603934",
        "content": "ssg-rhel-7-ds.xml",
        "benchmark": {
          "id": "xccdf_org.ssgproject.content_benchmark_RHEL-7"
        }
      },
      "check": {
        "result": "fail",
        "severity": "low",
        "references": "RHEL-07-030370 (http://iase.disa.mil/stigs/os/unix-linux/Pages/index.aspx), AC-17(7) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-1(b) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(a) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(c) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(d) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-12(a) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-12(c) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), IR-5 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), 126 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), 172 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), Req-10.5.5 (https://www.pcisecuritystandards.org/documents/PCI_DSS_v3-1.pdf), 5.2.10 (https://benchmarks.cisecurity.org/tools2/linux/CIS_Red_Hat_Enterprise_Linux_7_Benchmark_v1.1.0.pdf), SRG-OS-000064-GPOS-00033 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx), SRG-OS-000392-GPOS-00172 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx), SRG-OS-000458-GPOS-00203 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx), SRG-OS-000474-GPOS-00219 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx), 5.4.1.1 (https://www.fbi.gov/file-repository/cjis-security-policy-v5_5_20160601-2-1.pdf), 3.1.7 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-171.pdf)",
        "identifiers": "CCE-27364-9 (https://nvd.nist.gov/cce/index.cfm)",
        "oval": {
          "id": "oval:ssg-audit_rules_dac_modification_chown:def:1"
        },
        "description": "At a minimum, the audit system should collect file permission changes for all users and root. If the auditd daemon is configured to use the augenrules program to read audit rules during daemon startup (the default), add the following line to a file with suffix .rules in the directory /etc/audit/rules.d: -a always,exit -F arch=b32 -S chown -F auid>=1000 -F auid!=4294967295 -F key=perm_mod If the system is 64 bit then also add the following line: -a always,exit -F arch=b64 -S chown -F auid>=1000 -F auid!=4294967295 -F key=perm_mod If the auditd daemon is configured to use the auditctl utility to read audit rules during daemon startup, add the following line to /etc/audit/audit.rules file: -a always,exit -F arch=b32 -S chown -F auid>=1000 -F auid!=4294967295 -F key=perm_mod If the system is 64 bit then also add the following line: -a always,exit -F arch=b64 -S chown -F auid>=1000 -F auid!=4294967295 -F key=perm_mod",
        "id": "xccdf_org.ssgproject.content_rule_audit_rules_dac_modification_chown",
        "title": "Record Events that Modify the System's Discretionary Access Controls - chown",
        "rationale": "The changing of file permissions could indicate that a user is attempting to gain access to information that would otherwise be disallowed. Auditing DAC modifications can facilitate the identification of patterns of abuse among both authorized and unauthorized users."
      }
    }
  },
  "rule": {
    "firedtimes": 32,
    "mail": false,
    "level": 5,
    "pci_dss": ["2.2"],
    "description": "OpenSCAP: Record Events that Modify the System's Discretionary Access Controls - chown (not passed)",
    "groups": ["oscap", "oscap-result"],
    "id": "81529",
    "nist_800_53": ["CM.1"]
  }
}, {
  "data": {
    "oscap": {
      "scan": {
        "profile": {
          "id": "xccdf_org.ssgproject.content_profile_common",
          "title": "Common Profile for General-Purpose Systems"
        },
        "id": "0001587603934",
        "content": "ssg-rhel-7-ds.xml",
        "benchmark": {
          "id": "xccdf_org.ssgproject.content_benchmark_RHEL-7"
        }
      },
      "check": {
        "result": "fail",
        "severity": "medium",
        "references": "RHEL-07-030470 (http://iase.disa.mil/stigs/os/unix-linux/Pages/index.aspx), AC-17(7) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-1(b) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(a) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(c) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(d) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-12(a) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-12(c) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), IR-5 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), 172 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), Req-10.5.5 (https://www.pcisecuritystandards.org/documents/PCI_DSS_v3-1.pdf), 5.2.10 (https://benchmarks.cisecurity.org/tools2/linux/CIS_Red_Hat_Enterprise_Linux_7_Benchmark_v1.1.0.pdf), SRG-OS-000064-GPOS-00033 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx), SRG-OS-000392-GPOS-00172 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx), SRG-OS-000458-GPOS-00203 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx), 5.4.1.1 (https://www.fbi.gov/file-repository/cjis-security-policy-v5_5_20160601-2-1.pdf), 3.1.7 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-171.pdf)",
        "identifiers": "CCE-27367-2 (https://nvd.nist.gov/cce/index.cfm)",
        "oval": {
          "id": "oval:ssg-audit_rules_dac_modification_removexattr:def:1"
        },
        "description": "At a minimum, the audit system should collect file permission changes for all users and root. If the auditd daemon is configured to use the augenrules program to read audit rules during daemon startup (the default), add the following line to a file with suffix .rules in the directory /etc/audit/rules.d: -a always,exit -F arch=b32 -S removexattr -F auid>=1000 -F auid!=4294967295 -F key=perm_mod If the system is 64 bit then also add the following line: -a always,exit -F arch=b64 -S removexattr -F auid>=1000 -F auid!=4294967295 -F key=perm_mod If the auditd daemon is configured to use the auditctl utility to read audit rules during daemon startup, add the following line to /etc/audit/audit.rules file: -a always,exit -F arch=b32 -S removexattr -F auid>=1000 -F auid!=4294967295 -F key=perm_mod If the system is 64 bit then also add the following line: -a always,exit -F arch=b64 -S removexattr -F auid>=1000 -F auid!=4294967295 -F key=perm_mod",
        "id": "xccdf_org.ssgproject.content_rule_audit_rules_dac_modification_removexattr",
        "title": "Record Events that Modify the System's Discretionary Access Controls - removexattr",
        "rationale": "The changing of file permissions could indicate that a user is attempting to gain access to information that would otherwise be disallowed. Auditing DAC modifications can facilitate the identification of patterns of abuse among both authorized and unauthorized users."
      }
    }
  },
  "rule": {
    "firedtimes": 29,
    "mail": false,
    "level": 7,
    "pci_dss": ["2.2"],
    "description": "OpenSCAP: Record Events that Modify the System's Discretionary Access Controls - removexattr (not passed)",
    "groups": ["oscap", "oscap-result"],
    "id": "81530",
    "nist_800_53": ["CM.1"]
  }
}, {
  "data": {
    "oscap": {
      "scan": {
        "profile": {
          "id": "xccdf_org.ssgproject.content_profile_common",
          "title": "Common Profile for General-Purpose Systems"
        },
        "id": "0001587603934",
        "content": "ssg-rhel-7-ds.xml",
        "benchmark": {
          "id": "xccdf_org.ssgproject.content_benchmark_RHEL-7"
        }
      },
      "check": {
        "result": "fail",
        "severity": "low",
        "references": "AC-17(7) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-1(b) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(a) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(c) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(d) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-12(a) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-12(c) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), IR-5 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), Req-10.5.5 (https://www.pcisecuritystandards.org/documents/PCI_DSS_v3-1.pdf), 5.4.1.1 (https://www.fbi.gov/file-repository/cjis-security-policy-v5_5_20160601-2-1.pdf), 5.2.6 (https://benchmarks.cisecurity.org/tools2/linux/CIS_Red_Hat_Enterprise_Linux_7_Benchmark_v1.1.0.pdf), 3.1.7 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-171.pdf)",
        "identifiers": "CCE-27076-9 (https://nvd.nist.gov/cce/index.cfm)",
        "oval": {
          "id": "oval:ssg-audit_rules_networkconfig_modification:def:1"
        },
        "description": "If the auditd daemon is configured to use the augenrules program to read audit rules during daemon startup (the default), add the following lines to a file with suffix .rules in the directory /etc/audit/rules.d, setting ARCH to either b32 or b64 as appropriate for your system: -a always,exit -F arch=ARCH -S sethostname,setdomainname -F key=audit_rules_networkconfig_modification -w /etc/issue -p wa -k audit_rules_networkconfig_modification -w /etc/issue.net -p wa -k audit_rules_networkconfig_modification -w /etc/hosts -p wa -k audit_rules_networkconfig_modification -w /etc/sysconfig/network -p wa -k audit_rules_networkconfig_modification If the auditd daemon is configured to use the auditctl utility to read audit rules during daemon startup, add the following lines to /etc/audit/audit.rules file, setting ARCH to either b32 or b64 as appropriate for your system: -a always,exit -F arch=ARCH -S sethostname,setdomainname -F key=audit_rules_networkconfig_modification -w /etc/issue -p wa -k audit_rules_networkconfig_modification -w /etc/issue.net -p wa -k audit_rules_networkconfig_modification -w /etc/hosts -p wa -k audit_rules_networkconfig_modification -w /etc/sysconfig/network -p wa -k audit_rules_networkconfig_modification",
        "id": "xccdf_org.ssgproject.content_rule_audit_rules_networkconfig_modification",
        "title": "Record Events that Modify the System's Network Environment",
        "rationale": "The network environment should not be modified by anything other than administrator action. Any change to network parameters should be audited."
      }
    }
  },
  "rule": {
    "firedtimes": 29,
    "mail": false,
    "level": 5,
    "pci_dss": ["2.2"],
    "description": "OpenSCAP: Record Events that Modify the System's Network Environment (not passed)",
    "groups": ["oscap", "oscap-result"],
    "id": "81529",
    "nist_800_53": ["CM.1"]
  }
}, {
  "data": {
    "oscap": {
      "scan": {
        "profile": {
          "id": "xccdf_org.ssgproject.content_profile_common",
          "title": "Common Profile for General-Purpose Systems"
        },
        "id": "0001587603934",
        "content": "ssg-rhel-7-ds.xml",
        "benchmark": {
          "id": "xccdf_org.ssgproject.content_benchmark_RHEL-7"
        }
      },
      "check": {
        "result": "fail",
        "severity": "low",
        "references": "RHEL-07-030710 (http://iase.disa.mil/stigs/os/unix-linux/Pages/index.aspx), AC-2(4) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AC-17(7) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-1(b) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(a) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(c) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(d) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-12(a) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-12(c) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), IR-5 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), 18 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), 172 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), 1403 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), 2130 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), Req-10.2.5 (https://www.pcisecuritystandards.org/documents/PCI_DSS_v3-1.pdf), 5.2.5 (https://benchmarks.cisecurity.org/tools2/linux/CIS_Red_Hat_Enterprise_Linux_7_Benchmark_v1.1.0.pdf), SRG-OS-000004-GPOS-00004 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx), SRG-OS-000239-GPOS-00089 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx), SRG-OS-000241-GPOS-00090 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx), SRG-OS-000241-GPOS-00091 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx), SRG-OS-000303-GPOS-00120 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx), SRG-OS-000476-GPOS-00221 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx), 5.4.1.1 (https://www.fbi.gov/file-repository/cjis-security-policy-v5_5_20160601-2-1.pdf), 3.1.7 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-171.pdf)",
        "identifiers": "CCE-27192-4 (https://nvd.nist.gov/cce/index.cfm)",
        "oval": {
          "id": "oval:ssg-audit_rules_usergroup_modification:def:1"
        },
        "description": "If the auditd daemon is configured to use the augenrules program to read audit rules during daemon startup (the default), add the following lines to a file with suffix .rules in the directory /etc/audit/rules.d, in order to capture events that modify account changes: -w /etc/group -p wa -k audit_rules_usergroup_modification -w /etc/passwd -p wa -k audit_rules_usergroup_modification -w /etc/gshadow -p wa -k audit_rules_usergroup_modification -w /etc/shadow -p wa -k audit_rules_usergroup_modification -w /etc/security/opasswd -p wa -k audit_rules_usergroup_modification If the auditd daemon is configured to use the auditctl utility to read audit rules during daemon startup, add the following lines to /etc/audit/audit.rules file, in order to capture events that modify account changes: -w /etc/group -p wa -k audit_rules_usergroup_modification -w /etc/passwd -p wa -k audit_rules_usergroup_modification -w /etc/gshadow -p wa -k audit_rules_usergroup_modification -w /etc/shadow -p wa -k audit_rules_usergroup_modification -w /etc/security/opasswd -p wa -k audit_rules_usergroup_modification",
        "id": "xccdf_org.ssgproject.content_rule_audit_rules_usergroup_modification",
        "title": "Record Events that Modify User/Group Information",
        "rationale": "In addition to auditing new user and group accounts, these watches will alert the system administrator(s) to any modifications. Any unexpected users, groups, or modifications should be investigated for legitimacy."
      }
    }
  },
  "rule": {
    "firedtimes": 28,
    "mail": false,
    "level": 5,
    "pci_dss": ["2.2"],
    "description": "OpenSCAP: Record Events that Modify User/Group Information (not passed)",
    "groups": ["oscap", "oscap-result"],
    "id": "81529",
    "nist_800_53": ["CM.1"]
  }
}, {
  "data": {
    "oscap": {
      "scan": {
        "profile": {
          "id": "xccdf_org.ssgproject.content_profile_common",
          "title": "Common Profile for General-Purpose Systems"
        },
        "id": "0001587603934",
        "content": "ssg-rhel-7-ds.xml",
        "benchmark": {
          "id": "xccdf_org.ssgproject.content_benchmark_RHEL-7"
        }
      },
      "check": {
        "result": "fail",
        "severity": "low",
        "references": "AC-17(7) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-1(b) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(a) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(c) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(d) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-12(a) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-12(b) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), IR-5 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), 5.2.4 (https://benchmarks.cisecurity.org/tools2/linux/CIS_Red_Hat_Enterprise_Linux_7_Benchmark_v1.1.0.pdf), Req-10.4.2.b (https://www.pcisecuritystandards.org/documents/PCI_DSS_v3-1.pdf), 1487 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), 169 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), 5.4.1.1 (https://www.fbi.gov/file-repository/cjis-security-policy-v5_5_20160601-2-1.pdf), 3.1.7 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-171.pdf)",
        "identifiers": "CCE-27310-2 (https://nvd.nist.gov/cce/index.cfm)",
        "oval": {
          "id": "oval:ssg-audit_rules_time_watch_localtime:def:1"
        },
        "description": "If the auditd daemon is configured to use the augenrules program to read audit rules during daemon startup (the default), add the following line to a file with suffix .rules in the directory /etc/audit/rules.d: -w /etc/localtime -p wa -k audit_time_rules If the auditd daemon is configured to use the auditctl utility to read audit rules during daemon startup, add the following line to /etc/audit/audit.rules file: -w /etc/localtime -p wa -k audit_time_rules The -k option allows for the specification of a key in string form that can be used for better reporting capability through ausearch and aureport and should always be used.",
        "id": "xccdf_org.ssgproject.content_rule_audit_rules_time_watch_localtime",
        "title": "Record Attempts to Alter the localtime File",
        "rationale": "Arbitrary changes to the system time can be used to obfuscate nefarious activities in log files, as well as to confuse network services that are highly dependent upon an accurate system time (such as sshd). All changes to the system time should be audited."
      }
    }
  },
  "rule": {
    "firedtimes": 27,
    "mail": false,
    "level": 5,
    "pci_dss": ["2.2"],
    "description": "OpenSCAP: Record Attempts to Alter the localtime File (not passed)",
    "groups": ["oscap", "oscap-result"],
    "id": "81529",
    "nist_800_53": ["CM.1"]
  }
}, {
  "data": {
    "oscap": {
      "scan": {
        "profile": {
          "id": "xccdf_org.ssgproject.content_profile_common",
          "title": "Common Profile for General-Purpose Systems"
        },
        "id": "0001587603934",
        "content": "ssg-rhel-7-ds.xml",
        "benchmark": {
          "id": "xccdf_org.ssgproject.content_benchmark_RHEL-7"
        }
      },
      "check": {
        "result": "fail",
        "severity": "low",
        "references": "AC-17(7) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-1(b) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(a) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(c) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(d) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-12(a) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-12(c) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), IR-5 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), 5.2.4 (https://benchmarks.cisecurity.org/tools2/linux/CIS_Red_Hat_Enterprise_Linux_7_Benchmark_v1.1.0.pdf), Req-10.4.2.b (https://www.pcisecuritystandards.org/documents/PCI_DSS_v3-1.pdf), 1487 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), 169 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), 5.4.1.1 (https://www.fbi.gov/file-repository/cjis-security-policy-v5_5_20160601-2-1.pdf), 3.1.7 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-171.pdf)",
        "identifiers": "CCE-27219-5 (https://nvd.nist.gov/cce/index.cfm)",
        "oval": {
          "id": "oval:ssg-audit_rules_time_clock_settime:def:1"
        },
        "description": "If the auditd daemon is configured to use the augenrules program to read audit rules during daemon startup (the default), add the following line to a file with suffix .rules in the directory /etc/audit/rules.d: -a always,exit -F arch=b32 -S clock_settime -F a0=0x0 -F key=time-change If the system is 64 bit then also add the following line: -a always,exit -F arch=b64 -S clock_settime -F a0=0x0 -F key=time-change If the auditd daemon is configured to use the auditctl utility to read audit rules during daemon startup, add the following line to /etc/audit/audit.rules file: -a always,exit -F arch=b32 -S clock_settime -F a0=0x0 -F key=time-change If the system is 64 bit then also add the following line: -a always,exit -F arch=b64 -S clock_settime -F a0=0x0 -F key=time-change The -k option allows for the specification of a key in string form that can be used for better reporting capability through ausearch and aureport. Multiple system calls can be defined on the same line to save space if desired, but is not required. See an example of multiple combined syscalls: -a always,exit -F arch=b64 -S adjtimex,settimeofday -F key=audit_time_rules",
        "id": "xccdf_org.ssgproject.content_rule_audit_rules_time_clock_settime",
        "title": "Record Attempts to Alter Time Through clock_settime",
        "rationale": "Arbitrary changes to the system time can be used to obfuscate nefarious activities in log files, as well as to confuse network services that are highly dependent upon an accurate system time (such as sshd). All changes to the system time should be audited."
      }
    }
  },
  "rule": {
    "firedtimes": 26,
    "mail": false,
    "level": 5,
    "pci_dss": ["2.2"],
    "description": "OpenSCAP: Record Attempts to Alter Time Through clock_settime (not passed)",
    "groups": ["oscap", "oscap-result"],
    "id": "81529",
    "nist_800_53": ["CM.1"]
  }
}, {
  "data": {
    "oscap": {
      "scan": {
        "profile": {
          "id": "xccdf_org.ssgproject.content_profile_common",
          "title": "Common Profile for General-Purpose Systems"
        },
        "id": "0001587603934",
        "content": "ssg-rhel-7-ds.xml",
        "benchmark": {
          "id": "xccdf_org.ssgproject.content_benchmark_RHEL-7"
        }
      },
      "check": {
        "result": "fail",
        "severity": "low",
        "references": "AC-17(7) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-1(b) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(a) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(c) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(d) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-12(a) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-12(c) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), IR-5 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), 5.2.4 (https://benchmarks.cisecurity.org/tools2/linux/CIS_Red_Hat_Enterprise_Linux_7_Benchmark_v1.1.0.pdf), Req-10.4.2.b (https://www.pcisecuritystandards.org/documents/PCI_DSS_v3-1.pdf), 1487 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), 169 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), 5.4.1.1 (https://www.fbi.gov/file-repository/cjis-security-policy-v5_5_20160601-2-1.pdf), 3.1.7 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-171.pdf)",
        "identifiers": "CCE-27216-1 (https://nvd.nist.gov/cce/index.cfm)",
        "oval": {
          "id": "oval:ssg-audit_rules_time_settimeofday:def:1"
        },
        "description": "If the auditd daemon is configured to use the augenrules program to read audit rules during daemon startup (the default), add the following line to a file with suffix .rules in the directory /etc/audit/rules.d: -a always,exit -F arch=b32 -S settimeofday -F key=audit_time_rules If the system is 64 bit then also add the following line: -a always,exit -F arch=b64 -S settimeofday -F key=audit_time_rules If the auditd daemon is configured to use the auditctl utility to read audit rules during daemon startup, add the following line to /etc/audit/audit.rules file: -a always,exit -F arch=b32 -S settimeofday -F key=audit_time_rules If the system is 64 bit then also add the following line: -a always,exit -F arch=b64 -S settimeofday -F key=audit_time_rules The -k option allows for the specification of a key in string form that can be used for better reporting capability through ausearch and aureport. Multiple system calls can be defined on the same line to save space if desired, but is not required. See an example of multiple combined syscalls: -a always,exit -F arch=b64 -S adjtimex,settimeofday -F key=audit_time_rules",
        "id": "xccdf_org.ssgproject.content_rule_audit_rules_time_settimeofday",
        "title": "Record attempts to alter time through settimeofday",
        "rationale": "Arbitrary changes to the system time can be used to obfuscate nefarious activities in log files, as well as to confuse network services that are highly dependent upon an accurate system time (such as sshd). All changes to the system time should be audited."
      }
    }
  },
  "rule": {
    "firedtimes": 25,
    "mail": false,
    "level": 5,
    "pci_dss": ["2.2"],
    "description": "OpenSCAP: Record attempts to alter time through settimeofday (not passed)",
    "groups": ["oscap", "oscap-result"],
    "id": "81529",
    "nist_800_53": ["CM.1"]
  }
}, {
  "data": {
    "oscap": {
      "scan": {
        "profile": {
          "id": "xccdf_org.ssgproject.content_profile_pci-dss",
          "title": "PCI-DSS v3 Control Baseline for Red Hat Enterprise Linux 7"
        },
        "id": "0001587603717",
        "content": "ssg-rhel-7-ds.xml",
        "benchmark": {
          "id": "xccdf_org.ssgproject.content_benchmark_RHEL-7"
        }
      },
      "check": {
        "result": "fail",
        "severity": "medium",
        "references": "AC-17(7) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-1(b) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(a) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(c) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(d) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-12(a) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-12(c) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), IR-5 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), Req-10.2.7 (https://www.pcisecuritystandards.org/documents/PCI_DSS_v3-1.pdf), 5.2.14 (https://benchmarks.cisecurity.org/tools2/linux/CIS_Red_Hat_Enterprise_Linux_7_Benchmark_v1.1.0.pdf), 366 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), 172 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), 2884 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), 5.4.1.1 (https://www.fbi.gov/file-repository/cjis-security-policy-v5_5_20160601-2-1.pdf), 3.1.7 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-171.pdf)",
        "identifiers": "CCE-27206-2 (https://nvd.nist.gov/cce/index.cfm)",
        "oval": {
          "id": "oval:ssg-audit_rules_file_deletion_events:def:1"
        },
        "description": "At a minimum the audit system should collect file deletion events for all users and root. If the auditd daemon is configured to use the augenrules program to read audit rules during daemon startup (the default), add the following line to a file with suffix .rules in the directory /etc/audit/rules.d, setting ARCH to either b32 or b64 as appropriate for your system: -a always,exit -F arch=ARCH -S rmdiri,unlink,unlinkat,rename,renameat -F auid>=1000 -F auid!=4294967295 -F key=delete If the auditd daemon is configured to use the auditctl utility to read audit rules during daemon startup, add the following line to /etc/audit/audit.rules file, setting ARCH to either b32 or b64 as appropriate for your system: -a always,exit -F arch=ARCH -S rmdir,unlink,unlinkat,rename -S renameat -F auid>=1000 -F auid!=4294967295 -F key=delete",
        "id": "xccdf_org.ssgproject.content_rule_audit_rules_file_deletion_events",
        "title": "Ensure auditd Collects File Deletion Events by User",
        "rationale": "Auditing file deletions will create an audit trail for files that are removed from the system. The audit trail could aid in system troubleshooting, as well as, detecting malicious processes that attempt to delete log files to conceal their presence."
      }
    }
  },
  "rule": {
    "firedtimes": 24,
    "mail": false,
    "level": 7,
    "pci_dss": ["2.2"],
    "description": "OpenSCAP: Ensure auditd Collects File Deletion Events by User (not passed)",
    "groups": ["oscap", "oscap-result"],
    "id": "81530",
    "nist_800_53": ["CM.1"]
  }
}, {
  "data": {
    "oscap": {
      "scan": {
        "profile": {
          "id": "xccdf_org.ssgproject.content_profile_pci-dss",
          "title": "PCI-DSS v3 Control Baseline for Red Hat Enterprise Linux 7"
        },
        "id": "0001587603717",
        "content": "ssg-rhel-7-ds.xml",
        "benchmark": {
          "id": "xccdf_org.ssgproject.content_benchmark_RHEL-7"
        }
      },
      "check": {
        "result": "fail",
        "severity": "medium",
        "references": "AC-17(7) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-1(b) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-12(a) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-12(c) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), IR-5 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), 172 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), 2884 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), Req-10.2.3 (https://www.pcisecuritystandards.org/documents/PCI_DSS_v3-1.pdf), 5.2.8 (https://benchmarks.cisecurity.org/tools2/linux/CIS_Red_Hat_Enterprise_Linux_7_Benchmark_v1.1.0.pdf), 5.4.1.1 (https://www.fbi.gov/file-repository/cjis-security-policy-v5_5_20160601-2-1.pdf), 3.1.7 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-171.pdf)",
        "identifiers": "CCE-27204-7 (https://nvd.nist.gov/cce/index.cfm)",
        "oval": {
          "id": "oval:ssg-audit_rules_login_events:def:1"
        },
        "description": "The audit system already collects login information for all users and root. If the auditd daemon is configured to use the augenrules program to read audit rules during daemon startup (the default), add the following lines to a file with suffix .rules in the directory /etc/audit/rules.d in order to watch for attempted manual edits of files involved in storing logon events: -w /var/log/tallylog -p wa -k logins -w /var/run/faillock/ -p wa -k logins -w /var/log/lastlog -p wa -k logins If the auditd daemon is configured to use the auditctl utility to read audit rules during daemon startup, add the following lines to /etc/audit/audit.rules file in order to watch for unattempted manual edits of files involved in storing logon events: -w /var/log/tallylog -p wa -k logins -w /var/run/faillock/ -p wa -k logins -w /var/log/lastlog -p wa -k logins",
        "id": "xccdf_org.ssgproject.content_rule_audit_rules_login_events",
        "title": "Record Attempts to Alter Logon and Logout Events",
        "rationale": "Manual editing of these files may indicate nefarious activity, such as an attacker attempting to remove evidence of an intrusion."
      }
    }
  },
  "rule": {
    "firedtimes": 20,
    "mail": false,
    "level": 7,
    "pci_dss": ["2.2"],
    "description": "OpenSCAP: Record Attempts to Alter Logon and Logout Events (not passed)",
    "groups": ["oscap", "oscap-result"],
    "id": "81530",
    "nist_800_53": ["CM.1"]
  }
}, {
  "data": {
    "oscap": {
      "scan": {
        "profile": {
          "id": "xccdf_org.ssgproject.content_profile_pci-dss",
          "title": "PCI-DSS v3 Control Baseline for Red Hat Enterprise Linux 7"
        },
        "id": "0001587603717",
        "content": "ssg-rhel-7-ds.xml",
        "benchmark": {
          "id": "xccdf_org.ssgproject.content_benchmark_RHEL-7"
        }
      },
      "check": {
        "result": "fail",
        "severity": "low",
        "references": "RHEL-07-030710 (http://iase.disa.mil/stigs/os/unix-linux/Pages/index.aspx), AC-2(4) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AC-17(7) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-1(b) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(a) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(c) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(d) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-12(a) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-12(c) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), IR-5 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), 18 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), 172 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), 1403 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), 2130 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), Req-10.2.5 (https://www.pcisecuritystandards.org/documents/PCI_DSS_v3-1.pdf), 5.2.5 (https://benchmarks.cisecurity.org/tools2/linux/CIS_Red_Hat_Enterprise_Linux_7_Benchmark_v1.1.0.pdf), SRG-OS-000004-GPOS-00004 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx), SRG-OS-000239-GPOS-00089 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx), SRG-OS-000241-GPOS-00090 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx), SRG-OS-000241-GPOS-00091 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx), SRG-OS-000303-GPOS-00120 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx), SRG-OS-000476-GPOS-00221 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx), 5.4.1.1 (https://www.fbi.gov/file-repository/cjis-security-policy-v5_5_20160601-2-1.pdf), 3.1.7 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-171.pdf)",
        "identifiers": "CCE-27192-4 (https://nvd.nist.gov/cce/index.cfm)",
        "oval": {
          "id": "oval:ssg-audit_rules_usergroup_modification:def:1"
        },
        "description": "If the auditd daemon is configured to use the augenrules program to read audit rules during daemon startup (the default), add the following lines to a file with suffix .rules in the directory /etc/audit/rules.d, in order to capture events that modify account changes: -w /etc/group -p wa -k audit_rules_usergroup_modification -w /etc/passwd -p wa -k audit_rules_usergroup_modification -w /etc/gshadow -p wa -k audit_rules_usergroup_modification -w /etc/shadow -p wa -k audit_rules_usergroup_modification -w /etc/security/opasswd -p wa -k audit_rules_usergroup_modification If the auditd daemon is configured to use the auditctl utility to read audit rules during daemon startup, add the following lines to /etc/audit/audit.rules file, in order to capture events that modify account changes: -w /etc/group -p wa -k audit_rules_usergroup_modification -w /etc/passwd -p wa -k audit_rules_usergroup_modification -w /etc/gshadow -p wa -k audit_rules_usergroup_modification -w /etc/shadow -p wa -k audit_rules_usergroup_modification -w /etc/security/opasswd -p wa -k audit_rules_usergroup_modification",
        "id": "xccdf_org.ssgproject.content_rule_audit_rules_usergroup_modification",
        "title": "Record Events that Modify User/Group Information",
        "rationale": "In addition to auditing new user and group accounts, these watches will alert the system administrator(s) to any modifications. Any unexpected users, groups, or modifications should be investigated for legitimacy."
      }
    }
  },
  "rule": {
    "firedtimes": 6,
    "mail": false,
    "level": 5,
    "pci_dss": ["2.2"],
    "description": "OpenSCAP: Record Events that Modify User/Group Information (not passed)",
    "groups": ["oscap", "oscap-result"],
    "id": "81529",
    "nist_800_53": ["CM.1"]
  }
}, {
  "data": {
    "oscap": {
      "scan": {
        "profile": {
          "id": "xccdf_org.ssgproject.content_profile_pci-dss",
          "title": "PCI-DSS v3 Control Baseline for Red Hat Enterprise Linux 7"
        },
        "id": "0001587603717",
        "content": "ssg-rhel-7-ds.xml",
        "benchmark": {
          "id": "xccdf_org.ssgproject.content_benchmark_RHEL-7"
        }
      },
      "check": {
        "result": "fail",
        "severity": "medium",
        "references": "AU-1(b) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-3(2) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), IR-5 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), 136 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), Req-10.5.3 (https://www.pcisecuritystandards.org/documents/PCI_DSS_v3-1.pdf), 5.4.1.1 (https://www.fbi.gov/file-repository/cjis-security-policy-v5_5_20160601-2-1.pdf), 3.3.1 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-171.pdf)",
        "identifiers": "CCE-27341-7 (https://nvd.nist.gov/cce/index.cfm)",
        "oval": {
          "id": "oval:ssg-auditd_audispd_syslog_plugin_activated:def:1"
        },
        "description": "To configure the auditd service to use the syslog plug-in of the audispd audit event multiplexor, set the active line in /etc/audisp/plugins.d/syslog.conf to yes. Restart the auditd service: $ sudo service auditd restart",
        "id": "xccdf_org.ssgproject.content_rule_auditd_audispd_syslog_plugin_activated",
        "title": "Configure auditd to use audispd's syslog plugin",
        "rationale": "The auditd service does not include the ability to send audit records to a centralized server for management directly. It does, however, include a plug-in for audit event multiplexor (audispd) to pass audit records to the local syslog server"
      }
    }
  },
  "rule": {
    "firedtimes": 16,
    "mail": false,
    "level": 7,
    "pci_dss": ["2.2"],
    "description": "OpenSCAP: Configure auditd to use audispd's syslog plugin (not passed)",
    "groups": ["oscap", "oscap-result"],
    "id": "81530",
    "nist_800_53": ["CM.1"]
  }
}, {
  "data": {
    "oscap": {
      "scan": {
        "profile": {
          "id": "xccdf_org.ssgproject.content_profile_pci-dss",
          "title": "PCI-DSS v3 Control Baseline for Red Hat Enterprise Linux 7"
        },
        "id": "0001587603717",
        "content": "ssg-rhel-7-ds.xml",
        "benchmark": {
          "id": "xccdf_org.ssgproject.content_benchmark_RHEL-7"
        }
      },
      "check": {
        "result": "fail",
        "severity": "medium",
        "references": "RHEL-07-010500 (http://iase.disa.mil/stigs/os/unix-linux/Pages/index.aspx), IA-2(2) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), 765 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), 766 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), 767 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), 768 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), 771 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), 772 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), 884 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), Req-8.3 (https://www.pcisecuritystandards.org/documents/PCI_DSS_v3-1.pdf), SRG-OS-000104-GPOS-00051 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx), SRG-OS-000106-GPOS-00053 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx), SRG-OS-000107-GPOS-00054 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx), SRG-OS-000109-GPOS-00056 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx), SRG-OS-000108-GPOS-00055 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx), SRG-OS-000108-GPOS-00057 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx), SRG-OS-000108-GPOS-00058 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx)",
        "identifiers": "CCE-80207-4 (https://nvd.nist.gov/cce/index.cfm)",
        "oval": {
          "id": "oval:ssg-smartcard_auth:def:1"
        },
        "description": "To enable smart card authentication, consult the documentation at: https://access.redhat.com/documentation/en-US/Red_Hat_Enterprise_Linux/7/html/System-Level_Authentication_Guide/smartcards.html#authconfig-smartcards For guidance on enabling SSH to authenticate against a Common Access Card (CAC), consult documentation at: https://access.redhat.com/solutions/82273",
        "id": "xccdf_org.ssgproject.content_rule_smartcard_auth",
        "title": "Enable Smart Card Login",
        "rationale": "Smart card login provides two-factor authentication stronger than that provided by a username and password combination. Smart cards leverage PKI (public key infrastructure) in order to provide and verify credentials."
      }
    }
  },
  "rule": {
    "firedtimes": 11,
    "mail": false,
    "level": 7,
    "pci_dss": ["2.2"],
    "description": "OpenSCAP: Enable Smart Card Login (not passed)",
    "groups": ["oscap", "oscap-result"],
    "id": "81530",
    "nist_800_53": ["CM.1"]
  }
}, {
  "data": {
    "oscap": {
      "scan": {
        "profile": {
          "id": "xccdf_org.ssgproject.content_profile_pci-dss",
          "title": "PCI-DSS v3 Control Baseline for Red Hat Enterprise Linux 7"
        },
        "id": "0001587603717",
        "content": "ssg-rhel-7-ds.xml",
        "benchmark": {
          "id": "xccdf_org.ssgproject.content_benchmark_RHEL-7"
        }
      },
      "check": {
        "result": "fail",
        "severity": "medium",
        "references": "RHEL-07-010270 (http://iase.disa.mil/stigs/os/unix-linux/Pages/index.aspx), IA-5(f) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), IA-5(1)(e) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), 200 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), SRG-OS-000077-GPOS-00045 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx), Req-8.2.5 (https://www.pcisecuritystandards.org/documents/PCI_DSS_v3-1.pdf), 5.3.3 (https://benchmarks.cisecurity.org/tools2/linux/CIS_Red_Hat_Enterprise_Linux_7_Benchmark_v1.1.0.pdf), 5.6.2.1.1 (https://www.fbi.gov/file-repository/cjis-security-policy-v5_5_20160601-2-1.pdf), 3.5.8 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-171.pdf)",
        "identifiers": "CCE-26923-3 (https://nvd.nist.gov/cce/index.cfm)",
        "oval": {
          "id": "oval:ssg-accounts_password_pam_unix_remember:def:1"
        },
        "description": "Do not allow users to reuse recent passwords. This can be accomplished by using the remember option for the pam_unix or pam_pwhistory PAM modules. In the file /etc/pam.d/system-auth, append remember= to the line which refers to the pam_unix.so or pam_pwhistory.somodule, as shown below: for the pam_unix.so case: password sufficient pam_unix.so ...existing_options... remember= for the pam_pwhistory.so case: password requisite pam_pwhistory.so ...existing_options... remember= The DoD STIG requirement is 5 passwords.",
        "id": "xccdf_org.ssgproject.content_rule_accounts_password_pam_unix_remember",
        "title": "Limit Password Reuse",
        "rationale": "Preventing re-use of previous passwords helps ensure that a compromised password is not re-used by a user."
      }
    }
  },
  "rule": {
    "firedtimes": 10,
    "mail": false,
    "level": 7,
    "pci_dss": ["2.2"],
    "description": "OpenSCAP: Limit Password Reuse (not passed)",
    "groups": ["oscap", "oscap-result"],
    "id": "81530",
    "nist_800_53": ["CM.1"]
  }
}, {
  "data": {
    "oscap": {
      "scan": {
        "profile": {
          "id": "xccdf_org.ssgproject.content_profile_pci-dss",
          "title": "PCI-DSS v3 Control Baseline for Red Hat Enterprise Linux 7"
        },
        "id": "0001587603717",
        "content": "ssg-rhel-7-ds.xml",
        "benchmark": {
          "id": "xccdf_org.ssgproject.content_benchmark_RHEL-7"
        }
      },
      "check": {
        "result": "fail",
        "severity": "medium",
        "references": "RHEL-07-010320 (http://iase.disa.mil/stigs/os/unix-linux/Pages/index.aspx), AC-7(b) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), 002238 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), SRG-OS-000329-GPOS-00128 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx), SRG-OS-000021-GPOS-00005 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx), Req-8.1.7 (https://www.pcisecuritystandards.org/documents/PCI_DSS_v3-1.pdf), 6.3.3 (https://benchmarks.cisecurity.org/tools2/linux/CIS_Red_Hat_Enterprise_Linux_7_Benchmark_v1.1.0.pdf), 5.5.3 (https://www.fbi.gov/file-repository/cjis-security-policy-v5_5_20160601-2-1.pdf), 3.1.8 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-171.pdf)",
        "identifiers": "CCE-26884-7 (https://nvd.nist.gov/cce/index.cfm)",
        "oval": {
          "id": "oval:ssg-accounts_passwords_pam_faillock_unlock_time:def:1"
        },
        "description": "To configure the system to lock out accounts after a number of incorrect login attempts and require an administrator to unlock the account using pam_faillock.so, modify the content of both /etc/pam.d/system-auth and /etc/pam.d/password-auth as follows: add the following line immediately before the pam_unix.so statement in the AUTH section: auth required pam_faillock.so preauth silent deny= unlock_time= fail_interval= add the following line immediately after the pam_unix.so statement in the AUTH section: auth [default=die] pam_faillock.so authfail deny= unlock_time= fail_interval= add the following line immediately before the pam_unix.so statement in the ACCOUNT section: account required pam_faillock.so",
        "id": "xccdf_org.ssgproject.content_rule_accounts_passwords_pam_faillock_unlock_time",
        "title": "Set Lockout Time For Failed Password Attempts",
        "rationale": "Locking out user accounts after a number of incorrect attempts prevents direct password guessing attacks. Ensuring that an administrator is involved in unlocking locked accounts draws appropriate attention to such situations."
      }
    }
  },
  "rule": {
    "firedtimes": 9,
    "mail": false,
    "level": 7,
    "pci_dss": ["2.2"],
    "description": "OpenSCAP: Set Lockout Time For Failed Password Attempts (not passed)",
    "groups": ["oscap", "oscap-result"],
    "id": "81530",
    "nist_800_53": ["CM.1"]
  }
}, {
  "data": {
    "oscap": {
      "scan": {
        "profile": {
          "id": "xccdf_org.ssgproject.content_profile_pci-dss",
          "title": "PCI-DSS v3 Control Baseline for Red Hat Enterprise Linux 7"
        },
        "id": "0001587603717",
        "content": "ssg-rhel-7-ds.xml",
        "benchmark": {
          "id": "xccdf_org.ssgproject.content_benchmark_RHEL-7"
        }
      },
      "check": {
        "result": "fail",
        "severity": "medium",
        "references": "RHEL-07-010320 (http://iase.disa.mil/stigs/os/unix-linux/Pages/index.aspx), AC-7(b) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), 2238 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), SRG-OS-000329-GPOS-00128 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx), SRG-OS-000021-GPOS-00005 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx), Req-8.1.6 (https://www.pcisecuritystandards.org/documents/PCI_DSS_v3-1.pdf), 6.3.3 (https://benchmarks.cisecurity.org/tools2/linux/CIS_Red_Hat_Enterprise_Linux_7_Benchmark_v1.1.0.pdf), 5.5.3 (https://www.fbi.gov/file-repository/cjis-security-policy-v5_5_20160601-2-1.pdf), 3.1.8 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-171.pdf)",
        "identifiers": "CCE-27350-8 (https://nvd.nist.gov/cce/index.cfm)",
        "oval": {
          "id": "oval:ssg-accounts_passwords_pam_faillock_deny:def:1"
        },
        "description": "To configure the system to lock out accounts after a number of incorrect login attempts using pam_faillock.so, modify the content of both /etc/pam.d/system-auth and /etc/pam.d/password-auth as follows: add the following line immediately before the pam_unix.so statement in the AUTH section: auth required pam_faillock.so preauth silent deny= unlock_time= fail_interval= add the following line immediately after the pam_unix.so statement in the AUTH section: auth [default=die] pam_faillock.so authfail deny= unlock_time= fail_interval= add the following line immediately before the pam_unix.so statement in the ACCOUNT section: account required pam_faillock.so",
        "id": "xccdf_org.ssgproject.content_rule_accounts_passwords_pam_faillock_deny",
        "title": "Set Deny For Failed Password Attempts",
        "rationale": "Locking out user accounts after a number of incorrect attempts prevents direct password guessing attacks."
      }
    }
  },
  "rule": {
    "firedtimes": 8,
    "mail": false,
    "level": 7,
    "pci_dss": ["2.2"],
    "description": "OpenSCAP: Set Deny For Failed Password Attempts (not passed)",
    "groups": ["oscap", "oscap-result"],
    "id": "81530",
    "nist_800_53": ["CM.1"]
  }
}, {
  "data": {
    "oscap": {
      "scan": {
        "profile": {
          "id": "xccdf_org.ssgproject.content_profile_pci-dss",
          "title": "PCI-DSS v3 Control Baseline for Red Hat Enterprise Linux 7"
        },
        "id": "0001587603717",
        "content": "ssg-rhel-7-ds.xml",
        "benchmark": {
          "id": "xccdf_org.ssgproject.content_benchmark_RHEL-7"
        }
      },
      "check": {
        "result": "fail",
        "severity": "medium",
        "references": "RHEL-07-010130 (http://iase.disa.mil/stigs/os/unix-linux/Pages/index.aspx), IA-5(b) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), IA-5(c) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), IA-5(1)(a) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), 193 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), SRG-OS-000070-GPOS-00038 (), Req-8.2.3 (https://www.pcisecuritystandards.org/documents/PCI_DSS_v3-1.pdf)",
        "identifiers": "CCE-27345-8 (https://nvd.nist.gov/cce/index.cfm)",
        "oval": {
          "id": "oval:ssg-accounts_password_pam_lcredit:def:1"
        },
        "description": "The pam_pwquality module's lcredit parameter controls requirements for usage of lowercase letters in a password. When set to a negative number, any password will be required to contain that many lowercase characters. When set to a positive number, pam_pwquality will grant +1 additional length credit for each lowercase character. Modify the lcredit setting in /etc/security/pwquality.conf to require the use of a lowercase character in passwords.",
        "id": "xccdf_org.ssgproject.content_rule_accounts_password_pam_lcredit",
        "title": "Set Password Strength Minimum Lowercase Characters",
        "rationale": "Use of a complex password helps to increase the time and resources required to compromise the password. Password complexity, or strength, is a measure of the effectiveness of a password in resisting attempts at guessing and brute-force attacks. Password complexity is one factor of several that determines how long it takes to crack a password. The more complex the password, the greater the number of possble combinations that need to be tested before the password is compromised. Requiring a minimum number of lowercase characters makes password guessing attacks more difficult by ensuring a larger search space."
      }
    }
  },
  "rule": {
    "firedtimes": 7,
    "mail": false,
    "level": 7,
    "pci_dss": ["2.2"],
    "description": "OpenSCAP: Set Password Strength Minimum Lowercase Characters (not passed)",
    "groups": ["oscap", "oscap-result"],
    "id": "81530",
    "nist_800_53": ["CM.1"]
  }
}, {
  "data": {
    "oscap": {
      "scan": {
        "profile": {
          "id": "xccdf_org.ssgproject.content_profile_pci-dss",
          "title": "PCI-DSS v3 Control Baseline for Red Hat Enterprise Linux 7"
        },
        "id": "0001587603717",
        "content": "ssg-rhel-7-ds.xml",
        "benchmark": {
          "id": "xccdf_org.ssgproject.content_benchmark_RHEL-7"
        }
      },
      "check": {
        "result": "fail",
        "severity": "medium",
        "references": "RHEL-07-010120 (http://iase.disa.mil/stigs/os/unix-linux/Pages/index.aspx), IA-5(b) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), IA-5(c) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), IA-5(1)(a) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), 192 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), SRG-OS-000069-GPOS-00037 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx), Req-8.2.3 (https://www.pcisecuritystandards.org/documents/PCI_DSS_v3-1.pdf), 6.3.2 (https://benchmarks.cisecurity.org/tools2/linux/CIS_Red_Hat_Enterprise_Linux_7_Benchmark_v1.1.0.pdf)",
        "identifiers": "CCE-27200-5 (https://nvd.nist.gov/cce/index.cfm)",
        "oval": {
          "id": "oval:ssg-accounts_password_pam_ucredit:def:1"
        },
        "description": "The pam_pwquality module's ucredit= parameter controls requirements for usage of uppercase letters in a password. When set to a negative number, any password will be required to contain that many uppercase characters. When set to a positive number, pam_pwquality will grant +1 additional length credit for each uppercase character. Modify the ucredit setting in /etc/security/pwquality.conf to require the use of an uppercase character in passwords.",
        "id": "xccdf_org.ssgproject.content_rule_accounts_password_pam_ucredit",
        "title": "Set Password Strength Minimum Uppercase Characters",
        "rationale": "Use of a complex password helps to increase the time and resources reuiqred to compromise the password. Password complexity, or strength, is a measure of the effectiveness of a password in resisting attempts at guessing and brute-force attacks. Password complexity is one factor of several that determines how long it takes to crack a password. The more complex the password, the greater the number of possible combinations that need to be tested before the password is compromised."
      }
    }
  },
  "rule": {
    "firedtimes": 6,
    "mail": false,
    "level": 7,
    "pci_dss": ["2.2"],
    "description": "OpenSCAP: Set Password Strength Minimum Uppercase Characters (not passed)",
    "groups": ["oscap", "oscap-result"],
    "id": "81530",
    "nist_800_53": ["CM.1"]
  }
}, {
  "data": {
    "oscap": {
      "scan": {
        "profile": {
          "id": "xccdf_org.ssgproject.content_profile_pci-dss",
          "title": "PCI-DSS v3 Control Baseline for Red Hat Enterprise Linux 7"
        },
        "id": "0001587603717",
        "content": "ssg-rhel-7-ds.xml",
        "benchmark": {
          "id": "xccdf_org.ssgproject.content_benchmark_RHEL-7"
        }
      },
      "check": {
        "result": "fail",
        "severity": "medium",
        "references": "RHEL-07-010280 (http://iase.disa.mil/stigs/os/unix-linux/Pages/index.aspx), IA-5(1)(a) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), 205 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), SRG-OS-000078-GPOS-00046 (), Req-8.2.3 (https://www.pcisecuritystandards.org/documents/PCI_DSS_v3-1.pdf), 6.3.2 (https://benchmarks.cisecurity.org/tools2/linux/CIS_Red_Hat_Enterprise_Linux_7_Benchmark_v1.1.0.pdf)",
        "identifiers": "CCE-27293-0 (https://nvd.nist.gov/cce/index.cfm)",
        "oval": {
          "id": "oval:ssg-accounts_password_pam_minlen:def:1"
        },
        "description": "The pam_pwquality module's minlen parameter controls requirements for minimum characters required in a password. Add minlen= after pam_pwquality to set minimum password length requirements.",
        "id": "xccdf_org.ssgproject.content_rule_accounts_password_pam_minlen",
        "title": "Set Password Minimum Length",
        "rationale": "The shorter the password, the lower the number of possible combinations that need to be tested before the password is compromised. Password complexity, or strength, is a measure of the effectiveness of a password in resisting attempts at guessing and brute-force attacks. Password length is one factor of several that helps to determine strength and how long it takes to crack a password. Use of more characters in a password helps to exponentially increase the time and/or resources required to compromose the password."
      }
    }
  },
  "rule": {
    "firedtimes": 5,
    "mail": false,
    "level": 7,
    "pci_dss": ["2.2"],
    "description": "OpenSCAP: Set Password Minimum Length (not passed)",
    "groups": ["oscap", "oscap-result"],
    "id": "81530",
    "nist_800_53": ["CM.1"]
  }
}, {
  "data": {
    "oscap": {
      "scan": {
        "profile": {
          "id": "xccdf_org.ssgproject.content_profile_pci-dss",
          "title": "PCI-DSS v3 Control Baseline for Red Hat Enterprise Linux 7"
        },
        "id": "0001587603717",
        "content": "ssg-rhel-7-ds.xml",
        "benchmark": {
          "id": "xccdf_org.ssgproject.content_benchmark_RHEL-7"
        }
      },
      "check": {
        "result": "fail",
        "severity": "medium",
        "references": "RHEL-07-010140 (http://iase.disa.mil/stigs/os/unix-linux/Pages/index.aspx), IA-5(1)(a) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), IA-5(b) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), IA-5(c) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), 194 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), 194 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), SRG-OS-000071-GPOS-00039 (), Req-8.2.3 (https://www.pcisecuritystandards.org/documents/PCI_DSS_v3-1.pdf), 6.3.2 (https://benchmarks.cisecurity.org/tools2/linux/CIS_Red_Hat_Enterprise_Linux_7_Benchmark_v1.1.0.pdf)",
        "identifiers": "CCE-27214-6 (https://nvd.nist.gov/cce/index.cfm)",
        "oval": {
          "id": "oval:ssg-accounts_password_pam_dcredit:def:1"
        },
        "description": "The pam_pwquality module's dcredit parameter controls requirements for usage of digits in a password. When set to a negative number, any password will be required to contain that many digits. When set to a positive number, pam_pwquality will grant +1 additional length credit for each digit. Modify the dcredit setting in /etc/security/pwquality.conf to require the use of a digit in passwords.",
        "id": "xccdf_org.ssgproject.content_rule_accounts_password_pam_dcredit",
        "title": "Set Password Strength Minimum Digit Characters",
        "rationale": "Use of a complex password helps to increase the time and resources required to compromise the password. Password complexity, or strength, is a measure of the effectiveness of a password in resisting attempts at guessing and brute-force attacks. Password complexity is one factor of several that determines how long it takes to crack a password. The more complex the password, the greater the number of possble combinations that need to be tested before the password is compromised. Requiring digits makes password guessing attacks more difficult by ensuring a larger search space."
      }
    }
  },
  "rule": {
    "firedtimes": 4,
    "mail": false,
    "level": 7,
    "pci_dss": ["2.2"],
    "description": "OpenSCAP: Set Password Strength Minimum Digit Characters (not passed)",
    "groups": ["oscap", "oscap-result"],
    "id": "81530",
    "nist_800_53": ["CM.1"]
  }
}, {
  "data": {
    "oscap": {
      "scan": {
        "profile": {
          "id": "xccdf_org.ssgproject.content_profile_pci-dss",
          "title": "PCI-DSS v3 Control Baseline for Red Hat Enterprise Linux 7"
        },
        "id": "0001587603717",
        "content": "ssg-rhel-7-ds.xml",
        "benchmark": {
          "id": "xccdf_org.ssgproject.content_benchmark_RHEL-7"
        }
      },
      "check": {
        "result": "fail",
        "severity": "medium",
        "references": "RHEL-07-010250 (http://iase.disa.mil/stigs/os/unix-linux/Pages/index.aspx), IA-5(f) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), IA-5(g) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), IA-5(1)(d) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), 199 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), SRG-OS-000076-GPOS-00044 (), Req-8.2.4 (https://www.pcisecuritystandards.org/documents/PCI_DSS_v3-1.pdf), 5.4.1.1 (https://benchmarks.cisecurity.org/tools2/linux/CIS_Red_Hat_Enterprise_Linux_7_Benchmark_v1.1.0.pdf), 5.6.2.1 (https://www.fbi.gov/file-repository/cjis-security-policy-v5_5_20160601-2-1.pdf), 3.5.6 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-171.pdf)",
        "identifiers": "CCE-27051-2 (https://nvd.nist.gov/cce/index.cfm)",
        "oval": {
          "id": "oval:ssg-accounts_maximum_age_login_defs:def:1"
        },
        "description": "To specify password maximum age for new accounts, edit the file /etc/login.defs and add or correct the following line: PASS_MAX_DAYS A value of 180 days is sufficient for many environments. The DoD requirement is 60. The profile requirement is .",
        "id": "xccdf_org.ssgproject.content_rule_accounts_maximum_age_login_defs",
        "title": "Set Password Maximum Age",
        "rationale": "Any password, no matter how complex, can eventually be cracked. Therefore, passwords need to be changed periodically. If the operating system does not limit the lifetime of passwords and force users to change their passwords, there is the risk that the operating system passwords could be compromised. Setting the password maximum age ensures users are required to periodically change their passwords. Requiring shorter password lifetimes increases the risk of users writing down the password in a convenient location subject to physical compromise."
      }
    }
  },
  "rule": {
    "firedtimes": 3,
    "mail": false,
    "level": 7,
    "pci_dss": ["2.2"],
    "description": "OpenSCAP: Set Password Maximum Age (not passed)",
    "groups": ["oscap", "oscap-result"],
    "id": "81530",
    "nist_800_53": ["CM.1"]
  }
}, {
  "data": {
    "oscap": {
      "scan": {
        "profile": {
          "id": "xccdf_org.ssgproject.content_profile_pci-dss",
          "title": "PCI-DSS v3 Control Baseline for Red Hat Enterprise Linux 7"
        },
        "id": "0001587603717",
        "content": "ssg-rhel-7-ds.xml",
        "benchmark": {
          "id": "xccdf_org.ssgproject.content_benchmark_RHEL-7"
        }
      },
      "check": {
        "result": "fail",
        "severity": "high",
        "references": "RHEL-07-010290 (http://iase.disa.mil/stigs/os/unix-linux/Pages/index.aspx), AC-6 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), IA-5(b) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), IA-5(c) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), IA-5(1)(a) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), 366 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), SRG-OS-000480-GPOS-00227 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx), Req-8.2.3 (https://www.pcisecuritystandards.org/documents/PCI_DSS_v3-1.pdf), 5.5.2 (https://www.fbi.gov/file-repository/cjis-security-policy-v5_5_20160601-2-1.pdf), 3.1.1 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-171.pdf), 3.1.5 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-171.pdf)",
        "identifiers": "CCE-27286-4 (https://nvd.nist.gov/cce/index.cfm)",
        "oval": {
          "id": "oval:ssg-no_empty_passwords:def:1"
        },
        "description": "If an account is configured for password authentication but does not have an assigned password, it may be possible to log into the account without authentication. Remove any instances of the nullok option in /etc/pam.d/system-auth to prevent logins with empty passwords.",
        "id": "xccdf_org.ssgproject.content_rule_no_empty_passwords",
        "title": "Prevent Log In to Accounts With Empty Password",
        "rationale": "If an account has an empty password, anyone could log in and run commands with the privileges of that account. Accounts with empty passwords should never be used in operational environments."
      }
    }
  },
  "rule": {
    "firedtimes": 2,
    "mail": false,
    "level": 9,
    "pci_dss": ["2.2"],
    "description": "OpenSCAP: Prevent Log In to Accounts With Empty Password (not passed)",
    "groups": ["oscap", "oscap-result"],
    "id": "81531",
    "nist_800_53": ["CM.1"]
  }
}, {
  "data": {
    "oscap": {
      "scan": {
        "profile": {
          "id": "xccdf_org.ssgproject.content_profile_pci-dss",
          "title": "PCI-DSS v3 Control Baseline for Red Hat Enterprise Linux 7"
        },
        "id": "0001587603717",
        "content": "ssg-rhel-7-ds.xml",
        "benchmark": {
          "id": "xccdf_org.ssgproject.content_benchmark_RHEL-7"
        }
      },
      "check": {
        "result": "fail",
        "severity": "high",
        "references": "RHEL-07-010010 (http://iase.disa.mil/stigs/os/unix-linux/Pages/index.aspx), AC-6 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-9(1) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-9(3) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), CM-6(d) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), CM-6(3) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), 1494 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), 1496 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), Req-11.5 (https://www.pcisecuritystandards.org/documents/PCI_DSS_v3-1.pdf), 1.2.6 (https://benchmarks.cisecurity.org/tools2/linux/CIS_Red_Hat_Enterprise_Linux_7_Benchmark_v1.1.0.pdf), 6.1.3 (https://benchmarks.cisecurity.org/tools2/linux/CIS_Red_Hat_Enterprise_Linux_7_Benchmark_v1.1.0.pdf), 6.1.4 (https://benchmarks.cisecurity.org/tools2/linux/CIS_Red_Hat_Enterprise_Linux_7_Benchmark_v1.1.0.pdf), 6.1.5 (https://benchmarks.cisecurity.org/tools2/linux/CIS_Red_Hat_Enterprise_Linux_7_Benchmark_v1.1.0.pdf), 6.1.6 (https://benchmarks.cisecurity.org/tools2/linux/CIS_Red_Hat_Enterprise_Linux_7_Benchmark_v1.1.0.pdf), 6.1.7 (https://benchmarks.cisecurity.org/tools2/linux/CIS_Red_Hat_Enterprise_Linux_7_Benchmark_v1.1.0.pdf), 6.1.8 (https://benchmarks.cisecurity.org/tools2/linux/CIS_Red_Hat_Enterprise_Linux_7_Benchmark_v1.1.0.pdf), 6.1.9 (https://benchmarks.cisecurity.org/tools2/linux/CIS_Red_Hat_Enterprise_Linux_7_Benchmark_v1.1.0.pdf), 6.2.3 (https://benchmarks.cisecurity.org/tools2/linux/CIS_Red_Hat_Enterprise_Linux_7_Benchmark_v1.1.0.pdf), SRG-OS-000257-GPOS-00098 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx), SRG-OS-000278-GPOS-00108 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx), 5.10.4.1 (https://www.fbi.gov/file-repository/cjis-security-policy-v5_5_20160601-2-1.pdf), 3.3.8 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-171.pdf), 3.4.1 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-171.pdf)",
        "identifiers": "CCE-27209-6 (https://nvd.nist.gov/cce/index.cfm)",
        "oval": {
          "id": "oval:ssg-rpm_verify_permissions:def:1"
        },
        "description": "Discretionary access control is weakened if a user or group has access permissions to system files and directories greater than the default. The RPM package management system can check file access permissions of installed software packages, including many that are important to system security. Verify that the file permissions, ownership, and gruop membership of system files and commands match vendor values. Check the file permissions, ownership, and group membership with the following command: $ sudo rpm -Va | grep '^.M' Output indicates files that do not match vendor defaults. After locating a file with incorrect permissions, run the following command to determine which package owns it: $ rpm -qf FILENAME Next, run the following command to reset its permissions to the correct values: $ sudo rpm --setperms PACKAGENAME",
        "id": "xccdf_org.ssgproject.content_rule_rpm_verify_permissions",
        "title": "Verify and Correct File Permissions with RPM",
        "rationale": "Permissions on system binaries and configuration files that are too generous could allow an unauthorized user to gain privileges that they should not have. The permissions set by the vendor should be maintained. Any deviations from this baseline should be investigated."
      }
    }
  },
  "rule": {
    "firedtimes": 1,
    "mail": false,
    "level": 9,
    "pci_dss": ["2.2"],
    "description": "OpenSCAP: Verify and Correct File Permissions with RPM (not passed)",
    "groups": ["oscap", "oscap-result"],
    "id": "81531",
    "nist_800_53": ["CM.1"]
  }
}, {
  "data": {
    "oscap": {
      "scan": {
        "profile": {
          "id": "xccdf_org.ssgproject.content_profile_pci-dss",
          "title": "PCI-DSS v3 Control Baseline for Red Hat Enterprise Linux 7"
        },
        "id": "0001587603717",
        "content": "ssg-rhel-7-ds.xml",
        "benchmark": {
          "id": "xccdf_org.ssgproject.content_benchmark_RHEL-7"
        }
      },
      "check": {
        "result": "fail",
        "severity": "medium",
        "references": "RHEL-07-020030 (http://iase.disa.mil/stigs/os/unix-linux/Pages/index.aspx), CM-3(d) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), CM-3(e) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), CM-3(5) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), CM-6(d) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), CM-6(3) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), SC-28 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), SI-7 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), 1744 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), Req-11.5 (https://www.pcisecuritystandards.org/documents/PCI_DSS_v3-1.pdf), 1.3.2 (https://benchmarks.cisecurity.org/tools2/linux/CIS_Red_Hat_Enterprise_Linux_7_Benchmark_v1.1.0.pdf), SRG-OS-000363-GPOS-00150 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx), 5.10.1.3 (https://www.fbi.gov/file-repository/cjis-security-policy-v5_5_20160601-2-1.pdf)",
        "identifiers": "CCE-26952-2 (https://nvd.nist.gov/cce/index.cfm)",
        "oval": {
          "id": "oval:ssg-aide_periodic_cron_checking:def:1"
        },
        "description": "At a minimum, AIDE should be configured to run a weekly scan. At most, AIDE should be run daily. To implement a daily execution of AIDE at 4:05am using cron, add the following line to /etc/crontab: 05 4 * * * root /usr/sbin/aide --check To implement a weekly execution of AIDE at 4:05am using cron, add the following line to /etc/crontab: 05 4 * * 0 root /usr/sbin/aide --check AIDE can be executed periodically through other means; this is merely one example.",
        "id": "xccdf_org.ssgproject.content_rule_aide_periodic_cron_checking",
        "title": "Configure Periodic Execution of AIDE",
        "rationale": "By default, AIDE does not install itself for periodic execution. Periodically running AIDE is necessary to reveal unexpected changes in installed files. Unauthorized changes to the baseline configuration could make the system vulnerable to various attacks or allow unauthorized access to the operating system. Changes to operating system configurations can have unintended side effects, some of which may be relevant to security. Detecting such changes and providing an automated response can help avoid unintended, negative consequences that could ultimately affect the security state of the operating system. The operating system's Information Management Officer (IMO)/Information System Security Officer (ISSO) and System Administrators (SAs) must be notified via email and/or monitoring system trap when there is an unauthorized modification of a configuration item."
      }
    }
  },
  "rule": {
    "firedtimes": 2,
    "mail": false,
    "level": 7,
    "pci_dss": ["2.2"],
    "description": "OpenSCAP: Configure Periodic Execution of AIDE (not passed)",
    "groups": ["oscap", "oscap-result"],
    "id": "81530",
    "nist_800_53": ["CM.1"]
  }
}, {
  "data": {
    "oscap": {
      "scan": {
        "profile": {
          "id": "xccdf_org.ssgproject.content_profile_pci-dss",
          "title": "PCI-DSS v3 Control Baseline for Red Hat Enterprise Linux 7"
        },
        "id": "0001587603717",
        "content": "ssg-rhel-7-ds.xml",
        "benchmark": {
          "id": "xccdf_org.ssgproject.content_benchmark_RHEL-7"
        }
      },
      "check": {
        "result": "fail",
        "severity": "medium",
        "references": "CM-3(d) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), CM-3(e) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), CM-6(d) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), CM-6(3) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), SC-28 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), SI-7 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf),  (http://iase.disa.mil/stigs/cci/Pages/index.aspx), Req-11.5 (https://www.pcisecuritystandards.org/documents/PCI_DSS_v3-1.pdf), 1.3.1 (https://benchmarks.cisecurity.org/tools2/linux/CIS_Red_Hat_Enterprise_Linux_7_Benchmark_v1.1.0.pdf), 5.10.1.3 (https://www.fbi.gov/file-repository/cjis-security-policy-v5_5_20160601-2-1.pdf)",
        "identifiers": "CCE-27096-7 (https://nvd.nist.gov/cce/index.cfm)",
        "oval": {
          "id": "oval:ssg-package_aide_installed:def:1"
        },
        "description": "Install the AIDE package with the command: $ sudo yum install aide",
        "id": "xccdf_org.ssgproject.content_rule_package_aide_installed",
        "title": "Install AIDE",
        "rationale": "The AIDE package must be installed if it is to be available for integrity checking."
      }
    }
  },
  "rule": {
    "firedtimes": 1,
    "mail": false,
    "level": 7,
    "pci_dss": ["2.2"],
    "description": "OpenSCAP: Install AIDE (not passed)",
    "groups": ["oscap", "oscap-result"],
    "id": "81530",
    "nist_800_53": ["CM.1"]
  }
}, {
  "data": {
    "oscap": {
      "scan": {
        "score": "99.814812",
        "profile": {
          "id": "No profile",
          "title": "No profile"
        },
        "id": "0001587574647",
        "content": "cve-redhat-7-ds.xml",
        "benchmark": {
          "id": "xccdf_com.redhat.rhsa_benchmark_generated-xccdf"
        }
      }
    }
  },
  "manager": {
    "name": "ip-10-0-0-219.us-west-1.compute.internal"
  },
  "rule": {
    "firedtimes": 1,
    "mail": false,
    "level": 3,
    "pci_dss": ["2.2"],
    "description": "OpenSCAP Report overview.",
    "groups": ["oscap", "oscap-report"],
    "id": "81540",
    "nist_800_53": ["CM.1"]
  }
}];
exports.data = data;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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