"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getConfiguration = getConfiguration;

var _fs = _interopRequireDefault(require("fs"));

var _jsYaml = _interopRequireDefault(require("js-yaml"));

var _constants = require("../../common/constants");

/*
 * Wazuh app - Module to parse the configuration file
 * Copyright (C) 2015-2022 Wazuh, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Find more information about this on the LICENSE file.
 */
let cachedConfiguration = null;
let lastAssign = new Date().getTime();

function getConfiguration(isUpdating = false) {
  try {
    const now = new Date().getTime();
    const dateDiffer = now - lastAssign;

    if (!cachedConfiguration || dateDiffer >= _constants.WAZUH_CONFIGURATION_CACHE_TIME || isUpdating) {
      const raw = _fs.default.readFileSync(_constants.WAZUH_DATA_CONFIG_APP_PATH, {
        encoding: 'utf-8'
      });

      const file = _jsYaml.default.load(raw);

      for (const host of file.hosts) {
        Object.keys(host).forEach(k => {
          host[k].password = '*****';
        });
      }

      cachedConfiguration = { ...file
      };
      lastAssign = now;
    }

    return cachedConfiguration;
  } catch (error) {
    return false;
  }
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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