"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.monitoringKnownFields = void 0;

/*
 * Wazuh app - Module for wazuh-monitoring index pattern known fields
 * Copyright (C) 2015-2022 Wazuh, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Find more information about this on the LICENSE file.
 */
const monitoringKnownFields = [{
  name: '@timestamp',
  type: 'date',
  count: 0,
  scripted: false,
  searchable: true,
  aggregatable: true,
  readFromDocValues: true,
  excluded: true
}, {
  name: 'timestamp',
  type: 'date',
  count: 0,
  scripted: false,
  searchable: true,
  aggregatable: true,
  readFromDocValues: true
}, {
  name: '_id',
  type: 'string',
  count: 0,
  scripted: false,
  searchable: true,
  aggregatable: true,
  readFromDocValues: false
}, {
  name: '_index',
  type: 'string',
  count: 0,
  scripted: false,
  searchable: true,
  aggregatable: true,
  readFromDocValues: false
}, {
  name: '_score',
  type: 'number',
  count: 0,
  scripted: false,
  searchable: false,
  aggregatable: false,
  readFromDocValues: false
}, {
  name: '_source',
  type: '_source',
  count: 0,
  scripted: false,
  searchable: false,
  aggregatable: false,
  readFromDocValues: false
}, {
  name: '_type',
  type: 'string',
  count: 0,
  scripted: false,
  searchable: true,
  aggregatable: true,
  readFromDocValues: false
}, {
  name: 'dateAdd',
  type: 'string',
  count: 0,
  scripted: false,
  searchable: true,
  aggregatable: false,
  readFromDocValues: false
}, {
  name: 'group',
  type: 'string',
  count: 0,
  scripted: false,
  searchable: true,
  aggregatable: false,
  readFromDocValues: false
}, {
  name: 'host',
  type: 'string',
  count: 0,
  scripted: false,
  searchable: true,
  aggregatable: true,
  readFromDocValues: true
}, {
  name: 'id',
  type: 'string',
  count: 0,
  scripted: false,
  searchable: true,
  aggregatable: true,
  readFromDocValues: true
}, {
  name: 'ip',
  type: 'string',
  count: 0,
  scripted: false,
  searchable: true,
  aggregatable: true,
  readFromDocValues: true
}, {
  name: 'lastKeepAlive',
  type: 'string',
  count: 0,
  scripted: false,
  searchable: true,
  aggregatable: false,
  readFromDocValues: false
}, {
  name: 'cluster.name',
  type: 'string',
  count: 0,
  scripted: false,
  searchable: true,
  aggregatable: false,
  readFromDocValues: false
}, {
  name: 'mergedSum',
  type: 'string',
  count: 0,
  scripted: false,
  searchable: true,
  aggregatable: false,
  readFromDocValues: false
}, {
  name: 'configSum',
  type: 'string',
  count: 0,
  scripted: false,
  searchable: true,
  aggregatable: false,
  readFromDocValues: false
}, {
  name: 'node_name',
  type: 'string',
  count: 0,
  scripted: false,
  searchable: true,
  aggregatable: false,
  readFromDocValues: false
}, {
  name: 'manager',
  type: 'string',
  count: 0,
  scripted: false,
  searchable: true,
  aggregatable: false,
  readFromDocValues: false
}, {
  name: 'name',
  type: 'string',
  count: 0,
  scripted: false,
  searchable: true,
  aggregatable: true,
  readFromDocValues: true
}, {
  name: 'os.arch',
  type: 'string',
  count: 0,
  scripted: false,
  searchable: true,
  aggregatable: false,
  readFromDocValues: false
}, {
  name: 'os.codename',
  type: 'string',
  count: 0,
  scripted: false,
  searchable: true,
  aggregatable: false,
  readFromDocValues: false
}, {
  name: 'os.major',
  type: 'string',
  count: 0,
  scripted: false,
  searchable: true,
  aggregatable: false,
  readFromDocValues: false
}, {
  name: 'os.minor',
  type: 'string',
  count: 0,
  scripted: false,
  searchable: true,
  aggregatable: false,
  readFromDocValues: false
}, {
  name: 'os.name',
  type: 'string',
  count: 0,
  scripted: false,
  searchable: true,
  aggregatable: false,
  readFromDocValues: false
}, {
  name: 'os.platform',
  type: 'string',
  count: 0,
  scripted: false,
  searchable: true,
  aggregatable: false,
  readFromDocValues: false
}, {
  name: 'os.uname',
  type: 'string',
  count: 0,
  scripted: false,
  searchable: true,
  aggregatable: false,
  readFromDocValues: false
}, {
  name: 'os.version',
  type: 'string',
  count: 0,
  scripted: false,
  searchable: true,
  aggregatable: false,
  readFromDocValues: false
}, {
  name: 'status',
  type: 'string',
  count: 0,
  scripted: false,
  searchable: true,
  aggregatable: true,
  readFromDocValues: true
}, {
  name: 'version',
  type: 'string',
  count: 0,
  scripted: false,
  searchable: true,
  aggregatable: false,
  readFromDocValues: false
}, {
  name: 'registerIP',
  type: 'string',
  count: 0,
  scripted: false,
  searchable: true,
  aggregatable: false,
  readFromDocValues: false
}];
exports.monitoringKnownFields = monitoringKnownFields;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIm1vbml0b3Jpbmcta25vd24tZmllbGRzLnRzIl0sIm5hbWVzIjpbIm1vbml0b3JpbmdLbm93bkZpZWxkcyIsIm5hbWUiLCJ0eXBlIiwiY291bnQiLCJzY3JpcHRlZCIsInNlYXJjaGFibGUiLCJhZ2dyZWdhdGFibGUiLCJyZWFkRnJvbURvY1ZhbHVlcyIsImV4Y2x1ZGVkIl0sIm1hcHBpbmdzIjoiOzs7Ozs7O0FBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUVPLE1BQU1BLHFCQUFxQixHQUFHLENBQ25DO0FBQ0VDLEVBQUFBLElBQUksRUFBRSxZQURSO0FBRUVDLEVBQUFBLElBQUksRUFBRSxNQUZSO0FBR0VDLEVBQUFBLEtBQUssRUFBRSxDQUhUO0FBSUVDLEVBQUFBLFFBQVEsRUFBRSxLQUpaO0FBS0VDLEVBQUFBLFVBQVUsRUFBRSxJQUxkO0FBTUVDLEVBQUFBLFlBQVksRUFBRSxJQU5oQjtBQU9FQyxFQUFBQSxpQkFBaUIsRUFBRSxJQVByQjtBQVFFQyxFQUFBQSxRQUFRLEVBQUU7QUFSWixDQURtQyxFQVduQztBQUNFUCxFQUFBQSxJQUFJLEVBQUUsV0FEUjtBQUVFQyxFQUFBQSxJQUFJLEVBQUUsTUFGUjtBQUdFQyxFQUFBQSxLQUFLLEVBQUUsQ0FIVDtBQUlFQyxFQUFBQSxRQUFRLEVBQUUsS0FKWjtBQUtFQyxFQUFBQSxVQUFVLEVBQUUsSUFMZDtBQU1FQyxFQUFBQSxZQUFZLEVBQUUsSUFOaEI7QUFPRUMsRUFBQUEsaUJBQWlCLEVBQUU7QUFQckIsQ0FYbUMsRUFvQm5DO0FBQ0VOLEVBQUFBLElBQUksRUFBRSxLQURSO0FBRUVDLEVBQUFBLElBQUksRUFBRSxRQUZSO0FBR0VDLEVBQUFBLEtBQUssRUFBRSxDQUhUO0FBSUVDLEVBQUFBLFFBQVEsRUFBRSxLQUpaO0FBS0VDLEVBQUFBLFVBQVUsRUFBRSxJQUxkO0FBTUVDLEVBQUFBLFlBQVksRUFBRSxJQU5oQjtBQU9FQyxFQUFBQSxpQkFBaUIsRUFBRTtBQVByQixDQXBCbUMsRUE2Qm5DO0FBQ0VOLEVBQUFBLElBQUksRUFBRSxRQURSO0FBRUVDLEVBQUFBLElBQUksRUFBRSxRQUZSO0FBR0VDLEVBQUFBLEtBQUssRUFBRSxDQUhUO0FBSUVDLEVBQUFBLFFBQVEsRUFBRSxLQUpaO0FBS0VDLEVBQUFBLFVBQVUsRUFBRSxJQUxkO0FBTUVDLEVBQUFBLFlBQVksRUFBRSxJQU5oQjtBQU9FQyxFQUFBQSxpQkFBaUIsRUFBRTtBQVByQixDQTdCbUMsRUFzQ25DO0FBQ0VOLEVBQUFBLElBQUksRUFBRSxRQURSO0FBRUVDLEVBQUFBLElBQUksRUFBRSxRQUZSO0FBR0VDLEVBQUFBLEtBQUssRUFBRSxDQUhUO0FBSUVDLEVBQUFBLFFBQVEsRUFBRSxLQUpaO0FBS0VDLEVBQUFBLFVBQVUsRUFBRSxLQUxkO0FBTUVDLEVBQUFBLFlBQVksRUFBRSxLQU5oQjtBQU9FQyxFQUFBQSxpQkFBaUIsRUFBRTtBQVByQixDQXRDbUMsRUErQ25DO0FBQ0VOLEVBQUFBLElBQUksRUFBRSxTQURSO0FBRUVDLEVBQUFBLElBQUksRUFBRSxTQUZSO0FBR0VDLEVBQUFBLEtBQUssRUFBRSxDQUhUO0FBSUVDLEVBQUFBLFFBQVEsRUFBRSxLQUpaO0FBS0VDLEVBQUFBLFVBQVUsRUFBRSxLQUxkO0FBTUVDLEVBQUFBLFlBQVksRUFBRSxLQU5oQjtBQU9FQyxFQUFBQSxpQkFBaUIsRUFBRTtBQVByQixDQS9DbUMsRUF3RG5DO0FBQ0VOLEVBQUFBLElBQUksRUFBRSxPQURSO0FBRUVDLEVBQUFBLElBQUksRUFBRSxRQUZSO0FBR0VDLEVBQUFBLEtBQUssRUFBRSxDQUhUO0FBSUVDLEVBQUFBLFFBQVEsRUFBRSxLQUpaO0FBS0VDLEVBQUFBLFVBQVUsRUFBRSxJQUxkO0FBTUVDLEVBQUFBLFlBQVksRUFBRSxJQU5oQjtBQU9FQyxFQUFBQSxpQkFBaUIsRUFBRTtBQVByQixDQXhEbUMsRUFpRW5DO0FBQ0VOLEVBQUFBLElBQUksRUFBRSxTQURSO0FBRUVDLEVBQUFBLElBQUksRUFBRSxRQUZSO0FBR0VDLEVBQUFBLEtBQUssRUFBRSxDQUhUO0FBSUVDLEVBQUFBLFFBQVEsRUFBRSxLQUpaO0FBS0VDLEVBQUFBLFVBQVUsRUFBRSxJQUxkO0FBTUVDLEVBQUFBLFlBQVksRUFBRSxLQU5oQjtBQU9FQyxFQUFBQSxpQkFBaUIsRUFBRTtBQVByQixDQWpFbUMsRUEwRW5DO0FBQ0VOLEVBQUFBLElBQUksRUFBRSxPQURSO0FBRUVDLEVBQUFBLElBQUksRUFBRSxRQUZSO0FBR0VDLEVBQUFBLEtBQUssRUFBRSxDQUhUO0FBSUVDLEVBQUFBLFFBQVEsRUFBRSxLQUpaO0FBS0VDLEVBQUFBLFVBQVUsRUFBRSxJQUxkO0FBTUVDLEVBQUFBLFlBQVksRUFBRSxLQU5oQjtBQU9FQyxFQUFBQSxpQkFBaUIsRUFBRTtBQVByQixDQTFFbUMsRUFtRm5DO0FBQ0VOLEVBQUFBLElBQUksRUFBRSxNQURSO0FBRUVDLEVBQUFBLElBQUksRUFBRSxRQUZSO0FBR0VDLEVBQUFBLEtBQUssRUFBRSxDQUhUO0FBSUVDLEVBQUFBLFFBQVEsRUFBRSxLQUpaO0FBS0VDLEVBQUFBLFVBQVUsRUFBRSxJQUxkO0FBTUVDLEVBQUFBLFlBQVksRUFBRSxJQU5oQjtBQU9FQyxFQUFBQSxpQkFBaUIsRUFBRTtBQVByQixDQW5GbUMsRUE0Rm5DO0FBQ0VOLEVBQUFBLElBQUksRUFBRSxJQURSO0FBRUVDLEVBQUFBLElBQUksRUFBRSxRQUZSO0FBR0VDLEVBQUFBLEtBQUssRUFBRSxDQUhUO0FBSUVDLEVBQUFBLFFBQVEsRUFBRSxLQUpaO0FBS0VDLEVBQUFBLFVBQVUsRUFBRSxJQUxkO0FBTUVDLEVBQUFBLFlBQVksRUFBRSxJQU5oQjtBQU9FQyxFQUFBQSxpQkFBaUIsRUFBRTtBQVByQixDQTVGbUMsRUFxR25DO0FBQ0VOLEVBQUFBLElBQUksRUFBRSxJQURSO0FBRUVDLEVBQUFBLElBQUksRUFBRSxRQUZSO0FBR0VDLEVBQUFBLEtBQUssRUFBRSxDQUhUO0FBSUVDLEVBQUFBLFFBQVEsRUFBRSxLQUpaO0FBS0VDLEVBQUFBLFVBQVUsRUFBRSxJQUxkO0FBTUVDLEVBQUFBLFlBQVksRUFBRSxJQU5oQjtBQU9FQyxFQUFBQSxpQkFBaUIsRUFBRTtBQVByQixDQXJHbUMsRUE4R25DO0FBQ0VOLEVBQUFBLElBQUksRUFBRSxlQURSO0FBRUVDLEVBQUFBLElBQUksRUFBRSxRQUZSO0FBR0VDLEVBQUFBLEtBQUssRUFBRSxDQUhUO0FBSUVDLEVBQUFBLFFBQVEsRUFBRSxLQUpaO0FBS0VDLEVBQUFBLFVBQVUsRUFBRSxJQUxkO0FBTUVDLEVBQUFBLFlBQVksRUFBRSxLQU5oQjtBQU9FQyxFQUFBQSxpQkFBaUIsRUFBRTtBQVByQixDQTlHbUMsRUF1SG5DO0FBQ0VOLEVBQUFBLElBQUksRUFBRSxjQURSO0FBRUVDLEVBQUFBLElBQUksRUFBRSxRQUZSO0FBR0VDLEVBQUFBLEtBQUssRUFBRSxDQUhUO0FBSUVDLEVBQUFBLFFBQVEsRUFBRSxLQUpaO0FBS0VDLEVBQUFBLFVBQVUsRUFBRSxJQUxkO0FBTUVDLEVBQUFBLFlBQVksRUFBRSxLQU5oQjtBQU9FQyxFQUFBQSxpQkFBaUIsRUFBRTtBQVByQixDQXZIbUMsRUFnSW5DO0FBQ0VOLEVBQUFBLElBQUksRUFBRSxXQURSO0FBRUVDLEVBQUFBLElBQUksRUFBRSxRQUZSO0FBR0VDLEVBQUFBLEtBQUssRUFBRSxDQUhUO0FBSUVDLEVBQUFBLFFBQVEsRUFBRSxLQUpaO0FBS0VDLEVBQUFBLFVBQVUsRUFBRSxJQUxkO0FBTUVDLEVBQUFBLFlBQVksRUFBRSxLQU5oQjtBQU9FQyxFQUFBQSxpQkFBaUIsRUFBRTtBQVByQixDQWhJbUMsRUF5SW5DO0FBQ0VOLEVBQUFBLElBQUksRUFBRSxXQURSO0FBRUVDLEVBQUFBLElBQUksRUFBRSxRQUZSO0FBR0VDLEVBQUFBLEtBQUssRUFBRSxDQUhUO0FBSUVDLEVBQUFBLFFBQVEsRUFBRSxLQUpaO0FBS0VDLEVBQUFBLFVBQVUsRUFBRSxJQUxkO0FBTUVDLEVBQUFBLFlBQVksRUFBRSxLQU5oQjtBQU9FQyxFQUFBQSxpQkFBaUIsRUFBRTtBQVByQixDQXpJbUMsRUFrSm5DO0FBQ0VOLEVBQUFBLElBQUksRUFBRSxXQURSO0FBRUVDLEVBQUFBLElBQUksRUFBRSxRQUZSO0FBR0VDLEVBQUFBLEtBQUssRUFBRSxDQUhUO0FBSUVDLEVBQUFBLFFBQVEsRUFBRSxLQUpaO0FBS0VDLEVBQUFBLFVBQVUsRUFBRSxJQUxkO0FBTUVDLEVBQUFBLFlBQVksRUFBRSxLQU5oQjtBQU9FQyxFQUFBQSxpQkFBaUIsRUFBRTtBQVByQixDQWxKbUMsRUEySm5DO0FBQ0VOLEVBQUFBLElBQUksRUFBRSxTQURSO0FBRUVDLEVBQUFBLElBQUksRUFBRSxRQUZSO0FBR0VDLEVBQUFBLEtBQUssRUFBRSxDQUhUO0FBSUVDLEVBQUFBLFFBQVEsRUFBRSxLQUpaO0FBS0VDLEVBQUFBLFVBQVUsRUFBRSxJQUxkO0FBTUVDLEVBQUFBLFlBQVksRUFBRSxLQU5oQjtBQU9FQyxFQUFBQSxpQkFBaUIsRUFBRTtBQVByQixDQTNKbUMsRUFvS25DO0FBQ0VOLEVBQUFBLElBQUksRUFBRSxNQURSO0FBRUVDLEVBQUFBLElBQUksRUFBRSxRQUZSO0FBR0VDLEVBQUFBLEtBQUssRUFBRSxDQUhUO0FBSUVDLEVBQUFBLFFBQVEsRUFBRSxLQUpaO0FBS0VDLEVBQUFBLFVBQVUsRUFBRSxJQUxkO0FBTUVDLEVBQUFBLFlBQVksRUFBRSxJQU5oQjtBQU9FQyxFQUFBQSxpQkFBaUIsRUFBRTtBQVByQixDQXBLbUMsRUE2S25DO0FBQ0VOLEVBQUFBLElBQUksRUFBRSxTQURSO0FBRUVDLEVBQUFBLElBQUksRUFBRSxRQUZSO0FBR0VDLEVBQUFBLEtBQUssRUFBRSxDQUhUO0FBSUVDLEVBQUFBLFFBQVEsRUFBRSxLQUpaO0FBS0VDLEVBQUFBLFVBQVUsRUFBRSxJQUxkO0FBTUVDLEVBQUFBLFlBQVksRUFBRSxLQU5oQjtBQU9FQyxFQUFBQSxpQkFBaUIsRUFBRTtBQVByQixDQTdLbUMsRUFzTG5DO0FBQ0VOLEVBQUFBLElBQUksRUFBRSxhQURSO0FBRUVDLEVBQUFBLElBQUksRUFBRSxRQUZSO0FBR0VDLEVBQUFBLEtBQUssRUFBRSxDQUhUO0FBSUVDLEVBQUFBLFFBQVEsRUFBRSxLQUpaO0FBS0VDLEVBQUFBLFVBQVUsRUFBRSxJQUxkO0FBTUVDLEVBQUFBLFlBQVksRUFBRSxLQU5oQjtBQU9FQyxFQUFBQSxpQkFBaUIsRUFBRTtBQVByQixDQXRMbUMsRUErTG5DO0FBQ0VOLEVBQUFBLElBQUksRUFBRSxVQURSO0FBRUVDLEVBQUFBLElBQUksRUFBRSxRQUZSO0FBR0VDLEVBQUFBLEtBQUssRUFBRSxDQUhUO0FBSUVDLEVBQUFBLFFBQVEsRUFBRSxLQUpaO0FBS0VDLEVBQUFBLFVBQVUsRUFBRSxJQUxkO0FBTUVDLEVBQUFBLFlBQVksRUFBRSxLQU5oQjtBQU9FQyxFQUFBQSxpQkFBaUIsRUFBRTtBQVByQixDQS9MbUMsRUF3TW5DO0FBQ0VOLEVBQUFBLElBQUksRUFBRSxVQURSO0FBRUVDLEVBQUFBLElBQUksRUFBRSxRQUZSO0FBR0VDLEVBQUFBLEtBQUssRUFBRSxDQUhUO0FBSUVDLEVBQUFBLFFBQVEsRUFBRSxLQUpaO0FBS0VDLEVBQUFBLFVBQVUsRUFBRSxJQUxkO0FBTUVDLEVBQUFBLFlBQVksRUFBRSxLQU5oQjtBQU9FQyxFQUFBQSxpQkFBaUIsRUFBRTtBQVByQixDQXhNbUMsRUFpTm5DO0FBQ0VOLEVBQUFBLElBQUksRUFBRSxTQURSO0FBRUVDLEVBQUFBLElBQUksRUFBRSxRQUZSO0FBR0VDLEVBQUFBLEtBQUssRUFBRSxDQUhUO0FBSUVDLEVBQUFBLFFBQVEsRUFBRSxLQUpaO0FBS0VDLEVBQUFBLFVBQVUsRUFBRSxJQUxkO0FBTUVDLEVBQUFBLFlBQVksRUFBRSxLQU5oQjtBQU9FQyxFQUFBQSxpQkFBaUIsRUFBRTtBQVByQixDQWpObUMsRUEwTm5DO0FBQ0VOLEVBQUFBLElBQUksRUFBRSxhQURSO0FBRUVDLEVBQUFBLElBQUksRUFBRSxRQUZSO0FBR0VDLEVBQUFBLEtBQUssRUFBRSxDQUhUO0FBSUVDLEVBQUFBLFFBQVEsRUFBRSxLQUpaO0FBS0VDLEVBQUFBLFVBQVUsRUFBRSxJQUxkO0FBTUVDLEVBQUFBLFlBQVksRUFBRSxLQU5oQjtBQU9FQyxFQUFBQSxpQkFBaUIsRUFBRTtBQVByQixDQTFObUMsRUFtT25DO0FBQ0VOLEVBQUFBLElBQUksRUFBRSxVQURSO0FBRUVDLEVBQUFBLElBQUksRUFBRSxRQUZSO0FBR0VDLEVBQUFBLEtBQUssRUFBRSxDQUhUO0FBSUVDLEVBQUFBLFFBQVEsRUFBRSxLQUpaO0FBS0VDLEVBQUFBLFVBQVUsRUFBRSxJQUxkO0FBTUVDLEVBQUFBLFlBQVksRUFBRSxLQU5oQjtBQU9FQyxFQUFBQSxpQkFBaUIsRUFBRTtBQVByQixDQW5PbUMsRUE0T25DO0FBQ0VOLEVBQUFBLElBQUksRUFBRSxZQURSO0FBRUVDLEVBQUFBLElBQUksRUFBRSxRQUZSO0FBR0VDLEVBQUFBLEtBQUssRUFBRSxDQUhUO0FBSUVDLEVBQUFBLFFBQVEsRUFBRSxLQUpaO0FBS0VDLEVBQUFBLFVBQVUsRUFBRSxJQUxkO0FBTUVDLEVBQUFBLFlBQVksRUFBRSxLQU5oQjtBQU9FQyxFQUFBQSxpQkFBaUIsRUFBRTtBQVByQixDQTVPbUMsRUFxUG5DO0FBQ0VOLEVBQUFBLElBQUksRUFBRSxRQURSO0FBRUVDLEVBQUFBLElBQUksRUFBRSxRQUZSO0FBR0VDLEVBQUFBLEtBQUssRUFBRSxDQUhUO0FBSUVDLEVBQUFBLFFBQVEsRUFBRSxLQUpaO0FBS0VDLEVBQUFBLFVBQVUsRUFBRSxJQUxkO0FBTUVDLEVBQUFBLFlBQVksRUFBRSxJQU5oQjtBQU9FQyxFQUFBQSxpQkFBaUIsRUFBRTtBQVByQixDQXJQbUMsRUE4UG5DO0FBQ0VOLEVBQUFBLElBQUksRUFBRSxTQURSO0FBRUVDLEVBQUFBLElBQUksRUFBRSxRQUZSO0FBR0VDLEVBQUFBLEtBQUssRUFBRSxDQUhUO0FBSUVDLEVBQUFBLFFBQVEsRUFBRSxLQUpaO0FBS0VDLEVBQUFBLFVBQVUsRUFBRSxJQUxkO0FBTUVDLEVBQUFBLFlBQVksRUFBRSxLQU5oQjtBQU9FQyxFQUFBQSxpQkFBaUIsRUFBRTtBQVByQixDQTlQbUMsRUF1UW5DO0FBQ0VOLEVBQUFBLElBQUksRUFBRSxZQURSO0FBRUVDLEVBQUFBLElBQUksRUFBRSxRQUZSO0FBR0VDLEVBQUFBLEtBQUssRUFBRSxDQUhUO0FBSUVDLEVBQUFBLFFBQVEsRUFBRSxLQUpaO0FBS0VDLEVBQUFBLFVBQVUsRUFBRSxJQUxkO0FBTUVDLEVBQUFBLFlBQVksRUFBRSxLQU5oQjtBQU9FQyxFQUFBQSxpQkFBaUIsRUFBRTtBQVByQixDQXZRbUMsQ0FBOUIiLCJzb3VyY2VzQ29udGVudCI6WyIvKlxuICogV2F6dWggYXBwIC0gTW9kdWxlIGZvciB3YXp1aC1tb25pdG9yaW5nIGluZGV4IHBhdHRlcm4ga25vd24gZmllbGRzXG4gKiBDb3B5cmlnaHQgKEMpIDIwMTUtMjAyMiBXYXp1aCwgSW5jLlxuICpcbiAqIFRoaXMgcHJvZ3JhbSBpcyBmcmVlIHNvZnR3YXJlOyB5b3UgY2FuIHJlZGlzdHJpYnV0ZSBpdCBhbmQvb3IgbW9kaWZ5XG4gKiBpdCB1bmRlciB0aGUgdGVybXMgb2YgdGhlIEdOVSBHZW5lcmFsIFB1YmxpYyBMaWNlbnNlIGFzIHB1Ymxpc2hlZCBieVxuICogdGhlIEZyZWUgU29mdHdhcmUgRm91bmRhdGlvbjsgZWl0aGVyIHZlcnNpb24gMiBvZiB0aGUgTGljZW5zZSwgb3JcbiAqIChhdCB5b3VyIG9wdGlvbikgYW55IGxhdGVyIHZlcnNpb24uXG4gKlxuICogRmluZCBtb3JlIGluZm9ybWF0aW9uIGFib3V0IHRoaXMgb24gdGhlIExJQ0VOU0UgZmlsZS5cbiAqL1xuXG5leHBvcnQgY29uc3QgbW9uaXRvcmluZ0tub3duRmllbGRzID0gW1xuICB7XG4gICAgbmFtZTogJ0B0aW1lc3RhbXAnLFxuICAgIHR5cGU6ICdkYXRlJyxcbiAgICBjb3VudDogMCxcbiAgICBzY3JpcHRlZDogZmFsc2UsXG4gICAgc2VhcmNoYWJsZTogdHJ1ZSxcbiAgICBhZ2dyZWdhdGFibGU6IHRydWUsXG4gICAgcmVhZEZyb21Eb2NWYWx1ZXM6IHRydWUsXG4gICAgZXhjbHVkZWQ6IHRydWVcbiAgfSxcbiAge1xuICAgIG5hbWU6ICd0aW1lc3RhbXAnLFxuICAgIHR5cGU6ICdkYXRlJyxcbiAgICBjb3VudDogMCxcbiAgICBzY3JpcHRlZDogZmFsc2UsXG4gICAgc2VhcmNoYWJsZTogdHJ1ZSxcbiAgICBhZ2dyZWdhdGFibGU6IHRydWUsXG4gICAgcmVhZEZyb21Eb2NWYWx1ZXM6IHRydWVcbiAgfSxcbiAge1xuICAgIG5hbWU6ICdfaWQnLFxuICAgIHR5cGU6ICdzdHJpbmcnLFxuICAgIGNvdW50OiAwLFxuICAgIHNjcmlwdGVkOiBmYWxzZSxcbiAgICBzZWFyY2hhYmxlOiB0cnVlLFxuICAgIGFnZ3JlZ2F0YWJsZTogdHJ1ZSxcbiAgICByZWFkRnJvbURvY1ZhbHVlczogZmFsc2VcbiAgfSxcbiAge1xuICAgIG5hbWU6ICdfaW5kZXgnLFxuICAgIHR5cGU6ICdzdHJpbmcnLFxuICAgIGNvdW50OiAwLFxuICAgIHNjcmlwdGVkOiBmYWxzZSxcbiAgICBzZWFyY2hhYmxlOiB0cnVlLFxuICAgIGFnZ3JlZ2F0YWJsZTogdHJ1ZSxcbiAgICByZWFkRnJvbURvY1ZhbHVlczogZmFsc2VcbiAgfSxcbiAge1xuICAgIG5hbWU6ICdfc2NvcmUnLFxuICAgIHR5cGU6ICdudW1iZXInLFxuICAgIGNvdW50OiAwLFxuICAgIHNjcmlwdGVkOiBmYWxzZSxcbiAgICBzZWFyY2hhYmxlOiBmYWxzZSxcbiAgICBhZ2dyZWdhdGFibGU6IGZhbHNlLFxuICAgIHJlYWRGcm9tRG9jVmFsdWVzOiBmYWxzZVxuICB9LFxuICB7XG4gICAgbmFtZTogJ19zb3VyY2UnLFxuICAgIHR5cGU6ICdfc291cmNlJyxcbiAgICBjb3VudDogMCxcbiAgICBzY3JpcHRlZDogZmFsc2UsXG4gICAgc2VhcmNoYWJsZTogZmFsc2UsXG4gICAgYWdncmVnYXRhYmxlOiBmYWxzZSxcbiAgICByZWFkRnJvbURvY1ZhbHVlczogZmFsc2VcbiAgfSxcbiAge1xuICAgIG5hbWU6ICdfdHlwZScsXG4gICAgdHlwZTogJ3N0cmluZycsXG4gICAgY291bnQ6IDAsXG4gICAgc2NyaXB0ZWQ6IGZhbHNlLFxuICAgIHNlYXJjaGFibGU6IHRydWUsXG4gICAgYWdncmVnYXRhYmxlOiB0cnVlLFxuICAgIHJlYWRGcm9tRG9jVmFsdWVzOiBmYWxzZVxuICB9LFxuICB7XG4gICAgbmFtZTogJ2RhdGVBZGQnLFxuICAgIHR5cGU6ICdzdHJpbmcnLFxuICAgIGNvdW50OiAwLFxuICAgIHNjcmlwdGVkOiBmYWxzZSxcbiAgICBzZWFyY2hhYmxlOiB0cnVlLFxuICAgIGFnZ3JlZ2F0YWJsZTogZmFsc2UsXG4gICAgcmVhZEZyb21Eb2NWYWx1ZXM6IGZhbHNlXG4gIH0sXG4gIHtcbiAgICBuYW1lOiAnZ3JvdXAnLFxuICAgIHR5cGU6ICdzdHJpbmcnLFxuICAgIGNvdW50OiAwLFxuICAgIHNjcmlwdGVkOiBmYWxzZSxcbiAgICBzZWFyY2hhYmxlOiB0cnVlLFxuICAgIGFnZ3JlZ2F0YWJsZTogZmFsc2UsXG4gICAgcmVhZEZyb21Eb2NWYWx1ZXM6IGZhbHNlXG4gIH0sXG4gIHtcbiAgICBuYW1lOiAnaG9zdCcsXG4gICAgdHlwZTogJ3N0cmluZycsXG4gICAgY291bnQ6IDAsXG4gICAgc2NyaXB0ZWQ6IGZhbHNlLFxuICAgIHNlYXJjaGFibGU6IHRydWUsXG4gICAgYWdncmVnYXRhYmxlOiB0cnVlLFxuICAgIHJlYWRGcm9tRG9jVmFsdWVzOiB0cnVlXG4gIH0sXG4gIHtcbiAgICBuYW1lOiAnaWQnLFxuICAgIHR5cGU6ICdzdHJpbmcnLFxuICAgIGNvdW50OiAwLFxuICAgIHNjcmlwdGVkOiBmYWxzZSxcbiAgICBzZWFyY2hhYmxlOiB0cnVlLFxuICAgIGFnZ3JlZ2F0YWJsZTogdHJ1ZSxcbiAgICByZWFkRnJvbURvY1ZhbHVlczogdHJ1ZVxuICB9LFxuICB7XG4gICAgbmFtZTogJ2lwJyxcbiAgICB0eXBlOiAnc3RyaW5nJyxcbiAgICBjb3VudDogMCxcbiAgICBzY3JpcHRlZDogZmFsc2UsXG4gICAgc2VhcmNoYWJsZTogdHJ1ZSxcbiAgICBhZ2dyZWdhdGFibGU6IHRydWUsXG4gICAgcmVhZEZyb21Eb2NWYWx1ZXM6IHRydWVcbiAgfSxcbiAge1xuICAgIG5hbWU6ICdsYXN0S2VlcEFsaXZlJyxcbiAgICB0eXBlOiAnc3RyaW5nJyxcbiAgICBjb3VudDogMCxcbiAgICBzY3JpcHRlZDogZmFsc2UsXG4gICAgc2VhcmNoYWJsZTogdHJ1ZSxcbiAgICBhZ2dyZWdhdGFibGU6IGZhbHNlLFxuICAgIHJlYWRGcm9tRG9jVmFsdWVzOiBmYWxzZVxuICB9LFxuICB7XG4gICAgbmFtZTogJ2NsdXN0ZXIubmFtZScsXG4gICAgdHlwZTogJ3N0cmluZycsXG4gICAgY291bnQ6IDAsXG4gICAgc2NyaXB0ZWQ6IGZhbHNlLFxuICAgIHNlYXJjaGFibGU6IHRydWUsXG4gICAgYWdncmVnYXRhYmxlOiBmYWxzZSxcbiAgICByZWFkRnJvbURvY1ZhbHVlczogZmFsc2VcbiAgfSxcbiAge1xuICAgIG5hbWU6ICdtZXJnZWRTdW0nLFxuICAgIHR5cGU6ICdzdHJpbmcnLFxuICAgIGNvdW50OiAwLFxuICAgIHNjcmlwdGVkOiBmYWxzZSxcbiAgICBzZWFyY2hhYmxlOiB0cnVlLFxuICAgIGFnZ3JlZ2F0YWJsZTogZmFsc2UsXG4gICAgcmVhZEZyb21Eb2NWYWx1ZXM6IGZhbHNlXG4gIH0sXG4gIHtcbiAgICBuYW1lOiAnY29uZmlnU3VtJyxcbiAgICB0eXBlOiAnc3RyaW5nJyxcbiAgICBjb3VudDogMCxcbiAgICBzY3JpcHRlZDogZmFsc2UsXG4gICAgc2VhcmNoYWJsZTogdHJ1ZSxcbiAgICBhZ2dyZWdhdGFibGU6IGZhbHNlLFxuICAgIHJlYWRGcm9tRG9jVmFsdWVzOiBmYWxzZVxuICB9LFxuICB7XG4gICAgbmFtZTogJ25vZGVfbmFtZScsXG4gICAgdHlwZTogJ3N0cmluZycsXG4gICAgY291bnQ6IDAsXG4gICAgc2NyaXB0ZWQ6IGZhbHNlLFxuICAgIHNlYXJjaGFibGU6IHRydWUsXG4gICAgYWdncmVnYXRhYmxlOiBmYWxzZSxcbiAgICByZWFkRnJvbURvY1ZhbHVlczogZmFsc2VcbiAgfSxcbiAge1xuICAgIG5hbWU6ICdtYW5hZ2VyJyxcbiAgICB0eXBlOiAnc3RyaW5nJyxcbiAgICBjb3VudDogMCxcbiAgICBzY3JpcHRlZDogZmFsc2UsXG4gICAgc2VhcmNoYWJsZTogdHJ1ZSxcbiAgICBhZ2dyZWdhdGFibGU6IGZhbHNlLFxuICAgIHJlYWRGcm9tRG9jVmFsdWVzOiBmYWxzZVxuICB9LFxuICB7XG4gICAgbmFtZTogJ25hbWUnLFxuICAgIHR5cGU6ICdzdHJpbmcnLFxuICAgIGNvdW50OiAwLFxuICAgIHNjcmlwdGVkOiBmYWxzZSxcbiAgICBzZWFyY2hhYmxlOiB0cnVlLFxuICAgIGFnZ3JlZ2F0YWJsZTogdHJ1ZSxcbiAgICByZWFkRnJvbURvY1ZhbHVlczogdHJ1ZVxuICB9LFxuICB7XG4gICAgbmFtZTogJ29zLmFyY2gnLFxuICAgIHR5cGU6ICdzdHJpbmcnLFxuICAgIGNvdW50OiAwLFxuICAgIHNjcmlwdGVkOiBmYWxzZSxcbiAgICBzZWFyY2hhYmxlOiB0cnVlLFxuICAgIGFnZ3JlZ2F0YWJsZTogZmFsc2UsXG4gICAgcmVhZEZyb21Eb2NWYWx1ZXM6IGZhbHNlXG4gIH0sXG4gIHtcbiAgICBuYW1lOiAnb3MuY29kZW5hbWUnLFxuICAgIHR5cGU6ICdzdHJpbmcnLFxuICAgIGNvdW50OiAwLFxuICAgIHNjcmlwdGVkOiBmYWxzZSxcbiAgICBzZWFyY2hhYmxlOiB0cnVlLFxuICAgIGFnZ3JlZ2F0YWJsZTogZmFsc2UsXG4gICAgcmVhZEZyb21Eb2NWYWx1ZXM6IGZhbHNlXG4gIH0sXG4gIHtcbiAgICBuYW1lOiAnb3MubWFqb3InLFxuICAgIHR5cGU6ICdzdHJpbmcnLFxuICAgIGNvdW50OiAwLFxuICAgIHNjcmlwdGVkOiBmYWxzZSxcbiAgICBzZWFyY2hhYmxlOiB0cnVlLFxuICAgIGFnZ3JlZ2F0YWJsZTogZmFsc2UsXG4gICAgcmVhZEZyb21Eb2NWYWx1ZXM6IGZhbHNlXG4gIH0sXG4gIHtcbiAgICBuYW1lOiAnb3MubWlub3InLFxuICAgIHR5cGU6ICdzdHJpbmcnLFxuICAgIGNvdW50OiAwLFxuICAgIHNjcmlwdGVkOiBmYWxzZSxcbiAgICBzZWFyY2hhYmxlOiB0cnVlLFxuICAgIGFnZ3JlZ2F0YWJsZTogZmFsc2UsXG4gICAgcmVhZEZyb21Eb2NWYWx1ZXM6IGZhbHNlXG4gIH0sXG4gIHtcbiAgICBuYW1lOiAnb3MubmFtZScsXG4gICAgdHlwZTogJ3N0cmluZycsXG4gICAgY291bnQ6IDAsXG4gICAgc2NyaXB0ZWQ6IGZhbHNlLFxuICAgIHNlYXJjaGFibGU6IHRydWUsXG4gICAgYWdncmVnYXRhYmxlOiBmYWxzZSxcbiAgICByZWFkRnJvbURvY1ZhbHVlczogZmFsc2VcbiAgfSxcbiAge1xuICAgIG5hbWU6ICdvcy5wbGF0Zm9ybScsXG4gICAgdHlwZTogJ3N0cmluZycsXG4gICAgY291bnQ6IDAsXG4gICAgc2NyaXB0ZWQ6IGZhbHNlLFxuICAgIHNlYXJjaGFibGU6IHRydWUsXG4gICAgYWdncmVnYXRhYmxlOiBmYWxzZSxcbiAgICByZWFkRnJvbURvY1ZhbHVlczogZmFsc2VcbiAgfSxcbiAge1xuICAgIG5hbWU6ICdvcy51bmFtZScsXG4gICAgdHlwZTogJ3N0cmluZycsXG4gICAgY291bnQ6IDAsXG4gICAgc2NyaXB0ZWQ6IGZhbHNlLFxuICAgIHNlYXJjaGFibGU6IHRydWUsXG4gICAgYWdncmVnYXRhYmxlOiBmYWxzZSxcbiAgICByZWFkRnJvbURvY1ZhbHVlczogZmFsc2VcbiAgfSxcbiAge1xuICAgIG5hbWU6ICdvcy52ZXJzaW9uJyxcbiAgICB0eXBlOiAnc3RyaW5nJyxcbiAgICBjb3VudDogMCxcbiAgICBzY3JpcHRlZDogZmFsc2UsXG4gICAgc2VhcmNoYWJsZTogdHJ1ZSxcbiAgICBhZ2dyZWdhdGFibGU6IGZhbHNlLFxuICAgIHJlYWRGcm9tRG9jVmFsdWVzOiBmYWxzZVxuICB9LFxuICB7XG4gICAgbmFtZTogJ3N0YXR1cycsXG4gICAgdHlwZTogJ3N0cmluZycsXG4gICAgY291bnQ6IDAsXG4gICAgc2NyaXB0ZWQ6IGZhbHNlLFxuICAgIHNlYXJjaGFibGU6IHRydWUsXG4gICAgYWdncmVnYXRhYmxlOiB0cnVlLFxuICAgIHJlYWRGcm9tRG9jVmFsdWVzOiB0cnVlXG4gIH0sXG4gIHtcbiAgICBuYW1lOiAndmVyc2lvbicsXG4gICAgdHlwZTogJ3N0cmluZycsXG4gICAgY291bnQ6IDAsXG4gICAgc2NyaXB0ZWQ6IGZhbHNlLFxuICAgIHNlYXJjaGFibGU6IHRydWUsXG4gICAgYWdncmVnYXRhYmxlOiBmYWxzZSxcbiAgICByZWFkRnJvbURvY1ZhbHVlczogZmFsc2VcbiAgfSxcbiAge1xuICAgIG5hbWU6ICdyZWdpc3RlcklQJyxcbiAgICB0eXBlOiAnc3RyaW5nJyxcbiAgICBjb3VudDogMCxcbiAgICBzY3JpcHRlZDogZmFsc2UsXG4gICAgc2VhcmNoYWJsZTogdHJ1ZSxcbiAgICBhZ2dyZWdhdGFibGU6IGZhbHNlLFxuICAgIHJlYWRGcm9tRG9jVmFsdWVzOiBmYWxzZVxuICB9XG5dO1xuIl19