"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

/*
 * Wazuh app - Module for TSC requirements (Reporting)
 * Copyright (C) 2015-2022 Wazuh, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Find more information about this on the LICENSE file.
 */
var _default = {
  'A1.1': {
    stack: ['The entity maintains, monitors, and evaluates current processing capacity and use of system components (infrastructure, data, and software) to manage capacity demand and to enable the implementation of additional capacity to help meet its objectives', {
      text: '\n'
    }, {
      ul: ['Measures Current Usage', 'Forecasts Capacity', 'Makes Changes Based on Forecasts']
    }]
  },
  'A1.2': {
    stack: ['The entity authorizes, designs, develops or acquires, implements, operates, approves, maintains, and monitors environmental protections, software, data backup processes, and recovery infrastructure to meet its objectives.', {
      text: '\n'
    }, {
      ul: ['Identifies Environmental Threats', 'Designs Detection Measures', 'Implements and Maintains Environmental Protection Mechanisms', 'Implements Alerts to Analyze Anomalies', 'Responds to Environmental Threat Events —', 'Communicates and Reviews Detected Environmental Threat Events', 'Determines Data Requiring Backup', 'Performs Data Backup', 'Addresses Offsite Storage', 'Implements Alternate Processing Infrastructure']
    }]
  },
  'CC5.1': {
    stack: ['The entity selects and develops control activities that contribute to the mitigation of risks to the achievement of objectives to acceptable levels.', {
      text: '\n'
    }, {
      ul: ['Integrates With Risk Assessment', 'Considers Entity-Specific Factors', 'Determines Relevant Business Processes', 'Evaluates a Mix of Control Activity Types', 'Considers at What Level Activities Are Applied', 'Addresses Segregation of Duties']
    }]
  },
  'CC5.2': {
    stack: ['The entity also selects and develops general control activities over technology to support the achievement of objectives.', {
      text: '\n'
    }, {
      ul: ['Determines Dependency Between the Use of Technology in Business Processes and Technology General Controls', 'Establishes Relevant Technology Infrastructure Control Activities', 'Establishes Relevant Security Management Process Controls Activities', 'Establishes Relevant Technology Acquisition, Development, and Maintenance Process Control Activities']
    }]
  },
  'CC6.1': {
    stack: ["The entity implements logical access security software, infrastructure, and architectures over protected information assets to protect them from security events to meet the entity's objectives.", {
      text: '\n'
    }, {
      ul: ['Identifies and Manages the Inventory of Information Assets', 'Restricts Logical Access', 'Identifies and Authenticates Users', 'Considers Network Segmentation', 'Manages Points of Access', 'Restricts Access to Information Assets', 'Manages Identification and Authentication', 'Manages Credentials for Infrastructure and Software', 'Uses Encryption to Protect Data', 'Protects Encryption Keys']
    }]
  },
  'CC6.2': {
    stack: ['Prior to issuing system credentials and granting system access, the entity registers and authorizes new internal and external users whose access is administered by the entity. For those users whose access is administered by the entity, user system credentials are removed when user access is no longer authorized.', {
      text: '\n'
    }, {
      ul: ['Controls Access Credentials to Protected Assets', 'Removes Access to Protected Assets When Appropriate', 'Reviews Appropriateness of Access Credentials']
    }]
  },
  'CC6.3': {
    stack: ['The entity authorizes, modifies, or removes access to data, software, functions, and other protected information assets based on roles, responsibilities, or the system design and changes, giving consideration to the concepts of least privilege and segregation of duties, to meet the entity’s objectives.', {
      text: '\n'
    }, {
      ul: ['Creates or Modifies Access to Protected Information Assets', 'Removes Access to Protected Information Assets', 'Uses Role-Based Access Controls', 'Reviews Access Roles and Rules']
    }]
  },
  'CC6.4': {
    stack: ['The entity restricts physical access to facilities and protected information assets (for example, data center facilities, backup media storage, and other sensitive locations) to authorized personnel to meet the entity’s objectives', {
      text: '\n'
    }, {
      ul: ['Creates or Modifies Physical Access', 'Removes Physical Access', 'Reviews Physical Access']
    }]
  },
  'CC6.6': {
    stack: ['The entity implements logical access security measures to protect against threats from sources outside its system boundaries.', {
      text: '\n'
    }, {
      ul: ['Restricts Access', 'Protects Identification and Authentication Credentials', 'Requires Additional Authentication or Credentials', 'Implements Boundary Protection Systems']
    }]
  },
  'CC6.7': {
    stack: ['The entity restricts the transmission, movement, and removal of information to authorized internal and external users and processes, and protects it during transmission, movement, or removal to meet the entity’s objectives.', {
      text: '\n'
    }, {
      ul: ['Restricts the Ability to Perform Transmission', 'Uses Encryption Technologies or Secure Communication Channels to Protect Data', 'Protects Removal Media', 'Protects Mobile Devices']
    }]
  },
  'CC6.8': {
    stack: ['The entity implements controls to prevent or detect and act upon the introduction of unauthorized or malicious software to meet the entity’s objectives.', {
      text: '\n'
    }, {
      ul: ['Restricts Application and Software Installation', 'Detects Unauthorized Changes to Software and Configuration Parameters', 'Uses a Defined Change Control Process', 'Uses Antivirus and Anti-Malware Software', 'Scans Information Assets from Outside the Entity for Malware and Other Unauthorized Software']
    }]
  },
  'CC7.1': {
    stack: ['To meet its objectives, the entity uses detection and monitoring procedures to identify (1) changes to configurations that result in the introduction of new vulnerabilities, and (2) susceptibilities to newly discovered vulnerabilities.', {
      text: '\n'
    }, {
      ul: ['Uses Defined Configuration Standards', 'Monitors Infrastructure and Software', 'Implements Change-Detection Mechanisms', 'Detects Unknown or Unauthorized Components', 'Conducts Vulnerability Scans']
    }]
  },
  'CC7.2': {
    stack: ["The entity monitors system components and the operation of those components for anomalies that are indicative of malicious acts, natural disasters, and errors affecting the entity's ability to meet its objectives; anomalies are analyzed to determine whether they represent security events.", {
      text: '\n'
    }, {
      ul: ['Implements Detection Policies, Procedures, and Tools', 'Designs Detection Measures', 'Implements Filters to Analyze Anomalies', 'Monitors Detection Tools for Effective Operation']
    }]
  },
  'CC7.3': {
    stack: ['The entity evaluates security events to determine whether they could or have resulted in a failure of the entity to meet its objectives (security incidents) and, if so, takes actions to prevent or address such failures.', {
      text: '\n'
    }, {
      ul: ['Responds to Security Incidents', 'Communicates and Reviews Detected Security Events', 'Develops and Implements Procedures to Analyze Security Incidents']
    }]
  },
  'CC7.4': {
    stack: ['The entity responds to identified security incidents by executing a defined incident-response program to understand, contain, remediate, and communicate security incidents, as appropriate.', {
      text: '\n'
    }, {
      ul: ['Assigns Roles and Responsibilities', 'Contains Security Incidents', 'Mitigates Ongoing Security Incidents', 'Ends Threats Posed by Security Incidents', 'Restores Operations', 'Develops and Implements Communication Protocols for Security Incidents', 'Obtains Understanding of Nature of Incident and Determines Containment Strategy', 'Remediates Identified Vulnerabilities', 'Communicates Remediation Activities', 'Evaluates the Effectiveness of Incident Response', 'Periodically Evaluates Incidents']
    }]
  },
  'CC8.1': {
    stack: ['The entity authorizes, designs, develops or acquires, configures, documents, tests, approves, and implements changes to infrastructure, data, software, and procedures to meet its objectives', {
      text: '\n'
    }, {
      ul: ['Manages Changes Throughout the System Life Cycle', 'Authorizes Changes', 'Designs and Develops Changes', 'Documents Changes', 'Tracks System Changes', 'Configures Software', 'Tests System Changes ', 'Approves System Changes', 'Deploys System Changes', 'Identifies and Evaluates System Changes', 'Identifies Changes in Infrastructure, Data, Software, and Procedures Required to Remediate Incidents', 'Creates Baseline Configuration of IT Technology', 'Provides for Changes Necessary in Emergency Situations']
    }]
  },
  'PI1.4': {
    stack: ['The entity implements policies and procedures to make available or deliver output completely, accurately, and timely in accordance with specifications to meet the entity’s objectives.', {
      text: '\n'
    }, {
      ul: ['Protects Output', 'Distributes Output Only to Intended Parties', 'Distributes Output Completely and Accurately', 'Creates and Maintains Records of System Output Activities']
    }]
  },
  'PI1.5': {
    stack: ['The entity implements policies and procedures to store inputs, items in processing, and outputs completely, accurately, and timely in accordance with system specifications to meet the entity’s objectives.', {
      text: '\n'
    }, {
      ul: ['Protects Stored Items', 'Archives and Protects System Records', 'Stores Data Completely and Accurately', 'Creates and Maintains Records of System Storage Activities']
    }]
  }
};
exports.default = _default;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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