"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.configuredJobs = void 0;

var _index = require("./index");

var _getConfiguration = require("../../lib/get-configuration");

const configuredJobs = params => {
  const {
    host,
    jobName
  } = params;
  return checkCluster(checkConfiguration(getJobs({
    jobName,
    host
  })));
};

exports.configuredJobs = configuredJobs;

const getJobs = params => {
  const {
    host,
    jobName
  } = params;
  if (!jobName) return {
    jobObj: _index.jobs,
    host
  };
  return {
    jobObj: {
      [jobName]: _index.jobs[jobName]
    },
    host
  };
};

const checkCluster = params => {
  const {
    host
  } = params;
  const newJobObj = JSON.parse(JSON.stringify(params.jobObj));

  if (host && host.cluster_info && host.cluster_info.status === 'enabled') {
    ['manager-stats-remoted', 'manager-stats-analysisd'].forEach(item => {
      newJobObj[item] && (newJobObj[item].status = false);
    });
  } else if (host && host.cluster_info && host.cluster_info.status === 'disabled') {
    ['cluster-stats-remoted', 'cluster-stats-analysisd'].forEach(item => {
      newJobObj[item] && (newJobObj[item].status = false);
    });
  } else if (host && !host.cluster_info) {
    Object.keys(newJobObj).forEach(key => newJobObj[key].status = false);
  }

  return newJobObj;
};

const checkConfiguration = params => {
  const {
    jobObj,
    host
  } = params;
  const config = (0, _getConfiguration.getConfiguration)();
  const cronSettigns = Object.keys(config).filter(checkSetting);
  cronSettigns.forEach(setting => applySettings(setting, config[setting], jobObj));
  return {
    jobObj,
    host
  };
};

const cronRegx = /cron.(?<task>statistics).((?<index>\w+)\.)?(?<config>\w+)$/;

const checkSetting = setting => cronRegx.test(setting);

const applySettings = (setting, value, jobObj) => {
  const {
    task,
    index,
    config
  } = cronRegx.exec(setting).groups;
  Object.keys(jobObj).forEach(key => {
    if (task === 'statistics') {
      applyStatisticSetting(jobObj[key], index, config, value);
    } else if (!key.includes(task)) {
      return;
    } else {
      applySetting(jobObj[key], index, config, value);
    }
  });
};

const applySetting = (job, index, config, value) => {
  if (index) {
    job[index][config] = value;
  } else {
    job[config] = value;
  }
};

const applyStatisticSetting = (job, index, config, value) => {
  if (index) {
    job[index][config] = value;
  } else {
    job[config] = value;
  }
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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