"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WAZUH_UI_LOGS_PLAIN_FILENAME = exports.WAZUH_STATISTICS_TEMPLATE_NAME = exports.WAZUH_STATISTICS_PATTERN = exports.WAZUH_STATISTICS_DEFAULT_STATUS = exports.WAZUH_STATISTICS_DEFAULT_PREFIX = exports.WAZUH_STATISTICS_DEFAULT_NAME = exports.WAZUH_STATISTICS_DEFAULT_INDICES_SHARDS = exports.WAZUH_STATISTICS_DEFAULT_INDICES_REPLICAS = exports.WAZUH_STATISTICS_DEFAULT_FREQUENCY = exports.WAZUH_STATISTICS_DEFAULT_CRON_FREQ = exports.WAZUH_STATISTICS_DEFAULT_CREATION = exports.WAZUH_SECURITY_PLUGIN_XPACK_SECURITY = exports.WAZUH_SECURITY_PLUGIN_OPEN_DISTRO_FOR_ELASTICSEARCH = exports.WAZUH_SECURITY_PLUGINS = exports.WAZUH_SAMPLE_ALERT_PREFIX = exports.WAZUH_SAMPLE_ALERTS_INDEX_SHARDS = exports.WAZUH_SAMPLE_ALERTS_INDEX_REPLICAS = exports.WAZUH_SAMPLE_ALERTS_DEFAULT_NUMBER_ALERTS = exports.WAZUH_SAMPLE_ALERTS_CATEGORY_THREAT_DETECTION = exports.WAZUH_SAMPLE_ALERTS_CATEGORY_SECURITY = exports.WAZUH_SAMPLE_ALERTS_CATEGORY_AUDITING_POLICY_MONITORING = exports.WAZUH_SAMPLE_ALERTS_CATEGORIES_TYPE_ALERTS = exports.WAZUH_ROLE_ADMINISTRATOR_NAME = exports.WAZUH_ROLE_ADMINISTRATOR_ID = exports.WAZUH_QUEUE_CRON_FREQ = exports.WAZUH_PLUGIN_PLATFORM_TEMPLATE_NAME = exports.WAZUH_PLUGIN_PLATFORM_SETTING_TIME_FILTER = exports.WAZUH_PLUGIN_PLATFORM_SETTING_METAFIELDS = exports.WAZUH_PLUGIN_PLATFORM_SETTING_MAX_BUCKETS = exports.WAZUH_MONITORING_TEMPLATE_NAME = exports.WAZUH_MONITORING_PREFIX = exports.WAZUH_MONITORING_PATTERN = exports.WAZUH_MONITORING_DEFAULT_INDICES_SHARDS = exports.WAZUH_MONITORING_DEFAULT_INDICES_REPLICAS = exports.WAZUH_MONITORING_DEFAULT_FREQUENCY = exports.WAZUH_MONITORING_DEFAULT_ENABLED = exports.WAZUH_MONITORING_DEFAULT_CRON_FREQ = exports.WAZUH_MONITORING_DEFAULT_CREATION = exports.WAZUH_MODULES_ID = exports.WAZUH_MENU_TOOLS_SECTIONS_ID = exports.WAZUH_MENU_SETTINGS_SECTIONS_ID = exports.WAZUH_MENU_SECURITY_SECTIONS_ID = exports.WAZUH_MENU_MANAGEMENT_SECTIONS_ID = exports.WAZUH_LINK_SLACK = exports.WAZUH_LINK_GOOGLE_GROUPS = exports.WAZUH_LINK_GITHUB = exports.WAZUH_LINK_DOCUMENTATION = exports.WAZUH_INDEX_TYPE_STATISTICS = exports.WAZUH_INDEX_TYPE_MONITORING = exports.WAZUH_INDEX_TYPE_ALERTS = exports.WAZUH_ERROR_DAEMONS_NOT_READY = exports.WAZUH_DEFAULT_APP_CONFIG = exports.WAZUH_DATA_PLUGIN_PLATFORM_BASE_ABSOLUTE_PATH = exports.WAZUH_DATA_LOGS_RAW_PATH = exports.WAZUH_DATA_LOGS_RAW_FILENAME = exports.WAZUH_DATA_LOGS_PLAIN_PATH = exports.WAZUH_DATA_LOGS_PLAIN_FILENAME = exports.WAZUH_DATA_LOGS_DIRECTORY_PATH = exports.WAZUH_DATA_DOWNLOADS_REPORTS_DIRECTORY_PATH = exports.WAZUH_DATA_DOWNLOADS_DIRECTORY_PATH = exports.WAZUH_DATA_CONFIG_REGISTRY_PATH = exports.WAZUH_DATA_CONFIG_DIRECTORY_PATH = exports.WAZUH_DATA_CONFIG_APP_PATH = exports.WAZUH_DATA_ABSOLUTE_PATH = exports.WAZUH_CONFIGURATION_SETTINGS_NEED_RESTART = exports.WAZUH_CONFIGURATION_SETTINGS_NEED_RELOAD = exports.WAZUH_CONFIGURATION_SETTINGS_NEED_HEALTH_CHECK = exports.WAZUH_CONFIGURATION_CACHE_TIME = exports.WAZUH_API_RESERVED_ID_LOWER_THAN = exports.WAZUH_ALERTS_PREFIX = exports.WAZUH_ALERTS_PATTERN = exports.WAZUH_AGENTS_OS_TYPE = exports.UI_TOAST_COLOR = exports.UI_ORDER_AGENT_STATUS = exports.UI_LOGGER_LEVELS = exports.UI_LABEL_NAME_AGENT_STATUS = exports.UI_COLOR_AGENT_STATUS = exports.REPORTS_PRIMARY_COLOR = exports.REPORTS_PAGE_HEADER_TEXT = exports.REPORTS_PAGE_FOOTER_TEXT = exports.REPORTS_LOGO_IMAGE_ASSETS_RELATIVE_PATH = exports.PLUGIN_PLATFORM_WAZUH_DOCUMENTATION_URL_UPGRADE_PLATFORM = exports.PLUGIN_PLATFORM_WAZUH_DOCUMENTATION_URL_TROUBLESHOOTING = exports.PLUGIN_PLATFORM_WAZUH_DOCUMENTATION_URL_APP_CONFIGURATION = exports.PLUGIN_PLATFORM_URL_GUIDE_TITLE = exports.PLUGIN_PLATFORM_URL_GUIDE = exports.PLUGIN_PLATFORM_SETTING_NAME_TIME_FILTER = exports.PLUGIN_PLATFORM_SETTING_NAME_METAFIELDS = exports.PLUGIN_PLATFORM_SETTING_NAME_MAX_BUCKETS = exports.PLUGIN_PLATFORM_REQUEST_HEADERS = exports.PLUGIN_PLATFORM_NAME = exports.PLUGIN_PLATFORM_INSTALLATION_USER_GROUP = exports.PLUGIN_PLATFORM_INSTALLATION_USER = exports.PLUGIN_PLATFORM_BASE_INSTALLATION_PATH = exports.MAX_MB_LOG_FILES = exports.HEALTH_CHECK_REDIRECTION_TIME = exports.HEALTH_CHECK = exports.AUTHORIZED_AGENTS = exports.ASSETS_BASE_URL_PREFIX = exports.API_NAME_AGENT_STATUS = void 0;
exports.WAZUH_UI_LOGS_RAW_PATH = exports.WAZUH_UI_LOGS_RAW_FILENAME = exports.WAZUH_UI_LOGS_PLAIN_PATH = exports.WAZUH_UI_LOGS_PLAIN_FILENAME = exports.WAZUH_STATISTICS_TEMPLATE_NAME = exports.WAZUH_STATISTICS_PATTERN = exports.WAZUH_STATISTICS_DEFAULT_STATUS = exports.WAZUH_STATISTICS_DEFAULT_PREFIX = exports.WAZUH_STATISTICS_DEFAULT_NAME = exports.WAZUH_STATISTICS_DEFAULT_INDICES_SHARDS = exports.WAZUH_STATISTICS_DEFAULT_INDICES_REPLICAS = exports.WAZUH_STATISTICS_DEFAULT_FREQUENCY = exports.WAZUH_STATISTICS_DEFAULT_CRON_FREQ = exports.WAZUH_STATISTICS_DEFAULT_CREATION = exports.WAZUH_SECURITY_PLUGIN_XPACK_SECURITY = exports.WAZUH_SECURITY_PLUGIN_OPEN_DISTRO_FOR_ELASTICSEARCH = exports.WAZUH_SECURITY_PLUGINS = exports.WAZUH_SAMPLE_ALERT_PREFIX = exports.WAZUH_SAMPLE_ALERTS_INDEX_SHARDS = exports.WAZUH_SAMPLE_ALERTS_INDEX_REPLICAS = exports.WAZUH_SAMPLE_ALERTS_DEFAULT_NUMBER_ALERTS = exports.WAZUH_SAMPLE_ALERTS_CATEGORY_THREAT_DETECTION = exports.WAZUH_SAMPLE_ALERTS_CATEGORY_SECURITY = exports.WAZUH_SAMPLE_ALERTS_CATEGORY_AUDITING_POLICY_MONITORING = exports.WAZUH_SAMPLE_ALERTS_CATEGORIES_TYPE_ALERTS = exports.WAZUH_ROLE_ADMINISTRATOR_NAME = exports.WAZUH_ROLE_ADMINISTRATOR_ID = exports.WAZUH_QUEUE_CRON_FREQ = exports.WAZUH_PLUGIN_PLATFORM_TEMPLATE_NAME = exports.WAZUH_PLUGIN_PLATFORM_SETTING_TIME_FILTER = exports.WAZUH_PLUGIN_PLATFORM_SETTING_METAFIELDS = exports.WAZUH_PLUGIN_PLATFORM_SETTING_MAX_BUCKETS = exports.WAZUH_MONITORING_TEMPLATE_NAME = exports.WAZUH_MONITORING_PREFIX = exports.WAZUH_MONITORING_PATTERN = exports.WAZUH_MONITORING_DEFAULT_INDICES_SHARDS = exports.WAZUH_MONITORING_DEFAULT_INDICES_REPLICAS = exports.WAZUH_MONITORING_DEFAULT_FREQUENCY = exports.WAZUH_MONITORING_DEFAULT_ENABLED = exports.WAZUH_MONITORING_DEFAULT_CRON_FREQ = exports.WAZUH_MONITORING_DEFAULT_CREATION = exports.WAZUH_MODULES_ID = exports.WAZUH_MENU_TOOLS_SECTIONS_ID = exports.WAZUH_MENU_SETTINGS_SECTIONS_ID = exports.WAZUH_MENU_SECURITY_SECTIONS_ID = exports.WAZUH_MENU_MANAGEMENT_SECTIONS_ID = exports.WAZUH_LINK_SLACK = exports.WAZUH_LINK_GOOGLE_GROUPS = exports.WAZUH_LINK_GITHUB = exports.WAZUH_LINK_DOCUMENTATION = exports.WAZUH_INDEX_TYPE_STATISTICS = exports.WAZUH_INDEX_TYPE_MONITORING = exports.WAZUH_INDEX_TYPE_ALERTS = exports.WAZUH_ERROR_DAEMONS_NOT_READY = exports.WAZUH_DEFAULT_APP_CONFIG = exports.WAZUH_DATA_PLUGIN_PLATFORM_BASE_ABSOLUTE_PATH = exports.WAZUH_DATA_LOGS_RAW_PATH = exports.WAZUH_DATA_LOGS_RAW_FILENAME = exports.WAZUH_DATA_LOGS_PLAIN_PATH = exports.WAZUH_DATA_LOGS_PLAIN_FILENAME = exports.WAZUH_DATA_LOGS_DIRECTORY_PATH = exports.WAZUH_DATA_DOWNLOADS_REPORTS_DIRECTORY_PATH = exports.WAZUH_DATA_DOWNLOADS_DIRECTORY_PATH = exports.WAZUH_DATA_CONFIG_REGISTRY_PATH = exports.WAZUH_DATA_CONFIG_DIRECTORY_PATH = exports.WAZUH_DATA_CONFIG_APP_PATH = exports.WAZUH_DATA_ABSOLUTE_PATH = exports.WAZUH_CONFIGURATION_SETTINGS_NEED_RESTART = exports.WAZUH_CONFIGURATION_SETTINGS_NEED_RELOAD = exports.WAZUH_CONFIGURATION_SETTINGS_NEED_HEALTH_CHECK = exports.WAZUH_CONFIGURATION_CACHE_TIME = exports.WAZUH_API_RESERVED_ID_LOWER_THAN = exports.WAZUH_ALERTS_PREFIX = exports.WAZUH_ALERTS_PATTERN = exports.WAZUH_AGENTS_OS_TYPE = exports.UI_TOAST_COLOR = exports.UI_ORDER_AGENT_STATUS = exports.UI_LOGGER_LEVELS = exports.UI_LABEL_NAME_AGENT_STATUS = exports.UI_COLOR_AGENT_STATUS = exports.REPORTS_PRIMARY_COLOR = exports.REPORTS_PAGE_HEADER_TEXT = exports.REPORTS_PAGE_FOOTER_TEXT = exports.REPORTS_LOGO_IMAGE_ASSETS_RELATIVE_PATH = exports.PLUGIN_PLATFORM_WAZUH_DOCUMENTATION_URL_UPGRADE_PLATFORM = exports.PLUGIN_PLATFORM_WAZUH_DOCUMENTATION_URL_TROUBLESHOOTING = exports.PLUGIN_PLATFORM_WAZUH_DOCUMENTATION_URL_APP_CONFIGURATION = exports.PLUGIN_PLATFORM_URL_GUIDE_TITLE = exports.PLUGIN_PLATFORM_URL_GUIDE = exports.PLUGIN_PLATFORM_SETTING_NAME_TIME_FILTER = exports.PLUGIN_PLATFORM_SETTING_NAME_METAFIELDS = exports.PLUGIN_PLATFORM_SETTING_NAME_MAX_BUCKETS = exports.PLUGIN_PLATFORM_REQUEST_HEADERS = exports.PLUGIN_PLATFORM_NAME = exports.PLUGIN_PLATFORM_INSTALLATION_USER_GROUP = exports.PLUGIN_PLATFORM_INSTALLATION_USER = exports.PLUGIN_PLATFORM_BASE_INSTALLATION_PATH = exports.MAX_MB_LOG_FILES = exports.HEALTH_CHECK_REDIRECTION_TIME = exports.HEALTH_CHECK = exports.AUTHORIZED_AGENTS = exports.ASSETS_BASE_URL_PREFIX = exports.API_NAME_AGENT_STATUS = void 0;

var _path = _interopRequireDefault(require("path"));

/*
 * Wazuh app - Wazuh Constants file
 * Copyright (C) 2015-2022 Wazuh, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Find more information about this on the LICENSE file.
 */
// Index patterns - Wazuh alerts
const WAZUH_INDEX_TYPE_ALERTS = 'alerts';
exports.WAZUH_INDEX_TYPE_ALERTS = WAZUH_INDEX_TYPE_ALERTS;
const WAZUH_ALERTS_PREFIX = 'wazuh-alerts-';
exports.WAZUH_ALERTS_PREFIX = WAZUH_ALERTS_PREFIX;
const WAZUH_ALERTS_PATTERN = 'wazuh-alerts-*'; // Job - Wazuh monitoring

exports.WAZUH_ALERTS_PATTERN = WAZUH_ALERTS_PATTERN;
const WAZUH_INDEX_TYPE_MONITORING = "monitoring";
exports.WAZUH_INDEX_TYPE_MONITORING = WAZUH_INDEX_TYPE_MONITORING;
const WAZUH_MONITORING_PREFIX = "wazuh-monitoring-";
exports.WAZUH_MONITORING_PREFIX = WAZUH_MONITORING_PREFIX;
const WAZUH_MONITORING_PATTERN = "wazuh-monitoring-*";
exports.WAZUH_MONITORING_PATTERN = WAZUH_MONITORING_PATTERN;
const WAZUH_MONITORING_TEMPLATE_NAME = "wazuh-agent";
exports.WAZUH_MONITORING_TEMPLATE_NAME = WAZUH_MONITORING_TEMPLATE_NAME;
const WAZUH_MONITORING_DEFAULT_INDICES_SHARDS = 1;
exports.WAZUH_MONITORING_DEFAULT_INDICES_SHARDS = WAZUH_MONITORING_DEFAULT_INDICES_SHARDS;
const WAZUH_MONITORING_DEFAULT_INDICES_REPLICAS = 0;
exports.WAZUH_MONITORING_DEFAULT_INDICES_REPLICAS = WAZUH_MONITORING_DEFAULT_INDICES_REPLICAS;
const WAZUH_MONITORING_DEFAULT_CREATION = 'w';
exports.WAZUH_MONITORING_DEFAULT_CREATION = WAZUH_MONITORING_DEFAULT_CREATION;
const WAZUH_MONITORING_DEFAULT_ENABLED = true;
exports.WAZUH_MONITORING_DEFAULT_ENABLED = WAZUH_MONITORING_DEFAULT_ENABLED;
const WAZUH_MONITORING_DEFAULT_FREQUENCY = 900;
exports.WAZUH_MONITORING_DEFAULT_FREQUENCY = WAZUH_MONITORING_DEFAULT_FREQUENCY;
const WAZUH_MONITORING_DEFAULT_CRON_FREQ = '0 * * * * *'; // Job - Wazuh statistics

exports.WAZUH_MONITORING_DEFAULT_CRON_FREQ = WAZUH_MONITORING_DEFAULT_CRON_FREQ;
const WAZUH_INDEX_TYPE_STATISTICS = "statistics";
exports.WAZUH_INDEX_TYPE_STATISTICS = WAZUH_INDEX_TYPE_STATISTICS;
const WAZUH_STATISTICS_DEFAULT_PREFIX = "wazuh";
exports.WAZUH_STATISTICS_DEFAULT_PREFIX = WAZUH_STATISTICS_DEFAULT_PREFIX;
const WAZUH_STATISTICS_DEFAULT_NAME = "statistics";
exports.WAZUH_STATISTICS_DEFAULT_NAME = WAZUH_STATISTICS_DEFAULT_NAME;
const WAZUH_STATISTICS_PATTERN = `${WAZUH_STATISTICS_DEFAULT_PREFIX}-${WAZUH_STATISTICS_DEFAULT_NAME}-*`;
exports.WAZUH_STATISTICS_PATTERN = WAZUH_STATISTICS_PATTERN;
const WAZUH_STATISTICS_TEMPLATE_NAME = `${WAZUH_STATISTICS_DEFAULT_PREFIX}-${WAZUH_STATISTICS_DEFAULT_NAME}`;
exports.WAZUH_STATISTICS_TEMPLATE_NAME = WAZUH_STATISTICS_TEMPLATE_NAME;
const WAZUH_STATISTICS_DEFAULT_INDICES_SHARDS = 1;
exports.WAZUH_STATISTICS_DEFAULT_INDICES_SHARDS = WAZUH_STATISTICS_DEFAULT_INDICES_SHARDS;
const WAZUH_STATISTICS_DEFAULT_INDICES_REPLICAS = 0;
exports.WAZUH_STATISTICS_DEFAULT_INDICES_REPLICAS = WAZUH_STATISTICS_DEFAULT_INDICES_REPLICAS;
const WAZUH_STATISTICS_DEFAULT_CREATION = 'w';
exports.WAZUH_STATISTICS_DEFAULT_CREATION = WAZUH_STATISTICS_DEFAULT_CREATION;
const WAZUH_STATISTICS_DEFAULT_STATUS = true;
exports.WAZUH_STATISTICS_DEFAULT_STATUS = WAZUH_STATISTICS_DEFAULT_STATUS;
const WAZUH_STATISTICS_DEFAULT_FREQUENCY = 900;
exports.WAZUH_STATISTICS_DEFAULT_FREQUENCY = WAZUH_STATISTICS_DEFAULT_FREQUENCY;
const WAZUH_STATISTICS_DEFAULT_CRON_FREQ = '0 */5 * * * *'; // Job - Wazuh initialize

exports.WAZUH_STATISTICS_DEFAULT_CRON_FREQ = WAZUH_STATISTICS_DEFAULT_CRON_FREQ;
const WAZUH_PLUGIN_PLATFORM_TEMPLATE_NAME = 'wazuh-kibana'; // Permissions

exports.WAZUH_PLUGIN_PLATFORM_TEMPLATE_NAME = WAZUH_PLUGIN_PLATFORM_TEMPLATE_NAME;
const WAZUH_ROLE_ADMINISTRATOR_ID = 1;
exports.WAZUH_ROLE_ADMINISTRATOR_ID = WAZUH_ROLE_ADMINISTRATOR_ID;
const WAZUH_ROLE_ADMINISTRATOR_NAME = 'administrator'; // Sample data

exports.WAZUH_ROLE_ADMINISTRATOR_NAME = WAZUH_ROLE_ADMINISTRATOR_NAME;
const WAZUH_SAMPLE_ALERT_PREFIX = 'wazuh-alerts-4.x-';
exports.WAZUH_SAMPLE_ALERT_PREFIX = WAZUH_SAMPLE_ALERT_PREFIX;
const WAZUH_SAMPLE_ALERTS_INDEX_SHARDS = 1;
exports.WAZUH_SAMPLE_ALERTS_INDEX_SHARDS = WAZUH_SAMPLE_ALERTS_INDEX_SHARDS;
const WAZUH_SAMPLE_ALERTS_INDEX_REPLICAS = 0;
exports.WAZUH_SAMPLE_ALERTS_INDEX_REPLICAS = WAZUH_SAMPLE_ALERTS_INDEX_REPLICAS;
const WAZUH_SAMPLE_ALERTS_CATEGORY_SECURITY = 'security';
exports.WAZUH_SAMPLE_ALERTS_CATEGORY_SECURITY = WAZUH_SAMPLE_ALERTS_CATEGORY_SECURITY;
const WAZUH_SAMPLE_ALERTS_CATEGORY_AUDITING_POLICY_MONITORING = 'auditing-policy-monitoring';
exports.WAZUH_SAMPLE_ALERTS_CATEGORY_AUDITING_POLICY_MONITORING = WAZUH_SAMPLE_ALERTS_CATEGORY_AUDITING_POLICY_MONITORING;
const WAZUH_SAMPLE_ALERTS_CATEGORY_THREAT_DETECTION = 'threat-detection';
exports.WAZUH_SAMPLE_ALERTS_CATEGORY_THREAT_DETECTION = WAZUH_SAMPLE_ALERTS_CATEGORY_THREAT_DETECTION;
const WAZUH_SAMPLE_ALERTS_DEFAULT_NUMBER_ALERTS = 3000;
exports.WAZUH_SAMPLE_ALERTS_DEFAULT_NUMBER_ALERTS = WAZUH_SAMPLE_ALERTS_DEFAULT_NUMBER_ALERTS;
const WAZUH_SAMPLE_ALERTS_CATEGORIES_TYPE_ALERTS = {
  [WAZUH_SAMPLE_ALERTS_CATEGORY_SECURITY]: [{
    syscheck: true
  }, {
    aws: true
  }, {
    office: true
  }, {
    gcp: true
  }, {
    authentication: true
  }, {
    ssh: true
  }, {
    apache: true,
    alerts: 2000
  }, {
    web: true
  }, {
    windows: {
      service_control_manager: true
    },
    alerts: 1000
  }, {
    github: true
  }],
  [WAZUH_SAMPLE_ALERTS_CATEGORY_AUDITING_POLICY_MONITORING]: [{
    rootcheck: true
  }, {
    audit: true
  }, {
    openscap: true
  }, {
    ciscat: true
  }],
  [WAZUH_SAMPLE_ALERTS_CATEGORY_THREAT_DETECTION]: [{
    vulnerabilities: true
  }, {
    virustotal: true
  }, {
    osquery: true
  }, {
    docker: true
  }, {
    mitre: true
  }]
}; // Security

exports.WAZUH_SAMPLE_ALERTS_CATEGORIES_TYPE_ALERTS = WAZUH_SAMPLE_ALERTS_CATEGORIES_TYPE_ALERTS;
const WAZUH_SECURITY_PLUGIN_XPACK_SECURITY = 'X-Pack Security';
exports.WAZUH_SECURITY_PLUGIN_XPACK_SECURITY = WAZUH_SECURITY_PLUGIN_XPACK_SECURITY;
const WAZUH_SECURITY_PLUGIN_OPEN_DISTRO_FOR_ELASTICSEARCH = 'Open Distro for Elasticsearch';
exports.WAZUH_SECURITY_PLUGIN_OPEN_DISTRO_FOR_ELASTICSEARCH = WAZUH_SECURITY_PLUGIN_OPEN_DISTRO_FOR_ELASTICSEARCH;
const WAZUH_SECURITY_PLUGINS = [WAZUH_SECURITY_PLUGIN_XPACK_SECURITY, WAZUH_SECURITY_PLUGIN_OPEN_DISTRO_FOR_ELASTICSEARCH]; // App configuration

exports.WAZUH_SECURITY_PLUGINS = WAZUH_SECURITY_PLUGINS;
const WAZUH_CONFIGURATION_CACHE_TIME = 10000; // time in ms;

exports.WAZUH_CONFIGURATION_CACHE_TIME = WAZUH_CONFIGURATION_CACHE_TIME;
const WAZUH_CONFIGURATION_SETTINGS_NEED_RESTART = ['wazuh.monitoring.enabled', 'wazuh.monitoring.frequency', 'cron.statistics.interval', 'logs.level'];
exports.WAZUH_CONFIGURATION_SETTINGS_NEED_RESTART = WAZUH_CONFIGURATION_SETTINGS_NEED_RESTART;
const WAZUH_CONFIGURATION_SETTINGS_NEED_HEALTH_CHECK = ['pattern', 'wazuh.monitoring.replicas', 'wazuh.monitoring.creation', 'wazuh.monitoring.pattern', 'alerts.sample.prefix', 'cron.statistics.index.name', 'cron.statistics.index.creation', 'cron.statistics.index.shards', 'cron.statistics.index.replicas', 'wazuh.monitoring.shards'];
exports.WAZUH_CONFIGURATION_SETTINGS_NEED_HEALTH_CHECK = WAZUH_CONFIGURATION_SETTINGS_NEED_HEALTH_CHECK;
const WAZUH_CONFIGURATION_SETTINGS_NEED_RELOAD = ['hideManagerAlerts', 'customization.logo.sidebar']; // Reserved ids for Users/Role mapping

exports.WAZUH_CONFIGURATION_SETTINGS_NEED_RELOAD = WAZUH_CONFIGURATION_SETTINGS_NEED_RELOAD;
const WAZUH_API_RESERVED_ID_LOWER_THAN = 100; // Wazuh data path

exports.WAZUH_API_RESERVED_ID_LOWER_THAN = WAZUH_API_RESERVED_ID_LOWER_THAN;
const WAZUH_DATA_PLUGIN_PLATFORM_BASE_PATH = 'data';

const WAZUH_DATA_PLUGIN_PLATFORM_BASE_ABSOLUTE_PATH = _path.default.join(__dirname, '../../../', WAZUH_DATA_PLUGIN_PLATFORM_BASE_PATH);

exports.WAZUH_DATA_PLUGIN_PLATFORM_BASE_ABSOLUTE_PATH = WAZUH_DATA_PLUGIN_PLATFORM_BASE_ABSOLUTE_PATH;

const WAZUH_DATA_ABSOLUTE_PATH = _path.default.join(WAZUH_DATA_PLUGIN_PLATFORM_BASE_ABSOLUTE_PATH, 'wazuh'); // Wazuh data path - config


exports.WAZUH_DATA_ABSOLUTE_PATH = WAZUH_DATA_ABSOLUTE_PATH;

const WAZUH_DATA_CONFIG_DIRECTORY_PATH = _path.default.join(WAZUH_DATA_ABSOLUTE_PATH, 'config');

exports.WAZUH_DATA_CONFIG_DIRECTORY_PATH = WAZUH_DATA_CONFIG_DIRECTORY_PATH;

const WAZUH_DATA_CONFIG_APP_PATH = _path.default.join(WAZUH_DATA_CONFIG_DIRECTORY_PATH, 'wazuh.yml');

exports.WAZUH_DATA_CONFIG_APP_PATH = WAZUH_DATA_CONFIG_APP_PATH;

const WAZUH_DATA_CONFIG_REGISTRY_PATH = _path.default.join(WAZUH_DATA_CONFIG_DIRECTORY_PATH, 'wazuh-registry.json'); // Wazuh data path - logs


exports.WAZUH_DATA_CONFIG_REGISTRY_PATH = WAZUH_DATA_CONFIG_REGISTRY_PATH;
const MAX_MB_LOG_FILES = 100;
exports.MAX_MB_LOG_FILES = MAX_MB_LOG_FILES;

const WAZUH_DATA_LOGS_DIRECTORY_PATH = _path.default.join(WAZUH_DATA_ABSOLUTE_PATH, 'logs');

exports.WAZUH_DATA_LOGS_DIRECTORY_PATH = WAZUH_DATA_LOGS_DIRECTORY_PATH;
const WAZUH_DATA_LOGS_PLAIN_FILENAME = 'wazuhapp-plain.log';
exports.WAZUH_DATA_LOGS_PLAIN_FILENAME = WAZUH_DATA_LOGS_PLAIN_FILENAME;

const WAZUH_DATA_LOGS_PLAIN_PATH = _path.default.join(WAZUH_DATA_LOGS_DIRECTORY_PATH, WAZUH_DATA_LOGS_PLAIN_FILENAME);

exports.WAZUH_DATA_LOGS_PLAIN_PATH = WAZUH_DATA_LOGS_PLAIN_PATH;
const WAZUH_DATA_LOGS_RAW_FILENAME = 'wazuhapp.log';
exports.WAZUH_DATA_LOGS_RAW_FILENAME = WAZUH_DATA_LOGS_RAW_FILENAME;

const WAZUH_DATA_LOGS_RAW_PATH = _path.default.join(WAZUH_DATA_LOGS_DIRECTORY_PATH, WAZUH_DATA_LOGS_RAW_FILENAME); // Wazuh data path - UI logs


exports.WAZUH_DATA_LOGS_RAW_PATH = WAZUH_DATA_LOGS_RAW_PATH;
const WAZUH_UI_LOGS_PLAIN_FILENAME = 'wazuh-ui-plain.log';
exports.WAZUH_UI_LOGS_PLAIN_FILENAME = WAZUH_UI_LOGS_PLAIN_FILENAME;
const WAZUH_UI_LOGS_RAW_FILENAME = 'wazuh-ui.log';
exports.WAZUH_UI_LOGS_RAW_FILENAME = WAZUH_UI_LOGS_RAW_FILENAME;

const WAZUH_UI_LOGS_PLAIN_PATH = _path.default.join(WAZUH_DATA_LOGS_DIRECTORY_PATH, WAZUH_UI_LOGS_PLAIN_FILENAME);

exports.WAZUH_UI_LOGS_PLAIN_PATH = WAZUH_UI_LOGS_PLAIN_PATH;

const WAZUH_UI_LOGS_RAW_PATH = _path.default.join(WAZUH_DATA_LOGS_DIRECTORY_PATH, WAZUH_UI_LOGS_RAW_FILENAME); // Wazuh data path - downloads


exports.WAZUH_UI_LOGS_RAW_PATH = WAZUH_UI_LOGS_RAW_PATH;

const WAZUH_DATA_DOWNLOADS_DIRECTORY_PATH = _path.default.join(WAZUH_DATA_ABSOLUTE_PATH, 'downloads');

exports.WAZUH_DATA_DOWNLOADS_DIRECTORY_PATH = WAZUH_DATA_DOWNLOADS_DIRECTORY_PATH;

const WAZUH_DATA_DOWNLOADS_REPORTS_DIRECTORY_PATH = _path.default.join(WAZUH_DATA_DOWNLOADS_DIRECTORY_PATH, 'reports'); // Queue


exports.WAZUH_DATA_DOWNLOADS_REPORTS_DIRECTORY_PATH = WAZUH_DATA_DOWNLOADS_REPORTS_DIRECTORY_PATH;
const WAZUH_QUEUE_CRON_FREQ = '*/15 * * * * *'; // Every 15 seconds
// Default App Config

exports.WAZUH_QUEUE_CRON_FREQ = WAZUH_QUEUE_CRON_FREQ;
const WAZUH_DEFAULT_APP_CONFIG = {
  pattern: WAZUH_ALERTS_PATTERN,
  'checks.pattern': true,
  'checks.template': true,
  'checks.api': true,
  'checks.setup': true,
  'checks.fields': true,
  'checks.metaFields': true,
  'checks.maxBuckets': true,
  'checks.timeFilter': true,
  'extensions.pci': true,
  'extensions.gdpr': true,
  'extensions.hipaa': true,
  'extensions.nist': true,
  'extensions.tsc': true,
  'extensions.audit': true,
  'extensions.oscap': false,
  'extensions.ciscat': false,
  'extensions.aws': false,
  'extensions.office': false,
  'extensions.github': false,
  'extensions.gcp': false,
  'extensions.virustotal': false,
  'extensions.osquery': false,
  'extensions.docker': false,
  timeout: 20000,
  'ip.selector': true,
  'ip.ignore': [],
  'xpack.rbac.enabled': true,
  'wazuh.monitoring.enabled': WAZUH_MONITORING_DEFAULT_ENABLED,
  'wazuh.monitoring.frequency': WAZUH_MONITORING_DEFAULT_FREQUENCY,
  'wazuh.monitoring.shards': WAZUH_MONITORING_DEFAULT_INDICES_SHARDS,
  'wazuh.monitoring.replicas': WAZUH_MONITORING_DEFAULT_INDICES_REPLICAS,
  'wazuh.monitoring.creation': WAZUH_MONITORING_DEFAULT_CREATION,
  'wazuh.monitoring.pattern': WAZUH_MONITORING_PATTERN,
  'cron.prefix': WAZUH_STATISTICS_DEFAULT_PREFIX,
  'cron.statistics.status': WAZUH_STATISTICS_DEFAULT_STATUS,
  'cron.statistics.apis': [],
  'cron.statistics.interval': WAZUH_STATISTICS_DEFAULT_CRON_FREQ,
  'cron.statistics.index.name': WAZUH_STATISTICS_DEFAULT_NAME,
  'cron.statistics.index.creation': WAZUH_STATISTICS_DEFAULT_CREATION,
  'cron.statistics.index.shards': WAZUH_STATISTICS_DEFAULT_INDICES_SHARDS,
  'cron.statistics.index.replicas': WAZUH_STATISTICS_DEFAULT_INDICES_REPLICAS,
  'alerts.sample.prefix': WAZUH_SAMPLE_ALERT_PREFIX,
  hideManagerAlerts: false,
  'logs.level': 'info',
  'enrollment.dns': '',
  'customization.logo.app': '',
  'customization.logo.sidebar': '',
  'customization.logo.healthcheck': '',
  'customization.logo.reports': ''
}; // Wazuh errors

exports.WAZUH_DEFAULT_APP_CONFIG = WAZUH_DEFAULT_APP_CONFIG;
const WAZUH_ERROR_DAEMONS_NOT_READY = 'ERROR3099'; // Agents

exports.WAZUH_ERROR_DAEMONS_NOT_READY = WAZUH_ERROR_DAEMONS_NOT_READY;
let WAZUH_AGENTS_OS_TYPE;
exports.WAZUH_AGENTS_OS_TYPE = WAZUH_AGENTS_OS_TYPE;

(function (WAZUH_AGENTS_OS_TYPE) {
  WAZUH_AGENTS_OS_TYPE["WINDOWS"] = "windows";
  WAZUH_AGENTS_OS_TYPE["LINUX"] = "linux";
  WAZUH_AGENTS_OS_TYPE["SUNOS"] = "sunos";
  WAZUH_AGENTS_OS_TYPE["DARWIN"] = "darwin";
  WAZUH_AGENTS_OS_TYPE["OTHERS"] = "";
})(WAZUH_AGENTS_OS_TYPE || (exports.WAZUH_AGENTS_OS_TYPE = WAZUH_AGENTS_OS_TYPE = {}));

let WAZUH_MODULES_ID;
exports.WAZUH_MODULES_ID = WAZUH_MODULES_ID;

(function (WAZUH_MODULES_ID) {
  WAZUH_MODULES_ID["SECURITY_EVENTS"] = "general";
  WAZUH_MODULES_ID["INTEGRITY_MONITORING"] = "fim";
  WAZUH_MODULES_ID["AMAZON_WEB_SERVICES"] = "aws";
  WAZUH_MODULES_ID["OFFICE_365"] = "office";
  WAZUH_MODULES_ID["GOOGLE_CLOUD_PLATFORM"] = "gcp";
  WAZUH_MODULES_ID["POLICY_MONITORING"] = "pm";
  WAZUH_MODULES_ID["SECURITY_CONFIGURATION_ASSESSMENT"] = "sca";
  WAZUH_MODULES_ID["AUDITING"] = "audit";
  WAZUH_MODULES_ID["OPEN_SCAP"] = "oscap";
  WAZUH_MODULES_ID["VULNERABILITIES"] = "vuls";
  WAZUH_MODULES_ID["OSQUERY"] = "osquery";
  WAZUH_MODULES_ID["DOCKER"] = "docker";
  WAZUH_MODULES_ID["MITRE_ATTACK"] = "mitre";
  WAZUH_MODULES_ID["PCI_DSS"] = "pci";
  WAZUH_MODULES_ID["HIPAA"] = "hipaa";
  WAZUH_MODULES_ID["NIST_800_53"] = "nist";
  WAZUH_MODULES_ID["TSC"] = "tsc";
  WAZUH_MODULES_ID["CIS_CAT"] = "ciscat";
  WAZUH_MODULES_ID["VIRUSTOTAL"] = "virustotal";
  WAZUH_MODULES_ID["GDPR"] = "gdpr";
  WAZUH_MODULES_ID["GITHUB"] = "github";
})(WAZUH_MODULES_ID || (exports.WAZUH_MODULES_ID = WAZUH_MODULES_ID = {}));

;
let WAZUH_MENU_MANAGEMENT_SECTIONS_ID;
exports.WAZUH_MENU_MANAGEMENT_SECTIONS_ID = WAZUH_MENU_MANAGEMENT_SECTIONS_ID;

(function (WAZUH_MENU_MANAGEMENT_SECTIONS_ID) {
  WAZUH_MENU_MANAGEMENT_SECTIONS_ID["MANAGEMENT"] = "management";
  WAZUH_MENU_MANAGEMENT_SECTIONS_ID["ADMINISTRATION"] = "administration";
  WAZUH_MENU_MANAGEMENT_SECTIONS_ID["RULESET"] = "ruleset";
  WAZUH_MENU_MANAGEMENT_SECTIONS_ID["RULES"] = "rules";
  WAZUH_MENU_MANAGEMENT_SECTIONS_ID["DECODERS"] = "decoders";
  WAZUH_MENU_MANAGEMENT_SECTIONS_ID["CDB_LISTS"] = "lists";
  WAZUH_MENU_MANAGEMENT_SECTIONS_ID["GROUPS"] = "groups";
  WAZUH_MENU_MANAGEMENT_SECTIONS_ID["CONFIGURATION"] = "configuration";
  WAZUH_MENU_MANAGEMENT_SECTIONS_ID["STATUS_AND_REPORTS"] = "statusReports";
  WAZUH_MENU_MANAGEMENT_SECTIONS_ID["STATUS"] = "status";
  WAZUH_MENU_MANAGEMENT_SECTIONS_ID["CLUSTER"] = "monitoring";
  WAZUH_MENU_MANAGEMENT_SECTIONS_ID["LOGS"] = "logs";
  WAZUH_MENU_MANAGEMENT_SECTIONS_ID["REPORTING"] = "reporting";
  WAZUH_MENU_MANAGEMENT_SECTIONS_ID["STATISTICS"] = "statistics";
})(WAZUH_MENU_MANAGEMENT_SECTIONS_ID || (exports.WAZUH_MENU_MANAGEMENT_SECTIONS_ID = WAZUH_MENU_MANAGEMENT_SECTIONS_ID = {}));

;
let WAZUH_MENU_TOOLS_SECTIONS_ID;
exports.WAZUH_MENU_TOOLS_SECTIONS_ID = WAZUH_MENU_TOOLS_SECTIONS_ID;

(function (WAZUH_MENU_TOOLS_SECTIONS_ID) {
  WAZUH_MENU_TOOLS_SECTIONS_ID["API_CONSOLE"] = "devTools";
  WAZUH_MENU_TOOLS_SECTIONS_ID["RULESET_TEST"] = "logtest";
})(WAZUH_MENU_TOOLS_SECTIONS_ID || (exports.WAZUH_MENU_TOOLS_SECTIONS_ID = WAZUH_MENU_TOOLS_SECTIONS_ID = {}));

;
let WAZUH_MENU_SECURITY_SECTIONS_ID;
exports.WAZUH_MENU_SECURITY_SECTIONS_ID = WAZUH_MENU_SECURITY_SECTIONS_ID;

(function (WAZUH_MENU_SECURITY_SECTIONS_ID) {
  WAZUH_MENU_SECURITY_SECTIONS_ID["USERS"] = "users";
  WAZUH_MENU_SECURITY_SECTIONS_ID["ROLES"] = "roles";
  WAZUH_MENU_SECURITY_SECTIONS_ID["POLICIES"] = "policies";
  WAZUH_MENU_SECURITY_SECTIONS_ID["ROLES_MAPPING"] = "roleMapping";
})(WAZUH_MENU_SECURITY_SECTIONS_ID || (exports.WAZUH_MENU_SECURITY_SECTIONS_ID = WAZUH_MENU_SECURITY_SECTIONS_ID = {}));

;
let WAZUH_MENU_SETTINGS_SECTIONS_ID;
exports.WAZUH_MENU_SETTINGS_SECTIONS_ID = WAZUH_MENU_SETTINGS_SECTIONS_ID;

(function (WAZUH_MENU_SETTINGS_SECTIONS_ID) {
  WAZUH_MENU_SETTINGS_SECTIONS_ID["SETTINGS"] = "settings";
  WAZUH_MENU_SETTINGS_SECTIONS_ID["API_CONFIGURATION"] = "api";
  WAZUH_MENU_SETTINGS_SECTIONS_ID["MODULES"] = "modules";
  WAZUH_MENU_SETTINGS_SECTIONS_ID["SAMPLE_DATA"] = "sample_data";
  WAZUH_MENU_SETTINGS_SECTIONS_ID["CONFIGURATION"] = "configuration";
  WAZUH_MENU_SETTINGS_SECTIONS_ID["LOGS"] = "logs";
  WAZUH_MENU_SETTINGS_SECTIONS_ID["MISCELLANEOUS"] = "miscellaneous";
  WAZUH_MENU_SETTINGS_SECTIONS_ID["ABOUT"] = "about";
})(WAZUH_MENU_SETTINGS_SECTIONS_ID || (exports.WAZUH_MENU_SETTINGS_SECTIONS_ID = WAZUH_MENU_SETTINGS_SECTIONS_ID = {}));

;
const AUTHORIZED_AGENTS = 'authorized-agents'; // Wazuh links

exports.AUTHORIZED_AGENTS = AUTHORIZED_AGENTS;
const WAZUH_LINK_DOCUMENTATION = 'https://documentation.wazuh.com';
exports.WAZUH_LINK_DOCUMENTATION = WAZUH_LINK_DOCUMENTATION;
const WAZUH_LINK_GITHUB = 'https://github.com/wazuh';
exports.WAZUH_LINK_GITHUB = WAZUH_LINK_GITHUB;
const WAZUH_LINK_GOOGLE_GROUPS = 'https://groups.google.com/forum/#!forum/wazuh';
exports.WAZUH_LINK_GOOGLE_GROUPS = WAZUH_LINK_GOOGLE_GROUPS;
const WAZUH_LINK_SLACK = 'https://wazuh.com/community/join-us-on-slack';
exports.WAZUH_LINK_SLACK = WAZUH_LINK_SLACK;
const HEALTH_CHECK = 'health-check'; // Health check

exports.HEALTH_CHECK = HEALTH_CHECK;
const HEALTH_CHECK_REDIRECTION_TIME = 300; //ms
// Plugin platform settings
// Default timeFilter set by the app

exports.HEALTH_CHECK_REDIRECTION_TIME = HEALTH_CHECK_REDIRECTION_TIME;
const WAZUH_PLUGIN_PLATFORM_SETTING_TIME_FILTER = {
  from: 'now-24h',
  to: 'now'
};
exports.WAZUH_PLUGIN_PLATFORM_SETTING_TIME_FILTER = WAZUH_PLUGIN_PLATFORM_SETTING_TIME_FILTER;
const PLUGIN_PLATFORM_SETTING_NAME_TIME_FILTER = 'timepicker:timeDefaults'; // Default maxBuckets set by the app

exports.PLUGIN_PLATFORM_SETTING_NAME_TIME_FILTER = PLUGIN_PLATFORM_SETTING_NAME_TIME_FILTER;
const WAZUH_PLUGIN_PLATFORM_SETTING_MAX_BUCKETS = 200000;
exports.WAZUH_PLUGIN_PLATFORM_SETTING_MAX_BUCKETS = WAZUH_PLUGIN_PLATFORM_SETTING_MAX_BUCKETS;
const PLUGIN_PLATFORM_SETTING_NAME_MAX_BUCKETS = 'timelion:max_buckets'; // Default metaFields set by the app

exports.PLUGIN_PLATFORM_SETTING_NAME_MAX_BUCKETS = PLUGIN_PLATFORM_SETTING_NAME_MAX_BUCKETS;
const WAZUH_PLUGIN_PLATFORM_SETTING_METAFIELDS = ['_source', '_index'];
exports.WAZUH_PLUGIN_PLATFORM_SETTING_METAFIELDS = WAZUH_PLUGIN_PLATFORM_SETTING_METAFIELDS;
const PLUGIN_PLATFORM_SETTING_NAME_METAFIELDS = 'metaFields'; // Logger

exports.PLUGIN_PLATFORM_SETTING_NAME_METAFIELDS = PLUGIN_PLATFORM_SETTING_NAME_METAFIELDS;
const UI_LOGGER_LEVELS = {
  WARNING: 'WARNING',
  INFO: 'INFO',
  ERROR: 'ERROR'
};
exports.UI_LOGGER_LEVELS = UI_LOGGER_LEVELS;
const UI_TOAST_COLOR = {
  SUCCESS: 'success',
  WARNING: 'warning',
  DANGER: 'danger'
}; // Assets

exports.UI_TOAST_COLOR = UI_TOAST_COLOR;
const ASSETS_BASE_URL_PREFIX = '/plugins/wazuh/assets/'; // Reports

exports.ASSETS_BASE_URL_PREFIX = ASSETS_BASE_URL_PREFIX;
const REPORTS_LOGO_IMAGE_ASSETS_RELATIVE_PATH = 'images/logo_reports.png';
exports.REPORTS_LOGO_IMAGE_ASSETS_RELATIVE_PATH = REPORTS_LOGO_IMAGE_ASSETS_RELATIVE_PATH;
const REPORTS_PRIMARY_COLOR = '#256BD1';
exports.REPORTS_PRIMARY_COLOR = REPORTS_PRIMARY_COLOR;
const REPORTS_PAGE_FOOTER_TEXT = 'Copyright © 2022 Wazuh, Inc.';
exports.REPORTS_PAGE_FOOTER_TEXT = REPORTS_PAGE_FOOTER_TEXT;
const REPORTS_PAGE_HEADER_TEXT = 'info@wazuh.com\nhttps://wazuh.com'; // Plugin platform

exports.REPORTS_PAGE_HEADER_TEXT = REPORTS_PAGE_HEADER_TEXT;
const PLUGIN_PLATFORM_NAME = 'Kibana';
exports.PLUGIN_PLATFORM_NAME = PLUGIN_PLATFORM_NAME;
const PLUGIN_PLATFORM_BASE_INSTALLATION_PATH = '/usr/share/kibana/data/wazuh/';
exports.PLUGIN_PLATFORM_BASE_INSTALLATION_PATH = PLUGIN_PLATFORM_BASE_INSTALLATION_PATH;
const PLUGIN_PLATFORM_INSTALLATION_USER = 'kibana';
exports.PLUGIN_PLATFORM_INSTALLATION_USER = PLUGIN_PLATFORM_INSTALLATION_USER;
const PLUGIN_PLATFORM_INSTALLATION_USER_GROUP = 'kibana';
exports.PLUGIN_PLATFORM_INSTALLATION_USER_GROUP = PLUGIN_PLATFORM_INSTALLATION_USER_GROUP;
const PLUGIN_PLATFORM_WAZUH_DOCUMENTATION_URL_UPGRADE_PLATFORM = 'https://documentation.wazuh.com/current/upgrade-guide/';
exports.PLUGIN_PLATFORM_WAZUH_DOCUMENTATION_URL_UPGRADE_PLATFORM = PLUGIN_PLATFORM_WAZUH_DOCUMENTATION_URL_UPGRADE_PLATFORM;
const PLUGIN_PLATFORM_WAZUH_DOCUMENTATION_URL_TROUBLESHOOTING = 'https://documentation.wazuh.com/current/user-manual/elasticsearch/troubleshooting.html';
exports.PLUGIN_PLATFORM_WAZUH_DOCUMENTATION_URL_TROUBLESHOOTING = PLUGIN_PLATFORM_WAZUH_DOCUMENTATION_URL_TROUBLESHOOTING;
const PLUGIN_PLATFORM_WAZUH_DOCUMENTATION_URL_APP_CONFIGURATION = 'https://documentation.wazuh.com/current/user-manual/wazuh-dashboard/config-file.html';
exports.PLUGIN_PLATFORM_WAZUH_DOCUMENTATION_URL_APP_CONFIGURATION = PLUGIN_PLATFORM_WAZUH_DOCUMENTATION_URL_APP_CONFIGURATION;
const PLUGIN_PLATFORM_URL_GUIDE = 'https://www.elastic.co/guide/en/elasticsearch/reference/current/index.html';
exports.PLUGIN_PLATFORM_URL_GUIDE = PLUGIN_PLATFORM_URL_GUIDE;
const PLUGIN_PLATFORM_URL_GUIDE_TITLE = 'Elastic guide';
exports.PLUGIN_PLATFORM_URL_GUIDE_TITLE = PLUGIN_PLATFORM_URL_GUIDE_TITLE;
const PLUGIN_PLATFORM_REQUEST_HEADERS = {
  'kbn-xsrf': 'kibana'
}; // UI

exports.PLUGIN_PLATFORM_REQUEST_HEADERS = PLUGIN_PLATFORM_REQUEST_HEADERS;
const API_NAME_AGENT_STATUS = {
  ACTIVE: 'active',
  DISCONNECTED: 'disconnected',
  PENDING: 'pending',
  NEVER_CONNECTED: 'never_connected'
};
exports.API_NAME_AGENT_STATUS = API_NAME_AGENT_STATUS;
const UI_COLOR_AGENT_STATUS = {
  [API_NAME_AGENT_STATUS.ACTIVE]: '#007871',
  [API_NAME_AGENT_STATUS.DISCONNECTED]: '#BD271E',
  [API_NAME_AGENT_STATUS.PENDING]: '#FEC514',
  [API_NAME_AGENT_STATUS.NEVER_CONNECTED]: '#646A77',
  default: '#000000'
};
exports.UI_COLOR_AGENT_STATUS = UI_COLOR_AGENT_STATUS;
const UI_LABEL_NAME_AGENT_STATUS = {
  [API_NAME_AGENT_STATUS.ACTIVE]: 'Active',
  [API_NAME_AGENT_STATUS.DISCONNECTED]: 'Disconnected',
  [API_NAME_AGENT_STATUS.PENDING]: 'Pending',
  [API_NAME_AGENT_STATUS.NEVER_CONNECTED]: 'Never connected',
  default: 'Unknown'
};
exports.UI_LABEL_NAME_AGENT_STATUS = UI_LABEL_NAME_AGENT_STATUS;
const UI_ORDER_AGENT_STATUS = [API_NAME_AGENT_STATUS.ACTIVE, API_NAME_AGENT_STATUS.DISCONNECTED, API_NAME_AGENT_STATUS.PENDING, API_NAME_AGENT_STATUS.NEVER_CONNECTED];
exports.UI_ORDER_AGENT_STATUS = UI_ORDER_AGENT_STATUS;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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