"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WazuhReportingRoutes = WazuhReportingRoutes;

var _controllers = require("../controllers");

var _configSchema = require("@kbn/config-schema");

/*
 * Wazuh app - Module for Wazuh reporting routes
 * Copyright (C) 2015-2022 Wazuh, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Find more information about this on the LICENSE file.
 */
function WazuhReportingRoutes(router) {
  const ctrl = new _controllers.WazuhReportingCtrl();
  router.post({
    path: '/reports/modules/{moduleID}',
    validate: {
      body: _configSchema.schema.object({
        array: _configSchema.schema.any(),
        browserTimezone: _configSchema.schema.string(),
        filters: _configSchema.schema.maybe(_configSchema.schema.any()),
        agents: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.string(), _configSchema.schema.boolean()])),
        components: _configSchema.schema.maybe(_configSchema.schema.any()),
        name: _configSchema.schema.string(),
        searchBar: _configSchema.schema.maybe(_configSchema.schema.string()),
        section: _configSchema.schema.maybe(_configSchema.schema.string()),
        tab: _configSchema.schema.string(),
        tables: _configSchema.schema.maybe(_configSchema.schema.any()),
        time: _configSchema.schema.oneOf([_configSchema.schema.object({
          from: _configSchema.schema.string(),
          to: _configSchema.schema.string()
        }), _configSchema.schema.string()]),
        title: _configSchema.schema.maybe(_configSchema.schema.string()),
        indexPatternTitle: _configSchema.schema.string(),
        apiId: _configSchema.schema.string()
      }),
      params: _configSchema.schema.object({
        moduleID: _configSchema.schema.string()
      })
    }
  }, (context, request, response) => ctrl.createReportsModules(context, request, response));
  router.post({
    path: '/reports/groups/{groupID}',
    validate: {
      body: _configSchema.schema.object({
        browserTimezone: _configSchema.schema.string(),
        filters: _configSchema.schema.maybe(_configSchema.schema.any()),
        components: _configSchema.schema.maybe(_configSchema.schema.any()),
        name: _configSchema.schema.string(),
        section: _configSchema.schema.maybe(_configSchema.schema.string()),
        tab: _configSchema.schema.string(),
        apiId: _configSchema.schema.string()
      }),
      params: _configSchema.schema.object({
        groupID: _configSchema.schema.string()
      })
    }
  }, (context, request, response) => ctrl.createReportsGroups(context, request, response));
  router.post({
    path: '/reports/agents/{agentID}',
    validate: {
      body: _configSchema.schema.object({
        browserTimezone: _configSchema.schema.string(),
        filters: _configSchema.schema.any(),
        components: _configSchema.schema.maybe(_configSchema.schema.any()),
        name: _configSchema.schema.string(),
        section: _configSchema.schema.maybe(_configSchema.schema.string()),
        tab: _configSchema.schema.string(),
        apiId: _configSchema.schema.string()
      }),
      params: _configSchema.schema.object({
        agentID: _configSchema.schema.string()
      })
    }
  }, (context, request, response) => ctrl.createReportsAgents(context, request, response));
  router.post({
    path: '/reports/agents/{agentID}/inventory',
    validate: {
      body: _configSchema.schema.object({
        array: _configSchema.schema.any(),
        browserTimezone: _configSchema.schema.string(),
        filters: _configSchema.schema.maybe(_configSchema.schema.any()),
        agents: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.string(), _configSchema.schema.boolean()])),
        components: _configSchema.schema.maybe(_configSchema.schema.any()),
        name: _configSchema.schema.string(),
        searchBar: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.string(), _configSchema.schema.boolean()])),
        section: _configSchema.schema.maybe(_configSchema.schema.string()),
        tab: _configSchema.schema.string(),
        tables: _configSchema.schema.maybe(_configSchema.schema.any()),
        time: _configSchema.schema.oneOf([_configSchema.schema.object({
          from: _configSchema.schema.string(),
          to: _configSchema.schema.string()
        }), _configSchema.schema.string()]),
        title: _configSchema.schema.maybe(_configSchema.schema.string()),
        indexPatternTitle: _configSchema.schema.string(),
        apiId: _configSchema.schema.string()
      }),
      params: _configSchema.schema.object({
        agentID: _configSchema.schema.string()
      })
    }
  }, (context, request, response) => ctrl.createReportsAgentsInventory(context, request, response)); // Fetch specific report

  router.get({
    path: '/reports/{name}',
    validate: {
      params: _configSchema.schema.object({
        name: _configSchema.schema.string()
      })
    }
  }, (context, request, response) => ctrl.getReportByName(context, request, response)); // Delete specific report

  router.delete({
    path: '/reports/{name}',
    validate: {
      params: _configSchema.schema.object({
        name: _configSchema.schema.string()
      })
    }
  }, (context, request, response) => ctrl.deleteReportByName(context, request, response)); // Fetch the reports list

  router.get({
    path: '/reports',
    validate: false
  }, (context, request, response) => ctrl.getReports(context, request, response));
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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