"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WAZUH_STATISTICS_PATTERN = exports.WAZUH_STATISTICS_DEFAULT_STATUS = exports.WAZUH_STATISTICS_DEFAULT_PREFIX = exports.WAZUH_STATISTICS_DEFAULT_NAME = exports.WAZUH_STATISTICS_DEFAULT_INDICES_SHARDS = exports.WAZUH_STATISTICS_DEFAULT_INDICES_REPLICAS = exports.WAZUH_STATISTICS_DEFAULT_FREQUENCY = exports.WAZUH_STATISTICS_DEFAULT_CRON_FREQ = exports.WAZUH_STATISTICS_DEFAULT_CREATION = exports.WAZUH_SECURITY_PLUGIN_XPACK_SECURITY = exports.WAZUH_SECURITY_PLUGIN_OPEN_DISTRO_FOR_ELASTICSEARCH = exports.WAZUH_SECURITY_PLUGINS = exports.WAZUH_SAMPLE_ALERT_PREFIX = exports.WAZUH_SAMPLE_ALERTS_INDEX_SHARDS = exports.WAZUH_SAMPLE_ALERTS_INDEX_REPLICAS = exports.WAZUH_SAMPLE_ALERTS_DEFAULT_NUMBER_ALERTS = exports.WAZUH_SAMPLE_ALERTS_CATEGORY_THREAT_DETECTION = exports.WAZUH_SAMPLE_ALERTS_CATEGORY_SECURITY = exports.WAZUH_SAMPLE_ALERTS_CATEGORY_AUDITING_POLICY_MONITORING = exports.WAZUH_SAMPLE_ALERTS_CATEGORIES_TYPE_ALERTS = exports.WAZUH_ROLE_ADMINISTRATOR_NAME = exports.WAZUH_ROLE_ADMINISTRATOR_ID = exports.WAZUH_QUEUE_CRON_FREQ = exports.WAZUH_PLUGIN_PLATFORM_TEMPLATE_NAME = exports.WAZUH_PLUGIN_PLATFORM_SETTING_TIME_FILTER = exports.WAZUH_PLUGIN_PLATFORM_SETTING_METAFIELDS = exports.WAZUH_PLUGIN_PLATFORM_SETTING_MAX_BUCKETS = exports.WAZUH_MONITORING_TEMPLATE_NAME = exports.WAZUH_MONITORING_PREFIX = exports.WAZUH_MONITORING_PATTERN = exports.WAZUH_MONITORING_DEFAULT_INDICES_SHARDS = exports.WAZUH_MONITORING_DEFAULT_INDICES_REPLICAS = exports.WAZUH_MONITORING_DEFAULT_FREQUENCY = exports.WAZUH_MONITORING_DEFAULT_ENABLED = exports.WAZUH_MONITORING_DEFAULT_CRON_FREQ = exports.WAZUH_MONITORING_DEFAULT_CREATION = exports.WAZUH_MODULES_ID = exports.WAZUH_MENU_TOOLS_SECTIONS_ID = exports.WAZUH_MENU_SETTINGS_SECTIONS_ID = exports.WAZUH_MENU_SECURITY_SECTIONS_ID = exports.WAZUH_MENU_MANAGEMENT_SECTIONS_ID = exports.WAZUH_LINK_SLACK = exports.WAZUH_LINK_GOOGLE_GROUPS = exports.WAZUH_LINK_GITHUB = exports.WAZUH_INDEX_TYPE_STATISTICS = exports.WAZUH_INDEX_TYPE_MONITORING = exports.WAZUH_INDEX_TYPE_ALERTS = exports.WAZUH_ERROR_DAEMONS_NOT_READY = exports.WAZUH_DEFAULT_APP_CONFIG = exports.WAZUH_DATA_PLUGIN_PLATFORM_BASE_ABSOLUTE_PATH = exports.WAZUH_DATA_LOGS_RAW_PATH = exports.WAZUH_DATA_LOGS_RAW_FILENAME = exports.WAZUH_DATA_LOGS_PLAIN_PATH = exports.WAZUH_DATA_LOGS_PLAIN_FILENAME = exports.WAZUH_DATA_LOGS_DIRECTORY_PATH = exports.WAZUH_DATA_DOWNLOADS_REPORTS_DIRECTORY_PATH = exports.WAZUH_DATA_DOWNLOADS_DIRECTORY_PATH = exports.WAZUH_DATA_CONFIG_REGISTRY_PATH = exports.WAZUH_DATA_CONFIG_DIRECTORY_PATH = exports.WAZUH_DATA_CONFIG_APP_PATH = exports.WAZUH_DATA_ABSOLUTE_PATH = exports.WAZUH_CONFIGURATION_SETTINGS_NEED_RESTART = exports.WAZUH_CONFIGURATION_SETTINGS_NEED_RELOAD = exports.WAZUH_CONFIGURATION_SETTINGS_NEED_HEALTH_CHECK = exports.WAZUH_CONFIGURATION_CACHE_TIME = exports.WAZUH_API_RESERVED_ID_LOWER_THAN = exports.WAZUH_ALERTS_PREFIX = exports.WAZUH_ALERTS_PATTERN = exports.WAZUH_AGENTS_OS_TYPE = exports.UI_TOAST_COLOR = exports.UI_ORDER_AGENT_STATUS = exports.UI_LOGGER_LEVELS = exports.UI_LABEL_NAME_AGENT_STATUS = exports.UI_COLOR_AGENT_STATUS = exports.REPORTS_PRIMARY_COLOR = exports.REPORTS_PAGE_HEADER_TEXT = exports.REPORTS_PAGE_FOOTER_TEXT = exports.REPORTS_LOGO_IMAGE_ASSETS_RELATIVE_PATH = exports.PLUGIN_VERSION_SHORT = exports.PLUGIN_VERSION = exports.PLUGIN_PLATFORM_WAZUH_DOCUMENTATION_URL_PATH_UPGRADE_PLATFORM = exports.PLUGIN_PLATFORM_WAZUH_DOCUMENTATION_URL_PATH_TROUBLESHOOTING = exports.PLUGIN_PLATFORM_WAZUH_DOCUMENTATION_URL_PATH_APP_CONFIGURATION = exports.PLUGIN_PLATFORM_URL_GUIDE_TITLE = exports.PLUGIN_PLATFORM_URL_GUIDE = exports.PLUGIN_PLATFORM_SETTING_NAME_TIME_FILTER = exports.PLUGIN_PLATFORM_SETTING_NAME_METAFIELDS = exports.PLUGIN_PLATFORM_SETTING_NAME_MAX_BUCKETS = exports.PLUGIN_PLATFORM_REQUEST_HEADERS = exports.PLUGIN_PLATFORM_NAME = exports.PLUGIN_PLATFORM_INSTALLATION_USER_GROUP = exports.PLUGIN_PLATFORM_INSTALLATION_USER = exports.PLUGIN_PLATFORM_BASE_INSTALLATION_PATH = exports.MAX_MB_LOG_FILES = exports.HEALTH_CHECK_REDIRECTION_TIME = exports.HEALTH_CHECK = exports.DOCUMENTATION_WEB_BASE_URL = exports.AUTHORIZED_AGENTS = exports.ASSETS_BASE_URL_PREFIX = exports.API_NAME_AGENT_STATUS = void 0;
exports.WAZUH_UI_LOGS_RAW_PATH = exports.WAZUH_UI_LOGS_RAW_FILENAME = exports.WAZUH_UI_LOGS_PLAIN_PATH = exports.WAZUH_UI_LOGS_PLAIN_FILENAME = exports.WAZUH_STATISTICS_TEMPLATE_NAME = exports.WAZUH_STATISTICS_PATTERN = exports.WAZUH_STATISTICS_DEFAULT_STATUS = exports.WAZUH_STATISTICS_DEFAULT_PREFIX = exports.WAZUH_STATISTICS_DEFAULT_NAME = exports.WAZUH_STATISTICS_DEFAULT_INDICES_SHARDS = exports.WAZUH_STATISTICS_DEFAULT_INDICES_REPLICAS = exports.WAZUH_STATISTICS_DEFAULT_FREQUENCY = exports.WAZUH_STATISTICS_DEFAULT_CRON_FREQ = exports.WAZUH_STATISTICS_DEFAULT_CREATION = exports.WAZUH_SECURITY_PLUGIN_XPACK_SECURITY = exports.WAZUH_SECURITY_PLUGIN_OPEN_DISTRO_FOR_ELASTICSEARCH = exports.WAZUH_SECURITY_PLUGINS = exports.WAZUH_SAMPLE_ALERT_PREFIX = exports.WAZUH_SAMPLE_ALERTS_INDEX_SHARDS = exports.WAZUH_SAMPLE_ALERTS_INDEX_REPLICAS = exports.WAZUH_SAMPLE_ALERTS_DEFAULT_NUMBER_ALERTS = exports.WAZUH_SAMPLE_ALERTS_CATEGORY_THREAT_DETECTION = exports.WAZUH_SAMPLE_ALERTS_CATEGORY_SECURITY = exports.WAZUH_SAMPLE_ALERTS_CATEGORY_AUDITING_POLICY_MONITORING = exports.WAZUH_SAMPLE_ALERTS_CATEGORIES_TYPE_ALERTS = exports.WAZUH_ROLE_ADMINISTRATOR_NAME = exports.WAZUH_ROLE_ADMINISTRATOR_ID = exports.WAZUH_QUEUE_CRON_FREQ = exports.WAZUH_PLUGIN_PLATFORM_TEMPLATE_NAME = exports.WAZUH_PLUGIN_PLATFORM_SETTING_TIME_FILTER = exports.WAZUH_PLUGIN_PLATFORM_SETTING_METAFIELDS = exports.WAZUH_PLUGIN_PLATFORM_SETTING_MAX_BUCKETS = exports.WAZUH_MONITORING_TEMPLATE_NAME = exports.WAZUH_MONITORING_PREFIX = exports.WAZUH_MONITORING_PATTERN = exports.WAZUH_MONITORING_DEFAULT_INDICES_SHARDS = exports.WAZUH_MONITORING_DEFAULT_INDICES_REPLICAS = exports.WAZUH_MONITORING_DEFAULT_FREQUENCY = exports.WAZUH_MONITORING_DEFAULT_ENABLED = exports.WAZUH_MONITORING_DEFAULT_CRON_FREQ = exports.WAZUH_MONITORING_DEFAULT_CREATION = exports.WAZUH_MODULES_ID = exports.WAZUH_MENU_TOOLS_SECTIONS_ID = exports.WAZUH_MENU_SETTINGS_SECTIONS_ID = exports.WAZUH_MENU_SECURITY_SECTIONS_ID = exports.WAZUH_MENU_MANAGEMENT_SECTIONS_ID = exports.WAZUH_LINK_SLACK = exports.WAZUH_LINK_GOOGLE_GROUPS = exports.WAZUH_LINK_GITHUB = exports.WAZUH_INDEX_TYPE_STATISTICS = exports.WAZUH_INDEX_TYPE_MONITORING = exports.WAZUH_INDEX_TYPE_ALERTS = exports.WAZUH_ERROR_DAEMONS_NOT_READY = exports.WAZUH_DEFAULT_APP_CONFIG = exports.WAZUH_DATA_PLUGIN_PLATFORM_BASE_ABSOLUTE_PATH = exports.WAZUH_DATA_LOGS_RAW_PATH = exports.WAZUH_DATA_LOGS_RAW_FILENAME = exports.WAZUH_DATA_LOGS_PLAIN_PATH = exports.WAZUH_DATA_LOGS_PLAIN_FILENAME = exports.WAZUH_DATA_LOGS_DIRECTORY_PATH = exports.WAZUH_DATA_DOWNLOADS_REPORTS_DIRECTORY_PATH = exports.WAZUH_DATA_DOWNLOADS_DIRECTORY_PATH = exports.WAZUH_DATA_CONFIG_REGISTRY_PATH = exports.WAZUH_DATA_CONFIG_DIRECTORY_PATH = exports.WAZUH_DATA_CONFIG_APP_PATH = exports.WAZUH_DATA_ABSOLUTE_PATH = exports.WAZUH_CONFIGURATION_SETTINGS_NEED_RESTART = exports.WAZUH_CONFIGURATION_SETTINGS_NEED_RELOAD = exports.WAZUH_CONFIGURATION_SETTINGS_NEED_HEALTH_CHECK = exports.WAZUH_CONFIGURATION_CACHE_TIME = exports.WAZUH_API_RESERVED_ID_LOWER_THAN = exports.WAZUH_ALERTS_PREFIX = exports.WAZUH_ALERTS_PATTERN = exports.WAZUH_AGENTS_OS_TYPE = exports.UI_TOAST_COLOR = exports.UI_ORDER_AGENT_STATUS = exports.UI_LOGGER_LEVELS = exports.UI_LABEL_NAME_AGENT_STATUS = exports.UI_COLOR_AGENT_STATUS = exports.REPORTS_PRIMARY_COLOR = exports.REPORTS_PAGE_HEADER_TEXT = exports.REPORTS_PAGE_FOOTER_TEXT = exports.REPORTS_LOGO_IMAGE_ASSETS_RELATIVE_PATH = exports.PLUGIN_VERSION_SHORT = exports.PLUGIN_VERSION = exports.PLUGIN_PLATFORM_WAZUH_DOCUMENTATION_URL_PATH_UPGRADE_PLATFORM = exports.PLUGIN_PLATFORM_WAZUH_DOCUMENTATION_URL_PATH_TROUBLESHOOTING = exports.PLUGIN_PLATFORM_WAZUH_DOCUMENTATION_URL_PATH_APP_CONFIGURATION = exports.PLUGIN_PLATFORM_URL_GUIDE_TITLE = exports.PLUGIN_PLATFORM_URL_GUIDE = exports.PLUGIN_PLATFORM_SETTING_NAME_TIME_FILTER = exports.PLUGIN_PLATFORM_SETTING_NAME_METAFIELDS = exports.PLUGIN_PLATFORM_SETTING_NAME_MAX_BUCKETS = exports.PLUGIN_PLATFORM_REQUEST_HEADERS = exports.PLUGIN_PLATFORM_NAME = exports.PLUGIN_PLATFORM_INSTALLATION_USER_GROUP = exports.PLUGIN_PLATFORM_INSTALLATION_USER = exports.PLUGIN_PLATFORM_BASE_INSTALLATION_PATH = exports.MAX_MB_LOG_FILES = exports.HEALTH_CHECK_REDIRECTION_TIME = exports.HEALTH_CHECK = exports.DOCUMENTATION_WEB_BASE_URL = exports.AUTHORIZED_AGENTS = exports.ASSETS_BASE_URL_PREFIX = exports.API_NAME_AGENT_STATUS = void 0;

var _path = _interopRequireDefault(require("path"));

var _package = require("../package.json");

/*
 * Wazuh app - Wazuh Constants file
 * Copyright (C) 2015-2022 Wazuh, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Find more information about this on the LICENSE file.
 */
// Plugin
const PLUGIN_VERSION = _package.version;
exports.PLUGIN_VERSION = PLUGIN_VERSION;

const PLUGIN_VERSION_SHORT = _package.version.split('.').splice(0, 2).join('.'); // Index patterns - Wazuh alerts


exports.PLUGIN_VERSION_SHORT = PLUGIN_VERSION_SHORT;
const WAZUH_INDEX_TYPE_ALERTS = 'alerts';
exports.WAZUH_INDEX_TYPE_ALERTS = WAZUH_INDEX_TYPE_ALERTS;
const WAZUH_ALERTS_PREFIX = 'wazuh-alerts-';
exports.WAZUH_ALERTS_PREFIX = WAZUH_ALERTS_PREFIX;
const WAZUH_ALERTS_PATTERN = 'wazuh-alerts-*'; // Job - Wazuh monitoring

exports.WAZUH_ALERTS_PATTERN = WAZUH_ALERTS_PATTERN;
const WAZUH_INDEX_TYPE_MONITORING = "monitoring";
exports.WAZUH_INDEX_TYPE_MONITORING = WAZUH_INDEX_TYPE_MONITORING;
const WAZUH_MONITORING_PREFIX = "wazuh-monitoring-";
exports.WAZUH_MONITORING_PREFIX = WAZUH_MONITORING_PREFIX;
const WAZUH_MONITORING_PATTERN = "wazuh-monitoring-*";
exports.WAZUH_MONITORING_PATTERN = WAZUH_MONITORING_PATTERN;
const WAZUH_MONITORING_TEMPLATE_NAME = "wazuh-agent";
exports.WAZUH_MONITORING_TEMPLATE_NAME = WAZUH_MONITORING_TEMPLATE_NAME;
const WAZUH_MONITORING_DEFAULT_INDICES_SHARDS = 1;
exports.WAZUH_MONITORING_DEFAULT_INDICES_SHARDS = WAZUH_MONITORING_DEFAULT_INDICES_SHARDS;
const WAZUH_MONITORING_DEFAULT_INDICES_REPLICAS = 0;
exports.WAZUH_MONITORING_DEFAULT_INDICES_REPLICAS = WAZUH_MONITORING_DEFAULT_INDICES_REPLICAS;
const WAZUH_MONITORING_DEFAULT_CREATION = 'w';
exports.WAZUH_MONITORING_DEFAULT_CREATION = WAZUH_MONITORING_DEFAULT_CREATION;
const WAZUH_MONITORING_DEFAULT_ENABLED = true;
exports.WAZUH_MONITORING_DEFAULT_ENABLED = WAZUH_MONITORING_DEFAULT_ENABLED;
const WAZUH_MONITORING_DEFAULT_FREQUENCY = 900;
exports.WAZUH_MONITORING_DEFAULT_FREQUENCY = WAZUH_MONITORING_DEFAULT_FREQUENCY;
const WAZUH_MONITORING_DEFAULT_CRON_FREQ = '0 * * * * *'; // Job - Wazuh statistics

exports.WAZUH_MONITORING_DEFAULT_CRON_FREQ = WAZUH_MONITORING_DEFAULT_CRON_FREQ;
const WAZUH_INDEX_TYPE_STATISTICS = "statistics";
exports.WAZUH_INDEX_TYPE_STATISTICS = WAZUH_INDEX_TYPE_STATISTICS;
const WAZUH_STATISTICS_DEFAULT_PREFIX = "wazuh";
exports.WAZUH_STATISTICS_DEFAULT_PREFIX = WAZUH_STATISTICS_DEFAULT_PREFIX;
const WAZUH_STATISTICS_DEFAULT_NAME = "statistics";
exports.WAZUH_STATISTICS_DEFAULT_NAME = WAZUH_STATISTICS_DEFAULT_NAME;
const WAZUH_STATISTICS_PATTERN = `${WAZUH_STATISTICS_DEFAULT_PREFIX}-${WAZUH_STATISTICS_DEFAULT_NAME}-*`;
exports.WAZUH_STATISTICS_PATTERN = WAZUH_STATISTICS_PATTERN;
const WAZUH_STATISTICS_TEMPLATE_NAME = `${WAZUH_STATISTICS_DEFAULT_PREFIX}-${WAZUH_STATISTICS_DEFAULT_NAME}`;
exports.WAZUH_STATISTICS_TEMPLATE_NAME = WAZUH_STATISTICS_TEMPLATE_NAME;
const WAZUH_STATISTICS_DEFAULT_INDICES_SHARDS = 1;
exports.WAZUH_STATISTICS_DEFAULT_INDICES_SHARDS = WAZUH_STATISTICS_DEFAULT_INDICES_SHARDS;
const WAZUH_STATISTICS_DEFAULT_INDICES_REPLICAS = 0;
exports.WAZUH_STATISTICS_DEFAULT_INDICES_REPLICAS = WAZUH_STATISTICS_DEFAULT_INDICES_REPLICAS;
const WAZUH_STATISTICS_DEFAULT_CREATION = 'w';
exports.WAZUH_STATISTICS_DEFAULT_CREATION = WAZUH_STATISTICS_DEFAULT_CREATION;
const WAZUH_STATISTICS_DEFAULT_STATUS = true;
exports.WAZUH_STATISTICS_DEFAULT_STATUS = WAZUH_STATISTICS_DEFAULT_STATUS;
const WAZUH_STATISTICS_DEFAULT_FREQUENCY = 900;
exports.WAZUH_STATISTICS_DEFAULT_FREQUENCY = WAZUH_STATISTICS_DEFAULT_FREQUENCY;
const WAZUH_STATISTICS_DEFAULT_CRON_FREQ = '0 */5 * * * *'; // Job - Wazuh initialize

exports.WAZUH_STATISTICS_DEFAULT_CRON_FREQ = WAZUH_STATISTICS_DEFAULT_CRON_FREQ;
const WAZUH_PLUGIN_PLATFORM_TEMPLATE_NAME = 'wazuh-kibana'; // Permissions

exports.WAZUH_PLUGIN_PLATFORM_TEMPLATE_NAME = WAZUH_PLUGIN_PLATFORM_TEMPLATE_NAME;
const WAZUH_ROLE_ADMINISTRATOR_ID = 1;
exports.WAZUH_ROLE_ADMINISTRATOR_ID = WAZUH_ROLE_ADMINISTRATOR_ID;
const WAZUH_ROLE_ADMINISTRATOR_NAME = 'administrator'; // Sample data

exports.WAZUH_ROLE_ADMINISTRATOR_NAME = WAZUH_ROLE_ADMINISTRATOR_NAME;
const WAZUH_SAMPLE_ALERT_PREFIX = 'wazuh-alerts-4.x-';
exports.WAZUH_SAMPLE_ALERT_PREFIX = WAZUH_SAMPLE_ALERT_PREFIX;
const WAZUH_SAMPLE_ALERTS_INDEX_SHARDS = 1;
exports.WAZUH_SAMPLE_ALERTS_INDEX_SHARDS = WAZUH_SAMPLE_ALERTS_INDEX_SHARDS;
const WAZUH_SAMPLE_ALERTS_INDEX_REPLICAS = 0;
exports.WAZUH_SAMPLE_ALERTS_INDEX_REPLICAS = WAZUH_SAMPLE_ALERTS_INDEX_REPLICAS;
const WAZUH_SAMPLE_ALERTS_CATEGORY_SECURITY = 'security';
exports.WAZUH_SAMPLE_ALERTS_CATEGORY_SECURITY = WAZUH_SAMPLE_ALERTS_CATEGORY_SECURITY;
const WAZUH_SAMPLE_ALERTS_CATEGORY_AUDITING_POLICY_MONITORING = 'auditing-policy-monitoring';
exports.WAZUH_SAMPLE_ALERTS_CATEGORY_AUDITING_POLICY_MONITORING = WAZUH_SAMPLE_ALERTS_CATEGORY_AUDITING_POLICY_MONITORING;
const WAZUH_SAMPLE_ALERTS_CATEGORY_THREAT_DETECTION = 'threat-detection';
exports.WAZUH_SAMPLE_ALERTS_CATEGORY_THREAT_DETECTION = WAZUH_SAMPLE_ALERTS_CATEGORY_THREAT_DETECTION;
const WAZUH_SAMPLE_ALERTS_DEFAULT_NUMBER_ALERTS = 3000;
exports.WAZUH_SAMPLE_ALERTS_DEFAULT_NUMBER_ALERTS = WAZUH_SAMPLE_ALERTS_DEFAULT_NUMBER_ALERTS;
const WAZUH_SAMPLE_ALERTS_CATEGORIES_TYPE_ALERTS = {
  [WAZUH_SAMPLE_ALERTS_CATEGORY_SECURITY]: [{
    syscheck: true
  }, {
    aws: true
  }, {
    office: true
  }, {
    gcp: true
  }, {
    authentication: true
  }, {
    ssh: true
  }, {
    apache: true,
    alerts: 2000
  }, {
    web: true
  }, {
    windows: {
      service_control_manager: true
    },
    alerts: 1000
  }, {
    github: true
  }],
  [WAZUH_SAMPLE_ALERTS_CATEGORY_AUDITING_POLICY_MONITORING]: [{
    rootcheck: true
  }, {
    audit: true
  }, {
    openscap: true
  }, {
    ciscat: true
  }],
  [WAZUH_SAMPLE_ALERTS_CATEGORY_THREAT_DETECTION]: [{
    vulnerabilities: true
  }, {
    virustotal: true
  }, {
    osquery: true
  }, {
    docker: true
  }, {
    mitre: true
  }]
}; // Security

exports.WAZUH_SAMPLE_ALERTS_CATEGORIES_TYPE_ALERTS = WAZUH_SAMPLE_ALERTS_CATEGORIES_TYPE_ALERTS;
const WAZUH_SECURITY_PLUGIN_XPACK_SECURITY = 'X-Pack Security';
exports.WAZUH_SECURITY_PLUGIN_XPACK_SECURITY = WAZUH_SECURITY_PLUGIN_XPACK_SECURITY;
const WAZUH_SECURITY_PLUGIN_OPEN_DISTRO_FOR_ELASTICSEARCH = 'Open Distro for Elasticsearch';
exports.WAZUH_SECURITY_PLUGIN_OPEN_DISTRO_FOR_ELASTICSEARCH = WAZUH_SECURITY_PLUGIN_OPEN_DISTRO_FOR_ELASTICSEARCH;
const WAZUH_SECURITY_PLUGINS = [WAZUH_SECURITY_PLUGIN_XPACK_SECURITY, WAZUH_SECURITY_PLUGIN_OPEN_DISTRO_FOR_ELASTICSEARCH]; // App configuration

exports.WAZUH_SECURITY_PLUGINS = WAZUH_SECURITY_PLUGINS;
const WAZUH_CONFIGURATION_CACHE_TIME = 10000; // time in ms;

exports.WAZUH_CONFIGURATION_CACHE_TIME = WAZUH_CONFIGURATION_CACHE_TIME;
const WAZUH_CONFIGURATION_SETTINGS_NEED_RESTART = ['wazuh.monitoring.enabled', 'wazuh.monitoring.frequency', 'cron.statistics.interval', 'logs.level'];
exports.WAZUH_CONFIGURATION_SETTINGS_NEED_RESTART = WAZUH_CONFIGURATION_SETTINGS_NEED_RESTART;
const WAZUH_CONFIGURATION_SETTINGS_NEED_HEALTH_CHECK = ['pattern', 'wazuh.monitoring.replicas', 'wazuh.monitoring.creation', 'wazuh.monitoring.pattern', 'alerts.sample.prefix', 'cron.statistics.index.name', 'cron.statistics.index.creation', 'cron.statistics.index.shards', 'cron.statistics.index.replicas', 'wazuh.monitoring.shards'];
exports.WAZUH_CONFIGURATION_SETTINGS_NEED_HEALTH_CHECK = WAZUH_CONFIGURATION_SETTINGS_NEED_HEALTH_CHECK;
const WAZUH_CONFIGURATION_SETTINGS_NEED_RELOAD = ['hideManagerAlerts', 'customization.logo.sidebar']; // Reserved ids for Users/Role mapping

exports.WAZUH_CONFIGURATION_SETTINGS_NEED_RELOAD = WAZUH_CONFIGURATION_SETTINGS_NEED_RELOAD;
const WAZUH_API_RESERVED_ID_LOWER_THAN = 100; // Wazuh data path

exports.WAZUH_API_RESERVED_ID_LOWER_THAN = WAZUH_API_RESERVED_ID_LOWER_THAN;
const WAZUH_DATA_PLUGIN_PLATFORM_BASE_PATH = 'data';

const WAZUH_DATA_PLUGIN_PLATFORM_BASE_ABSOLUTE_PATH = _path.default.join(__dirname, '../../../', WAZUH_DATA_PLUGIN_PLATFORM_BASE_PATH);

exports.WAZUH_DATA_PLUGIN_PLATFORM_BASE_ABSOLUTE_PATH = WAZUH_DATA_PLUGIN_PLATFORM_BASE_ABSOLUTE_PATH;

const WAZUH_DATA_ABSOLUTE_PATH = _path.default.join(WAZUH_DATA_PLUGIN_PLATFORM_BASE_ABSOLUTE_PATH, 'wazuh'); // Wazuh data path - config


exports.WAZUH_DATA_ABSOLUTE_PATH = WAZUH_DATA_ABSOLUTE_PATH;

const WAZUH_DATA_CONFIG_DIRECTORY_PATH = _path.default.join(WAZUH_DATA_ABSOLUTE_PATH, 'config');

exports.WAZUH_DATA_CONFIG_DIRECTORY_PATH = WAZUH_DATA_CONFIG_DIRECTORY_PATH;

const WAZUH_DATA_CONFIG_APP_PATH = _path.default.join(WAZUH_DATA_CONFIG_DIRECTORY_PATH, 'wazuh.yml');

exports.WAZUH_DATA_CONFIG_APP_PATH = WAZUH_DATA_CONFIG_APP_PATH;

const WAZUH_DATA_CONFIG_REGISTRY_PATH = _path.default.join(WAZUH_DATA_CONFIG_DIRECTORY_PATH, 'wazuh-registry.json'); // Wazuh data path - logs


exports.WAZUH_DATA_CONFIG_REGISTRY_PATH = WAZUH_DATA_CONFIG_REGISTRY_PATH;
const MAX_MB_LOG_FILES = 100;
exports.MAX_MB_LOG_FILES = MAX_MB_LOG_FILES;

const WAZUH_DATA_LOGS_DIRECTORY_PATH = _path.default.join(WAZUH_DATA_ABSOLUTE_PATH, 'logs');

exports.WAZUH_DATA_LOGS_DIRECTORY_PATH = WAZUH_DATA_LOGS_DIRECTORY_PATH;
const WAZUH_DATA_LOGS_PLAIN_FILENAME = 'wazuhapp-plain.log';
exports.WAZUH_DATA_LOGS_PLAIN_FILENAME = WAZUH_DATA_LOGS_PLAIN_FILENAME;

const WAZUH_DATA_LOGS_PLAIN_PATH = _path.default.join(WAZUH_DATA_LOGS_DIRECTORY_PATH, WAZUH_DATA_LOGS_PLAIN_FILENAME);

exports.WAZUH_DATA_LOGS_PLAIN_PATH = WAZUH_DATA_LOGS_PLAIN_PATH;
const WAZUH_DATA_LOGS_RAW_FILENAME = 'wazuhapp.log';
exports.WAZUH_DATA_LOGS_RAW_FILENAME = WAZUH_DATA_LOGS_RAW_FILENAME;

const WAZUH_DATA_LOGS_RAW_PATH = _path.default.join(WAZUH_DATA_LOGS_DIRECTORY_PATH, WAZUH_DATA_LOGS_RAW_FILENAME); // Wazuh data path - UI logs


exports.WAZUH_DATA_LOGS_RAW_PATH = WAZUH_DATA_LOGS_RAW_PATH;
const WAZUH_UI_LOGS_PLAIN_FILENAME = 'wazuh-ui-plain.log';
exports.WAZUH_UI_LOGS_PLAIN_FILENAME = WAZUH_UI_LOGS_PLAIN_FILENAME;
const WAZUH_UI_LOGS_RAW_FILENAME = 'wazuh-ui.log';
exports.WAZUH_UI_LOGS_RAW_FILENAME = WAZUH_UI_LOGS_RAW_FILENAME;

const WAZUH_UI_LOGS_PLAIN_PATH = _path.default.join(WAZUH_DATA_LOGS_DIRECTORY_PATH, WAZUH_UI_LOGS_PLAIN_FILENAME);

exports.WAZUH_UI_LOGS_PLAIN_PATH = WAZUH_UI_LOGS_PLAIN_PATH;

const WAZUH_UI_LOGS_RAW_PATH = _path.default.join(WAZUH_DATA_LOGS_DIRECTORY_PATH, WAZUH_UI_LOGS_RAW_FILENAME); // Wazuh data path - downloads


exports.WAZUH_UI_LOGS_RAW_PATH = WAZUH_UI_LOGS_RAW_PATH;

const WAZUH_DATA_DOWNLOADS_DIRECTORY_PATH = _path.default.join(WAZUH_DATA_ABSOLUTE_PATH, 'downloads');

exports.WAZUH_DATA_DOWNLOADS_DIRECTORY_PATH = WAZUH_DATA_DOWNLOADS_DIRECTORY_PATH;

const WAZUH_DATA_DOWNLOADS_REPORTS_DIRECTORY_PATH = _path.default.join(WAZUH_DATA_DOWNLOADS_DIRECTORY_PATH, 'reports'); // Queue


exports.WAZUH_DATA_DOWNLOADS_REPORTS_DIRECTORY_PATH = WAZUH_DATA_DOWNLOADS_REPORTS_DIRECTORY_PATH;
const WAZUH_QUEUE_CRON_FREQ = '*/15 * * * * *'; // Every 15 seconds
// Default App Config

exports.WAZUH_QUEUE_CRON_FREQ = WAZUH_QUEUE_CRON_FREQ;
const WAZUH_DEFAULT_APP_CONFIG = {
  pattern: WAZUH_ALERTS_PATTERN,
  'checks.pattern': true,
  'checks.template': true,
  'checks.api': true,
  'checks.setup': true,
  'checks.fields': true,
  'checks.metaFields': true,
  'checks.maxBuckets': true,
  'checks.timeFilter': true,
  'extensions.pci': true,
  'extensions.gdpr': true,
  'extensions.hipaa': true,
  'extensions.nist': true,
  'extensions.tsc': true,
  'extensions.audit': true,
  'extensions.oscap': false,
  'extensions.ciscat': false,
  'extensions.aws': false,
  'extensions.office': false,
  'extensions.github': false,
  'extensions.gcp': false,
  'extensions.virustotal': false,
  'extensions.osquery': false,
  'extensions.docker': false,
  timeout: 20000,
  'ip.selector': true,
  'ip.ignore': [],
  'xpack.rbac.enabled': true,
  'wazuh.monitoring.enabled': WAZUH_MONITORING_DEFAULT_ENABLED,
  'wazuh.monitoring.frequency': WAZUH_MONITORING_DEFAULT_FREQUENCY,
  'wazuh.monitoring.shards': WAZUH_MONITORING_DEFAULT_INDICES_SHARDS,
  'wazuh.monitoring.replicas': WAZUH_MONITORING_DEFAULT_INDICES_REPLICAS,
  'wazuh.monitoring.creation': WAZUH_MONITORING_DEFAULT_CREATION,
  'wazuh.monitoring.pattern': WAZUH_MONITORING_PATTERN,
  'cron.prefix': WAZUH_STATISTICS_DEFAULT_PREFIX,
  'cron.statistics.status': WAZUH_STATISTICS_DEFAULT_STATUS,
  'cron.statistics.apis': [],
  'cron.statistics.interval': WAZUH_STATISTICS_DEFAULT_CRON_FREQ,
  'cron.statistics.index.name': WAZUH_STATISTICS_DEFAULT_NAME,
  'cron.statistics.index.creation': WAZUH_STATISTICS_DEFAULT_CREATION,
  'cron.statistics.index.shards': WAZUH_STATISTICS_DEFAULT_INDICES_SHARDS,
  'cron.statistics.index.replicas': WAZUH_STATISTICS_DEFAULT_INDICES_REPLICAS,
  'alerts.sample.prefix': WAZUH_SAMPLE_ALERT_PREFIX,
  hideManagerAlerts: false,
  'logs.level': 'info',
  'enrollment.dns': '',
  'customization.logo.app': '',
  'customization.logo.sidebar': '',
  'customization.logo.healthcheck': '',
  'customization.logo.reports': ''
}; // Wazuh errors

exports.WAZUH_DEFAULT_APP_CONFIG = WAZUH_DEFAULT_APP_CONFIG;
const WAZUH_ERROR_DAEMONS_NOT_READY = 'ERROR3099'; // Agents

exports.WAZUH_ERROR_DAEMONS_NOT_READY = WAZUH_ERROR_DAEMONS_NOT_READY;
let WAZUH_AGENTS_OS_TYPE;
exports.WAZUH_AGENTS_OS_TYPE = WAZUH_AGENTS_OS_TYPE;

(function (WAZUH_AGENTS_OS_TYPE) {
  WAZUH_AGENTS_OS_TYPE["WINDOWS"] = "windows";
  WAZUH_AGENTS_OS_TYPE["LINUX"] = "linux";
  WAZUH_AGENTS_OS_TYPE["SUNOS"] = "sunos";
  WAZUH_AGENTS_OS_TYPE["DARWIN"] = "darwin";
  WAZUH_AGENTS_OS_TYPE["OTHERS"] = "";
})(WAZUH_AGENTS_OS_TYPE || (exports.WAZUH_AGENTS_OS_TYPE = WAZUH_AGENTS_OS_TYPE = {}));

let WAZUH_MODULES_ID;
exports.WAZUH_MODULES_ID = WAZUH_MODULES_ID;

(function (WAZUH_MODULES_ID) {
  WAZUH_MODULES_ID["SECURITY_EVENTS"] = "general";
  WAZUH_MODULES_ID["INTEGRITY_MONITORING"] = "fim";
  WAZUH_MODULES_ID["AMAZON_WEB_SERVICES"] = "aws";
  WAZUH_MODULES_ID["OFFICE_365"] = "office";
  WAZUH_MODULES_ID["GOOGLE_CLOUD_PLATFORM"] = "gcp";
  WAZUH_MODULES_ID["POLICY_MONITORING"] = "pm";
  WAZUH_MODULES_ID["SECURITY_CONFIGURATION_ASSESSMENT"] = "sca";
  WAZUH_MODULES_ID["AUDITING"] = "audit";
  WAZUH_MODULES_ID["OPEN_SCAP"] = "oscap";
  WAZUH_MODULES_ID["VULNERABILITIES"] = "vuls";
  WAZUH_MODULES_ID["OSQUERY"] = "osquery";
  WAZUH_MODULES_ID["DOCKER"] = "docker";
  WAZUH_MODULES_ID["MITRE_ATTACK"] = "mitre";
  WAZUH_MODULES_ID["PCI_DSS"] = "pci";
  WAZUH_MODULES_ID["HIPAA"] = "hipaa";
  WAZUH_MODULES_ID["NIST_800_53"] = "nist";
  WAZUH_MODULES_ID["TSC"] = "tsc";
  WAZUH_MODULES_ID["CIS_CAT"] = "ciscat";
  WAZUH_MODULES_ID["VIRUSTOTAL"] = "virustotal";
  WAZUH_MODULES_ID["GDPR"] = "gdpr";
  WAZUH_MODULES_ID["GITHUB"] = "github";
})(WAZUH_MODULES_ID || (exports.WAZUH_MODULES_ID = WAZUH_MODULES_ID = {}));

;
let WAZUH_MENU_MANAGEMENT_SECTIONS_ID;
exports.WAZUH_MENU_MANAGEMENT_SECTIONS_ID = WAZUH_MENU_MANAGEMENT_SECTIONS_ID;

(function (WAZUH_MENU_MANAGEMENT_SECTIONS_ID) {
  WAZUH_MENU_MANAGEMENT_SECTIONS_ID["MANAGEMENT"] = "management";
  WAZUH_MENU_MANAGEMENT_SECTIONS_ID["ADMINISTRATION"] = "administration";
  WAZUH_MENU_MANAGEMENT_SECTIONS_ID["RULESET"] = "ruleset";
  WAZUH_MENU_MANAGEMENT_SECTIONS_ID["RULES"] = "rules";
  WAZUH_MENU_MANAGEMENT_SECTIONS_ID["DECODERS"] = "decoders";
  WAZUH_MENU_MANAGEMENT_SECTIONS_ID["CDB_LISTS"] = "lists";
  WAZUH_MENU_MANAGEMENT_SECTIONS_ID["GROUPS"] = "groups";
  WAZUH_MENU_MANAGEMENT_SECTIONS_ID["CONFIGURATION"] = "configuration";
  WAZUH_MENU_MANAGEMENT_SECTIONS_ID["STATUS_AND_REPORTS"] = "statusReports";
  WAZUH_MENU_MANAGEMENT_SECTIONS_ID["STATUS"] = "status";
  WAZUH_MENU_MANAGEMENT_SECTIONS_ID["CLUSTER"] = "monitoring";
  WAZUH_MENU_MANAGEMENT_SECTIONS_ID["LOGS"] = "logs";
  WAZUH_MENU_MANAGEMENT_SECTIONS_ID["REPORTING"] = "reporting";
  WAZUH_MENU_MANAGEMENT_SECTIONS_ID["STATISTICS"] = "statistics";
})(WAZUH_MENU_MANAGEMENT_SECTIONS_ID || (exports.WAZUH_MENU_MANAGEMENT_SECTIONS_ID = WAZUH_MENU_MANAGEMENT_SECTIONS_ID = {}));

;
let WAZUH_MENU_TOOLS_SECTIONS_ID;
exports.WAZUH_MENU_TOOLS_SECTIONS_ID = WAZUH_MENU_TOOLS_SECTIONS_ID;

(function (WAZUH_MENU_TOOLS_SECTIONS_ID) {
  WAZUH_MENU_TOOLS_SECTIONS_ID["API_CONSOLE"] = "devTools";
  WAZUH_MENU_TOOLS_SECTIONS_ID["RULESET_TEST"] = "logtest";
})(WAZUH_MENU_TOOLS_SECTIONS_ID || (exports.WAZUH_MENU_TOOLS_SECTIONS_ID = WAZUH_MENU_TOOLS_SECTIONS_ID = {}));

;
let WAZUH_MENU_SECURITY_SECTIONS_ID;
exports.WAZUH_MENU_SECURITY_SECTIONS_ID = WAZUH_MENU_SECURITY_SECTIONS_ID;

(function (WAZUH_MENU_SECURITY_SECTIONS_ID) {
  WAZUH_MENU_SECURITY_SECTIONS_ID["USERS"] = "users";
  WAZUH_MENU_SECURITY_SECTIONS_ID["ROLES"] = "roles";
  WAZUH_MENU_SECURITY_SECTIONS_ID["POLICIES"] = "policies";
  WAZUH_MENU_SECURITY_SECTIONS_ID["ROLES_MAPPING"] = "roleMapping";
})(WAZUH_MENU_SECURITY_SECTIONS_ID || (exports.WAZUH_MENU_SECURITY_SECTIONS_ID = WAZUH_MENU_SECURITY_SECTIONS_ID = {}));

;
let WAZUH_MENU_SETTINGS_SECTIONS_ID;
exports.WAZUH_MENU_SETTINGS_SECTIONS_ID = WAZUH_MENU_SETTINGS_SECTIONS_ID;

(function (WAZUH_MENU_SETTINGS_SECTIONS_ID) {
  WAZUH_MENU_SETTINGS_SECTIONS_ID["SETTINGS"] = "settings";
  WAZUH_MENU_SETTINGS_SECTIONS_ID["API_CONFIGURATION"] = "api";
  WAZUH_MENU_SETTINGS_SECTIONS_ID["MODULES"] = "modules";
  WAZUH_MENU_SETTINGS_SECTIONS_ID["SAMPLE_DATA"] = "sample_data";
  WAZUH_MENU_SETTINGS_SECTIONS_ID["CONFIGURATION"] = "configuration";
  WAZUH_MENU_SETTINGS_SECTIONS_ID["LOGS"] = "logs";
  WAZUH_MENU_SETTINGS_SECTIONS_ID["MISCELLANEOUS"] = "miscellaneous";
  WAZUH_MENU_SETTINGS_SECTIONS_ID["ABOUT"] = "about";
})(WAZUH_MENU_SETTINGS_SECTIONS_ID || (exports.WAZUH_MENU_SETTINGS_SECTIONS_ID = WAZUH_MENU_SETTINGS_SECTIONS_ID = {}));

;
const AUTHORIZED_AGENTS = 'authorized-agents'; // Wazuh links

exports.AUTHORIZED_AGENTS = AUTHORIZED_AGENTS;
const WAZUH_LINK_GITHUB = 'https://github.com/wazuh';
exports.WAZUH_LINK_GITHUB = WAZUH_LINK_GITHUB;
const WAZUH_LINK_GOOGLE_GROUPS = 'https://groups.google.com/forum/#!forum/wazuh';
exports.WAZUH_LINK_GOOGLE_GROUPS = WAZUH_LINK_GOOGLE_GROUPS;
const WAZUH_LINK_SLACK = 'https://wazuh.com/community/join-us-on-slack';
exports.WAZUH_LINK_SLACK = WAZUH_LINK_SLACK;
const HEALTH_CHECK = 'health-check'; // Health check

exports.HEALTH_CHECK = HEALTH_CHECK;
const HEALTH_CHECK_REDIRECTION_TIME = 300; //ms
// Plugin platform settings
// Default timeFilter set by the app

exports.HEALTH_CHECK_REDIRECTION_TIME = HEALTH_CHECK_REDIRECTION_TIME;
const WAZUH_PLUGIN_PLATFORM_SETTING_TIME_FILTER = {
  from: 'now-24h',
  to: 'now'
};
exports.WAZUH_PLUGIN_PLATFORM_SETTING_TIME_FILTER = WAZUH_PLUGIN_PLATFORM_SETTING_TIME_FILTER;
const PLUGIN_PLATFORM_SETTING_NAME_TIME_FILTER = 'timepicker:timeDefaults'; // Default maxBuckets set by the app

exports.PLUGIN_PLATFORM_SETTING_NAME_TIME_FILTER = PLUGIN_PLATFORM_SETTING_NAME_TIME_FILTER;
const WAZUH_PLUGIN_PLATFORM_SETTING_MAX_BUCKETS = 200000;
exports.WAZUH_PLUGIN_PLATFORM_SETTING_MAX_BUCKETS = WAZUH_PLUGIN_PLATFORM_SETTING_MAX_BUCKETS;
const PLUGIN_PLATFORM_SETTING_NAME_MAX_BUCKETS = 'timelion:max_buckets'; // Default metaFields set by the app

exports.PLUGIN_PLATFORM_SETTING_NAME_MAX_BUCKETS = PLUGIN_PLATFORM_SETTING_NAME_MAX_BUCKETS;
const WAZUH_PLUGIN_PLATFORM_SETTING_METAFIELDS = ['_source', '_index'];
exports.WAZUH_PLUGIN_PLATFORM_SETTING_METAFIELDS = WAZUH_PLUGIN_PLATFORM_SETTING_METAFIELDS;
const PLUGIN_PLATFORM_SETTING_NAME_METAFIELDS = 'metaFields'; // Logger

exports.PLUGIN_PLATFORM_SETTING_NAME_METAFIELDS = PLUGIN_PLATFORM_SETTING_NAME_METAFIELDS;
const UI_LOGGER_LEVELS = {
  WARNING: 'WARNING',
  INFO: 'INFO',
  ERROR: 'ERROR'
};
exports.UI_LOGGER_LEVELS = UI_LOGGER_LEVELS;
const UI_TOAST_COLOR = {
  SUCCESS: 'success',
  WARNING: 'warning',
  DANGER: 'danger'
}; // Assets

exports.UI_TOAST_COLOR = UI_TOAST_COLOR;
const ASSETS_BASE_URL_PREFIX = '/plugins/wazuh/assets/'; // Reports

exports.ASSETS_BASE_URL_PREFIX = ASSETS_BASE_URL_PREFIX;
const REPORTS_LOGO_IMAGE_ASSETS_RELATIVE_PATH = 'images/logo_reports.png';
exports.REPORTS_LOGO_IMAGE_ASSETS_RELATIVE_PATH = REPORTS_LOGO_IMAGE_ASSETS_RELATIVE_PATH;
const REPORTS_PRIMARY_COLOR = '#256BD1';
exports.REPORTS_PRIMARY_COLOR = REPORTS_PRIMARY_COLOR;
const REPORTS_PAGE_FOOTER_TEXT = 'Copyright © 2022 Wazuh, Inc.';
exports.REPORTS_PAGE_FOOTER_TEXT = REPORTS_PAGE_FOOTER_TEXT;
const REPORTS_PAGE_HEADER_TEXT = 'info@wazuh.com\nhttps://wazuh.com'; // Plugin platform

exports.REPORTS_PAGE_HEADER_TEXT = REPORTS_PAGE_HEADER_TEXT;
const PLUGIN_PLATFORM_NAME = 'Kibana';
exports.PLUGIN_PLATFORM_NAME = PLUGIN_PLATFORM_NAME;
const PLUGIN_PLATFORM_BASE_INSTALLATION_PATH = '/usr/share/kibana/data/wazuh/';
exports.PLUGIN_PLATFORM_BASE_INSTALLATION_PATH = PLUGIN_PLATFORM_BASE_INSTALLATION_PATH;
const PLUGIN_PLATFORM_INSTALLATION_USER = 'kibana';
exports.PLUGIN_PLATFORM_INSTALLATION_USER = PLUGIN_PLATFORM_INSTALLATION_USER;
const PLUGIN_PLATFORM_INSTALLATION_USER_GROUP = 'kibana';
exports.PLUGIN_PLATFORM_INSTALLATION_USER_GROUP = PLUGIN_PLATFORM_INSTALLATION_USER_GROUP;
const PLUGIN_PLATFORM_WAZUH_DOCUMENTATION_URL_PATH_UPGRADE_PLATFORM = 'upgrade-guide';
exports.PLUGIN_PLATFORM_WAZUH_DOCUMENTATION_URL_PATH_UPGRADE_PLATFORM = PLUGIN_PLATFORM_WAZUH_DOCUMENTATION_URL_PATH_UPGRADE_PLATFORM;
const PLUGIN_PLATFORM_WAZUH_DOCUMENTATION_URL_PATH_TROUBLESHOOTING = 'user-manual/elasticsearch/troubleshooting.html';
exports.PLUGIN_PLATFORM_WAZUH_DOCUMENTATION_URL_PATH_TROUBLESHOOTING = PLUGIN_PLATFORM_WAZUH_DOCUMENTATION_URL_PATH_TROUBLESHOOTING;
const PLUGIN_PLATFORM_WAZUH_DOCUMENTATION_URL_PATH_APP_CONFIGURATION = 'user-manual/wazuh-dashboard/config-file.html';
exports.PLUGIN_PLATFORM_WAZUH_DOCUMENTATION_URL_PATH_APP_CONFIGURATION = PLUGIN_PLATFORM_WAZUH_DOCUMENTATION_URL_PATH_APP_CONFIGURATION;
const PLUGIN_PLATFORM_URL_GUIDE = 'https://www.elastic.co/guide/en/elasticsearch/reference/current/index.html';
exports.PLUGIN_PLATFORM_URL_GUIDE = PLUGIN_PLATFORM_URL_GUIDE;
const PLUGIN_PLATFORM_URL_GUIDE_TITLE = 'Elastic guide';
exports.PLUGIN_PLATFORM_URL_GUIDE_TITLE = PLUGIN_PLATFORM_URL_GUIDE_TITLE;
const PLUGIN_PLATFORM_REQUEST_HEADERS = {
  'kbn-xsrf': 'kibana'
}; // UI

exports.PLUGIN_PLATFORM_REQUEST_HEADERS = PLUGIN_PLATFORM_REQUEST_HEADERS;
const API_NAME_AGENT_STATUS = {
  ACTIVE: 'active',
  DISCONNECTED: 'disconnected',
  PENDING: 'pending',
  NEVER_CONNECTED: 'never_connected'
};
exports.API_NAME_AGENT_STATUS = API_NAME_AGENT_STATUS;
const UI_COLOR_AGENT_STATUS = {
  [API_NAME_AGENT_STATUS.ACTIVE]: '#007871',
  [API_NAME_AGENT_STATUS.DISCONNECTED]: '#BD271E',
  [API_NAME_AGENT_STATUS.PENDING]: '#FEC514',
  [API_NAME_AGENT_STATUS.NEVER_CONNECTED]: '#646A77',
  default: '#000000'
};
exports.UI_COLOR_AGENT_STATUS = UI_COLOR_AGENT_STATUS;
const UI_LABEL_NAME_AGENT_STATUS = {
  [API_NAME_AGENT_STATUS.ACTIVE]: 'Active',
  [API_NAME_AGENT_STATUS.DISCONNECTED]: 'Disconnected',
  [API_NAME_AGENT_STATUS.PENDING]: 'Pending',
  [API_NAME_AGENT_STATUS.NEVER_CONNECTED]: 'Never connected',
  default: 'Unknown'
};
exports.UI_LABEL_NAME_AGENT_STATUS = UI_LABEL_NAME_AGENT_STATUS;
const UI_ORDER_AGENT_STATUS = [API_NAME_AGENT_STATUS.ACTIVE, API_NAME_AGENT_STATUS.DISCONNECTED, API_NAME_AGENT_STATUS.PENDING, API_NAME_AGENT_STATUS.NEVER_CONNECTED]; // Documentation

exports.UI_ORDER_AGENT_STATUS = UI_ORDER_AGENT_STATUS;
const DOCUMENTATION_WEB_BASE_URL = "https://documentation.wazuh.com";
exports.DOCUMENTATION_WEB_BASE_URL = DOCUMENTATION_WEB_BASE_URL;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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