"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WazuhUtilsRoutes = WazuhUtilsRoutes;

var _controllers = require("../../controllers");

var _configSchema = require("@kbn/config-schema");

/*
 * Wazuh app - Module for Wazuh utils routes
 * Copyright (C) 2015-2022 Wazuh, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Find more information about this on the LICENSE file.
 */
function WazuhUtilsRoutes(router) {
  const ctrl = new _controllers.WazuhUtilsCtrl(); // Returns the wazuh.yml file parsed

  router.get({
    path: '/utils/configuration',
    validate: false
  }, async (context, request, response) => ctrl.getConfigurationFile(context, request, response)); // Returns the wazuh.yml file in raw

  router.put({
    path: '/utils/configuration',
    validate: {
      body: _configSchema.schema.object({
        key: _configSchema.schema.string(),
        value: _configSchema.schema.any()
      })
    }
  }, async (context, request, response) => ctrl.updateConfigurationFile(context, request, response)); // Returns Wazuh app logs

  router.get({
    path: '/utils/logs',
    validate: false
  }, async (context, request, response) => ctrl.getAppLogs(context, request, response));
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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