"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.gdprRequirementsFile = void 0;

/*
 * Wazuh app - Module for GDPR requirements
 * Copyright (C) 2015-2022 Wazuh, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Find more information about this on the LICENSE file.
 */
const gdprRequirementsFile = {
  'II_5.1.f': 'Ensure the ongoing confidentiality, integrity, availability and resilience of processing systems and services, verifying its modifications, accesses, locations and guarantee the safety of them.File sharing protection and file sharing technologies that meet the requirements of data protection.',
  'III_14.2.c': ' Restrict the processing of personal data temporarily.',
  III_17: ' Permanently erase personal information of a subject.',
  'IV_24.2': 'Be able to demonstrate compliance with the GDPR by complying with data protection policies.',
  IV_28: ' Ensure data protection during processing, through technical and organizational measures.',
  'IV_30.1.g': 'It is necessary to keep all processing activities documented, to carry out an inventory of data from beginning to end and an audit, in order to know all the places where personal and sensitive data are located, processed, stored or transmitted.',
  'IV_32.1.c': 'Data Loss Prevention (DLP) capabilities to examine data flows and identify personal data that is not subject to adequate safeguards or authorizations. DLP tools can block or quarantine such data flows. Classify current data appropriately to determine specific categories of data that will be subject to the GDPR.',
  'IV_32.2': 'Account management tools that closely monitor actions taken by standard administrators and users who use standard or privileged account credentials are required to control access to data. ',
  IV_33: ' Notify the supervisory authority of a violation of the data in 72 hours and in certain cases, the injured parties.',
  'IV_35.1': 'Perform a data protection impact evaluation for high risk processes. Implement appropriate technical measures to safeguard the rights and freedoms of data subjects, informed by an assessment of the risks to these rights and freedoms.',
  'IV_35.7.d': 'Capabilities for identification, blocking and forensic investigation of data breaches by malicious actors, through compromised credentials, unauthorized network access, persistent threats and verification of the correct operation of all components.Network perimeter and endpoint security tools to prevent unauthorized access to the network, prevent the entry of unwanted data types and malicious threats. Anti-malware and anti-ransomware to prevent malware and ransomware threats from entering your devices.A behavioral analysis that uses machine intelligence to identify people who do anomalous things on the network, in order to give early visibility and alert employees who start to become corrupt.'
};
exports.gdprRequirementsFile = gdprRequirementsFile;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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