"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.nistRequirementsFile = void 0;

/*
 * Wazuh app - Module for NIST 800-53 requirements
 * Copyright (C) 2015-2022 Wazuh, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Find more information about this on the LICENSE file.
 */
const nistRequirementsFile = {
  'AC.2': 'ACCOUNT MANAGEMENT - Identifies and selects the following types of information system accounts to support organizational missions/business functions.',
  'AC.6': 'LEAST PRIVILEGE - The organization employs the principle of least privilege, allowing only authorized accesses for users (or processes acting on behalf of users) which are necessary to accomplish assigned tasks in accordance with organizational missions and business functions.',
  'AC.7': 'UNSUCCESSFUL LOGON ATTEMPTS - Enforces a limit of consecutive invalid logon attempts by a user during a time period.',
  'AC.12': 'SESSION TERMINATION - The information system automatically terminates a user session.',
  'AU.5': 'RESPONSE TO AUDIT PROCESSING FAILURES - The information system alerts organization-defined personnel or roles in the event of an audit processing failure and takes organization-defined actions to be taken (e.g., shut down information system, overwrite oldest audit records, stop generating audit records).',
  'AU.6': 'AUDIT REVIEW, ANALYSIS, AND REPORTING - Reviews and analyzes information system audit records.',
  'AU.8': 'TIME STAMPS - Uses internal system clocks to generate time stamps for audit records and records time stamps for audit records.',
  'AU.9': 'PROTECTION OF AUDIT INFORMATION - The information system protects audit information and audit tools from unauthorized access, modification, and deletion.',
  'AU.12': 'AUDIT GENERATION - The information system provides audit record generation capability for the auditable events at organization-defined information system components, allows organization-defined personnel or roles to select which auditable events are to be audited by specific components of the information system and generates audit records.',
  'CA.3': 'SYSTEM INTERCONNECTIONS - Authorizes connections from the information system to other information systems through the use of Interconnection Security Agreements, Documents, for each interconnection, the interface characteristics, security requirements, and the nature of the information communicated and Reviews and updates Interconnection Security Agreements ',
  'CM.1': 'CONFIGURATION MANAGEMENT POLICY AND PROCEDURES - Develops, documents, and disseminates to a configuration management policy. Revies and updates the current configuration management policy and procedures.',
  'CM.3': 'CONFIGURATION CHANGE CONTROL - The organization determines the types of changes to the information system that are configuration-controlled. ',
  'CM.5': 'ACCESS RESTRICTIONS FOR CHANGE - The organization defines, documents, approves, and enforces physical and logical access restrictions associated with changes to the information system.',
  'IA.4': 'IDENTIFIER MANAGEMENT - The organization manages information system identifiers by: Receiving authorization from organization-defined personnel or roles to assign an individual, group, role, or device identifier. Selecting an identifier that identifies an individual, group, role, or device. Assigning the identifier to the intended individual, group, role, or device. Preventing reuse of identifiers for a organization-defined time period. Disabling the identifier after organization-defined time period of inactivity.',
  'IA.5': 'AUTHENTICATOR MANAGEMENT - The organization manages information system authenticators by verifying, as part of the initial authenticator distribution, the identity of the individual, group role, or device receiving the authenticator.',
  'IA.10': 'ADAPTIVE IDENTIFICATION AND AUTHENTICATION - The organization requires that individuals accessing the information system employ organization-defined supplemental authentication techniques or mechanisms under specific organization-defined circumstances or situations. ',
  'SA.11': 'DEVELOPER SECURITY TESTING AND EVALUATION - The organization requires the developer of the information system, system component, or information system service to create and implement a security assessment plan.',
  'SC.2': 'APPLICATION PARTITIONING - The information system separates user functionality (including user interface services) from information system management functionality.',
  'SC.7': 'BOUNDARY PROTECTION - The information system monitors and controls communications at the external boundary of the system and at key internal boundaries within the system.',
  'SC.8': 'TRANSMISSION CONFIDENTIALITY AND INTEGRITY - The information system protects the confidentiality and integrity of transmitted information.',
  'SI.2': 'FLAW REMEDIATION - The organization identifies, reports, and corrects information system flaws; tests software and firmware updates related to flaw remediation for effectiveness and potential side effects before installation; installs security-relevant software and firmware updates within organizationdefined time period of the release of the updates and  incorporates flaw remediation into the organizational configuration management process.',
  'SI.3': 'MALICIOUS CODE PROTECTION - The organization employs malicious code protection mechanisms at information system entry and exit points to detect and eradicate malicious code, updates malicious code protection mechanisms whenever new releases are available in accordance with organizational configuration management policy and procedures, configures malicious code protection mechanisms and addresses the receipt of false positives during malicious code detection and eradication and the resulting potential impact on the availability of the information system.',
  'SI.7': 'SOFTWARE, FIRMWARE, AND INFORMATION INTEGRITY - The organization employs integrity verification tools to detect unauthorized changes to organization-defined software, firmware, and information.'
};
exports.nistRequirementsFile = nistRequirementsFile;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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