"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.pciRequirementsFile = void 0;

/*
 * Wazuh app - Module for PCI requirements
 * Copyright (C) 2015-2022 Wazuh, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Find more information about this on the LICENSE file.
 */
const pciRequirementsFile = {
  '1.1.1': 'A formal process for approving and testing all network connections and changes to the firewall and router configurations',
  '1.3.4': 'Do not allow unauthorized outbound traffic from the cardholder data environment to the Internet.',
  '1.4': 'Install personal firewall software or equivalent functionality on any portable computing devices (including company and/or employee-owned) that connect to the Internet when outside the network (for example, laptops used by employees), and which are also used to access the CDE. Firewall (or equivalent) configurations include:Specific configuration settings are defined. Personal firewall (or equivalent functionality) is actively running. Personal firewall (or equivalent functionality) is not alterable by users of the portable computing devices. ',
  '2.2': 'Develop configuration standards for all system components. Assure that these standards address all known security vulnerabilities and are consistent with industry accepted system hardening standards (CIS, ISO, SANS, NIST).',
  '2.2.2': 'Enable only necessary services, protocols, daemons, etc., as required for the function of the system. ',
  '2.2.3': 'Implement additional security features for any required services, protocols, or daemons that are considered to be insecure',
  '2.2.4': 'Configure system security parameters to prevent misuse.',
  '4.1': 'Use strong cryptography and security protocols (for example, SSL/TLS, IPSEC, SSH, etc.) to safeguard sensitive cardholder data during transmission over open, public networks, including the following:Only trusted keys and certificates are accepted. The protocol in use only supports secure versions or configurations. The encryption strength is appropriate for the encryption methodology in use. ',
  '5.1': 'Deploy anti-virus software on all systems commonly affected by malicious software (particularly personal computers and servers).',
  '5.2': 'Ensure that all anti-virus mechanisms are maintained as follows:Are kept current. Perform periodic scans. Generate audit logs which are retained per PCI DSS Requirement 10.7. ',
  '6.2': 'Ensure that all system components and software are protected from known vulnerabilities by installing applicable vendor-supplied security patches. Install critical security patches within one month of release.',
  '6.5': 'Address common coding vulnerabilities in software development processes as follows:Train developers in secure coding techniques, including how to avoid common coding vulnerabilities, and understanding how sensitive data is handled in memory. Develop applications based on secure coding guidelines. ',
  '6.5.1': 'Injection flaws, particularly SQL injection. Also consider OS Command Injection, LDAP and XPath injection flaws as well as other injection flaws.',
  '6.5.2': 'Buffer overflows',
  '6.5.5': 'Improper error handling',
  '6.5.7': 'Cross-site scripting (XSS)',
  '6.5.8': 'Improper access control (such an insecure direct object references, failure to restrict URL access, directory traversal, and failure to restrict user access to functions).',
  '6.5.10': 'Broken authentication and session management.',
  '6.6': 'For public-facing web applications, address new threats and vulnerabilities on an ongoing basis and ensure these applications are protected against known attacks by either of the following methods:Reviewing public-facing web applications via manual or automated application vulnerability security assessment tools or methods, at least annually and after any changes. Installing an automated technical solution that detects and prevents web-based attacks (for example, a web-application firewall) in front of public-facing web applications, to continually check all traffic. ',
  '8.1.2': 'Control addition, deletion, and modification of user IDs, credentials, and other identifier objects.',
  '8.1.4': 'Remove/disable inactive user accounts within 90 days.',
  '8.1.5': 'Manage IDs used by third parties to access, support, or maintain system components via remote access as follows:Enabled only during the time period needed and disabled when not in use. Monitored when in use. ',
  '8.1.6': 'Limit repeated access attempts by locking out the user ID after not more than six attempts.',
  '8.1.8': 'If a session has been idle for more than 15 minutes, require the user to reauthenticate to re-activate the terminal or session.',
  '8.2.4': 'Change user passwords/passphrases at least once every 90 days.',
  '8.5.1': 'Additional requirement for service providers: Service providers with remote access to customer premises (for example, for support of POS systems or servers) must use a unique authentication credential (such as a password/phrase) for each customer.',
  '8.7': 'All access to any database containing cardholder data (including access by applications, administrators, and all other users) is restricted as follows:All user access to, user queries of, and user actions on databases are through programmatic methods. Only database administrators have the ability to directly access or query databases. Application IDs for database applications can only be used by the applications (and not by individual users or other non-application processes).',
  '10.1': 'Implement audit trails to link all access to system components to each individual user.',
  '10.2.1': 'All individual user accesses to cardholder data',
  '10.2.2': 'All actions taken by any individual with root or administrative privileges.',
  '10.2.4': 'Invalid logical access attempts',
  '10.2.5': 'Use of and changes to identification and authentication mechanisms including but not limited to creation of new accounts and elevation of privileges and all changes, additions, or deletions to accounts with root or administrative privileges.',
  '10.2.6': 'Initialization, stopping, or pausing of the audit logs',
  '10.2.7': 'Creation and deletion of system level objects',
  '10.5.2': 'Protect audit trail files from unauthorized modifications',
  '10.5.5': 'Use file integrity monitoring or change detection software on logs to ensure that existing log data cannot be changed without generating alerts (although new data being added should not cause an alert).',
  '10.4': 'Using time-synchronization technology, synchronize all critical system clocks and times and ensure that the following is implemented for acquiring, distributing, and storing time.',
  '10.6': 'Review logs and security events for all system components to identify anomalies or suspicious activity',
  '10.6.1': 'Review the following at least daily: All security events. Logs of all system components that store, process, or transmit CHD and/or SAD, or that could. impact the security of CHD and/or SAD. Logs of all critical system components. Logs of all servers and system components that perform security functions (for example, firewalls, intrusion detection systems/intrusion prevention systems (IDS/IPS), authentication servers, ecommerce redirection servers, etc.). ',
  '11.4': 'Use intrusion detection and/or intrusion prevention techniques to detect and/or prevent intrusions into the network.Monitor all traffic at the perimeter of the cardholder data environment as well as at critical points in the cardholder data environment, and alert personnel to suspected compromises. Keep all intrusion detection and prevention engines, baselines, and signatures up to date.',
  '11.5': 'Deploy a change detection mechanism (for example, file integrity monitoring tools) to alert personnel to unauthorized modification of critical system files, configuration files, or content files; and configure the software to perform critical file comparisons at least weekly.',
  '11.2.1': 'Perform quarterly internal vulnerability scans. Address vulnerabilities and perform rescans to verify all “high risk” vulnerabilities are resolved in accordance with the entity’s vulnerability ranking. Scans must be performed by qualified personnel.',
  '11.2.3': 'Perform internal and external scans, and rescans as needed, after any significant change. Scans must be performed by qualified personnel.'
};
exports.pciRequirementsFile = pciRequirementsFile;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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