"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PLUGIN_PLATFORM_URL_GUIDE_TITLE = exports.PLUGIN_PLATFORM_URL_GUIDE = exports.PLUGIN_PLATFORM_WAZUH_DOCUMENTATION_URL_PATH_APP_CONFIGURATION = exports.PLUGIN_PLATFORM_WAZUH_DOCUMENTATION_URL_PATH_TROUBLESHOOTING = exports.PLUGIN_PLATFORM_WAZUH_DOCUMENTATION_URL_PATH_UPGRADE_PLATFORM = exports.PLUGIN_PLATFORM_INSTALLATION_USER_GROUP = exports.PLUGIN_PLATFORM_INSTALLATION_USER = exports.PLUGIN_PLATFORM_BASE_INSTALLATION_PATH = exports.PLUGIN_PLATFORM_NAME = exports.REPORTS_PAGE_HEADER_TEXT = exports.REPORTS_PAGE_FOOTER_TEXT = exports.REPORTS_PRIMARY_COLOR = exports.REPORTS_LOGO_IMAGE_ASSETS_RELATIVE_PATH = exports.ASSETS_PUBLIC_URL = exports.ASSETS_BASE_URL_PREFIX = exports.UI_TOAST_COLOR = exports.UI_LOGGER_LEVELS = exports.PLUGIN_PLATFORM_SETTING_NAME_METAFIELDS = exports.WAZUH_PLUGIN_PLATFORM_SETTING_METAFIELDS = exports.PLUGIN_PLATFORM_SETTING_NAME_MAX_BUCKETS = exports.WAZUH_PLUGIN_PLATFORM_SETTING_MAX_BUCKETS = exports.PLUGIN_PLATFORM_SETTING_NAME_TIME_FILTER = exports.WAZUH_PLUGIN_PLATFORM_SETTING_TIME_FILTER = exports.HEALTH_CHECK_REDIRECTION_TIME = exports.HEALTH_CHECK = exports.WAZUH_LINK_SLACK = exports.WAZUH_LINK_GOOGLE_GROUPS = exports.WAZUH_LINK_GITHUB = exports.AUTHORIZED_AGENTS = exports.WAZUH_MENU_SETTINGS_SECTIONS_ID = exports.WAZUH_MENU_SECURITY_SECTIONS_ID = exports.WAZUH_MENU_TOOLS_SECTIONS_ID = exports.WAZUH_MENU_MANAGEMENT_SECTIONS_ID = exports.WAZUH_MODULES_ID = exports.WAZUH_AGENTS_OS_TYPE = exports.WAZUH_ERROR_DAEMONS_NOT_READY = exports.WAZUH_DEFAULT_APP_CONFIG = exports.WAZUH_QUEUE_CRON_FREQ = exports.WAZUH_DATA_DOWNLOADS_REPORTS_DIRECTORY_PATH = exports.WAZUH_DATA_DOWNLOADS_DIRECTORY_PATH = exports.WAZUH_UI_LOGS_RAW_PATH = exports.WAZUH_UI_LOGS_PLAIN_PATH = exports.WAZUH_UI_LOGS_RAW_FILENAME = exports.WAZUH_UI_LOGS_PLAIN_FILENAME = exports.WAZUH_DATA_LOGS_RAW_PATH = exports.WAZUH_DATA_LOGS_RAW_FILENAME = exports.WAZUH_DATA_LOGS_PLAIN_PATH = exports.WAZUH_DATA_LOGS_PLAIN_FILENAME = exports.WAZUH_DATA_LOGS_DIRECTORY_PATH = exports.MAX_MB_LOG_FILES = exports.WAZUH_DATA_CONFIG_REGISTRY_PATH = exports.WAZUH_DATA_CONFIG_APP_PATH = exports.WAZUH_DATA_CONFIG_DIRECTORY_PATH = exports.WAZUH_DATA_ABSOLUTE_PATH = exports.WAZUH_DATA_PLUGIN_PLATFORM_BASE_ABSOLUTE_PATH = exports.WAZUH_API_RESERVED_ID_LOWER_THAN = exports.WAZUH_CONFIGURATION_SETTINGS_NEED_RELOAD = exports.WAZUH_CONFIGURATION_SETTINGS_NEED_HEALTH_CHECK = exports.WAZUH_CONFIGURATION_SETTINGS_NEED_RESTART = exports.WAZUH_CONFIGURATION_CACHE_TIME = exports.WAZUH_SECURITY_PLUGINS = exports.WAZUH_SECURITY_PLUGIN_OPEN_DISTRO_FOR_ELASTICSEARCH = exports.WAZUH_SECURITY_PLUGIN_XPACK_SECURITY = exports.WAZUH_SAMPLE_ALERTS_CATEGORIES_TYPE_ALERTS = exports.WAZUH_SAMPLE_ALERTS_DEFAULT_NUMBER_ALERTS = exports.WAZUH_SAMPLE_ALERTS_CATEGORY_THREAT_DETECTION = exports.WAZUH_SAMPLE_ALERTS_CATEGORY_AUDITING_POLICY_MONITORING = exports.WAZUH_SAMPLE_ALERTS_CATEGORY_SECURITY = exports.WAZUH_SAMPLE_ALERTS_INDEX_REPLICAS = exports.WAZUH_SAMPLE_ALERTS_INDEX_SHARDS = exports.WAZUH_SAMPLE_ALERT_PREFIX = exports.WAZUH_ROLE_ADMINISTRATOR_NAME = exports.WAZUH_ROLE_ADMINISTRATOR_ID = exports.WAZUH_PLUGIN_PLATFORM_TEMPLATE_NAME = exports.WAZUH_STATISTICS_DEFAULT_CRON_FREQ = exports.WAZUH_STATISTICS_DEFAULT_FREQUENCY = exports.WAZUH_STATISTICS_DEFAULT_STATUS = exports.WAZUH_STATISTICS_DEFAULT_CREATION = exports.WAZUH_STATISTICS_DEFAULT_INDICES_REPLICAS = exports.WAZUH_STATISTICS_DEFAULT_INDICES_SHARDS = exports.WAZUH_STATISTICS_TEMPLATE_NAME = exports.WAZUH_STATISTICS_PATTERN = exports.WAZUH_STATISTICS_DEFAULT_NAME = exports.WAZUH_STATISTICS_DEFAULT_PREFIX = exports.WAZUH_INDEX_TYPE_STATISTICS = exports.WAZUH_MONITORING_DEFAULT_CRON_FREQ = exports.WAZUH_MONITORING_DEFAULT_FREQUENCY = exports.WAZUH_MONITORING_DEFAULT_ENABLED = exports.WAZUH_MONITORING_DEFAULT_CREATION = exports.WAZUH_MONITORING_DEFAULT_INDICES_REPLICAS = exports.WAZUH_MONITORING_DEFAULT_INDICES_SHARDS = exports.WAZUH_MONITORING_TEMPLATE_NAME = exports.WAZUH_MONITORING_PATTERN = exports.WAZUH_MONITORING_PREFIX = exports.WAZUH_INDEX_TYPE_MONITORING = exports.WAZUH_ALERTS_PATTERN = exports.WAZUH_ALERTS_PREFIX = exports.WAZUH_INDEX_TYPE_ALERTS = exports.PLUGIN_VERSION_SHORT = exports.PLUGIN_VERSION = void 0;
exports.ELASTIC_NAME = exports.DOCUMENTATION_WEB_BASE_URL = exports.UI_ORDER_AGENT_STATUS = exports.UI_LABEL_NAME_AGENT_STATUS = exports.UI_COLOR_AGENT_STATUS = exports.API_NAME_AGENT_STATUS = exports.PLUGIN_PLATFORM_REQUEST_HEADERS = void 0;

var _path = _interopRequireDefault(require("path"));

var _package = require("../package.json");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Wazuh app - Wazuh Constants file
 * Copyright (C) 2015-2022 Wazuh, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Find more information about this on the LICENSE file.
 */
// Plugin
const PLUGIN_VERSION = _package.version;
exports.PLUGIN_VERSION = PLUGIN_VERSION;

const PLUGIN_VERSION_SHORT = _package.version.split('.').splice(0, 2).join('.'); // Index patterns - Wazuh alerts


exports.PLUGIN_VERSION_SHORT = PLUGIN_VERSION_SHORT;
const WAZUH_INDEX_TYPE_ALERTS = 'alerts';
exports.WAZUH_INDEX_TYPE_ALERTS = WAZUH_INDEX_TYPE_ALERTS;
const WAZUH_ALERTS_PREFIX = 'wazuh-alerts-';
exports.WAZUH_ALERTS_PREFIX = WAZUH_ALERTS_PREFIX;
const WAZUH_ALERTS_PATTERN = 'wazuh-alerts-*'; // Job - Wazuh monitoring

exports.WAZUH_ALERTS_PATTERN = WAZUH_ALERTS_PATTERN;
const WAZUH_INDEX_TYPE_MONITORING = "monitoring";
exports.WAZUH_INDEX_TYPE_MONITORING = WAZUH_INDEX_TYPE_MONITORING;
const WAZUH_MONITORING_PREFIX = "wazuh-monitoring-";
exports.WAZUH_MONITORING_PREFIX = WAZUH_MONITORING_PREFIX;
const WAZUH_MONITORING_PATTERN = "wazuh-monitoring-*";
exports.WAZUH_MONITORING_PATTERN = WAZUH_MONITORING_PATTERN;
const WAZUH_MONITORING_TEMPLATE_NAME = "wazuh-agent";
exports.WAZUH_MONITORING_TEMPLATE_NAME = WAZUH_MONITORING_TEMPLATE_NAME;
const WAZUH_MONITORING_DEFAULT_INDICES_SHARDS = 1;
exports.WAZUH_MONITORING_DEFAULT_INDICES_SHARDS = WAZUH_MONITORING_DEFAULT_INDICES_SHARDS;
const WAZUH_MONITORING_DEFAULT_INDICES_REPLICAS = 0;
exports.WAZUH_MONITORING_DEFAULT_INDICES_REPLICAS = WAZUH_MONITORING_DEFAULT_INDICES_REPLICAS;
const WAZUH_MONITORING_DEFAULT_CREATION = 'w';
exports.WAZUH_MONITORING_DEFAULT_CREATION = WAZUH_MONITORING_DEFAULT_CREATION;
const WAZUH_MONITORING_DEFAULT_ENABLED = true;
exports.WAZUH_MONITORING_DEFAULT_ENABLED = WAZUH_MONITORING_DEFAULT_ENABLED;
const WAZUH_MONITORING_DEFAULT_FREQUENCY = 900;
exports.WAZUH_MONITORING_DEFAULT_FREQUENCY = WAZUH_MONITORING_DEFAULT_FREQUENCY;
const WAZUH_MONITORING_DEFAULT_CRON_FREQ = '0 * * * * *'; // Job - Wazuh statistics

exports.WAZUH_MONITORING_DEFAULT_CRON_FREQ = WAZUH_MONITORING_DEFAULT_CRON_FREQ;
const WAZUH_INDEX_TYPE_STATISTICS = "statistics";
exports.WAZUH_INDEX_TYPE_STATISTICS = WAZUH_INDEX_TYPE_STATISTICS;
const WAZUH_STATISTICS_DEFAULT_PREFIX = "wazuh";
exports.WAZUH_STATISTICS_DEFAULT_PREFIX = WAZUH_STATISTICS_DEFAULT_PREFIX;
const WAZUH_STATISTICS_DEFAULT_NAME = "statistics";
exports.WAZUH_STATISTICS_DEFAULT_NAME = WAZUH_STATISTICS_DEFAULT_NAME;
const WAZUH_STATISTICS_PATTERN = `${WAZUH_STATISTICS_DEFAULT_PREFIX}-${WAZUH_STATISTICS_DEFAULT_NAME}-*`;
exports.WAZUH_STATISTICS_PATTERN = WAZUH_STATISTICS_PATTERN;
const WAZUH_STATISTICS_TEMPLATE_NAME = `${WAZUH_STATISTICS_DEFAULT_PREFIX}-${WAZUH_STATISTICS_DEFAULT_NAME}`;
exports.WAZUH_STATISTICS_TEMPLATE_NAME = WAZUH_STATISTICS_TEMPLATE_NAME;
const WAZUH_STATISTICS_DEFAULT_INDICES_SHARDS = 1;
exports.WAZUH_STATISTICS_DEFAULT_INDICES_SHARDS = WAZUH_STATISTICS_DEFAULT_INDICES_SHARDS;
const WAZUH_STATISTICS_DEFAULT_INDICES_REPLICAS = 0;
exports.WAZUH_STATISTICS_DEFAULT_INDICES_REPLICAS = WAZUH_STATISTICS_DEFAULT_INDICES_REPLICAS;
const WAZUH_STATISTICS_DEFAULT_CREATION = 'w';
exports.WAZUH_STATISTICS_DEFAULT_CREATION = WAZUH_STATISTICS_DEFAULT_CREATION;
const WAZUH_STATISTICS_DEFAULT_STATUS = true;
exports.WAZUH_STATISTICS_DEFAULT_STATUS = WAZUH_STATISTICS_DEFAULT_STATUS;
const WAZUH_STATISTICS_DEFAULT_FREQUENCY = 900;
exports.WAZUH_STATISTICS_DEFAULT_FREQUENCY = WAZUH_STATISTICS_DEFAULT_FREQUENCY;
const WAZUH_STATISTICS_DEFAULT_CRON_FREQ = '0 */5 * * * *'; // Job - Wazuh initialize

exports.WAZUH_STATISTICS_DEFAULT_CRON_FREQ = WAZUH_STATISTICS_DEFAULT_CRON_FREQ;
const WAZUH_PLUGIN_PLATFORM_TEMPLATE_NAME = 'wazuh-kibana'; // Permissions

exports.WAZUH_PLUGIN_PLATFORM_TEMPLATE_NAME = WAZUH_PLUGIN_PLATFORM_TEMPLATE_NAME;
const WAZUH_ROLE_ADMINISTRATOR_ID = 1;
exports.WAZUH_ROLE_ADMINISTRATOR_ID = WAZUH_ROLE_ADMINISTRATOR_ID;
const WAZUH_ROLE_ADMINISTRATOR_NAME = 'administrator'; // Sample data

exports.WAZUH_ROLE_ADMINISTRATOR_NAME = WAZUH_ROLE_ADMINISTRATOR_NAME;
const WAZUH_SAMPLE_ALERT_PREFIX = 'wazuh-alerts-4.x-';
exports.WAZUH_SAMPLE_ALERT_PREFIX = WAZUH_SAMPLE_ALERT_PREFIX;
const WAZUH_SAMPLE_ALERTS_INDEX_SHARDS = 1;
exports.WAZUH_SAMPLE_ALERTS_INDEX_SHARDS = WAZUH_SAMPLE_ALERTS_INDEX_SHARDS;
const WAZUH_SAMPLE_ALERTS_INDEX_REPLICAS = 0;
exports.WAZUH_SAMPLE_ALERTS_INDEX_REPLICAS = WAZUH_SAMPLE_ALERTS_INDEX_REPLICAS;
const WAZUH_SAMPLE_ALERTS_CATEGORY_SECURITY = 'security';
exports.WAZUH_SAMPLE_ALERTS_CATEGORY_SECURITY = WAZUH_SAMPLE_ALERTS_CATEGORY_SECURITY;
const WAZUH_SAMPLE_ALERTS_CATEGORY_AUDITING_POLICY_MONITORING = 'auditing-policy-monitoring';
exports.WAZUH_SAMPLE_ALERTS_CATEGORY_AUDITING_POLICY_MONITORING = WAZUH_SAMPLE_ALERTS_CATEGORY_AUDITING_POLICY_MONITORING;
const WAZUH_SAMPLE_ALERTS_CATEGORY_THREAT_DETECTION = 'threat-detection';
exports.WAZUH_SAMPLE_ALERTS_CATEGORY_THREAT_DETECTION = WAZUH_SAMPLE_ALERTS_CATEGORY_THREAT_DETECTION;
const WAZUH_SAMPLE_ALERTS_DEFAULT_NUMBER_ALERTS = 3000;
exports.WAZUH_SAMPLE_ALERTS_DEFAULT_NUMBER_ALERTS = WAZUH_SAMPLE_ALERTS_DEFAULT_NUMBER_ALERTS;
const WAZUH_SAMPLE_ALERTS_CATEGORIES_TYPE_ALERTS = {
  [WAZUH_SAMPLE_ALERTS_CATEGORY_SECURITY]: [{
    syscheck: true
  }, {
    aws: true
  }, {
    office: true
  }, {
    gcp: true
  }, {
    authentication: true
  }, {
    ssh: true
  }, {
    apache: true,
    alerts: 2000
  }, {
    web: true
  }, {
    windows: {
      service_control_manager: true
    },
    alerts: 1000
  }, {
    github: true
  }],
  [WAZUH_SAMPLE_ALERTS_CATEGORY_AUDITING_POLICY_MONITORING]: [{
    rootcheck: true
  }, {
    audit: true
  }, {
    openscap: true
  }, {
    ciscat: true
  }],
  [WAZUH_SAMPLE_ALERTS_CATEGORY_THREAT_DETECTION]: [{
    vulnerabilities: true
  }, {
    virustotal: true
  }, {
    osquery: true
  }, {
    docker: true
  }, {
    mitre: true
  }]
}; // Security

exports.WAZUH_SAMPLE_ALERTS_CATEGORIES_TYPE_ALERTS = WAZUH_SAMPLE_ALERTS_CATEGORIES_TYPE_ALERTS;
const WAZUH_SECURITY_PLUGIN_XPACK_SECURITY = 'X-Pack Security';
exports.WAZUH_SECURITY_PLUGIN_XPACK_SECURITY = WAZUH_SECURITY_PLUGIN_XPACK_SECURITY;
const WAZUH_SECURITY_PLUGIN_OPEN_DISTRO_FOR_ELASTICSEARCH = 'Open Distro for Elasticsearch';
exports.WAZUH_SECURITY_PLUGIN_OPEN_DISTRO_FOR_ELASTICSEARCH = WAZUH_SECURITY_PLUGIN_OPEN_DISTRO_FOR_ELASTICSEARCH;
const WAZUH_SECURITY_PLUGINS = [WAZUH_SECURITY_PLUGIN_XPACK_SECURITY, WAZUH_SECURITY_PLUGIN_OPEN_DISTRO_FOR_ELASTICSEARCH]; // App configuration

exports.WAZUH_SECURITY_PLUGINS = WAZUH_SECURITY_PLUGINS;
const WAZUH_CONFIGURATION_CACHE_TIME = 10000; // time in ms;

exports.WAZUH_CONFIGURATION_CACHE_TIME = WAZUH_CONFIGURATION_CACHE_TIME;
const WAZUH_CONFIGURATION_SETTINGS_NEED_RESTART = ['wazuh.monitoring.enabled', 'wazuh.monitoring.frequency', 'cron.statistics.interval', 'logs.level'];
exports.WAZUH_CONFIGURATION_SETTINGS_NEED_RESTART = WAZUH_CONFIGURATION_SETTINGS_NEED_RESTART;
const WAZUH_CONFIGURATION_SETTINGS_NEED_HEALTH_CHECK = ['pattern', 'wazuh.monitoring.replicas', 'wazuh.monitoring.creation', 'wazuh.monitoring.pattern', 'alerts.sample.prefix', 'cron.statistics.index.name', 'cron.statistics.index.creation', 'cron.statistics.index.shards', 'cron.statistics.index.replicas', 'wazuh.monitoring.shards'];
exports.WAZUH_CONFIGURATION_SETTINGS_NEED_HEALTH_CHECK = WAZUH_CONFIGURATION_SETTINGS_NEED_HEALTH_CHECK;
const WAZUH_CONFIGURATION_SETTINGS_NEED_RELOAD = ['hideManagerAlerts', 'customization.logo.sidebar']; // Reserved ids for Users/Role mapping

exports.WAZUH_CONFIGURATION_SETTINGS_NEED_RELOAD = WAZUH_CONFIGURATION_SETTINGS_NEED_RELOAD;
const WAZUH_API_RESERVED_ID_LOWER_THAN = 100; // Wazuh data path

exports.WAZUH_API_RESERVED_ID_LOWER_THAN = WAZUH_API_RESERVED_ID_LOWER_THAN;
const WAZUH_DATA_PLUGIN_PLATFORM_BASE_PATH = 'data';

const WAZUH_DATA_PLUGIN_PLATFORM_BASE_ABSOLUTE_PATH = _path.default.join(__dirname, '../../../', WAZUH_DATA_PLUGIN_PLATFORM_BASE_PATH);

exports.WAZUH_DATA_PLUGIN_PLATFORM_BASE_ABSOLUTE_PATH = WAZUH_DATA_PLUGIN_PLATFORM_BASE_ABSOLUTE_PATH;

const WAZUH_DATA_ABSOLUTE_PATH = _path.default.join(WAZUH_DATA_PLUGIN_PLATFORM_BASE_ABSOLUTE_PATH, 'wazuh'); // Wazuh data path - config


exports.WAZUH_DATA_ABSOLUTE_PATH = WAZUH_DATA_ABSOLUTE_PATH;

const WAZUH_DATA_CONFIG_DIRECTORY_PATH = _path.default.join(WAZUH_DATA_ABSOLUTE_PATH, 'config');

exports.WAZUH_DATA_CONFIG_DIRECTORY_PATH = WAZUH_DATA_CONFIG_DIRECTORY_PATH;

const WAZUH_DATA_CONFIG_APP_PATH = _path.default.join(WAZUH_DATA_CONFIG_DIRECTORY_PATH, 'wazuh.yml');

exports.WAZUH_DATA_CONFIG_APP_PATH = WAZUH_DATA_CONFIG_APP_PATH;

const WAZUH_DATA_CONFIG_REGISTRY_PATH = _path.default.join(WAZUH_DATA_CONFIG_DIRECTORY_PATH, 'wazuh-registry.json'); // Wazuh data path - logs


exports.WAZUH_DATA_CONFIG_REGISTRY_PATH = WAZUH_DATA_CONFIG_REGISTRY_PATH;
const MAX_MB_LOG_FILES = 100;
exports.MAX_MB_LOG_FILES = MAX_MB_LOG_FILES;

const WAZUH_DATA_LOGS_DIRECTORY_PATH = _path.default.join(WAZUH_DATA_ABSOLUTE_PATH, 'logs');

exports.WAZUH_DATA_LOGS_DIRECTORY_PATH = WAZUH_DATA_LOGS_DIRECTORY_PATH;
const WAZUH_DATA_LOGS_PLAIN_FILENAME = 'wazuhapp-plain.log';
exports.WAZUH_DATA_LOGS_PLAIN_FILENAME = WAZUH_DATA_LOGS_PLAIN_FILENAME;

const WAZUH_DATA_LOGS_PLAIN_PATH = _path.default.join(WAZUH_DATA_LOGS_DIRECTORY_PATH, WAZUH_DATA_LOGS_PLAIN_FILENAME);

exports.WAZUH_DATA_LOGS_PLAIN_PATH = WAZUH_DATA_LOGS_PLAIN_PATH;
const WAZUH_DATA_LOGS_RAW_FILENAME = 'wazuhapp.log';
exports.WAZUH_DATA_LOGS_RAW_FILENAME = WAZUH_DATA_LOGS_RAW_FILENAME;

const WAZUH_DATA_LOGS_RAW_PATH = _path.default.join(WAZUH_DATA_LOGS_DIRECTORY_PATH, WAZUH_DATA_LOGS_RAW_FILENAME); // Wazuh data path - UI logs


exports.WAZUH_DATA_LOGS_RAW_PATH = WAZUH_DATA_LOGS_RAW_PATH;
const WAZUH_UI_LOGS_PLAIN_FILENAME = 'wazuh-ui-plain.log';
exports.WAZUH_UI_LOGS_PLAIN_FILENAME = WAZUH_UI_LOGS_PLAIN_FILENAME;
const WAZUH_UI_LOGS_RAW_FILENAME = 'wazuh-ui.log';
exports.WAZUH_UI_LOGS_RAW_FILENAME = WAZUH_UI_LOGS_RAW_FILENAME;

const WAZUH_UI_LOGS_PLAIN_PATH = _path.default.join(WAZUH_DATA_LOGS_DIRECTORY_PATH, WAZUH_UI_LOGS_PLAIN_FILENAME);

exports.WAZUH_UI_LOGS_PLAIN_PATH = WAZUH_UI_LOGS_PLAIN_PATH;

const WAZUH_UI_LOGS_RAW_PATH = _path.default.join(WAZUH_DATA_LOGS_DIRECTORY_PATH, WAZUH_UI_LOGS_RAW_FILENAME); // Wazuh data path - downloads


exports.WAZUH_UI_LOGS_RAW_PATH = WAZUH_UI_LOGS_RAW_PATH;

const WAZUH_DATA_DOWNLOADS_DIRECTORY_PATH = _path.default.join(WAZUH_DATA_ABSOLUTE_PATH, 'downloads');

exports.WAZUH_DATA_DOWNLOADS_DIRECTORY_PATH = WAZUH_DATA_DOWNLOADS_DIRECTORY_PATH;

const WAZUH_DATA_DOWNLOADS_REPORTS_DIRECTORY_PATH = _path.default.join(WAZUH_DATA_DOWNLOADS_DIRECTORY_PATH, 'reports'); // Queue


exports.WAZUH_DATA_DOWNLOADS_REPORTS_DIRECTORY_PATH = WAZUH_DATA_DOWNLOADS_REPORTS_DIRECTORY_PATH;
const WAZUH_QUEUE_CRON_FREQ = '*/15 * * * * *'; // Every 15 seconds
// Default App Config

exports.WAZUH_QUEUE_CRON_FREQ = WAZUH_QUEUE_CRON_FREQ;
const WAZUH_DEFAULT_APP_CONFIG = {
  pattern: WAZUH_ALERTS_PATTERN,
  'checks.pattern': true,
  'checks.template': true,
  'checks.api': true,
  'checks.setup': true,
  'checks.fields': true,
  'checks.metaFields': true,
  'checks.maxBuckets': true,
  'checks.timeFilter': true,
  'extensions.pci': true,
  'extensions.gdpr': true,
  'extensions.hipaa': true,
  'extensions.nist': true,
  'extensions.tsc': true,
  'extensions.audit': true,
  'extensions.oscap': false,
  'extensions.ciscat': false,
  'extensions.aws': false,
  'extensions.office': false,
  'extensions.github': false,
  'extensions.gcp': false,
  'extensions.virustotal': false,
  'extensions.osquery': false,
  'extensions.docker': false,
  timeout: 20000,
  'ip.selector': true,
  'ip.ignore': [],
  'xpack.rbac.enabled': true,
  'wazuh.monitoring.enabled': WAZUH_MONITORING_DEFAULT_ENABLED,
  'wazuh.monitoring.frequency': WAZUH_MONITORING_DEFAULT_FREQUENCY,
  'wazuh.monitoring.shards': WAZUH_MONITORING_DEFAULT_INDICES_SHARDS,
  'wazuh.monitoring.replicas': WAZUH_MONITORING_DEFAULT_INDICES_REPLICAS,
  'wazuh.monitoring.creation': WAZUH_MONITORING_DEFAULT_CREATION,
  'wazuh.monitoring.pattern': WAZUH_MONITORING_PATTERN,
  'cron.prefix': WAZUH_STATISTICS_DEFAULT_PREFIX,
  'cron.statistics.status': WAZUH_STATISTICS_DEFAULT_STATUS,
  'cron.statistics.apis': [],
  'cron.statistics.interval': WAZUH_STATISTICS_DEFAULT_CRON_FREQ,
  'cron.statistics.index.name': WAZUH_STATISTICS_DEFAULT_NAME,
  'cron.statistics.index.creation': WAZUH_STATISTICS_DEFAULT_CREATION,
  'cron.statistics.index.shards': WAZUH_STATISTICS_DEFAULT_INDICES_SHARDS,
  'cron.statistics.index.replicas': WAZUH_STATISTICS_DEFAULT_INDICES_REPLICAS,
  'alerts.sample.prefix': WAZUH_SAMPLE_ALERT_PREFIX,
  hideManagerAlerts: false,
  'logs.level': 'info',
  'enrollment.dns': '',
  'enrollment.password': '',
  'customization.logo.app': '',
  'customization.logo.sidebar': '',
  'customization.logo.healthcheck': '',
  'customization.logo.reports': ''
}; // Wazuh errors

exports.WAZUH_DEFAULT_APP_CONFIG = WAZUH_DEFAULT_APP_CONFIG;
const WAZUH_ERROR_DAEMONS_NOT_READY = 'ERROR3099'; // Agents

exports.WAZUH_ERROR_DAEMONS_NOT_READY = WAZUH_ERROR_DAEMONS_NOT_READY;
let WAZUH_AGENTS_OS_TYPE;
exports.WAZUH_AGENTS_OS_TYPE = WAZUH_AGENTS_OS_TYPE;

(function (WAZUH_AGENTS_OS_TYPE) {
  WAZUH_AGENTS_OS_TYPE["WINDOWS"] = "windows";
  WAZUH_AGENTS_OS_TYPE["LINUX"] = "linux";
  WAZUH_AGENTS_OS_TYPE["SUNOS"] = "sunos";
  WAZUH_AGENTS_OS_TYPE["DARWIN"] = "darwin";
  WAZUH_AGENTS_OS_TYPE["OTHERS"] = "";
})(WAZUH_AGENTS_OS_TYPE || (exports.WAZUH_AGENTS_OS_TYPE = WAZUH_AGENTS_OS_TYPE = {}));

let WAZUH_MODULES_ID;
exports.WAZUH_MODULES_ID = WAZUH_MODULES_ID;

(function (WAZUH_MODULES_ID) {
  WAZUH_MODULES_ID["SECURITY_EVENTS"] = "general";
  WAZUH_MODULES_ID["INTEGRITY_MONITORING"] = "fim";
  WAZUH_MODULES_ID["AMAZON_WEB_SERVICES"] = "aws";
  WAZUH_MODULES_ID["OFFICE_365"] = "office";
  WAZUH_MODULES_ID["GOOGLE_CLOUD_PLATFORM"] = "gcp";
  WAZUH_MODULES_ID["POLICY_MONITORING"] = "pm";
  WAZUH_MODULES_ID["SECURITY_CONFIGURATION_ASSESSMENT"] = "sca";
  WAZUH_MODULES_ID["AUDITING"] = "audit";
  WAZUH_MODULES_ID["OPEN_SCAP"] = "oscap";
  WAZUH_MODULES_ID["VULNERABILITIES"] = "vuls";
  WAZUH_MODULES_ID["OSQUERY"] = "osquery";
  WAZUH_MODULES_ID["DOCKER"] = "docker";
  WAZUH_MODULES_ID["MITRE_ATTACK"] = "mitre";
  WAZUH_MODULES_ID["PCI_DSS"] = "pci";
  WAZUH_MODULES_ID["HIPAA"] = "hipaa";
  WAZUH_MODULES_ID["NIST_800_53"] = "nist";
  WAZUH_MODULES_ID["TSC"] = "tsc";
  WAZUH_MODULES_ID["CIS_CAT"] = "ciscat";
  WAZUH_MODULES_ID["VIRUSTOTAL"] = "virustotal";
  WAZUH_MODULES_ID["GDPR"] = "gdpr";
  WAZUH_MODULES_ID["GITHUB"] = "github";
})(WAZUH_MODULES_ID || (exports.WAZUH_MODULES_ID = WAZUH_MODULES_ID = {}));

;
let WAZUH_MENU_MANAGEMENT_SECTIONS_ID;
exports.WAZUH_MENU_MANAGEMENT_SECTIONS_ID = WAZUH_MENU_MANAGEMENT_SECTIONS_ID;

(function (WAZUH_MENU_MANAGEMENT_SECTIONS_ID) {
  WAZUH_MENU_MANAGEMENT_SECTIONS_ID["MANAGEMENT"] = "management";
  WAZUH_MENU_MANAGEMENT_SECTIONS_ID["ADMINISTRATION"] = "administration";
  WAZUH_MENU_MANAGEMENT_SECTIONS_ID["RULESET"] = "ruleset";
  WAZUH_MENU_MANAGEMENT_SECTIONS_ID["RULES"] = "rules";
  WAZUH_MENU_MANAGEMENT_SECTIONS_ID["DECODERS"] = "decoders";
  WAZUH_MENU_MANAGEMENT_SECTIONS_ID["CDB_LISTS"] = "lists";
  WAZUH_MENU_MANAGEMENT_SECTIONS_ID["GROUPS"] = "groups";
  WAZUH_MENU_MANAGEMENT_SECTIONS_ID["CONFIGURATION"] = "configuration";
  WAZUH_MENU_MANAGEMENT_SECTIONS_ID["STATUS_AND_REPORTS"] = "statusReports";
  WAZUH_MENU_MANAGEMENT_SECTIONS_ID["STATUS"] = "status";
  WAZUH_MENU_MANAGEMENT_SECTIONS_ID["CLUSTER"] = "monitoring";
  WAZUH_MENU_MANAGEMENT_SECTIONS_ID["LOGS"] = "logs";
  WAZUH_MENU_MANAGEMENT_SECTIONS_ID["REPORTING"] = "reporting";
  WAZUH_MENU_MANAGEMENT_SECTIONS_ID["STATISTICS"] = "statistics";
})(WAZUH_MENU_MANAGEMENT_SECTIONS_ID || (exports.WAZUH_MENU_MANAGEMENT_SECTIONS_ID = WAZUH_MENU_MANAGEMENT_SECTIONS_ID = {}));

;
let WAZUH_MENU_TOOLS_SECTIONS_ID;
exports.WAZUH_MENU_TOOLS_SECTIONS_ID = WAZUH_MENU_TOOLS_SECTIONS_ID;

(function (WAZUH_MENU_TOOLS_SECTIONS_ID) {
  WAZUH_MENU_TOOLS_SECTIONS_ID["API_CONSOLE"] = "devTools";
  WAZUH_MENU_TOOLS_SECTIONS_ID["RULESET_TEST"] = "logtest";
})(WAZUH_MENU_TOOLS_SECTIONS_ID || (exports.WAZUH_MENU_TOOLS_SECTIONS_ID = WAZUH_MENU_TOOLS_SECTIONS_ID = {}));

;
let WAZUH_MENU_SECURITY_SECTIONS_ID;
exports.WAZUH_MENU_SECURITY_SECTIONS_ID = WAZUH_MENU_SECURITY_SECTIONS_ID;

(function (WAZUH_MENU_SECURITY_SECTIONS_ID) {
  WAZUH_MENU_SECURITY_SECTIONS_ID["USERS"] = "users";
  WAZUH_MENU_SECURITY_SECTIONS_ID["ROLES"] = "roles";
  WAZUH_MENU_SECURITY_SECTIONS_ID["POLICIES"] = "policies";
  WAZUH_MENU_SECURITY_SECTIONS_ID["ROLES_MAPPING"] = "roleMapping";
})(WAZUH_MENU_SECURITY_SECTIONS_ID || (exports.WAZUH_MENU_SECURITY_SECTIONS_ID = WAZUH_MENU_SECURITY_SECTIONS_ID = {}));

;
let WAZUH_MENU_SETTINGS_SECTIONS_ID;
exports.WAZUH_MENU_SETTINGS_SECTIONS_ID = WAZUH_MENU_SETTINGS_SECTIONS_ID;

(function (WAZUH_MENU_SETTINGS_SECTIONS_ID) {
  WAZUH_MENU_SETTINGS_SECTIONS_ID["SETTINGS"] = "settings";
  WAZUH_MENU_SETTINGS_SECTIONS_ID["API_CONFIGURATION"] = "api";
  WAZUH_MENU_SETTINGS_SECTIONS_ID["MODULES"] = "modules";
  WAZUH_MENU_SETTINGS_SECTIONS_ID["SAMPLE_DATA"] = "sample_data";
  WAZUH_MENU_SETTINGS_SECTIONS_ID["CONFIGURATION"] = "configuration";
  WAZUH_MENU_SETTINGS_SECTIONS_ID["LOGS"] = "logs";
  WAZUH_MENU_SETTINGS_SECTIONS_ID["MISCELLANEOUS"] = "miscellaneous";
  WAZUH_MENU_SETTINGS_SECTIONS_ID["ABOUT"] = "about";
})(WAZUH_MENU_SETTINGS_SECTIONS_ID || (exports.WAZUH_MENU_SETTINGS_SECTIONS_ID = WAZUH_MENU_SETTINGS_SECTIONS_ID = {}));

;
const AUTHORIZED_AGENTS = 'authorized-agents'; // Wazuh links

exports.AUTHORIZED_AGENTS = AUTHORIZED_AGENTS;
const WAZUH_LINK_GITHUB = 'https://github.com/wazuh';
exports.WAZUH_LINK_GITHUB = WAZUH_LINK_GITHUB;
const WAZUH_LINK_GOOGLE_GROUPS = 'https://groups.google.com/forum/#!forum/wazuh';
exports.WAZUH_LINK_GOOGLE_GROUPS = WAZUH_LINK_GOOGLE_GROUPS;
const WAZUH_LINK_SLACK = 'https://wazuh.com/community/join-us-on-slack';
exports.WAZUH_LINK_SLACK = WAZUH_LINK_SLACK;
const HEALTH_CHECK = 'health-check'; // Health check

exports.HEALTH_CHECK = HEALTH_CHECK;
const HEALTH_CHECK_REDIRECTION_TIME = 300; //ms
// Plugin platform settings
// Default timeFilter set by the app

exports.HEALTH_CHECK_REDIRECTION_TIME = HEALTH_CHECK_REDIRECTION_TIME;
const WAZUH_PLUGIN_PLATFORM_SETTING_TIME_FILTER = {
  from: 'now-24h',
  to: 'now'
};
exports.WAZUH_PLUGIN_PLATFORM_SETTING_TIME_FILTER = WAZUH_PLUGIN_PLATFORM_SETTING_TIME_FILTER;
const PLUGIN_PLATFORM_SETTING_NAME_TIME_FILTER = 'timepicker:timeDefaults'; // Default maxBuckets set by the app

exports.PLUGIN_PLATFORM_SETTING_NAME_TIME_FILTER = PLUGIN_PLATFORM_SETTING_NAME_TIME_FILTER;
const WAZUH_PLUGIN_PLATFORM_SETTING_MAX_BUCKETS = 200000;
exports.WAZUH_PLUGIN_PLATFORM_SETTING_MAX_BUCKETS = WAZUH_PLUGIN_PLATFORM_SETTING_MAX_BUCKETS;
const PLUGIN_PLATFORM_SETTING_NAME_MAX_BUCKETS = 'timelion:max_buckets'; // Default metaFields set by the app

exports.PLUGIN_PLATFORM_SETTING_NAME_MAX_BUCKETS = PLUGIN_PLATFORM_SETTING_NAME_MAX_BUCKETS;
const WAZUH_PLUGIN_PLATFORM_SETTING_METAFIELDS = ['_source', '_index'];
exports.WAZUH_PLUGIN_PLATFORM_SETTING_METAFIELDS = WAZUH_PLUGIN_PLATFORM_SETTING_METAFIELDS;
const PLUGIN_PLATFORM_SETTING_NAME_METAFIELDS = 'metaFields'; // Logger

exports.PLUGIN_PLATFORM_SETTING_NAME_METAFIELDS = PLUGIN_PLATFORM_SETTING_NAME_METAFIELDS;
const UI_LOGGER_LEVELS = {
  WARNING: 'WARNING',
  INFO: 'INFO',
  ERROR: 'ERROR'
};
exports.UI_LOGGER_LEVELS = UI_LOGGER_LEVELS;
const UI_TOAST_COLOR = {
  SUCCESS: 'success',
  WARNING: 'warning',
  DANGER: 'danger'
}; // Assets

exports.UI_TOAST_COLOR = UI_TOAST_COLOR;
const ASSETS_BASE_URL_PREFIX = '/plugins/wazuh/assets/';
exports.ASSETS_BASE_URL_PREFIX = ASSETS_BASE_URL_PREFIX;
const ASSETS_PUBLIC_URL = '/plugins/wazuh/public/assets/'; // Reports

exports.ASSETS_PUBLIC_URL = ASSETS_PUBLIC_URL;
const REPORTS_LOGO_IMAGE_ASSETS_RELATIVE_PATH = 'images/logo_reports.png';
exports.REPORTS_LOGO_IMAGE_ASSETS_RELATIVE_PATH = REPORTS_LOGO_IMAGE_ASSETS_RELATIVE_PATH;
const REPORTS_PRIMARY_COLOR = '#256BD1';
exports.REPORTS_PRIMARY_COLOR = REPORTS_PRIMARY_COLOR;
const REPORTS_PAGE_FOOTER_TEXT = 'Copyright © 2022 Wazuh, Inc.';
exports.REPORTS_PAGE_FOOTER_TEXT = REPORTS_PAGE_FOOTER_TEXT;
const REPORTS_PAGE_HEADER_TEXT = 'info@wazuh.com\nhttps://wazuh.com'; // Plugin platform

exports.REPORTS_PAGE_HEADER_TEXT = REPORTS_PAGE_HEADER_TEXT;
const PLUGIN_PLATFORM_NAME = 'Kibana';
exports.PLUGIN_PLATFORM_NAME = PLUGIN_PLATFORM_NAME;
const PLUGIN_PLATFORM_BASE_INSTALLATION_PATH = '/usr/share/kibana/data/wazuh/';
exports.PLUGIN_PLATFORM_BASE_INSTALLATION_PATH = PLUGIN_PLATFORM_BASE_INSTALLATION_PATH;
const PLUGIN_PLATFORM_INSTALLATION_USER = 'kibana';
exports.PLUGIN_PLATFORM_INSTALLATION_USER = PLUGIN_PLATFORM_INSTALLATION_USER;
const PLUGIN_PLATFORM_INSTALLATION_USER_GROUP = 'kibana';
exports.PLUGIN_PLATFORM_INSTALLATION_USER_GROUP = PLUGIN_PLATFORM_INSTALLATION_USER_GROUP;
const PLUGIN_PLATFORM_WAZUH_DOCUMENTATION_URL_PATH_UPGRADE_PLATFORM = 'upgrade-guide';
exports.PLUGIN_PLATFORM_WAZUH_DOCUMENTATION_URL_PATH_UPGRADE_PLATFORM = PLUGIN_PLATFORM_WAZUH_DOCUMENTATION_URL_PATH_UPGRADE_PLATFORM;
const PLUGIN_PLATFORM_WAZUH_DOCUMENTATION_URL_PATH_TROUBLESHOOTING = 'user-manual/elasticsearch/troubleshooting.html';
exports.PLUGIN_PLATFORM_WAZUH_DOCUMENTATION_URL_PATH_TROUBLESHOOTING = PLUGIN_PLATFORM_WAZUH_DOCUMENTATION_URL_PATH_TROUBLESHOOTING;
const PLUGIN_PLATFORM_WAZUH_DOCUMENTATION_URL_PATH_APP_CONFIGURATION = 'user-manual/wazuh-dashboard/config-file.html';
exports.PLUGIN_PLATFORM_WAZUH_DOCUMENTATION_URL_PATH_APP_CONFIGURATION = PLUGIN_PLATFORM_WAZUH_DOCUMENTATION_URL_PATH_APP_CONFIGURATION;
const PLUGIN_PLATFORM_URL_GUIDE = 'https://www.elastic.co/guide/en/elasticsearch/reference/current/index.html';
exports.PLUGIN_PLATFORM_URL_GUIDE = PLUGIN_PLATFORM_URL_GUIDE;
const PLUGIN_PLATFORM_URL_GUIDE_TITLE = 'Elastic guide';
exports.PLUGIN_PLATFORM_URL_GUIDE_TITLE = PLUGIN_PLATFORM_URL_GUIDE_TITLE;
const PLUGIN_PLATFORM_REQUEST_HEADERS = {
  'kbn-xsrf': 'kibana'
}; // UI

exports.PLUGIN_PLATFORM_REQUEST_HEADERS = PLUGIN_PLATFORM_REQUEST_HEADERS;
const API_NAME_AGENT_STATUS = {
  ACTIVE: 'active',
  DISCONNECTED: 'disconnected',
  PENDING: 'pending',
  NEVER_CONNECTED: 'never_connected'
};
exports.API_NAME_AGENT_STATUS = API_NAME_AGENT_STATUS;
const UI_COLOR_AGENT_STATUS = {
  [API_NAME_AGENT_STATUS.ACTIVE]: '#007871',
  [API_NAME_AGENT_STATUS.DISCONNECTED]: '#BD271E',
  [API_NAME_AGENT_STATUS.PENDING]: '#FEC514',
  [API_NAME_AGENT_STATUS.NEVER_CONNECTED]: '#646A77',
  default: '#000000'
};
exports.UI_COLOR_AGENT_STATUS = UI_COLOR_AGENT_STATUS;
const UI_LABEL_NAME_AGENT_STATUS = {
  [API_NAME_AGENT_STATUS.ACTIVE]: 'Active',
  [API_NAME_AGENT_STATUS.DISCONNECTED]: 'Disconnected',
  [API_NAME_AGENT_STATUS.PENDING]: 'Pending',
  [API_NAME_AGENT_STATUS.NEVER_CONNECTED]: 'Never connected',
  default: 'Unknown'
};
exports.UI_LABEL_NAME_AGENT_STATUS = UI_LABEL_NAME_AGENT_STATUS;
const UI_ORDER_AGENT_STATUS = [API_NAME_AGENT_STATUS.ACTIVE, API_NAME_AGENT_STATUS.DISCONNECTED, API_NAME_AGENT_STATUS.PENDING, API_NAME_AGENT_STATUS.NEVER_CONNECTED]; // Documentation

exports.UI_ORDER_AGENT_STATUS = UI_ORDER_AGENT_STATUS;
const DOCUMENTATION_WEB_BASE_URL = "https://documentation.wazuh.com"; // Default Elasticsearch user name context

exports.DOCUMENTATION_WEB_BASE_URL = DOCUMENTATION_WEB_BASE_URL;
const ELASTIC_NAME = 'elastic';
exports.ELASTIC_NAME = ELASTIC_NAME;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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