"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KeyEquivalence = void 0;

/*
 * Wazuh app - Wazuh CSV column keys
 * Copyright (C) 2015-2022 Wazuh, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Find more information about this on the LICENSE file.
 */
const KeyEquivalence = {
  id: 'ID',
  timestamp: 'Timestamp',
  url: 'URL',
  version: 'Version',
  'os.name': 'OS name',
  'os.version': 'OS version',
  'os.arch': 'OS version architecture',
  'os.build': 'OS version build',
  'os.codename': 'OS code name',
  'os.major': 'OS version major',
  'os.minor': 'OS version minor',
  'os.platform': 'OS platform',
  'os.uname': 'OS uname',
  status: 'Status',
  group: 'Group',
  ip: 'IP',
  description: 'Description',
  tag: 'Tag',
  level: 'Level',
  conf_sum: 'Group checksum',
  merged_sum: 'Configuration checksum',
  hash: 'Checksum',
  filename: 'File',
  file: 'File',
  gdpr: 'GDPR',
  pci: 'PCI',
  hipaa: 'HIPAA',
  'nist-800-53': 'NIST 800-53',
  cis: 'CIS',
  event: 'Event',
  groups: 'Groups',
  name: 'Name',
  count: 'Count',
  'details.program_name': 'Program name',
  'details.order': 'Order',
  vendor: 'Vendor',
  type: 'Type',
  architecture: 'Architecture',
  node_name: 'Node',
  dateAdd: 'Registration date',
  manager: 'Manager',
  lastKeepAlive: 'Last keep alive',
  os: 'OS',
  path: 'Path',
  details: 'Details',
  position: 'Position',
  configSum: 'Group checksum',
  mergedSum: 'Configuration checksum',
  key: 'Key',
  scan_id: 'Scan ID',
  format: 'Format',
  scan_time: 'Scan date',
  state: 'State',
  mac: 'MAC',
  gateway: 'Gateway',
  dhcp: 'DHCP',
  iface: 'Interface',
  broadcast: 'Broadcast',
  proto: 'Protocol',
  address: 'Address',
  protocol: 'Protocol',
  netmask: 'Netmask',
  'local.ip': 'Local IP',
  'remote.ip': 'Remote IP',
  'local.port': 'Local port',
  'remote.port': 'Remote port',
  euser: 'Effective user',
  egroup: 'Effective group',
  vm_size: 'VM size',
  processor: 'Processor',
  session: 'Session',
  tty: 'TTY',
  pid: 'PID',
  ppid: 'Parent PID',
  argvs: 'Argvs',
  nice: 'Priority',
  size: 'Size',
  uname: 'User',
  gname: 'Group',
  perm: 'Permissions',
  inode: 'Inode',
  uid: 'User ID',
  gid: 'Group ID',
  mtime: 'Last modified',
  priority: 'Priority',
  cmd: 'Command',
  nlwp: 'NLWP',
  process: 'Process',
  md5: 'MD5',
  sha1: 'SHA1',
  sha256: 'SHA256',
  title: 'Title',
  remediation: 'Remediation',
  references: 'References',
  result: 'Result',
  directory: 'Path(s)',
  rationale: 'Rationale',
  registry: 'Registry',
  date: 'Date',
  value: 'Value',
  location: 'Location',
  mtu: 'MTU',
  attributes: 'Attributes',
  policy_id: 'Policy ID',
  policy_ID: 'Policy ID',
  compliance: 'Compliance',
  rules: 'Rules',
  reason: 'Reason',
  registerIP: 'Register IP',
  hotfix: 'Update code',
  'scan.time': 'Registered by Wazuh at'
};
exports.KeyEquivalence = KeyEquivalence;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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