"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

/*
 * Wazuh app - Module for PCI requirements (Reporting)
 * Copyright (C) 2015-2022 Wazuh, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Find more information about this on the LICENSE file.
 */
var _default = {
  '1.1.1': 'A formal process for approving and testing all network connections and changes to the firewall and router configurations',
  '1.3.4': 'Do not allow unauthorized outbound traffic from the cardholder data environment to the Internet.',
  '1.4': {
    stack: ['Install personal firewall software or equivalent functionality on any portable computing devices (including company and/or employee-owned) that connect to the Internet when outside the network (for example, laptops used by employees), and which are also used to access the CDE. Firewall (or equivalent) configurations include:', {
      text: '\n'
    }, {
      ul: ['Specific configuration settings are defined.', 'Personal firewall (or equivalent functionality) is actively running.', 'Personal firewall (or equivalent functionality) is not alterable by users of the portable computing devices.']
    }]
  },
  '2.2': 'Develop configuration standards for all system components. Assure that these standards address all known security vulnerabilities and are consistent with industry accepted system hardening standards (CIS, ISO, SANS, NIST).',
  '2.2.2': 'Enable only necessary services, protocols, daemons, etc., as required for the function of the system. ',
  '2.2.3': 'Implement additional security features for any required services, protocols, or daemons that are considered to be insecure',
  '2.2.4': 'Configure system security parameters to prevent misuse.',
  '4.1': {
    stack: ['Use strong cryptography and security protocols (for example, SSL/TLS, IPSEC, SSH, etc.) to safeguard sensitive cardholder data during transmission over open, public networks, including the following:', {
      text: '\n'
    }, {
      ul: ['Only trusted keys and certificates are accepted.', 'The protocol in use only supports secure versions or configurations.', 'The encryption strength is appropriate for the encryption methodology in use.']
    }]
  },
  '5.1': 'Deploy anti-virus software on all systems commonly affected by malicious software (particularly personal computers and servers).',
  '5.2': {
    stack: ['Ensure that all anti-virus mechanisms are maintained as follows:', {
      text: '\n'
    }, {
      ul: ['Are kept current.', 'Perform periodic scans.', 'Generate audit logs which are retained per PCI DSS Requirement 10.7.']
    }]
  },
  '6.2': 'Ensure that all system components and software are protected from known vulnerabilities by installing applicable vendor-supplied security patches. Install critical security patches within one month of release.',
  '6.5': {
    stack: ['Address common coding vulnerabilities in software development processes as follows:', {
      text: '\n'
    }, {
      ul: ['Train developers in secure coding techniques, including how to avoid common coding vulnerabilities, and understanding how sensitive data is handled in memory.', 'Develop applications based on secure coding guidelines.']
    }]
  },
  '6.5.1': 'Injection flaws, particularly SQL injection. Also consider OS Command Injection, LDAP and XPath injection flaws as well as other injection flaws.',
  '6.5.2': 'Buffer overflows',
  '6.5.5': 'Improper error handling',
  '6.5.7': 'Cross-site scripting (XSS)',
  '6.5.8': 'Improper access control (such an insecure direct object references, failure to restrict URL access, directory traversal, and failure to restrict user access to functions).',
  '6.5.10': 'Broken authentication and session management.',
  '6.6': {
    stack: ['For public-facing web applications, address new threats and vulnerabilities on an ongoing basis and ensure these applications are protected against known attacks by either of the following methods:', {
      text: '\n'
    }, {
      ul: ['Reviewing public-facing web applications via manual or automated application vulnerability security assessment tools or methods, at least annually and after any changes', 'Installing an automated technical solution that detects and prevents web-based attacks (for example, a web-application firewall) in front of public-facing web applications, to continually check all traffic.']
    }]
  },
  '8.1.2': 'Control addition, deletion, and modification of user IDs, credentials, and other identifier objects.',
  '8.1.4': 'Remove/disable inactive user accounts within 90 days.',
  '8.1.5': {
    stack: ['Manage IDs used by third parties to access, support, or maintain system components via remote access as follows:', {
      text: '\n'
    }, {
      ul: ['Enabled only during the time period needed and disabled when not in use.', 'Monitored when in use.']
    }]
  },
  '8.1.6': 'Limit repeated access attempts by locking out the user ID after not more than six attempts.',
  '8.1.8': 'If a session has been idle for more than 15 minutes, require the user to reauthenticate to re-activate the terminal or session.',
  '8.2.4': 'Change user passwords/passphrases at least once every 90 days.',
  '8.5.1': 'Additional requirement for service providers: Service providers with remote access to customer premises (for example, for support of POS systems or servers) must use a unique authentication credential (such as a password/phrase) for each customer.',
  '8.7': {
    stack: ['All access to any database containing cardholder data (including access by applications, administrators, and all other users) is restricted as follows:', {
      text: '\n'
    }, {
      ul: ['All user access to, user queries of, and user actions on databases are through programmatic methods.', 'Only database administrators have the ability to directly access or query databases.', 'Application IDs for database applications can only be used by the applications (and not by individual users or other non-application processes).']
    }]
  },
  '10.1': 'Implement audit trails to link all access to system components to each individual user.',
  '10.2.1': 'All individual user accesses to cardholder data',
  '10.2.2': 'All actions taken by any individual with root or administrative privileges.',
  '10.2.4': 'Invalid logical access attempts',
  '10.2.5': 'Use of and changes to identification and authentication mechanisms including but not limited to creation of new accounts and elevation of privileges and all changes, additions, or deletions to accounts with root or administrative privileges.',
  '10.2.6': 'Initialization, stopping, or pausing of the audit logs',
  '10.2.7': 'Creation and deletion of system level objects',
  '10.5.2': 'Protect audit trail files from unauthorized modifications',
  '10.5.5': 'Use file integrity monitoring or change detection software on logs to ensure that existing log data cannot be changed without generating alerts (although new data being added should not cause an alert).',
  '10.4': 'Using time-synchronization technology, synchronize all critical system clocks and times and ensure that the following is implemented for acquiring, distributing, and storing time.',
  '10.6': 'Review logs and security events for all system components to identify anomalies or suspicious activity',
  '10.6.1': {
    stack: ['Review the following at least daily:', {
      text: '\n'
    }, {
      ul: ['All security events.', 'Logs of all system components that store, process, or transmit CHD and/or SAD, or that could impact the security of CHD and/or SAD.', 'Logs of all critical system components.', 'Logs of all servers and system components that perform security functions (for example, firewalls, intrusion detection systems/intrusion prevention systems (IDS/IPS), authentication servers, ecommerce redirection servers, etc.)']
    }],
    style: 'standard'
  },
  '11.4': 'Use intrusion detection and/or intrusion prevention techniques to detect and/or prevent intrusions into the network. Monitor all traffic at the perimeter of the cardholder data environment as well as at critical points in the cardholder data environment, and alert personnel to suspected compromises. Keep all intrusion detection and prevention engines, baselines, and signatures up to date.',
  '11.5': 'Deploy a change detection mechanism (for example, file integrity monitoring tools) to alert personnel to unauthorized modification of critical system files, configuration files, or content files; and configure the software to perform critical file comparisons at least weekly.'
};
exports.default = _default;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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