"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

/*
 * Wazuh app - Module for TSC requirements (Reporting)
 * Copyright (C) 2015-2022 Wazuh, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Find more information about this on the LICENSE file.
 */
var _default = {
  'A1.1': {
    stack: ['The entity maintains, monitors, and evaluates current processing capacity and use of system components (infrastructure, data, and software) to manage capacity demand and to enable the implementation of additional capacity to help meet its objectives', {
      text: '\n'
    }, {
      ul: ['Measures Current Usage', 'Forecasts Capacity', 'Makes Changes Based on Forecasts']
    }]
  },
  'A1.2': {
    stack: ['The entity authorizes, designs, develops or acquires, implements, operates, approves, maintains, and monitors environmental protections, software, data backup processes, and recovery infrastructure to meet its objectives.', {
      text: '\n'
    }, {
      ul: ['Identifies Environmental Threats', 'Designs Detection Measures', 'Implements and Maintains Environmental Protection Mechanisms', 'Implements Alerts to Analyze Anomalies', 'Responds to Environmental Threat Events —', 'Communicates and Reviews Detected Environmental Threat Events', 'Determines Data Requiring Backup', 'Performs Data Backup', 'Addresses Offsite Storage', 'Implements Alternate Processing Infrastructure']
    }]
  },
  'CC5.1': {
    stack: ['The entity selects and develops control activities that contribute to the mitigation of risks to the achievement of objectives to acceptable levels.', {
      text: '\n'
    }, {
      ul: ['Integrates With Risk Assessment', 'Considers Entity-Specific Factors', 'Determines Relevant Business Processes', 'Evaluates a Mix of Control Activity Types', 'Considers at What Level Activities Are Applied', 'Addresses Segregation of Duties']
    }]
  },
  'CC5.2': {
    stack: ['The entity also selects and develops general control activities over technology to support the achievement of objectives.', {
      text: '\n'
    }, {
      ul: ['Determines Dependency Between the Use of Technology in Business Processes and Technology General Controls', 'Establishes Relevant Technology Infrastructure Control Activities', 'Establishes Relevant Security Management Process Controls Activities', 'Establishes Relevant Technology Acquisition, Development, and Maintenance Process Control Activities']
    }]
  },
  'CC6.1': {
    stack: ["The entity implements logical access security software, infrastructure, and architectures over protected information assets to protect them from security events to meet the entity's objectives.", {
      text: '\n'
    }, {
      ul: ['Identifies and Manages the Inventory of Information Assets', 'Restricts Logical Access', 'Identifies and Authenticates Users', 'Considers Network Segmentation', 'Manages Points of Access', 'Restricts Access to Information Assets', 'Manages Identification and Authentication', 'Manages Credentials for Infrastructure and Software', 'Uses Encryption to Protect Data', 'Protects Encryption Keys']
    }]
  },
  'CC6.2': {
    stack: ['Prior to issuing system credentials and granting system access, the entity registers and authorizes new internal and external users whose access is administered by the entity. For those users whose access is administered by the entity, user system credentials are removed when user access is no longer authorized.', {
      text: '\n'
    }, {
      ul: ['Controls Access Credentials to Protected Assets', 'Removes Access to Protected Assets When Appropriate', 'Reviews Appropriateness of Access Credentials']
    }]
  },
  'CC6.3': {
    stack: ['The entity authorizes, modifies, or removes access to data, software, functions, and other protected information assets based on roles, responsibilities, or the system design and changes, giving consideration to the concepts of least privilege and segregation of duties, to meet the entity’s objectives.', {
      text: '\n'
    }, {
      ul: ['Creates or Modifies Access to Protected Information Assets', 'Removes Access to Protected Information Assets', 'Uses Role-Based Access Controls', 'Reviews Access Roles and Rules']
    }]
  },
  'CC6.4': {
    stack: ['The entity restricts physical access to facilities and protected information assets (for example, data center facilities, backup media storage, and other sensitive locations) to authorized personnel to meet the entity’s objectives', {
      text: '\n'
    }, {
      ul: ['Creates or Modifies Physical Access', 'Removes Physical Access', 'Reviews Physical Access']
    }]
  },
  'CC6.6': {
    stack: ['The entity implements logical access security measures to protect against threats from sources outside its system boundaries.', {
      text: '\n'
    }, {
      ul: ['Restricts Access', 'Protects Identification and Authentication Credentials', 'Requires Additional Authentication or Credentials', 'Implements Boundary Protection Systems']
    }]
  },
  'CC6.7': {
    stack: ['The entity restricts the transmission, movement, and removal of information to authorized internal and external users and processes, and protects it during transmission, movement, or removal to meet the entity’s objectives.', {
      text: '\n'
    }, {
      ul: ['Restricts the Ability to Perform Transmission', 'Uses Encryption Technologies or Secure Communication Channels to Protect Data', 'Protects Removal Media', 'Protects Mobile Devices']
    }]
  },
  'CC6.8': {
    stack: ['The entity implements controls to prevent or detect and act upon the introduction of unauthorized or malicious software to meet the entity’s objectives.', {
      text: '\n'
    }, {
      ul: ['Restricts Application and Software Installation', 'Detects Unauthorized Changes to Software and Configuration Parameters', 'Uses a Defined Change Control Process', 'Uses Antivirus and Anti-Malware Software', 'Scans Information Assets from Outside the Entity for Malware and Other Unauthorized Software']
    }]
  },
  'CC7.1': {
    stack: ['To meet its objectives, the entity uses detection and monitoring procedures to identify (1) changes to configurations that result in the introduction of new vulnerabilities, and (2) susceptibilities to newly discovered vulnerabilities.', {
      text: '\n'
    }, {
      ul: ['Uses Defined Configuration Standards', 'Monitors Infrastructure and Software', 'Implements Change-Detection Mechanisms', 'Detects Unknown or Unauthorized Components', 'Conducts Vulnerability Scans']
    }]
  },
  'CC7.2': {
    stack: ["The entity monitors system components and the operation of those components for anomalies that are indicative of malicious acts, natural disasters, and errors affecting the entity's ability to meet its objectives; anomalies are analyzed to determine whether they represent security events.", {
      text: '\n'
    }, {
      ul: ['Implements Detection Policies, Procedures, and Tools', 'Designs Detection Measures', 'Implements Filters to Analyze Anomalies', 'Monitors Detection Tools for Effective Operation']
    }]
  },
  'CC7.3': {
    stack: ['The entity evaluates security events to determine whether they could or have resulted in a failure of the entity to meet its objectives (security incidents) and, if so, takes actions to prevent or address such failures.', {
      text: '\n'
    }, {
      ul: ['Responds to Security Incidents', 'Communicates and Reviews Detected Security Events', 'Develops and Implements Procedures to Analyze Security Incidents']
    }]
  },
  'CC7.4': {
    stack: ['The entity responds to identified security incidents by executing a defined incident-response program to understand, contain, remediate, and communicate security incidents, as appropriate.', {
      text: '\n'
    }, {
      ul: ['Assigns Roles and Responsibilities', 'Contains Security Incidents', 'Mitigates Ongoing Security Incidents', 'Ends Threats Posed by Security Incidents', 'Restores Operations', 'Develops and Implements Communication Protocols for Security Incidents', 'Obtains Understanding of Nature of Incident and Determines Containment Strategy', 'Remediates Identified Vulnerabilities', 'Communicates Remediation Activities', 'Evaluates the Effectiveness of Incident Response', 'Periodically Evaluates Incidents']
    }]
  },
  'CC8.1': {
    stack: ['The entity authorizes, designs, develops or acquires, configures, documents, tests, approves, and implements changes to infrastructure, data, software, and procedures to meet its objectives', {
      text: '\n'
    }, {
      ul: ['Manages Changes Throughout the System Life Cycle', 'Authorizes Changes', 'Designs and Develops Changes', 'Documents Changes', 'Tracks System Changes', 'Configures Software', 'Tests System Changes ', 'Approves System Changes', 'Deploys System Changes', 'Identifies and Evaluates System Changes', 'Identifies Changes in Infrastructure, Data, Software, and Procedures Required to Remediate Incidents', 'Creates Baseline Configuration of IT Technology', 'Provides for Changes Necessary in Emergency Situations']
    }]
  },
  'PI1.4': {
    stack: ['The entity implements policies and procedures to make available or deliver output completely, accurately, and timely in accordance with specifications to meet the entity’s objectives.', {
      text: '\n'
    }, {
      ul: ['Protects Output', 'Distributes Output Only to Intended Parties', 'Distributes Output Completely and Accurately', 'Creates and Maintains Records of System Output Activities']
    }]
  },
  'PI1.5': {
    stack: ['The entity implements policies and procedures to store inputs, items in processing, and outputs completely, accurately, and timely in accordance with system specifications to meet the entity’s objectives.', {
      text: '\n'
    }, {
      ul: ['Protects Stored Items', 'Archives and Protects System Records', 'Stores Data Completely and Accurately', 'Creates and Maintains Records of System Storage Activities']
    }]
  }
};
exports.default = _default;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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