"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDataDirectoryRelative = exports.createDataDirectoryIfNotExists = exports.createLogFileIfNotExists = exports.createDirectoryIfNotExists = void 0;

var _fs = _interopRequireDefault(require("fs"));

var _path = _interopRequireDefault(require("path"));

var _constants = require("../../common/constants");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const createDirectoryIfNotExists = directory => {
  if (!_fs.default.existsSync(directory)) {
    _fs.default.mkdirSync(directory);
  }
};

exports.createDirectoryIfNotExists = createDirectoryIfNotExists;

const createLogFileIfNotExists = filePath => {
  if (!_fs.default.existsSync(filePath)) {
    _fs.default.closeSync(_fs.default.openSync(filePath, 'w'));
  }
};

exports.createLogFileIfNotExists = createLogFileIfNotExists;

const createDataDirectoryIfNotExists = directory => {
  const absoluteRoute = directory ? _path.default.join(_constants.WAZUH_DATA_ABSOLUTE_PATH, directory) : _constants.WAZUH_DATA_ABSOLUTE_PATH;

  if (!_fs.default.existsSync(absoluteRoute)) {
    _fs.default.mkdirSync(absoluteRoute);
  }
};

exports.createDataDirectoryIfNotExists = createDataDirectoryIfNotExists;

const getDataDirectoryRelative = directory => {
  return _path.default.join(_constants.WAZUH_DATA_ABSOLUTE_PATH, directory);
};

exports.getDataDirectoryRelative = getDataDirectoryRelative;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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