"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.randomArrayItem = exports.randomElements = exports.GeoLocation = exports.Agents = exports.Paths = exports.Win_Hostnames = exports.Ports = exports.Users = exports.IPs = void 0;

/*
 * Wazuh app - Common data to generate 
 * Copyright (C) 2015-2022 Wazuh, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Find more information about this on the LICENSE file.
 */
// Common data
const IPs = ['141.98.81.37', '54.10.24.5', '187.80.4.18', '134.87.21.47', '40.220.102.15', '45.124.37.241', '45.75.196.15', '16.4.20.20'];
exports.IPs = IPs;
const Users = ["root", "ec2-user", "SYSTEM", "wazuh", "Administrators", "suricata", "LOCAL\ Service", "NETWORK\ Service"];
exports.Users = Users;
const Ports = ["22", "55047", "26874", "8905", "3014", "2222", "4547", "3475", "7558", "4277", "3527", "5784", "7854"];
exports.Ports = Ports;
const Win_Hostnames = ['Win_Server_01', 'Win_Server_02', 'Win_Server_03', 'Win_Server_04'];
exports.Win_Hostnames = Win_Hostnames;
const Paths = ["/home/user/sample", "/tmp/sample", "/etc/sample"]; // Agents

exports.Paths = Paths;
const Agents = [// { id: '000', name: 'master', ip: '120.17.47.10' }, 
{
  id: '001',
  name: 'RHEL7',
  ip: '187.54.247.68'
}, {
  id: '002',
  name: 'Amazon',
  ip: '145.80.240.15'
}, {
  id: '003',
  name: 'ip-10-0-0-180.us-west-1.compute.internal',
  ip: '10.0.0.180'
}, {
  id: '004',
  name: 'Ubuntu',
  ip: '47.204.15.21'
}, {
  id: '005',
  name: 'Centos',
  ip: '197.17.1.4'
}, {
  id: '006',
  name: 'Windows',
  ip: '207.45.34.78'
}, {
  id: '007',
  name: 'Debian',
  ip: '24.273.97.14'
}]; // Geolocation {country_name, location: {lat, lon }, region_name}

exports.Agents = Agents;
const GeoLocation = [{
  country_name: 'Spain',
  location: {
    lat: 37.1881714,
    lon: -3.6066699
  },
  region_name: 'Andalucía',
  city_name: 'Granada'
}, {
  country_name: 'France',
  location: {
    lat: 48.8534088,
    lon: 2.3487999
  },
  region_name: 'Paris',
  city_name: 'Paris'
}, {
  country_name: 'England',
  location: {
    lat: 51.5085297,
    lon: -0.12574
  },
  region_name: 'London',
  city_name: 'London'
}, {
  country_name: 'Germany',
  location: {
    lat: 52.524,
    lon: 13.411
  },
  region_name: 'Berlin',
  city_name: 'Berlin'
}, {
  country_name: 'United States of America',
  location: {
    lat: 40.7142715,
    lon: -74.0059662
  },
  region_name: 'New York',
  city_name: 'New York'
}, {
  country_name: 'Canada',
  location: {
    lat: 49.2496605,
    lon: -123.119339
  },
  region_name: 'Vancouver',
  city_name: 'Vancouver'
}, {
  country_name: 'Brasil',
  location: {
    lat: -22.9064198,
    lon: -43.1822319
  },
  region_name: 'Río de Janeiro',
  city_name: 'Río de Janeiro'
}, {
  country_name: 'India',
  location: {
    lat: 19.0728302,
    lon: 72.8826065
  },
  region_name: 'Bombay',
  city_name: 'Bombay'
}, {
  country_name: 'Australia',
  location: {
    lat: -33.8678513,
    lon: 151.2073212
  },
  region_name: 'Sydney',
  city_name: 'Sydney'
}, {
  country_name: 'China',
  location: {
    lat: 31.222,
    lon: 121.458
  },
  region_name: 'Shanghai',
  city_name: 'Shanghai'
}];
/**
 * Get a random element of an array
 * @param {[]} array - Array to get a randomized element
 * @returns {any} - Element randomized
 */

exports.GeoLocation = GeoLocation;

function randomStrItem(str) {
  let array = str.split('');
  return array[Math.floor(array.length * Math.random())];
}

const randomElements = (length, elements) => {
  let hash = '';

  for (let i = 0; i < length; i++) {
    hash += randomStrItem(elements);
  }

  return hash;
};

exports.randomElements = randomElements;

const randomArrayItem = array => {
  return array[Math.floor(array.length * Math.random())];
};

exports.randomArrayItem = randomArrayItem;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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