"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.data = exports.location = exports.decoder = exports.checkTitle = exports.scanContent = exports.checkResult = exports.checkSeverity = exports.scanProfileTitle = void 0;

/*
 * Wazuh app - OpenSCAP sample data
 * Copyright (C) 2015-2022 Wazuh, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Find more information about this on the LICENSE file.
 */
// OpenSCAP
const scanProfileTitle = ["xccdf_org.ssgproject.content_profile_standard", "xccdf_org.ssgproject.content_profile_pci-dss", "xccdf_org.ssgproject.content_profile_common", "xccdf_org.ssgproject.content_profile_anssi_np_nt28_minimal"];
exports.scanProfileTitle = scanProfileTitle;
const checkSeverity = ["low", "medium", "high"];
exports.checkSeverity = checkSeverity;
const checkResult = ["fail"];
exports.checkResult = checkResult;
const scanContent = ["ssg-centos-7-ds.xml", "ssg-centos-6-ds.xml", "ssg-rhel6-ds.xml", "ssg-ubuntu18-ds.xml", "ssg-debian-ds.xml", "ssg-fedora-ds.xml"];
exports.scanContent = scanContent;
const checkTitle = ["Record Attempts to Alter the localtime File", "Record Attempts to Alter Time Through clock_settime", "Ensure auditd Collects Unauthorized Access Attempts to Files (unsuccessful)", "Ensure auditd Collects System Administrator Actions", "Ensure auditd Collects File Deletion Events by User"];
exports.checkTitle = checkTitle;
const decoder = {
  parent: "oscap",
  name: "oscap"
};
exports.decoder = decoder;
const location = 'wodle_open-scap';
exports.location = location;
const data = [{
  // "input": {
  //   "type": "log"
  // },
  "data": {
    "oscap": {
      "scan": {
        "score": "99.814812",
        "profile": {
          "id": "No profile",
          "title": "No profile"
        },
        "id": "0001587604016",
        "content": "cve-redhat-7-ds.xml",
        "benchmark": {
          "id": "xccdf_com.redhat.rhsa_benchmark_generated-xccdf"
        }
      }
    }
  },
  "rule": {
    "firedtimes": 1,
    "mail": false,
    "level": 3,
    "pci_dss": ["2.2"],
    "description": "OpenSCAP Report overview.",
    "groups": ["oscap", "oscap-report"],
    "id": "81540",
    "nist_800_53": ["CM.1"]
  },
  "full_log": "oscap: msg: \"xccdf-overview\", scan-id: \"{data.oscap.scan.id}\", content: \"{data.oscap.scan.content}\", benchmark-id: \"{data.oscap.scan.benhmark.id}\", profile-id: \"{data.oscap.scan.profile.id}\", profile-title: \"{data.oscap.scan.profile.title}\", score: \"{data.oscap.scan.score}\"."
}, {
  "data": {
    "oscap": {
      "scan": {
        "score": "75.000000",
        "profile": {
          "id": "xccdf_org.ssgproject.content_profile_common",
          "title": "Common Profile for General-Purpose Systems"
        },
        "id": "0001587603934",
        "content": "ssg-rhel-7-ds.xml",
        "benchmark": {
          "id": "xccdf_org.ssgproject.content_benchmark_RHEL-7"
        }
      }
    }
  },
  "rule": {
    "firedtimes": 2,
    "mail": false,
    "level": 5,
    "pci_dss": ["2.2"],
    "description": "OpenSCAP Report overview: Score less than 80",
    "groups": ["oscap", "oscap-report"],
    "id": "81542",
    "nist_800_53": ["CM.1"]
  },
  "full_log": "oscap: msg: \"xccdf-overview\", scan-id: \"{data.oscap.scan.id}\", content: \"{data.oscap.scan.content}\", benchmark-id: \"{data.oscap.scan.benhmark.id}\", profile-id: \"{data.oscap.scan.profile.id}\", profile-title: \"{data.oscap.scan.profile.title}\", score: \"{data.oscap.scan.score}\".",
  "timestamp": "2020-04-23T01:06:56.060+0000"
}, {
  "data": {
    "oscap": {
      "scan": {
        "profile": {
          "id": "No profile",
          "title": "No profile"
        },
        "id": "0001587604016",
        "content": "cve-redhat-7-ds.xml",
        "benchmark": {
          "id": "xccdf_com.redhat.rhsa_benchmark_generated-xccdf"
        }
      },
      "check": {
        "result": "fail",
        "severity": "high",
        "identifiers": "CVE-2016-5195 (http://cve.mitre.org), CVE-2016-7039 (http://cve.mitre.org), CVE-2016-8666 (http://cve.mitre.org)",
        "oval": {
          "id": "oval:com.redhat.rhsa:def:20170372"
        },
        "id": "xccdf_com.redhat.rhsa_rule_oval-com.redhat.rhsa-def-20170372",
        "title": "RHSA-2017:0372: kernel-aarch64 security and bug fix update (Important)"
      }
    }
  },
  "rule": {
    "firedtimes": 3,
    "mail": false,
    "level": 9,
    "pci_dss": ["2.2"],
    "description": "OpenSCAP: RHSA-2017:0372: kernel-aarch64 security and bug fix update (Important) (not passed)",
    "groups": ["oscap", "oscap-result"],
    "id": "81531",
    "nist_800_53": ["CM.1"]
  }
}, {
  "data": {
    "oscap": {
      "scan": {
        "profile": {
          "id": "xccdf_org.ssgproject.content_profile_common",
          "title": "Common Profile for General-Purpose Systems"
        },
        "id": "0001587603934",
        "content": "ssg-rhel-7-ds.xml",
        "benchmark": {
          "id": "xccdf_org.ssgproject.content_benchmark_RHEL-7"
        }
      },
      "check": {
        "result": "fail",
        "severity": "low",
        "references": "RHEL-07-030700 (http://iase.disa.mil/stigs/os/unix-linux/Pages/index.aspx), AC-2(7)(b) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AC-17(7) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-1(b) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(a) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(c) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(d) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), iAU-3(1) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-12(a) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-12(c) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), IR-5 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), 126 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), 130 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), 135 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), 172 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), 2884 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), Req-10.2.2 (https://www.pcisecuritystandards.org/documents/PCI_DSS_v3-1.pdf), Req-10.2.5.b (https://www.pcisecuritystandards.org/documents/PCI_DSS_v3-1.pdf), SRG-OS-000037-GPOS-00015 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx), SRG-OS-000042-GPOS-00020 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx), SRG-OS-000392-GPOS-00172 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx), SRG-OS-000462-GPOS-00206 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx), SRG-OS-000471-GPOS-00215 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx), 5.4.1.1 (https://www.fbi.gov/file-repository/cjis-security-policy-v5_5_20160601-2-1.pdf), 3.1.7 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-171.pdf)",
        "identifiers": "CCE-27461-3 (https://nvd.nist.gov/cce/index.cfm)",
        "oval": {
          "id": "oval:ssg-audit_rules_sysadmin_actions:def:1"
        },
        "description": "At a minimum, the audit system should collect administrator actions for all users and root. If the auditd daemon is configured to use the augenrules program to read audit rules during daemon startup (the default), add the following line to a file with suffix .rules in the directory /etc/audit/rules.d: -w /etc/sudoers -p wa -k actions -w /etc/sudoers.d/ -p wa -k actions If the auditd daemon is configured to use the auditctl utility to read audit rules during daemon startup, add the following line to /etc/audit/audit.rules file: -w /etc/sudoers -p wa -k actions -w /etc/sudoers.d/ -p wa -k actions",
        "id": "xccdf_org.ssgproject.content_rule_audit_rules_sysadmin_actions",
        "title": "Ensure auditd Collects System Administrator Actions",
        "rationale": "The actions taken by system administrators should be audited to keep a record of what was executed on the system, as well as, for accountability purposes."
      }
    }
  },
  "rule": {
    "firedtimes": 41,
    "mail": false,
    "level": 5,
    "pci_dss": ["2.2"],
    "description": "OpenSCAP: Ensure auditd Collects System Administrator Actions (not passed)",
    "groups": ["oscap", "oscap-result"],
    "id": "81529",
    "nist_800_53": ["CM.1"]
  }
}, {
  "data": {
    "oscap": {
      "scan": {
        "profile": {
          "id": "xccdf_org.ssgproject.content_profile_common",
          "title": "Common Profile for General-Purpose Systems"
        },
        "id": "0001587603934",
        "content": "ssg-rhel-7-ds.xml",
        "benchmark": {
          "id": "xccdf_org.ssgproject.content_benchmark_RHEL-7"
        }
      },
      "check": {
        "result": "fail",
        "severity": "medium",
        "references": "AC-17(7) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-1(b) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(a) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(c) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(d) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-12(a) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-12(c) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), IR-5 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), Req-10.2.7 (https://www.pcisecuritystandards.org/documents/PCI_DSS_v3-1.pdf), 5.2.17 (https://benchmarks.cisecurity.org/tools2/linux/CIS_Red_Hat_Enterprise_Linux_7_Benchmark_v1.1.0.pdf), 172 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), 5.4.1.1 (https://www.fbi.gov/file-repository/cjis-security-policy-v5_5_20160601-2-1.pdf), 3.1.7 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-171.pdf)",
        "identifiers": "CCE-27129-6 (https://nvd.nist.gov/cce/index.cfm)",
        "oval": {
          "id": "oval:ssg-audit_rules_kernel_module_loading:def:1"
        },
        "description": "If the auditd daemon is configured to use the augenrules program to read audit rules during daemon startup (the default), add the following lines to a file with suffix .rules in the directory /etc/audit/rules.d to capture kernel module loading and unloading events, setting ARCH to either b32 or b64 as appropriate for your system: -w /usr/sbin/insmod -p x -k modules -w /usr/sbin/rmmod -p x -k modules -w /usr/sbin/modprobe -p x -k modules -a always,exit -F arch=ARCH -S init_module -S delete_module -k modules If the auditd daemon is configured to use the auditctl utility to read audit rules during daemon startup, add the following lines to /etc/audit/audit.rules file in order to capture kernel module loading and unloading events, setting ARCH to either b32 or b64 as appropriate for your system: -w /usr/sbin/insmod -p x -k modules -w /usr/sbin/rmmod -p x -k modules -w /usr/sbin/modprobe -p x -k modules -a always,exit -F arch=ARCH -S init_module -S delete_module -k modules",
        "id": "xccdf_org.ssgproject.content_rule_audit_rules_kernel_module_loading",
        "title": "Ensure auditd Collects Information on Kernel Module Loading and Unloading",
        "rationale": "The addition/removal of kernel modules can be used to alter the behavior of the kernel and potentially introduce malicious code into kernel space. It is important to have an audit trail of modules that have been introduced into the kernel."
      }
    }
  },
  "rule": {
    "firedtimes": 34,
    "mail": false,
    "level": 7,
    "pci_dss": ["2.2"],
    "description": "OpenSCAP: Ensure auditd Collects Information on Kernel Module Loading and Unloading (not passed)",
    "groups": ["oscap", "oscap-result"],
    "id": "81530",
    "nist_800_53": ["CM.1"]
  }
}, {
  "data": {
    "oscap": {
      "scan": {
        "profile": {
          "id": "xccdf_org.ssgproject.content_profile_common",
          "title": "Common Profile for General-Purpose Systems"
        },
        "id": "0001587603934",
        "content": "ssg-rhel-7-ds.xml",
        "benchmark": {
          "id": "xccdf_org.ssgproject.content_benchmark_RHEL-7"
        }
      },
      "check": {
        "result": "fail",
        "severity": "medium",
        "references": "AC-17(7) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-1(b) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(a) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(c) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(d) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-12(a) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-12(c) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), IR-5 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), Req-10.2.7 (https://www.pcisecuritystandards.org/documents/PCI_DSS_v3-1.pdf), 5.2.17 (https://benchmarks.cisecurity.org/tools2/linux/CIS_Red_Hat_Enterprise_Linux_7_Benchmark_v1.1.0.pdf), 172 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), 5.4.1.1 (https://www.fbi.gov/file-repository/cjis-security-policy-v5_5_20160601-2-1.pdf), 3.1.7 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-171.pdf)",
        "identifiers": "CCE-27129-6 (https://nvd.nist.gov/cce/index.cfm)",
        "oval": {
          "id": "oval:ssg-audit_rules_kernel_module_loading:def:1"
        },
        "description": "If the auditd daemon is configured to use the augenrules program to read audit rules during daemon startup (the default), add the following lines to a file with suffix .rules in the directory /etc/audit/rules.d to capture kernel module loading and unloading events, setting ARCH to either b32 or b64 as appropriate for your system: -w /usr/sbin/insmod -p x -k modules -w /usr/sbin/rmmod -p x -k modules -w /usr/sbin/modprobe -p x -k modules -a always,exit -F arch=ARCH -S init_module -S delete_module -k modules If the auditd daemon is configured to use the auditctl utility to read audit rules during daemon startup, add the following lines to /etc/audit/audit.rules file in order to capture kernel module loading and unloading events, setting ARCH to either b32 or b64 as appropriate for your system: -w /usr/sbin/insmod -p x -k modules -w /usr/sbin/rmmod -p x -k modules -w /usr/sbin/modprobe -p x -k modules -a always,exit -F arch=ARCH -S init_module -S delete_module -k modules",
        "id": "xccdf_org.ssgproject.content_rule_audit_rules_kernel_module_loading",
        "title": "Ensure auditd Collects Information on Kernel Module Loading and Unloading",
        "rationale": "The addition/removal of kernel modules can be used to alter the behavior of the kernel and potentially introduce malicious code into kernel space. It is important to have an audit trail of modules that have been introduced into the kernel."
      }
    }
  },
  "rule": {
    "firedtimes": 34,
    "mail": false,
    "level": 7,
    "pci_dss": ["2.2"],
    "description": "OpenSCAP: Ensure auditd Collects Information on Kernel Module Loading and Unloading (not passed)",
    "groups": ["oscap", "oscap-result"],
    "id": "81530",
    "nist_800_53": ["CM.1"]
  }
}, {
  "data": {
    "oscap": {
      "scan": {
        "profile": {
          "id": "xccdf_org.ssgproject.content_profile_common",
          "title": "Common Profile for General-Purpose Systems"
        },
        "id": "0001587603934",
        "content": "ssg-rhel-7-ds.xml",
        "benchmark": {
          "id": "xccdf_org.ssgproject.content_benchmark_RHEL-7"
        }
      },
      "check": {
        "result": "fail",
        "severity": "medium",
        "references": "AC-17(7) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-1(b) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(a) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(c) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(d) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-12(a) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-12(c) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), IR-5 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), Req-10.2.7 (https://www.pcisecuritystandards.org/documents/PCI_DSS_v3-1.pdf), 5.2.14 (https://benchmarks.cisecurity.org/tools2/linux/CIS_Red_Hat_Enterprise_Linux_7_Benchmark_v1.1.0.pdf), 366 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), 172 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), 2884 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), 5.4.1.1 (https://www.fbi.gov/file-repository/cjis-security-policy-v5_5_20160601-2-1.pdf), 3.1.7 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-171.pdf)",
        "identifiers": "CCE-27206-2 (https://nvd.nist.gov/cce/index.cfm)",
        "oval": {
          "id": "oval:ssg-audit_rules_file_deletion_events:def:1"
        },
        "description": "At a minimum the audit system should collect file deletion events for all users and root. If the auditd daemon is configured to use the augenrules program to read audit rules during daemon startup (the default), add the following line to a file with suffix .rules in the directory /etc/audit/rules.d, setting ARCH to either b32 or b64 as appropriate for your system: -a always,exit -F arch=ARCH -S rmdiri,unlink,unlinkat,rename,renameat -F auid>=1000 -F auid!=4294967295 -F key=delete If the auditd daemon is configured to use the auditctl utility to read audit rules during daemon startup, add the following line to /etc/audit/audit.rules file, setting ARCH to either b32 or b64 as appropriate for your system: -a always,exit -F arch=ARCH -S rmdir,unlink,unlinkat,rename -S renameat -F auid>=1000 -F auid!=4294967295 -F key=delete",
        "id": "xccdf_org.ssgproject.content_rule_audit_rules_file_deletion_events",
        "title": "Ensure auditd Collects File Deletion Events by User",
        "rationale": "Auditing file deletions will create an audit trail for files that are removed from the system. The audit trail could aid in system troubleshooting, as well as, detecting malicious processes that attempt to delete log files to conceal their presence."
      }
    }
  },
  "rule": {
    "firedtimes": 33,
    "mail": false,
    "level": 7,
    "pci_dss": ["2.2"],
    "description": "OpenSCAP: Ensure auditd Collects File Deletion Events by User (not passed)",
    "groups": ["oscap", "oscap-result"],
    "id": "81530",
    "nist_800_53": ["CM.1"]
  }
}, {
  "data": {
    "oscap": {
      "scan": {
        "profile": {
          "id": "xccdf_org.ssgproject.content_profile_common",
          "title": "Common Profile for General-Purpose Systems"
        },
        "id": "0001587603934",
        "content": "ssg-rhel-7-ds.xml",
        "benchmark": {
          "id": "xccdf_org.ssgproject.content_benchmark_RHEL-7"
        }
      },
      "check": {
        "result": "fail",
        "severity": "medium",
        "references": "RHEL-07-030740 (http://iase.disa.mil/stigs/os/unix-linux/Pages/index.aspx), AC-17(7) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-1(b) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(a) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(c) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(d) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-3(1) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-12(a) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-12(c) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), IR-5 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), 135 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), 2884 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), SRG-OS-000042-GPOS-00020 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx), SRG-OS-000392-GPOS-00172 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx), Req-10.2.7 (https://www.pcisecuritystandards.org/documents/PCI_DSS_v3-1.pdf), 5.2.13 (https://benchmarks.cisecurity.org/tools2/linux/CIS_Red_Hat_Enterprise_Linux_7_Benchmark_v1.1.0.pdf), 5.4.1.1 (https://www.fbi.gov/file-repository/cjis-security-policy-v5_5_20160601-2-1.pdf), 3.1.7 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-171.pdf)",
        "identifiers": "CCE-27447-2 (https://nvd.nist.gov/cce/index.cfm)",
        "oval": {
          "id": "oval:ssg-audit_rules_media_export:def:1"
        },
        "description": "At a minimum, the audit system should collect media exportation events for all users and root. If the auditd daemon is configured to use the augenrules program to read audit rules during daemon startup (the default), add the following line to a file with suffix .rules in the directory /etc/audit/rules.d, setting ARCH to either b32 or b64 as appropriate for your system: -a always,exit -F arch=ARCH -S mount -F auid>=1000 -F auid!=4294967295 -F key=export If the auditd daemon is configured to use the auditctl utility to read audit rules during daemon startup, add the following line to /etc/audit/audit.rules file, setting ARCH to either b32 or b64 as appropriate for your system: -a always,exit -F arch=ARCH -S mount -F auid>=1000 -F auid!=4294967295 -F key=export",
        "id": "xccdf_org.ssgproject.content_rule_audit_rules_media_export",
        "title": "Ensure auditd Collects Information on Exporting to Media (successful)",
        "rationale": "The unauthorized exportation of data to external media could result in an information leak where classified information, Privacy Act information, and intellectual property could be lost. An audit trail should be created each time a filesystem is mounted to help identify and guard against information loss."
      }
    }
  },
  "rule": {
    "firedtimes": 32,
    "mail": false,
    "level": 7,
    "pci_dss": ["2.2"],
    "description": "OpenSCAP: Ensure auditd Collects Information on Exporting to Media (successful) (not passed)",
    "groups": ["oscap", "oscap-result"],
    "id": "81530",
    "nist_800_53": ["CM.1"]
  }
}, {
  "data": {
    "oscap": {
      "scan": {
        "profile": {
          "id": "xccdf_org.ssgproject.content_profile_common",
          "title": "Common Profile for General-Purpose Systems"
        },
        "id": "0001587603934",
        "content": "ssg-rhel-7-ds.xml",
        "benchmark": {
          "id": "xccdf_org.ssgproject.content_benchmark_RHEL-7"
        }
      },
      "check": {
        "result": "fail",
        "severity": "medium",
        "references": "RHEL-07-030360 (http://iase.disa.mil/stigs/os/unix-linux/Pages/index.aspx), AC-17(7) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-1(b) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(a) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(c) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(d) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(4) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-6(9) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-12(a) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-12(c) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), IR-5 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), 2234 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), SRG-OS-000327-GPOS-00127 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx), Req-10.2.2 (https://www.pcisecuritystandards.org/documents/PCI_DSS_v3-1.pdf), 5.2.10 (https://benchmarks.cisecurity.org/tools2/linux/CIS_Red_Hat_Enterprise_Linux_7_Benchmark_v1.1.0.pdf), 5.4.1.1 (https://www.fbi.gov/file-repository/cjis-security-policy-v5_5_20160601-2-1.pdf), 3.1.7 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-171.pdf)",
        "identifiers": "CCE-27437-3 (https://nvd.nist.gov/cce/index.cfm)",
        "oval": {
          "id": "oval:ssg-audit_rules_privileged_commands:def:1"
        },
        "description": "At a minimum, the audit system should collect the execution of privileged commands for all users and root. To find the relevant setuid / setgid programs, run the following command for each local partition PART: $ sudo find PART -xdev -type f -perm -4000 -o -type f -perm -2000 2>/dev/null If the auditd daemon is configured to use the augenrules program to read audit rules during daemon startup (the default), add a line of the following form to a file with suffix .rules in the directory /etc/audit/rules.d for each setuid / setgid program on the system, replacing the SETUID_PROG_PATH part with the full path of that setuid / setgid program in the list: -a always,exit -F path=SETUID_PROG_PATH -F perm=x -F auid>=1000 -F auid!=4294967295 -F key=privileged If the auditd daemon is configured to use the auditctl utility to read audit rules during daemon startup, add a line of the following form to /etc/audit/audit.rules for each setuid / setgid program on the system, replacing the SETUID_PROG_PATH part with the full path of that setuid / setgid program in the list: -a always,exit -F path=SETUID_PROG_PATH -F perm=x -F auid>=1000 -F auid!=4294967295 -F key=privileged",
        "id": "xccdf_org.ssgproject.content_rule_audit_rules_privileged_commands",
        "title": "Ensure auditd Collects Information on the Use of Privileged Commands",
        "rationale": "Misuse of privileged functions, either intentionally or unintentionally by authorized users, or by unauthorized external entities that have compromised system accounts, is a serious and ongoing concern and can have significant adverse impacts on organizations. Auditing the use of privileged functions is one way to detect such misuse and identify the risk from insider and advanced persistent threast. Privileged programs are subject to escalation-of-privilege attacks, which attempt to subvert their normal role of providing some necessary but limited capability. As such, motivation exists to monitor these programs for unusual activity."
      }
    }
  },
  "rule": {
    "firedtimes": 31,
    "mail": false,
    "level": 7,
    "pci_dss": ["2.2"],
    "description": "OpenSCAP: Ensure auditd Collects Information on the Use of Privileged Commands (not passed)",
    "groups": ["oscap", "oscap-result"],
    "id": "81530",
    "nist_800_53": ["CM.1"]
  }
}, {
  "data": {
    "oscap": {
      "scan": {
        "profile": {
          "id": "xccdf_org.ssgproject.content_profile_common",
          "title": "Common Profile for General-Purpose Systems"
        },
        "id": "0001587603934",
        "content": "ssg-rhel-7-ds.xml",
        "benchmark": {
          "id": "xccdf_org.ssgproject.content_benchmark_RHEL-7"
        }
      },
      "check": {
        "result": "fail",
        "severity": "medium",
        "references": "AC-17(7) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-1(b) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(a) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(c) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(d) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-12(a) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-12(c) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), IR-5 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), 172 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), 2884 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), Req-10.2.4 (https://www.pcisecuritystandards.org/documents/PCI_DSS_v3-1.pdf), Req-10.2.1 (https://www.pcisecuritystandards.org/documents/PCI_DSS_v3-1.pdf), 5.2.10 (https://benchmarks.cisecurity.org/tools2/linux/CIS_Red_Hat_Enterprise_Linux_7_Benchmark_v1.1.0.pdf), 5.4.1.1 (https://www.fbi.gov/file-repository/cjis-security-policy-v5_5_20160601-2-1.pdf), 3.1.7 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-171.pdf)",
        "identifiers": "CCE-27347-4 (https://nvd.nist.gov/cce/index.cfm)",
        "oval": {
          "id": "oval:ssg-audit_rules_unsuccessful_file_modification:def:1"
        },
        "description": "At a minimum the audit system should collect unauthorized file accesses for all users and root. If the auditd daemon is configured to use the augenrules program to read audit rules during daemon startup (the default), add the following lines to a file with suffix .rules in the directory /etc/audit/rules.d: -a always,exit -F arch=b32 -S creat,open,openat,open_by_handle_at,truncate,ftruncate -F exit=-EACCES -F auid>=1000 -F auid!=4294967295 -F key=access -a always,exit -F arch=b32 -S creat,open,openat,open_by_handle_at,truncate,ftruncate -F exit=-EPERM -F auid>=1000 -F auid!=4294967295 -F key=access If the system is 64 bit then also add the following lines: -a always,exit -F arch=b64 -S creat,open,openat,open_by_handle_at,truncate,ftruncate -F exit=-EACCES -F auid>=1000 -F auid!=4294967295 -F key=access -a always,exit -F arch=b64 -S creat,open,openat,open_by_handle_at,truncate,ftruncate -F exit=-EPERM -F auid>=1000 -F auid!=4294967295 -F key=access If the auditd daemon is configured to use the auditctl utility to read audit rules during daemon startup, add the following lines to /etc/audit/audit.rules file: -a always,exit -F arch=b32 -S creat,open,openat,open_by_handle_at,truncate,ftruncate -F exit=-EACCES -F auid>=1000 -F auid!=4294967295 -F key=access -a always,exit -F arch=b32 -S creat,open,openat,open_by_handle_at,truncate,ftruncate -F exit=-EPERM -F auid>=1000 -F auid!=4294967295 -F key=access If the system is 64 bit then also add the following lines: -a always,exit -F arch=b64 -S creat,open,openat,open_by_handle_at,truncate,ftruncate -F exit=-EACCES -F auid>=1000 -F auid!=4294967295 -F key=access -a always,exit -F arch=b64 -S creat,open,openat,open_by_handle_at,truncate,ftruncate -F exit=-EPERM -F auid>=1000 -F auid!=4294967295 -F key=access",
        "id": "xccdf_org.ssgproject.content_rule_audit_rules_unsuccessful_file_modification",
        "title": "Ensure auditd Collects Unauthorized Access Attempts to Files (unsuccessful)",
        "rationale": "Unsuccessful attempts to access files could be an indicator of malicious activity on a system. Auditing these events could serve as evidence of potential system compromise."
      }
    }
  },
  "rule": {
    "firedtimes": 30,
    "mail": false,
    "level": 7,
    "pci_dss": ["2.2"],
    "description": "OpenSCAP: Ensure auditd Collects Unauthorized Access Attempts to Files (unsuccessful) (not passed)",
    "groups": ["oscap", "oscap-result"],
    "id": "81530",
    "nist_800_53": ["CM.1"]
  }
}, {
  "data": {
    "oscap": {
      "scan": {
        "profile": {
          "id": "xccdf_org.ssgproject.content_profile_common",
          "title": "Common Profile for General-Purpose Systems"
        },
        "id": "0001587603934",
        "content": "ssg-rhel-7-ds.xml",
        "benchmark": {
          "id": "xccdf_org.ssgproject.content_benchmark_RHEL-7"
        }
      },
      "check": {
        "result": "fail",
        "severity": "low",
        "references": "RHEL-07-030370 (http://iase.disa.mil/stigs/os/unix-linux/Pages/index.aspx), AC-17(7) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-1(b) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(a) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(c) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(d) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-12(a) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-12(c) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), IR-5 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), 126 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), 172 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), Req-10.5.5 (https://www.pcisecuritystandards.org/documents/PCI_DSS_v3-1.pdf), 5.2.10 (https://benchmarks.cisecurity.org/tools2/linux/CIS_Red_Hat_Enterprise_Linux_7_Benchmark_v1.1.0.pdf), SRG-OS-000064-GPOS-00033 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx), SRG-OS-000392-GPOS-00172 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx), SRG-OS-000458-GPOS-00203 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx), SRG-OS-000474-GPOS-00219 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx), 5.4.1.1 (https://www.fbi.gov/file-repository/cjis-security-policy-v5_5_20160601-2-1.pdf), 3.1.7 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-171.pdf)",
        "identifiers": "CCE-27364-9 (https://nvd.nist.gov/cce/index.cfm)",
        "oval": {
          "id": "oval:ssg-audit_rules_dac_modification_chown:def:1"
        },
        "description": "At a minimum, the audit system should collect file permission changes for all users and root. If the auditd daemon is configured to use the augenrules program to read audit rules during daemon startup (the default), add the following line to a file with suffix .rules in the directory /etc/audit/rules.d: -a always,exit -F arch=b32 -S chown -F auid>=1000 -F auid!=4294967295 -F key=perm_mod If the system is 64 bit then also add the following line: -a always,exit -F arch=b64 -S chown -F auid>=1000 -F auid!=4294967295 -F key=perm_mod If the auditd daemon is configured to use the auditctl utility to read audit rules during daemon startup, add the following line to /etc/audit/audit.rules file: -a always,exit -F arch=b32 -S chown -F auid>=1000 -F auid!=4294967295 -F key=perm_mod If the system is 64 bit then also add the following line: -a always,exit -F arch=b64 -S chown -F auid>=1000 -F auid!=4294967295 -F key=perm_mod",
        "id": "xccdf_org.ssgproject.content_rule_audit_rules_dac_modification_chown",
        "title": "Record Events that Modify the System's Discretionary Access Controls - chown",
        "rationale": "The changing of file permissions could indicate that a user is attempting to gain access to information that would otherwise be disallowed. Auditing DAC modifications can facilitate the identification of patterns of abuse among both authorized and unauthorized users."
      }
    }
  },
  "rule": {
    "firedtimes": 32,
    "mail": false,
    "level": 5,
    "pci_dss": ["2.2"],
    "description": "OpenSCAP: Record Events that Modify the System's Discretionary Access Controls - chown (not passed)",
    "groups": ["oscap", "oscap-result"],
    "id": "81529",
    "nist_800_53": ["CM.1"]
  }
}, {
  "data": {
    "oscap": {
      "scan": {
        "profile": {
          "id": "xccdf_org.ssgproject.content_profile_common",
          "title": "Common Profile for General-Purpose Systems"
        },
        "id": "0001587603934",
        "content": "ssg-rhel-7-ds.xml",
        "benchmark": {
          "id": "xccdf_org.ssgproject.content_benchmark_RHEL-7"
        }
      },
      "check": {
        "result": "fail",
        "severity": "medium",
        "references": "RHEL-07-030470 (http://iase.disa.mil/stigs/os/unix-linux/Pages/index.aspx), AC-17(7) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-1(b) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(a) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(c) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(d) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-12(a) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-12(c) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), IR-5 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), 172 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), Req-10.5.5 (https://www.pcisecuritystandards.org/documents/PCI_DSS_v3-1.pdf), 5.2.10 (https://benchmarks.cisecurity.org/tools2/linux/CIS_Red_Hat_Enterprise_Linux_7_Benchmark_v1.1.0.pdf), SRG-OS-000064-GPOS-00033 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx), SRG-OS-000392-GPOS-00172 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx), SRG-OS-000458-GPOS-00203 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx), 5.4.1.1 (https://www.fbi.gov/file-repository/cjis-security-policy-v5_5_20160601-2-1.pdf), 3.1.7 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-171.pdf)",
        "identifiers": "CCE-27367-2 (https://nvd.nist.gov/cce/index.cfm)",
        "oval": {
          "id": "oval:ssg-audit_rules_dac_modification_removexattr:def:1"
        },
        "description": "At a minimum, the audit system should collect file permission changes for all users and root. If the auditd daemon is configured to use the augenrules program to read audit rules during daemon startup (the default), add the following line to a file with suffix .rules in the directory /etc/audit/rules.d: -a always,exit -F arch=b32 -S removexattr -F auid>=1000 -F auid!=4294967295 -F key=perm_mod If the system is 64 bit then also add the following line: -a always,exit -F arch=b64 -S removexattr -F auid>=1000 -F auid!=4294967295 -F key=perm_mod If the auditd daemon is configured to use the auditctl utility to read audit rules during daemon startup, add the following line to /etc/audit/audit.rules file: -a always,exit -F arch=b32 -S removexattr -F auid>=1000 -F auid!=4294967295 -F key=perm_mod If the system is 64 bit then also add the following line: -a always,exit -F arch=b64 -S removexattr -F auid>=1000 -F auid!=4294967295 -F key=perm_mod",
        "id": "xccdf_org.ssgproject.content_rule_audit_rules_dac_modification_removexattr",
        "title": "Record Events that Modify the System's Discretionary Access Controls - removexattr",
        "rationale": "The changing of file permissions could indicate that a user is attempting to gain access to information that would otherwise be disallowed. Auditing DAC modifications can facilitate the identification of patterns of abuse among both authorized and unauthorized users."
      }
    }
  },
  "rule": {
    "firedtimes": 29,
    "mail": false,
    "level": 7,
    "pci_dss": ["2.2"],
    "description": "OpenSCAP: Record Events that Modify the System's Discretionary Access Controls - removexattr (not passed)",
    "groups": ["oscap", "oscap-result"],
    "id": "81530",
    "nist_800_53": ["CM.1"]
  }
}, {
  "data": {
    "oscap": {
      "scan": {
        "profile": {
          "id": "xccdf_org.ssgproject.content_profile_common",
          "title": "Common Profile for General-Purpose Systems"
        },
        "id": "0001587603934",
        "content": "ssg-rhel-7-ds.xml",
        "benchmark": {
          "id": "xccdf_org.ssgproject.content_benchmark_RHEL-7"
        }
      },
      "check": {
        "result": "fail",
        "severity": "low",
        "references": "AC-17(7) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-1(b) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(a) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(c) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(d) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-12(a) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-12(c) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), IR-5 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), Req-10.5.5 (https://www.pcisecuritystandards.org/documents/PCI_DSS_v3-1.pdf), 5.4.1.1 (https://www.fbi.gov/file-repository/cjis-security-policy-v5_5_20160601-2-1.pdf), 5.2.6 (https://benchmarks.cisecurity.org/tools2/linux/CIS_Red_Hat_Enterprise_Linux_7_Benchmark_v1.1.0.pdf), 3.1.7 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-171.pdf)",
        "identifiers": "CCE-27076-9 (https://nvd.nist.gov/cce/index.cfm)",
        "oval": {
          "id": "oval:ssg-audit_rules_networkconfig_modification:def:1"
        },
        "description": "If the auditd daemon is configured to use the augenrules program to read audit rules during daemon startup (the default), add the following lines to a file with suffix .rules in the directory /etc/audit/rules.d, setting ARCH to either b32 or b64 as appropriate for your system: -a always,exit -F arch=ARCH -S sethostname,setdomainname -F key=audit_rules_networkconfig_modification -w /etc/issue -p wa -k audit_rules_networkconfig_modification -w /etc/issue.net -p wa -k audit_rules_networkconfig_modification -w /etc/hosts -p wa -k audit_rules_networkconfig_modification -w /etc/sysconfig/network -p wa -k audit_rules_networkconfig_modification If the auditd daemon is configured to use the auditctl utility to read audit rules during daemon startup, add the following lines to /etc/audit/audit.rules file, setting ARCH to either b32 or b64 as appropriate for your system: -a always,exit -F arch=ARCH -S sethostname,setdomainname -F key=audit_rules_networkconfig_modification -w /etc/issue -p wa -k audit_rules_networkconfig_modification -w /etc/issue.net -p wa -k audit_rules_networkconfig_modification -w /etc/hosts -p wa -k audit_rules_networkconfig_modification -w /etc/sysconfig/network -p wa -k audit_rules_networkconfig_modification",
        "id": "xccdf_org.ssgproject.content_rule_audit_rules_networkconfig_modification",
        "title": "Record Events that Modify the System's Network Environment",
        "rationale": "The network environment should not be modified by anything other than administrator action. Any change to network parameters should be audited."
      }
    }
  },
  "rule": {
    "firedtimes": 29,
    "mail": false,
    "level": 5,
    "pci_dss": ["2.2"],
    "description": "OpenSCAP: Record Events that Modify the System's Network Environment (not passed)",
    "groups": ["oscap", "oscap-result"],
    "id": "81529",
    "nist_800_53": ["CM.1"]
  }
}, {
  "data": {
    "oscap": {
      "scan": {
        "profile": {
          "id": "xccdf_org.ssgproject.content_profile_common",
          "title": "Common Profile for General-Purpose Systems"
        },
        "id": "0001587603934",
        "content": "ssg-rhel-7-ds.xml",
        "benchmark": {
          "id": "xccdf_org.ssgproject.content_benchmark_RHEL-7"
        }
      },
      "check": {
        "result": "fail",
        "severity": "low",
        "references": "RHEL-07-030710 (http://iase.disa.mil/stigs/os/unix-linux/Pages/index.aspx), AC-2(4) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AC-17(7) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-1(b) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(a) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(c) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(d) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-12(a) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-12(c) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), IR-5 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), 18 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), 172 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), 1403 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), 2130 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), Req-10.2.5 (https://www.pcisecuritystandards.org/documents/PCI_DSS_v3-1.pdf), 5.2.5 (https://benchmarks.cisecurity.org/tools2/linux/CIS_Red_Hat_Enterprise_Linux_7_Benchmark_v1.1.0.pdf), SRG-OS-000004-GPOS-00004 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx), SRG-OS-000239-GPOS-00089 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx), SRG-OS-000241-GPOS-00090 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx), SRG-OS-000241-GPOS-00091 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx), SRG-OS-000303-GPOS-00120 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx), SRG-OS-000476-GPOS-00221 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx), 5.4.1.1 (https://www.fbi.gov/file-repository/cjis-security-policy-v5_5_20160601-2-1.pdf), 3.1.7 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-171.pdf)",
        "identifiers": "CCE-27192-4 (https://nvd.nist.gov/cce/index.cfm)",
        "oval": {
          "id": "oval:ssg-audit_rules_usergroup_modification:def:1"
        },
        "description": "If the auditd daemon is configured to use the augenrules program to read audit rules during daemon startup (the default), add the following lines to a file with suffix .rules in the directory /etc/audit/rules.d, in order to capture events that modify account changes: -w /etc/group -p wa -k audit_rules_usergroup_modification -w /etc/passwd -p wa -k audit_rules_usergroup_modification -w /etc/gshadow -p wa -k audit_rules_usergroup_modification -w /etc/shadow -p wa -k audit_rules_usergroup_modification -w /etc/security/opasswd -p wa -k audit_rules_usergroup_modification If the auditd daemon is configured to use the auditctl utility to read audit rules during daemon startup, add the following lines to /etc/audit/audit.rules file, in order to capture events that modify account changes: -w /etc/group -p wa -k audit_rules_usergroup_modification -w /etc/passwd -p wa -k audit_rules_usergroup_modification -w /etc/gshadow -p wa -k audit_rules_usergroup_modification -w /etc/shadow -p wa -k audit_rules_usergroup_modification -w /etc/security/opasswd -p wa -k audit_rules_usergroup_modification",
        "id": "xccdf_org.ssgproject.content_rule_audit_rules_usergroup_modification",
        "title": "Record Events that Modify User/Group Information",
        "rationale": "In addition to auditing new user and group accounts, these watches will alert the system administrator(s) to any modifications. Any unexpected users, groups, or modifications should be investigated for legitimacy."
      }
    }
  },
  "rule": {
    "firedtimes": 28,
    "mail": false,
    "level": 5,
    "pci_dss": ["2.2"],
    "description": "OpenSCAP: Record Events that Modify User/Group Information (not passed)",
    "groups": ["oscap", "oscap-result"],
    "id": "81529",
    "nist_800_53": ["CM.1"]
  }
}, {
  "data": {
    "oscap": {
      "scan": {
        "profile": {
          "id": "xccdf_org.ssgproject.content_profile_common",
          "title": "Common Profile for General-Purpose Systems"
        },
        "id": "0001587603934",
        "content": "ssg-rhel-7-ds.xml",
        "benchmark": {
          "id": "xccdf_org.ssgproject.content_benchmark_RHEL-7"
        }
      },
      "check": {
        "result": "fail",
        "severity": "low",
        "references": "AC-17(7) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-1(b) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(a) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(c) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(d) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-12(a) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-12(b) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), IR-5 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), 5.2.4 (https://benchmarks.cisecurity.org/tools2/linux/CIS_Red_Hat_Enterprise_Linux_7_Benchmark_v1.1.0.pdf), Req-10.4.2.b (https://www.pcisecuritystandards.org/documents/PCI_DSS_v3-1.pdf), 1487 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), 169 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), 5.4.1.1 (https://www.fbi.gov/file-repository/cjis-security-policy-v5_5_20160601-2-1.pdf), 3.1.7 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-171.pdf)",
        "identifiers": "CCE-27310-2 (https://nvd.nist.gov/cce/index.cfm)",
        "oval": {
          "id": "oval:ssg-audit_rules_time_watch_localtime:def:1"
        },
        "description": "If the auditd daemon is configured to use the augenrules program to read audit rules during daemon startup (the default), add the following line to a file with suffix .rules in the directory /etc/audit/rules.d: -w /etc/localtime -p wa -k audit_time_rules If the auditd daemon is configured to use the auditctl utility to read audit rules during daemon startup, add the following line to /etc/audit/audit.rules file: -w /etc/localtime -p wa -k audit_time_rules The -k option allows for the specification of a key in string form that can be used for better reporting capability through ausearch and aureport and should always be used.",
        "id": "xccdf_org.ssgproject.content_rule_audit_rules_time_watch_localtime",
        "title": "Record Attempts to Alter the localtime File",
        "rationale": "Arbitrary changes to the system time can be used to obfuscate nefarious activities in log files, as well as to confuse network services that are highly dependent upon an accurate system time (such as sshd). All changes to the system time should be audited."
      }
    }
  },
  "rule": {
    "firedtimes": 27,
    "mail": false,
    "level": 5,
    "pci_dss": ["2.2"],
    "description": "OpenSCAP: Record Attempts to Alter the localtime File (not passed)",
    "groups": ["oscap", "oscap-result"],
    "id": "81529",
    "nist_800_53": ["CM.1"]
  }
}, {
  "data": {
    "oscap": {
      "scan": {
        "profile": {
          "id": "xccdf_org.ssgproject.content_profile_common",
          "title": "Common Profile for General-Purpose Systems"
        },
        "id": "0001587603934",
        "content": "ssg-rhel-7-ds.xml",
        "benchmark": {
          "id": "xccdf_org.ssgproject.content_benchmark_RHEL-7"
        }
      },
      "check": {
        "result": "fail",
        "severity": "low",
        "references": "AC-17(7) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-1(b) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(a) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(c) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(d) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-12(a) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-12(c) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), IR-5 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), 5.2.4 (https://benchmarks.cisecurity.org/tools2/linux/CIS_Red_Hat_Enterprise_Linux_7_Benchmark_v1.1.0.pdf), Req-10.4.2.b (https://www.pcisecuritystandards.org/documents/PCI_DSS_v3-1.pdf), 1487 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), 169 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), 5.4.1.1 (https://www.fbi.gov/file-repository/cjis-security-policy-v5_5_20160601-2-1.pdf), 3.1.7 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-171.pdf)",
        "identifiers": "CCE-27219-5 (https://nvd.nist.gov/cce/index.cfm)",
        "oval": {
          "id": "oval:ssg-audit_rules_time_clock_settime:def:1"
        },
        "description": "If the auditd daemon is configured to use the augenrules program to read audit rules during daemon startup (the default), add the following line to a file with suffix .rules in the directory /etc/audit/rules.d: -a always,exit -F arch=b32 -S clock_settime -F a0=0x0 -F key=time-change If the system is 64 bit then also add the following line: -a always,exit -F arch=b64 -S clock_settime -F a0=0x0 -F key=time-change If the auditd daemon is configured to use the auditctl utility to read audit rules during daemon startup, add the following line to /etc/audit/audit.rules file: -a always,exit -F arch=b32 -S clock_settime -F a0=0x0 -F key=time-change If the system is 64 bit then also add the following line: -a always,exit -F arch=b64 -S clock_settime -F a0=0x0 -F key=time-change The -k option allows for the specification of a key in string form that can be used for better reporting capability through ausearch and aureport. Multiple system calls can be defined on the same line to save space if desired, but is not required. See an example of multiple combined syscalls: -a always,exit -F arch=b64 -S adjtimex,settimeofday -F key=audit_time_rules",
        "id": "xccdf_org.ssgproject.content_rule_audit_rules_time_clock_settime",
        "title": "Record Attempts to Alter Time Through clock_settime",
        "rationale": "Arbitrary changes to the system time can be used to obfuscate nefarious activities in log files, as well as to confuse network services that are highly dependent upon an accurate system time (such as sshd). All changes to the system time should be audited."
      }
    }
  },
  "rule": {
    "firedtimes": 26,
    "mail": false,
    "level": 5,
    "pci_dss": ["2.2"],
    "description": "OpenSCAP: Record Attempts to Alter Time Through clock_settime (not passed)",
    "groups": ["oscap", "oscap-result"],
    "id": "81529",
    "nist_800_53": ["CM.1"]
  }
}, {
  "data": {
    "oscap": {
      "scan": {
        "profile": {
          "id": "xccdf_org.ssgproject.content_profile_common",
          "title": "Common Profile for General-Purpose Systems"
        },
        "id": "0001587603934",
        "content": "ssg-rhel-7-ds.xml",
        "benchmark": {
          "id": "xccdf_org.ssgproject.content_benchmark_RHEL-7"
        }
      },
      "check": {
        "result": "fail",
        "severity": "low",
        "references": "AC-17(7) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-1(b) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(a) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(c) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(d) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-12(a) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-12(c) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), IR-5 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), 5.2.4 (https://benchmarks.cisecurity.org/tools2/linux/CIS_Red_Hat_Enterprise_Linux_7_Benchmark_v1.1.0.pdf), Req-10.4.2.b (https://www.pcisecuritystandards.org/documents/PCI_DSS_v3-1.pdf), 1487 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), 169 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), 5.4.1.1 (https://www.fbi.gov/file-repository/cjis-security-policy-v5_5_20160601-2-1.pdf), 3.1.7 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-171.pdf)",
        "identifiers": "CCE-27216-1 (https://nvd.nist.gov/cce/index.cfm)",
        "oval": {
          "id": "oval:ssg-audit_rules_time_settimeofday:def:1"
        },
        "description": "If the auditd daemon is configured to use the augenrules program to read audit rules during daemon startup (the default), add the following line to a file with suffix .rules in the directory /etc/audit/rules.d: -a always,exit -F arch=b32 -S settimeofday -F key=audit_time_rules If the system is 64 bit then also add the following line: -a always,exit -F arch=b64 -S settimeofday -F key=audit_time_rules If the auditd daemon is configured to use the auditctl utility to read audit rules during daemon startup, add the following line to /etc/audit/audit.rules file: -a always,exit -F arch=b32 -S settimeofday -F key=audit_time_rules If the system is 64 bit then also add the following line: -a always,exit -F arch=b64 -S settimeofday -F key=audit_time_rules The -k option allows for the specification of a key in string form that can be used for better reporting capability through ausearch and aureport. Multiple system calls can be defined on the same line to save space if desired, but is not required. See an example of multiple combined syscalls: -a always,exit -F arch=b64 -S adjtimex,settimeofday -F key=audit_time_rules",
        "id": "xccdf_org.ssgproject.content_rule_audit_rules_time_settimeofday",
        "title": "Record attempts to alter time through settimeofday",
        "rationale": "Arbitrary changes to the system time can be used to obfuscate nefarious activities in log files, as well as to confuse network services that are highly dependent upon an accurate system time (such as sshd). All changes to the system time should be audited."
      }
    }
  },
  "rule": {
    "firedtimes": 25,
    "mail": false,
    "level": 5,
    "pci_dss": ["2.2"],
    "description": "OpenSCAP: Record attempts to alter time through settimeofday (not passed)",
    "groups": ["oscap", "oscap-result"],
    "id": "81529",
    "nist_800_53": ["CM.1"]
  }
}, {
  "data": {
    "oscap": {
      "scan": {
        "profile": {
          "id": "xccdf_org.ssgproject.content_profile_pci-dss",
          "title": "PCI-DSS v3 Control Baseline for Red Hat Enterprise Linux 7"
        },
        "id": "0001587603717",
        "content": "ssg-rhel-7-ds.xml",
        "benchmark": {
          "id": "xccdf_org.ssgproject.content_benchmark_RHEL-7"
        }
      },
      "check": {
        "result": "fail",
        "severity": "medium",
        "references": "AC-17(7) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-1(b) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(a) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(c) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(d) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-12(a) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-12(c) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), IR-5 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), Req-10.2.7 (https://www.pcisecuritystandards.org/documents/PCI_DSS_v3-1.pdf), 5.2.14 (https://benchmarks.cisecurity.org/tools2/linux/CIS_Red_Hat_Enterprise_Linux_7_Benchmark_v1.1.0.pdf), 366 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), 172 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), 2884 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), 5.4.1.1 (https://www.fbi.gov/file-repository/cjis-security-policy-v5_5_20160601-2-1.pdf), 3.1.7 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-171.pdf)",
        "identifiers": "CCE-27206-2 (https://nvd.nist.gov/cce/index.cfm)",
        "oval": {
          "id": "oval:ssg-audit_rules_file_deletion_events:def:1"
        },
        "description": "At a minimum the audit system should collect file deletion events for all users and root. If the auditd daemon is configured to use the augenrules program to read audit rules during daemon startup (the default), add the following line to a file with suffix .rules in the directory /etc/audit/rules.d, setting ARCH to either b32 or b64 as appropriate for your system: -a always,exit -F arch=ARCH -S rmdiri,unlink,unlinkat,rename,renameat -F auid>=1000 -F auid!=4294967295 -F key=delete If the auditd daemon is configured to use the auditctl utility to read audit rules during daemon startup, add the following line to /etc/audit/audit.rules file, setting ARCH to either b32 or b64 as appropriate for your system: -a always,exit -F arch=ARCH -S rmdir,unlink,unlinkat,rename -S renameat -F auid>=1000 -F auid!=4294967295 -F key=delete",
        "id": "xccdf_org.ssgproject.content_rule_audit_rules_file_deletion_events",
        "title": "Ensure auditd Collects File Deletion Events by User",
        "rationale": "Auditing file deletions will create an audit trail for files that are removed from the system. The audit trail could aid in system troubleshooting, as well as, detecting malicious processes that attempt to delete log files to conceal their presence."
      }
    }
  },
  "rule": {
    "firedtimes": 24,
    "mail": false,
    "level": 7,
    "pci_dss": ["2.2"],
    "description": "OpenSCAP: Ensure auditd Collects File Deletion Events by User (not passed)",
    "groups": ["oscap", "oscap-result"],
    "id": "81530",
    "nist_800_53": ["CM.1"]
  }
}, {
  "data": {
    "oscap": {
      "scan": {
        "profile": {
          "id": "xccdf_org.ssgproject.content_profile_pci-dss",
          "title": "PCI-DSS v3 Control Baseline for Red Hat Enterprise Linux 7"
        },
        "id": "0001587603717",
        "content": "ssg-rhel-7-ds.xml",
        "benchmark": {
          "id": "xccdf_org.ssgproject.content_benchmark_RHEL-7"
        }
      },
      "check": {
        "result": "fail",
        "severity": "medium",
        "references": "AC-17(7) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-1(b) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-12(a) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-12(c) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), IR-5 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), 172 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), 2884 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), Req-10.2.3 (https://www.pcisecuritystandards.org/documents/PCI_DSS_v3-1.pdf), 5.2.8 (https://benchmarks.cisecurity.org/tools2/linux/CIS_Red_Hat_Enterprise_Linux_7_Benchmark_v1.1.0.pdf), 5.4.1.1 (https://www.fbi.gov/file-repository/cjis-security-policy-v5_5_20160601-2-1.pdf), 3.1.7 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-171.pdf)",
        "identifiers": "CCE-27204-7 (https://nvd.nist.gov/cce/index.cfm)",
        "oval": {
          "id": "oval:ssg-audit_rules_login_events:def:1"
        },
        "description": "The audit system already collects login information for all users and root. If the auditd daemon is configured to use the augenrules program to read audit rules during daemon startup (the default), add the following lines to a file with suffix .rules in the directory /etc/audit/rules.d in order to watch for attempted manual edits of files involved in storing logon events: -w /var/log/tallylog -p wa -k logins -w /var/run/faillock/ -p wa -k logins -w /var/log/lastlog -p wa -k logins If the auditd daemon is configured to use the auditctl utility to read audit rules during daemon startup, add the following lines to /etc/audit/audit.rules file in order to watch for unattempted manual edits of files involved in storing logon events: -w /var/log/tallylog -p wa -k logins -w /var/run/faillock/ -p wa -k logins -w /var/log/lastlog -p wa -k logins",
        "id": "xccdf_org.ssgproject.content_rule_audit_rules_login_events",
        "title": "Record Attempts to Alter Logon and Logout Events",
        "rationale": "Manual editing of these files may indicate nefarious activity, such as an attacker attempting to remove evidence of an intrusion."
      }
    }
  },
  "rule": {
    "firedtimes": 20,
    "mail": false,
    "level": 7,
    "pci_dss": ["2.2"],
    "description": "OpenSCAP: Record Attempts to Alter Logon and Logout Events (not passed)",
    "groups": ["oscap", "oscap-result"],
    "id": "81530",
    "nist_800_53": ["CM.1"]
  }
}, {
  "data": {
    "oscap": {
      "scan": {
        "profile": {
          "id": "xccdf_org.ssgproject.content_profile_pci-dss",
          "title": "PCI-DSS v3 Control Baseline for Red Hat Enterprise Linux 7"
        },
        "id": "0001587603717",
        "content": "ssg-rhel-7-ds.xml",
        "benchmark": {
          "id": "xccdf_org.ssgproject.content_benchmark_RHEL-7"
        }
      },
      "check": {
        "result": "fail",
        "severity": "low",
        "references": "RHEL-07-030710 (http://iase.disa.mil/stigs/os/unix-linux/Pages/index.aspx), AC-2(4) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AC-17(7) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-1(b) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(a) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(c) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-2(d) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-12(a) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-12(c) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), IR-5 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), 18 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), 172 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), 1403 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), 2130 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), Req-10.2.5 (https://www.pcisecuritystandards.org/documents/PCI_DSS_v3-1.pdf), 5.2.5 (https://benchmarks.cisecurity.org/tools2/linux/CIS_Red_Hat_Enterprise_Linux_7_Benchmark_v1.1.0.pdf), SRG-OS-000004-GPOS-00004 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx), SRG-OS-000239-GPOS-00089 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx), SRG-OS-000241-GPOS-00090 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx), SRG-OS-000241-GPOS-00091 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx), SRG-OS-000303-GPOS-00120 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx), SRG-OS-000476-GPOS-00221 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx), 5.4.1.1 (https://www.fbi.gov/file-repository/cjis-security-policy-v5_5_20160601-2-1.pdf), 3.1.7 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-171.pdf)",
        "identifiers": "CCE-27192-4 (https://nvd.nist.gov/cce/index.cfm)",
        "oval": {
          "id": "oval:ssg-audit_rules_usergroup_modification:def:1"
        },
        "description": "If the auditd daemon is configured to use the augenrules program to read audit rules during daemon startup (the default), add the following lines to a file with suffix .rules in the directory /etc/audit/rules.d, in order to capture events that modify account changes: -w /etc/group -p wa -k audit_rules_usergroup_modification -w /etc/passwd -p wa -k audit_rules_usergroup_modification -w /etc/gshadow -p wa -k audit_rules_usergroup_modification -w /etc/shadow -p wa -k audit_rules_usergroup_modification -w /etc/security/opasswd -p wa -k audit_rules_usergroup_modification If the auditd daemon is configured to use the auditctl utility to read audit rules during daemon startup, add the following lines to /etc/audit/audit.rules file, in order to capture events that modify account changes: -w /etc/group -p wa -k audit_rules_usergroup_modification -w /etc/passwd -p wa -k audit_rules_usergroup_modification -w /etc/gshadow -p wa -k audit_rules_usergroup_modification -w /etc/shadow -p wa -k audit_rules_usergroup_modification -w /etc/security/opasswd -p wa -k audit_rules_usergroup_modification",
        "id": "xccdf_org.ssgproject.content_rule_audit_rules_usergroup_modification",
        "title": "Record Events that Modify User/Group Information",
        "rationale": "In addition to auditing new user and group accounts, these watches will alert the system administrator(s) to any modifications. Any unexpected users, groups, or modifications should be investigated for legitimacy."
      }
    }
  },
  "rule": {
    "firedtimes": 6,
    "mail": false,
    "level": 5,
    "pci_dss": ["2.2"],
    "description": "OpenSCAP: Record Events that Modify User/Group Information (not passed)",
    "groups": ["oscap", "oscap-result"],
    "id": "81529",
    "nist_800_53": ["CM.1"]
  }
}, {
  "data": {
    "oscap": {
      "scan": {
        "profile": {
          "id": "xccdf_org.ssgproject.content_profile_pci-dss",
          "title": "PCI-DSS v3 Control Baseline for Red Hat Enterprise Linux 7"
        },
        "id": "0001587603717",
        "content": "ssg-rhel-7-ds.xml",
        "benchmark": {
          "id": "xccdf_org.ssgproject.content_benchmark_RHEL-7"
        }
      },
      "check": {
        "result": "fail",
        "severity": "medium",
        "references": "AU-1(b) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-3(2) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), IR-5 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), 136 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), Req-10.5.3 (https://www.pcisecuritystandards.org/documents/PCI_DSS_v3-1.pdf), 5.4.1.1 (https://www.fbi.gov/file-repository/cjis-security-policy-v5_5_20160601-2-1.pdf), 3.3.1 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-171.pdf)",
        "identifiers": "CCE-27341-7 (https://nvd.nist.gov/cce/index.cfm)",
        "oval": {
          "id": "oval:ssg-auditd_audispd_syslog_plugin_activated:def:1"
        },
        "description": "To configure the auditd service to use the syslog plug-in of the audispd audit event multiplexor, set the active line in /etc/audisp/plugins.d/syslog.conf to yes. Restart the auditd service: $ sudo service auditd restart",
        "id": "xccdf_org.ssgproject.content_rule_auditd_audispd_syslog_plugin_activated",
        "title": "Configure auditd to use audispd's syslog plugin",
        "rationale": "The auditd service does not include the ability to send audit records to a centralized server for management directly. It does, however, include a plug-in for audit event multiplexor (audispd) to pass audit records to the local syslog server"
      }
    }
  },
  "rule": {
    "firedtimes": 16,
    "mail": false,
    "level": 7,
    "pci_dss": ["2.2"],
    "description": "OpenSCAP: Configure auditd to use audispd's syslog plugin (not passed)",
    "groups": ["oscap", "oscap-result"],
    "id": "81530",
    "nist_800_53": ["CM.1"]
  }
}, {
  "data": {
    "oscap": {
      "scan": {
        "profile": {
          "id": "xccdf_org.ssgproject.content_profile_pci-dss",
          "title": "PCI-DSS v3 Control Baseline for Red Hat Enterprise Linux 7"
        },
        "id": "0001587603717",
        "content": "ssg-rhel-7-ds.xml",
        "benchmark": {
          "id": "xccdf_org.ssgproject.content_benchmark_RHEL-7"
        }
      },
      "check": {
        "result": "fail",
        "severity": "medium",
        "references": "RHEL-07-010500 (http://iase.disa.mil/stigs/os/unix-linux/Pages/index.aspx), IA-2(2) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), 765 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), 766 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), 767 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), 768 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), 771 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), 772 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), 884 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), Req-8.3 (https://www.pcisecuritystandards.org/documents/PCI_DSS_v3-1.pdf), SRG-OS-000104-GPOS-00051 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx), SRG-OS-000106-GPOS-00053 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx), SRG-OS-000107-GPOS-00054 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx), SRG-OS-000109-GPOS-00056 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx), SRG-OS-000108-GPOS-00055 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx), SRG-OS-000108-GPOS-00057 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx), SRG-OS-000108-GPOS-00058 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx)",
        "identifiers": "CCE-80207-4 (https://nvd.nist.gov/cce/index.cfm)",
        "oval": {
          "id": "oval:ssg-smartcard_auth:def:1"
        },
        "description": "To enable smart card authentication, consult the documentation at: https://access.redhat.com/documentation/en-US/Red_Hat_Enterprise_Linux/7/html/System-Level_Authentication_Guide/smartcards.html#authconfig-smartcards For guidance on enabling SSH to authenticate against a Common Access Card (CAC), consult documentation at: https://access.redhat.com/solutions/82273",
        "id": "xccdf_org.ssgproject.content_rule_smartcard_auth",
        "title": "Enable Smart Card Login",
        "rationale": "Smart card login provides two-factor authentication stronger than that provided by a username and password combination. Smart cards leverage PKI (public key infrastructure) in order to provide and verify credentials."
      }
    }
  },
  "rule": {
    "firedtimes": 11,
    "mail": false,
    "level": 7,
    "pci_dss": ["2.2"],
    "description": "OpenSCAP: Enable Smart Card Login (not passed)",
    "groups": ["oscap", "oscap-result"],
    "id": "81530",
    "nist_800_53": ["CM.1"]
  }
}, {
  "data": {
    "oscap": {
      "scan": {
        "profile": {
          "id": "xccdf_org.ssgproject.content_profile_pci-dss",
          "title": "PCI-DSS v3 Control Baseline for Red Hat Enterprise Linux 7"
        },
        "id": "0001587603717",
        "content": "ssg-rhel-7-ds.xml",
        "benchmark": {
          "id": "xccdf_org.ssgproject.content_benchmark_RHEL-7"
        }
      },
      "check": {
        "result": "fail",
        "severity": "medium",
        "references": "RHEL-07-010270 (http://iase.disa.mil/stigs/os/unix-linux/Pages/index.aspx), IA-5(f) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), IA-5(1)(e) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), 200 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), SRG-OS-000077-GPOS-00045 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx), Req-8.2.5 (https://www.pcisecuritystandards.org/documents/PCI_DSS_v3-1.pdf), 5.3.3 (https://benchmarks.cisecurity.org/tools2/linux/CIS_Red_Hat_Enterprise_Linux_7_Benchmark_v1.1.0.pdf), 5.6.2.1.1 (https://www.fbi.gov/file-repository/cjis-security-policy-v5_5_20160601-2-1.pdf), 3.5.8 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-171.pdf)",
        "identifiers": "CCE-26923-3 (https://nvd.nist.gov/cce/index.cfm)",
        "oval": {
          "id": "oval:ssg-accounts_password_pam_unix_remember:def:1"
        },
        "description": "Do not allow users to reuse recent passwords. This can be accomplished by using the remember option for the pam_unix or pam_pwhistory PAM modules. In the file /etc/pam.d/system-auth, append remember= to the line which refers to the pam_unix.so or pam_pwhistory.somodule, as shown below: for the pam_unix.so case: password sufficient pam_unix.so ...existing_options... remember= for the pam_pwhistory.so case: password requisite pam_pwhistory.so ...existing_options... remember= The DoD STIG requirement is 5 passwords.",
        "id": "xccdf_org.ssgproject.content_rule_accounts_password_pam_unix_remember",
        "title": "Limit Password Reuse",
        "rationale": "Preventing re-use of previous passwords helps ensure that a compromised password is not re-used by a user."
      }
    }
  },
  "rule": {
    "firedtimes": 10,
    "mail": false,
    "level": 7,
    "pci_dss": ["2.2"],
    "description": "OpenSCAP: Limit Password Reuse (not passed)",
    "groups": ["oscap", "oscap-result"],
    "id": "81530",
    "nist_800_53": ["CM.1"]
  }
}, {
  "data": {
    "oscap": {
      "scan": {
        "profile": {
          "id": "xccdf_org.ssgproject.content_profile_pci-dss",
          "title": "PCI-DSS v3 Control Baseline for Red Hat Enterprise Linux 7"
        },
        "id": "0001587603717",
        "content": "ssg-rhel-7-ds.xml",
        "benchmark": {
          "id": "xccdf_org.ssgproject.content_benchmark_RHEL-7"
        }
      },
      "check": {
        "result": "fail",
        "severity": "medium",
        "references": "RHEL-07-010320 (http://iase.disa.mil/stigs/os/unix-linux/Pages/index.aspx), AC-7(b) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), 002238 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), SRG-OS-000329-GPOS-00128 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx), SRG-OS-000021-GPOS-00005 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx), Req-8.1.7 (https://www.pcisecuritystandards.org/documents/PCI_DSS_v3-1.pdf), 6.3.3 (https://benchmarks.cisecurity.org/tools2/linux/CIS_Red_Hat_Enterprise_Linux_7_Benchmark_v1.1.0.pdf), 5.5.3 (https://www.fbi.gov/file-repository/cjis-security-policy-v5_5_20160601-2-1.pdf), 3.1.8 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-171.pdf)",
        "identifiers": "CCE-26884-7 (https://nvd.nist.gov/cce/index.cfm)",
        "oval": {
          "id": "oval:ssg-accounts_passwords_pam_faillock_unlock_time:def:1"
        },
        "description": "To configure the system to lock out accounts after a number of incorrect login attempts and require an administrator to unlock the account using pam_faillock.so, modify the content of both /etc/pam.d/system-auth and /etc/pam.d/password-auth as follows: add the following line immediately before the pam_unix.so statement in the AUTH section: auth required pam_faillock.so preauth silent deny= unlock_time= fail_interval= add the following line immediately after the pam_unix.so statement in the AUTH section: auth [default=die] pam_faillock.so authfail deny= unlock_time= fail_interval= add the following line immediately before the pam_unix.so statement in the ACCOUNT section: account required pam_faillock.so",
        "id": "xccdf_org.ssgproject.content_rule_accounts_passwords_pam_faillock_unlock_time",
        "title": "Set Lockout Time For Failed Password Attempts",
        "rationale": "Locking out user accounts after a number of incorrect attempts prevents direct password guessing attacks. Ensuring that an administrator is involved in unlocking locked accounts draws appropriate attention to such situations."
      }
    }
  },
  "rule": {
    "firedtimes": 9,
    "mail": false,
    "level": 7,
    "pci_dss": ["2.2"],
    "description": "OpenSCAP: Set Lockout Time For Failed Password Attempts (not passed)",
    "groups": ["oscap", "oscap-result"],
    "id": "81530",
    "nist_800_53": ["CM.1"]
  }
}, {
  "data": {
    "oscap": {
      "scan": {
        "profile": {
          "id": "xccdf_org.ssgproject.content_profile_pci-dss",
          "title": "PCI-DSS v3 Control Baseline for Red Hat Enterprise Linux 7"
        },
        "id": "0001587603717",
        "content": "ssg-rhel-7-ds.xml",
        "benchmark": {
          "id": "xccdf_org.ssgproject.content_benchmark_RHEL-7"
        }
      },
      "check": {
        "result": "fail",
        "severity": "medium",
        "references": "RHEL-07-010320 (http://iase.disa.mil/stigs/os/unix-linux/Pages/index.aspx), AC-7(b) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), 2238 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), SRG-OS-000329-GPOS-00128 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx), SRG-OS-000021-GPOS-00005 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx), Req-8.1.6 (https://www.pcisecuritystandards.org/documents/PCI_DSS_v3-1.pdf), 6.3.3 (https://benchmarks.cisecurity.org/tools2/linux/CIS_Red_Hat_Enterprise_Linux_7_Benchmark_v1.1.0.pdf), 5.5.3 (https://www.fbi.gov/file-repository/cjis-security-policy-v5_5_20160601-2-1.pdf), 3.1.8 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-171.pdf)",
        "identifiers": "CCE-27350-8 (https://nvd.nist.gov/cce/index.cfm)",
        "oval": {
          "id": "oval:ssg-accounts_passwords_pam_faillock_deny:def:1"
        },
        "description": "To configure the system to lock out accounts after a number of incorrect login attempts using pam_faillock.so, modify the content of both /etc/pam.d/system-auth and /etc/pam.d/password-auth as follows: add the following line immediately before the pam_unix.so statement in the AUTH section: auth required pam_faillock.so preauth silent deny= unlock_time= fail_interval= add the following line immediately after the pam_unix.so statement in the AUTH section: auth [default=die] pam_faillock.so authfail deny= unlock_time= fail_interval= add the following line immediately before the pam_unix.so statement in the ACCOUNT section: account required pam_faillock.so",
        "id": "xccdf_org.ssgproject.content_rule_accounts_passwords_pam_faillock_deny",
        "title": "Set Deny For Failed Password Attempts",
        "rationale": "Locking out user accounts after a number of incorrect attempts prevents direct password guessing attacks."
      }
    }
  },
  "rule": {
    "firedtimes": 8,
    "mail": false,
    "level": 7,
    "pci_dss": ["2.2"],
    "description": "OpenSCAP: Set Deny For Failed Password Attempts (not passed)",
    "groups": ["oscap", "oscap-result"],
    "id": "81530",
    "nist_800_53": ["CM.1"]
  }
}, {
  "data": {
    "oscap": {
      "scan": {
        "profile": {
          "id": "xccdf_org.ssgproject.content_profile_pci-dss",
          "title": "PCI-DSS v3 Control Baseline for Red Hat Enterprise Linux 7"
        },
        "id": "0001587603717",
        "content": "ssg-rhel-7-ds.xml",
        "benchmark": {
          "id": "xccdf_org.ssgproject.content_benchmark_RHEL-7"
        }
      },
      "check": {
        "result": "fail",
        "severity": "medium",
        "references": "RHEL-07-010130 (http://iase.disa.mil/stigs/os/unix-linux/Pages/index.aspx), IA-5(b) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), IA-5(c) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), IA-5(1)(a) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), 193 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), SRG-OS-000070-GPOS-00038 (), Req-8.2.3 (https://www.pcisecuritystandards.org/documents/PCI_DSS_v3-1.pdf)",
        "identifiers": "CCE-27345-8 (https://nvd.nist.gov/cce/index.cfm)",
        "oval": {
          "id": "oval:ssg-accounts_password_pam_lcredit:def:1"
        },
        "description": "The pam_pwquality module's lcredit parameter controls requirements for usage of lowercase letters in a password. When set to a negative number, any password will be required to contain that many lowercase characters. When set to a positive number, pam_pwquality will grant +1 additional length credit for each lowercase character. Modify the lcredit setting in /etc/security/pwquality.conf to require the use of a lowercase character in passwords.",
        "id": "xccdf_org.ssgproject.content_rule_accounts_password_pam_lcredit",
        "title": "Set Password Strength Minimum Lowercase Characters",
        "rationale": "Use of a complex password helps to increase the time and resources required to compromise the password. Password complexity, or strength, is a measure of the effectiveness of a password in resisting attempts at guessing and brute-force attacks. Password complexity is one factor of several that determines how long it takes to crack a password. The more complex the password, the greater the number of possble combinations that need to be tested before the password is compromised. Requiring a minimum number of lowercase characters makes password guessing attacks more difficult by ensuring a larger search space."
      }
    }
  },
  "rule": {
    "firedtimes": 7,
    "mail": false,
    "level": 7,
    "pci_dss": ["2.2"],
    "description": "OpenSCAP: Set Password Strength Minimum Lowercase Characters (not passed)",
    "groups": ["oscap", "oscap-result"],
    "id": "81530",
    "nist_800_53": ["CM.1"]
  }
}, {
  "data": {
    "oscap": {
      "scan": {
        "profile": {
          "id": "xccdf_org.ssgproject.content_profile_pci-dss",
          "title": "PCI-DSS v3 Control Baseline for Red Hat Enterprise Linux 7"
        },
        "id": "0001587603717",
        "content": "ssg-rhel-7-ds.xml",
        "benchmark": {
          "id": "xccdf_org.ssgproject.content_benchmark_RHEL-7"
        }
      },
      "check": {
        "result": "fail",
        "severity": "medium",
        "references": "RHEL-07-010120 (http://iase.disa.mil/stigs/os/unix-linux/Pages/index.aspx), IA-5(b) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), IA-5(c) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), IA-5(1)(a) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), 192 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), SRG-OS-000069-GPOS-00037 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx), Req-8.2.3 (https://www.pcisecuritystandards.org/documents/PCI_DSS_v3-1.pdf), 6.3.2 (https://benchmarks.cisecurity.org/tools2/linux/CIS_Red_Hat_Enterprise_Linux_7_Benchmark_v1.1.0.pdf)",
        "identifiers": "CCE-27200-5 (https://nvd.nist.gov/cce/index.cfm)",
        "oval": {
          "id": "oval:ssg-accounts_password_pam_ucredit:def:1"
        },
        "description": "The pam_pwquality module's ucredit= parameter controls requirements for usage of uppercase letters in a password. When set to a negative number, any password will be required to contain that many uppercase characters. When set to a positive number, pam_pwquality will grant +1 additional length credit for each uppercase character. Modify the ucredit setting in /etc/security/pwquality.conf to require the use of an uppercase character in passwords.",
        "id": "xccdf_org.ssgproject.content_rule_accounts_password_pam_ucredit",
        "title": "Set Password Strength Minimum Uppercase Characters",
        "rationale": "Use of a complex password helps to increase the time and resources reuiqred to compromise the password. Password complexity, or strength, is a measure of the effectiveness of a password in resisting attempts at guessing and brute-force attacks. Password complexity is one factor of several that determines how long it takes to crack a password. The more complex the password, the greater the number of possible combinations that need to be tested before the password is compromised."
      }
    }
  },
  "rule": {
    "firedtimes": 6,
    "mail": false,
    "level": 7,
    "pci_dss": ["2.2"],
    "description": "OpenSCAP: Set Password Strength Minimum Uppercase Characters (not passed)",
    "groups": ["oscap", "oscap-result"],
    "id": "81530",
    "nist_800_53": ["CM.1"]
  }
}, {
  "data": {
    "oscap": {
      "scan": {
        "profile": {
          "id": "xccdf_org.ssgproject.content_profile_pci-dss",
          "title": "PCI-DSS v3 Control Baseline for Red Hat Enterprise Linux 7"
        },
        "id": "0001587603717",
        "content": "ssg-rhel-7-ds.xml",
        "benchmark": {
          "id": "xccdf_org.ssgproject.content_benchmark_RHEL-7"
        }
      },
      "check": {
        "result": "fail",
        "severity": "medium",
        "references": "RHEL-07-010280 (http://iase.disa.mil/stigs/os/unix-linux/Pages/index.aspx), IA-5(1)(a) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), 205 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), SRG-OS-000078-GPOS-00046 (), Req-8.2.3 (https://www.pcisecuritystandards.org/documents/PCI_DSS_v3-1.pdf), 6.3.2 (https://benchmarks.cisecurity.org/tools2/linux/CIS_Red_Hat_Enterprise_Linux_7_Benchmark_v1.1.0.pdf)",
        "identifiers": "CCE-27293-0 (https://nvd.nist.gov/cce/index.cfm)",
        "oval": {
          "id": "oval:ssg-accounts_password_pam_minlen:def:1"
        },
        "description": "The pam_pwquality module's minlen parameter controls requirements for minimum characters required in a password. Add minlen= after pam_pwquality to set minimum password length requirements.",
        "id": "xccdf_org.ssgproject.content_rule_accounts_password_pam_minlen",
        "title": "Set Password Minimum Length",
        "rationale": "The shorter the password, the lower the number of possible combinations that need to be tested before the password is compromised. Password complexity, or strength, is a measure of the effectiveness of a password in resisting attempts at guessing and brute-force attacks. Password length is one factor of several that helps to determine strength and how long it takes to crack a password. Use of more characters in a password helps to exponentially increase the time and/or resources required to compromose the password."
      }
    }
  },
  "rule": {
    "firedtimes": 5,
    "mail": false,
    "level": 7,
    "pci_dss": ["2.2"],
    "description": "OpenSCAP: Set Password Minimum Length (not passed)",
    "groups": ["oscap", "oscap-result"],
    "id": "81530",
    "nist_800_53": ["CM.1"]
  }
}, {
  "data": {
    "oscap": {
      "scan": {
        "profile": {
          "id": "xccdf_org.ssgproject.content_profile_pci-dss",
          "title": "PCI-DSS v3 Control Baseline for Red Hat Enterprise Linux 7"
        },
        "id": "0001587603717",
        "content": "ssg-rhel-7-ds.xml",
        "benchmark": {
          "id": "xccdf_org.ssgproject.content_benchmark_RHEL-7"
        }
      },
      "check": {
        "result": "fail",
        "severity": "medium",
        "references": "RHEL-07-010140 (http://iase.disa.mil/stigs/os/unix-linux/Pages/index.aspx), IA-5(1)(a) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), IA-5(b) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), IA-5(c) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), 194 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), 194 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), SRG-OS-000071-GPOS-00039 (), Req-8.2.3 (https://www.pcisecuritystandards.org/documents/PCI_DSS_v3-1.pdf), 6.3.2 (https://benchmarks.cisecurity.org/tools2/linux/CIS_Red_Hat_Enterprise_Linux_7_Benchmark_v1.1.0.pdf)",
        "identifiers": "CCE-27214-6 (https://nvd.nist.gov/cce/index.cfm)",
        "oval": {
          "id": "oval:ssg-accounts_password_pam_dcredit:def:1"
        },
        "description": "The pam_pwquality module's dcredit parameter controls requirements for usage of digits in a password. When set to a negative number, any password will be required to contain that many digits. When set to a positive number, pam_pwquality will grant +1 additional length credit for each digit. Modify the dcredit setting in /etc/security/pwquality.conf to require the use of a digit in passwords.",
        "id": "xccdf_org.ssgproject.content_rule_accounts_password_pam_dcredit",
        "title": "Set Password Strength Minimum Digit Characters",
        "rationale": "Use of a complex password helps to increase the time and resources required to compromise the password. Password complexity, or strength, is a measure of the effectiveness of a password in resisting attempts at guessing and brute-force attacks. Password complexity is one factor of several that determines how long it takes to crack a password. The more complex the password, the greater the number of possble combinations that need to be tested before the password is compromised. Requiring digits makes password guessing attacks more difficult by ensuring a larger search space."
      }
    }
  },
  "rule": {
    "firedtimes": 4,
    "mail": false,
    "level": 7,
    "pci_dss": ["2.2"],
    "description": "OpenSCAP: Set Password Strength Minimum Digit Characters (not passed)",
    "groups": ["oscap", "oscap-result"],
    "id": "81530",
    "nist_800_53": ["CM.1"]
  }
}, {
  "data": {
    "oscap": {
      "scan": {
        "profile": {
          "id": "xccdf_org.ssgproject.content_profile_pci-dss",
          "title": "PCI-DSS v3 Control Baseline for Red Hat Enterprise Linux 7"
        },
        "id": "0001587603717",
        "content": "ssg-rhel-7-ds.xml",
        "benchmark": {
          "id": "xccdf_org.ssgproject.content_benchmark_RHEL-7"
        }
      },
      "check": {
        "result": "fail",
        "severity": "medium",
        "references": "RHEL-07-010250 (http://iase.disa.mil/stigs/os/unix-linux/Pages/index.aspx), IA-5(f) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), IA-5(g) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), IA-5(1)(d) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), 199 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), SRG-OS-000076-GPOS-00044 (), Req-8.2.4 (https://www.pcisecuritystandards.org/documents/PCI_DSS_v3-1.pdf), 5.4.1.1 (https://benchmarks.cisecurity.org/tools2/linux/CIS_Red_Hat_Enterprise_Linux_7_Benchmark_v1.1.0.pdf), 5.6.2.1 (https://www.fbi.gov/file-repository/cjis-security-policy-v5_5_20160601-2-1.pdf), 3.5.6 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-171.pdf)",
        "identifiers": "CCE-27051-2 (https://nvd.nist.gov/cce/index.cfm)",
        "oval": {
          "id": "oval:ssg-accounts_maximum_age_login_defs:def:1"
        },
        "description": "To specify password maximum age for new accounts, edit the file /etc/login.defs and add or correct the following line: PASS_MAX_DAYS A value of 180 days is sufficient for many environments. The DoD requirement is 60. The profile requirement is .",
        "id": "xccdf_org.ssgproject.content_rule_accounts_maximum_age_login_defs",
        "title": "Set Password Maximum Age",
        "rationale": "Any password, no matter how complex, can eventually be cracked. Therefore, passwords need to be changed periodically. If the operating system does not limit the lifetime of passwords and force users to change their passwords, there is the risk that the operating system passwords could be compromised. Setting the password maximum age ensures users are required to periodically change their passwords. Requiring shorter password lifetimes increases the risk of users writing down the password in a convenient location subject to physical compromise."
      }
    }
  },
  "rule": {
    "firedtimes": 3,
    "mail": false,
    "level": 7,
    "pci_dss": ["2.2"],
    "description": "OpenSCAP: Set Password Maximum Age (not passed)",
    "groups": ["oscap", "oscap-result"],
    "id": "81530",
    "nist_800_53": ["CM.1"]
  }
}, {
  "data": {
    "oscap": {
      "scan": {
        "profile": {
          "id": "xccdf_org.ssgproject.content_profile_pci-dss",
          "title": "PCI-DSS v3 Control Baseline for Red Hat Enterprise Linux 7"
        },
        "id": "0001587603717",
        "content": "ssg-rhel-7-ds.xml",
        "benchmark": {
          "id": "xccdf_org.ssgproject.content_benchmark_RHEL-7"
        }
      },
      "check": {
        "result": "fail",
        "severity": "high",
        "references": "RHEL-07-010290 (http://iase.disa.mil/stigs/os/unix-linux/Pages/index.aspx), AC-6 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), IA-5(b) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), IA-5(c) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), IA-5(1)(a) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), 366 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), SRG-OS-000480-GPOS-00227 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx), Req-8.2.3 (https://www.pcisecuritystandards.org/documents/PCI_DSS_v3-1.pdf), 5.5.2 (https://www.fbi.gov/file-repository/cjis-security-policy-v5_5_20160601-2-1.pdf), 3.1.1 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-171.pdf), 3.1.5 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-171.pdf)",
        "identifiers": "CCE-27286-4 (https://nvd.nist.gov/cce/index.cfm)",
        "oval": {
          "id": "oval:ssg-no_empty_passwords:def:1"
        },
        "description": "If an account is configured for password authentication but does not have an assigned password, it may be possible to log into the account without authentication. Remove any instances of the nullok option in /etc/pam.d/system-auth to prevent logins with empty passwords.",
        "id": "xccdf_org.ssgproject.content_rule_no_empty_passwords",
        "title": "Prevent Log In to Accounts With Empty Password",
        "rationale": "If an account has an empty password, anyone could log in and run commands with the privileges of that account. Accounts with empty passwords should never be used in operational environments."
      }
    }
  },
  "rule": {
    "firedtimes": 2,
    "mail": false,
    "level": 9,
    "pci_dss": ["2.2"],
    "description": "OpenSCAP: Prevent Log In to Accounts With Empty Password (not passed)",
    "groups": ["oscap", "oscap-result"],
    "id": "81531",
    "nist_800_53": ["CM.1"]
  }
}, {
  "data": {
    "oscap": {
      "scan": {
        "profile": {
          "id": "xccdf_org.ssgproject.content_profile_pci-dss",
          "title": "PCI-DSS v3 Control Baseline for Red Hat Enterprise Linux 7"
        },
        "id": "0001587603717",
        "content": "ssg-rhel-7-ds.xml",
        "benchmark": {
          "id": "xccdf_org.ssgproject.content_benchmark_RHEL-7"
        }
      },
      "check": {
        "result": "fail",
        "severity": "high",
        "references": "RHEL-07-010010 (http://iase.disa.mil/stigs/os/unix-linux/Pages/index.aspx), AC-6 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-9(1) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), AU-9(3) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), CM-6(d) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), CM-6(3) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), 1494 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), 1496 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), Req-11.5 (https://www.pcisecuritystandards.org/documents/PCI_DSS_v3-1.pdf), 1.2.6 (https://benchmarks.cisecurity.org/tools2/linux/CIS_Red_Hat_Enterprise_Linux_7_Benchmark_v1.1.0.pdf), 6.1.3 (https://benchmarks.cisecurity.org/tools2/linux/CIS_Red_Hat_Enterprise_Linux_7_Benchmark_v1.1.0.pdf), 6.1.4 (https://benchmarks.cisecurity.org/tools2/linux/CIS_Red_Hat_Enterprise_Linux_7_Benchmark_v1.1.0.pdf), 6.1.5 (https://benchmarks.cisecurity.org/tools2/linux/CIS_Red_Hat_Enterprise_Linux_7_Benchmark_v1.1.0.pdf), 6.1.6 (https://benchmarks.cisecurity.org/tools2/linux/CIS_Red_Hat_Enterprise_Linux_7_Benchmark_v1.1.0.pdf), 6.1.7 (https://benchmarks.cisecurity.org/tools2/linux/CIS_Red_Hat_Enterprise_Linux_7_Benchmark_v1.1.0.pdf), 6.1.8 (https://benchmarks.cisecurity.org/tools2/linux/CIS_Red_Hat_Enterprise_Linux_7_Benchmark_v1.1.0.pdf), 6.1.9 (https://benchmarks.cisecurity.org/tools2/linux/CIS_Red_Hat_Enterprise_Linux_7_Benchmark_v1.1.0.pdf), 6.2.3 (https://benchmarks.cisecurity.org/tools2/linux/CIS_Red_Hat_Enterprise_Linux_7_Benchmark_v1.1.0.pdf), SRG-OS-000257-GPOS-00098 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx), SRG-OS-000278-GPOS-00108 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx), 5.10.4.1 (https://www.fbi.gov/file-repository/cjis-security-policy-v5_5_20160601-2-1.pdf), 3.3.8 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-171.pdf), 3.4.1 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-171.pdf)",
        "identifiers": "CCE-27209-6 (https://nvd.nist.gov/cce/index.cfm)",
        "oval": {
          "id": "oval:ssg-rpm_verify_permissions:def:1"
        },
        "description": "Discretionary access control is weakened if a user or group has access permissions to system files and directories greater than the default. The RPM package management system can check file access permissions of installed software packages, including many that are important to system security. Verify that the file permissions, ownership, and gruop membership of system files and commands match vendor values. Check the file permissions, ownership, and group membership with the following command: $ sudo rpm -Va | grep '^.M' Output indicates files that do not match vendor defaults. After locating a file with incorrect permissions, run the following command to determine which package owns it: $ rpm -qf FILENAME Next, run the following command to reset its permissions to the correct values: $ sudo rpm --setperms PACKAGENAME",
        "id": "xccdf_org.ssgproject.content_rule_rpm_verify_permissions",
        "title": "Verify and Correct File Permissions with RPM",
        "rationale": "Permissions on system binaries and configuration files that are too generous could allow an unauthorized user to gain privileges that they should not have. The permissions set by the vendor should be maintained. Any deviations from this baseline should be investigated."
      }
    }
  },
  "rule": {
    "firedtimes": 1,
    "mail": false,
    "level": 9,
    "pci_dss": ["2.2"],
    "description": "OpenSCAP: Verify and Correct File Permissions with RPM (not passed)",
    "groups": ["oscap", "oscap-result"],
    "id": "81531",
    "nist_800_53": ["CM.1"]
  }
}, {
  "data": {
    "oscap": {
      "scan": {
        "profile": {
          "id": "xccdf_org.ssgproject.content_profile_pci-dss",
          "title": "PCI-DSS v3 Control Baseline for Red Hat Enterprise Linux 7"
        },
        "id": "0001587603717",
        "content": "ssg-rhel-7-ds.xml",
        "benchmark": {
          "id": "xccdf_org.ssgproject.content_benchmark_RHEL-7"
        }
      },
      "check": {
        "result": "fail",
        "severity": "medium",
        "references": "RHEL-07-020030 (http://iase.disa.mil/stigs/os/unix-linux/Pages/index.aspx), CM-3(d) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), CM-3(e) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), CM-3(5) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), CM-6(d) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), CM-6(3) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), SC-28 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), SI-7 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), 1744 (http://iase.disa.mil/stigs/cci/Pages/index.aspx), Req-11.5 (https://www.pcisecuritystandards.org/documents/PCI_DSS_v3-1.pdf), 1.3.2 (https://benchmarks.cisecurity.org/tools2/linux/CIS_Red_Hat_Enterprise_Linux_7_Benchmark_v1.1.0.pdf), SRG-OS-000363-GPOS-00150 (http://iase.disa.mil/stigs/srgs/Pages/index.aspx), 5.10.1.3 (https://www.fbi.gov/file-repository/cjis-security-policy-v5_5_20160601-2-1.pdf)",
        "identifiers": "CCE-26952-2 (https://nvd.nist.gov/cce/index.cfm)",
        "oval": {
          "id": "oval:ssg-aide_periodic_cron_checking:def:1"
        },
        "description": "At a minimum, AIDE should be configured to run a weekly scan. At most, AIDE should be run daily. To implement a daily execution of AIDE at 4:05am using cron, add the following line to /etc/crontab: 05 4 * * * root /usr/sbin/aide --check To implement a weekly execution of AIDE at 4:05am using cron, add the following line to /etc/crontab: 05 4 * * 0 root /usr/sbin/aide --check AIDE can be executed periodically through other means; this is merely one example.",
        "id": "xccdf_org.ssgproject.content_rule_aide_periodic_cron_checking",
        "title": "Configure Periodic Execution of AIDE",
        "rationale": "By default, AIDE does not install itself for periodic execution. Periodically running AIDE is necessary to reveal unexpected changes in installed files. Unauthorized changes to the baseline configuration could make the system vulnerable to various attacks or allow unauthorized access to the operating system. Changes to operating system configurations can have unintended side effects, some of which may be relevant to security. Detecting such changes and providing an automated response can help avoid unintended, negative consequences that could ultimately affect the security state of the operating system. The operating system's Information Management Officer (IMO)/Information System Security Officer (ISSO) and System Administrators (SAs) must be notified via email and/or monitoring system trap when there is an unauthorized modification of a configuration item."
      }
    }
  },
  "rule": {
    "firedtimes": 2,
    "mail": false,
    "level": 7,
    "pci_dss": ["2.2"],
    "description": "OpenSCAP: Configure Periodic Execution of AIDE (not passed)",
    "groups": ["oscap", "oscap-result"],
    "id": "81530",
    "nist_800_53": ["CM.1"]
  }
}, {
  "data": {
    "oscap": {
      "scan": {
        "profile": {
          "id": "xccdf_org.ssgproject.content_profile_pci-dss",
          "title": "PCI-DSS v3 Control Baseline for Red Hat Enterprise Linux 7"
        },
        "id": "0001587603717",
        "content": "ssg-rhel-7-ds.xml",
        "benchmark": {
          "id": "xccdf_org.ssgproject.content_benchmark_RHEL-7"
        }
      },
      "check": {
        "result": "fail",
        "severity": "medium",
        "references": "CM-3(d) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), CM-3(e) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), CM-6(d) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), CM-6(3) (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), SC-28 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf), SI-7 (http://nvlpubs.nist.gov/nistpubs/SpecialPublications/NIST.SP.800-53r4.pdf),  (http://iase.disa.mil/stigs/cci/Pages/index.aspx), Req-11.5 (https://www.pcisecuritystandards.org/documents/PCI_DSS_v3-1.pdf), 1.3.1 (https://benchmarks.cisecurity.org/tools2/linux/CIS_Red_Hat_Enterprise_Linux_7_Benchmark_v1.1.0.pdf), 5.10.1.3 (https://www.fbi.gov/file-repository/cjis-security-policy-v5_5_20160601-2-1.pdf)",
        "identifiers": "CCE-27096-7 (https://nvd.nist.gov/cce/index.cfm)",
        "oval": {
          "id": "oval:ssg-package_aide_installed:def:1"
        },
        "description": "Install the AIDE package with the command: $ sudo yum install aide",
        "id": "xccdf_org.ssgproject.content_rule_package_aide_installed",
        "title": "Install AIDE",
        "rationale": "The AIDE package must be installed if it is to be available for integrity checking."
      }
    }
  },
  "rule": {
    "firedtimes": 1,
    "mail": false,
    "level": 7,
    "pci_dss": ["2.2"],
    "description": "OpenSCAP: Install AIDE (not passed)",
    "groups": ["oscap", "oscap-result"],
    "id": "81530",
    "nist_800_53": ["CM.1"]
  }
}, {
  "data": {
    "oscap": {
      "scan": {
        "score": "99.814812",
        "profile": {
          "id": "No profile",
          "title": "No profile"
        },
        "id": "0001587574647",
        "content": "cve-redhat-7-ds.xml",
        "benchmark": {
          "id": "xccdf_com.redhat.rhsa_benchmark_generated-xccdf"
        }
      }
    }
  },
  "manager": {
    "name": "ip-10-0-0-219.us-west-1.compute.internal"
  },
  "rule": {
    "firedtimes": 1,
    "mail": false,
    "level": 3,
    "pci_dss": ["2.2"],
    "description": "OpenSCAP Report overview.",
    "groups": ["oscap", "oscap-report"],
    "id": "81540",
    "nist_800_53": ["CM.1"]
  }
}];
exports.data = data;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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