"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dataOsquery = void 0;

/*
 * Wazuh app - Osquery sample alerts
 * Copyright (C) 2015-2022 Wazuh, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Find more information about this on the LICENSE file.
 */
const dataOsquery = [{
  osquery: {
    calendarTime: new Date(),
    subquery: "osquery_info",
    columns: {
      counter: "43",
      uuid: "EC234A5B-D23B-A7AD-CFF7-BC3F24CC5366",
      version: "3.3.2"
    },
    name: "pack_osquery-monitoring_osquery_info",
    action: "added",
    epoch: "0",
    counter: "1836",
    pack: "osquery-monitoring"
  },
  rule: {
    firedtimes: 2,
    mail: false,
    level: 4,
    description: 'osquery: osquery-monitoring osquery_info: Osquery version is 3.3.2 build on ubuntu xenial'
  }
}, {
  osquery: {
    calendarTime: new Date(),
    subquery: "iptables",
    columns: {
      chain: "POSTROUTING",
      filter_name: "nat",
      dst_mask: "0.0.0.0",
      match: "yes",
      src_mask: "255.255.0.0",
      dst_ip: "0.0.0.0",
      packets: "43092",
      target: "MASQUERADE",
      src_ip: "172.17.0.0",
      protocol: "0",
      outiface_mask: "FFFFFFFFFFFFFFFF",
      bytes: "3271628",
      iniface: "all",
      outiface: "docker0",
      policy: "ACCEPT"
    },
    name: "pack_incident-response_iptables",
    action: "added",
    epoch: "0",
    counter: "282",
    pack: "incident-response"
  },
  rule: {
    firedtimes: 17,
    mail: false,
    level: 4,
    description: "osquery: incident-response iptables: Iptable source ip 172.17.0.0 with policy ACCEPT and target MASQUERADE has a packet count of 43092"
  }
}, {
  osquery: {
    calendarTime: new Date(),
    subquery: "iptables",
    columns: {
      chain: "PREROUTING",
      filter_name: "nat",
      dst_mask: "0.0.0.0",
      match: "yes",
      src_mask: "0.0.0.0",
      dst_ip: "0.0.0.0",
      packets: "34553",
      target: "DOCKER",
      src_ip: "0.0.0.0",
      protocol: "0",
      bytes: "2065050",
      iniface: "all",
      outiface: "all",
      policy: "ACCEPT"
    },
    name: "pack_incident-response_iptables",
    action: "added",
    epoch: "0",
    counter: "282",
    pack: "incident-response"
  },
  rule: {
    firedtimes: 17,
    mail: false,
    level: 4,
    description: "osquery: incident-response iptables: Iptable source ip 0.0.0.0 with policy ACCEPT and target DOCKER has a packet count of 34553"
  }
}, {
  osquery: {
    calendarTime: new Date(),
    subquery: "schedule",
    columns: {
      average_memory: "0",
      avg_system_time: "0",
      executions: "177",
      output_size: "0",
      name: "pack_ossec-rootkit_zk_rootkit",
      interval: "3600",
      avg_user_time: "0",
      last_executed: "1587482079",
      wall_time: "0"
    },
    name: "pack_osquery-monitoring_schedule",
    action: "added",
    epoch: "0",
    counter: "282",
    pack: "osquery-monitoring"
  },
  rule: {
    firedtimes: 82,
    mail: false,
    level: 4,
    description: "osquery: osquery-monitoring schedule: The pack executed is pack_ossec-rootkit_zk_rootkit and the interval is 3600 "
  }
}, {
  osquery: {
    calendarTime: new Date(),
    subquery: "osquery_info",
    columns: {
      watcher: "18596",
      system_time: "86740",
      config_valid: "1",
      pid: "18631",
      counter: "33",
      uuid: "EC234A5B-D23B-A7AD-CFF7-BC3F24CC5366",
      version: "3.3.2",
      config_hash: "8423af1820e09cef21c8ed5594827b13ea8af90d",
      build_platform: "ubuntu",
      start_time: "1586893611",
      extensions: "active",
      instance_id: "29ebc250-4d9d-4420-b46f-127ff9e2437d",
      build_distro: "xenial",
      resident_size: "66664000",
      user_time: "124490"
    },
    name: "pack_osquery-monitoring_osquery_info",
    action: "added",
    epoch: "0",
    counter: "1789",
    pack: "osquery-monitoring"
  },
  rule: {
    firedtimes: 82,
    mail: false,
    level: 4,
    description: "osquery: osquery-monitoring schedule: The pack executed is pack_ossec-rootkit_zk_rootkit and the interval is 3600 "
  }
}, {
  osquery: {
    calendarTime: new Date(),
    subquery: "mounts",
    columns: {
      path: "/",
      blocks: "5239803",
      inodes: "10484720",
      flags: "rw,seclabel,relatime,attr2,inode64,noquota",
      inodes_free: "10436261",
      blocks_size: "4096",
      blocks_available: "3940776",
      type: "xfs",
      device: "/dev/xvda2",
      device_alias: "/dev/xvda2",
      blocks_free: "3940776"
    },
    name: "pack_incident-response_mounts",
    action: "added",
    epoch: "0",
    counter: "278",
    pack: "incident-response"
  },
  rule: {
    firedtimes: 82,
    mail: false,
    level: 4,
    description: "osquery: osquery-monitoring schedule: The pack executed is pack_ossec-rootkit_zk_rootkit and the interval is 3600 "
  }
}, {
  osquery: {
    calendarTime: new Date(),
    subquery: "iptables",
    columns: {
      memory_free: "156012544",
      memory_free_perc: "0.039271301812363",
      threshold: "10%",
      memory_total: "3972685824"
    },
    name: "low_free_memory",
    action: "added",
    epoch: "0",
    counter: "548"
  },
  rule: {
    firedtimes: 82,
    mail: false,
    level: 4,
    description: "osquery: System memory is under 10%"
  }
}, {
  osquery: {
    calendarTime: new Date(),
    subquery: "iptables",
    columns: {
      memory_free: "156012544",
      memory_free_perc: "0.039271301812363",
      threshold: "15%",
      memory_total: "3972685824"
    },
    name: "low_free_memory",
    action: "added",
    epoch: "0",
    counter: "548"
  },
  rule: {
    firedtimes: 82,
    mail: false,
    level: 4,
    description: "osquery: System memory is under 15%"
  }
}, {
  osquery: {
    calendarTime: new Date(),
    subquery: "process_memory",
    columns: {
      inode: "0",
      offset: "0",
      permissions: "r-xp",
      start: "0xffffffffff600000",
      end: "0xffffffffff601000",
      pid: "644",
      device: "00:00",
      pseudo: "1"
    },
    name: "pack_incident-response_process_memory",
    action: "added",
    epoch: "0",
    counter: "12"
  },
  rule: {
    firedtimes: 7621,
    mail: false,
    level: 4,
    description: "osquery: incident-response process_memory: Process 644 [vsyscall] memory start 0xffffffffff600000, memory end 0xffffffffff601000"
  }
}, {
  osquery: {
    calendarTime: new Date(),
    subquery: "iptables",
    columns: {
      chain: "POSTROUTING",
      filter_name: "nat",
      dst_mask: "0.0.0.0",
      match: "yes",
      src_mask: "255.255.0.0",
      dst_ip: "0.0.0.0",
      packets: "43294",
      target: "MASQUERADE",
      src_ip: "172.17.0.0",
      protocol: "0",
      outiface_mask: "FFFFFFFFFFFFFFFF",
      bytes: "3287370",
      iniface: "all",
      outiface: "docker0",
      policy: "ACCEPT"
    },
    name: "pack_incident-response_iptables",
    action: "added",
    epoch: "0",
    counter: "283"
  },
  rule: {
    firedtimes: 18,
    mail: false,
    level: 4,
    description: "osquery: incident-response iptables: Iptable source ip 172.17.0.0 with policy ACCEPT and target MASQUERADE has a packet count of 43294"
  }
}, {
  osquery: {
    calendarTime: new Date(),
    subquery: "process_env",
    columns: {
      pid: "26151",
      value: "244",
      key: "GENERATION"
    },
    name: "pack_incident-response_process_env",
    action: "added",
    epoch: "0",
    counter: "11"
  },
  rule: {
    firedtimes: 18,
    mail: false,
    level: 4,
    description: "osquery: incident-response process_env: Process 26151 Environment variable GENERATION value 244"
  }
}, {
  osquery: {
    calendarTime: new Date(),
    subquery: "device_nodes",
    columns: {
      mode: "0666",
      path: "/dev/ptmx",
      uid: "0",
      atime: "0",
      gid: "5",
      ctime: "1586444340",
      mtime: "1587489592",
      type: "character",
      block_size: "4096"
    },
    name: "pack_hardware-monitoring_device_nodes",
    action: "added",
    epoch: "0",
    counter: "138",
    pack: "hardware-monitoring"
  },
  rule: {
    firedtimes: 6,
    mail: false,
    level: 4,
    description: "osquery: hardware-monitoring device_nodes: Device /dev/ptmx, UID 0, GID 5, type character"
  }
}, {
  osquery: {
    calendarTime: new Date(),
    subquery: "last",
    columns: {
      tty: "pts/0",
      pid: "25728",
      time: "1587494777",
      type: "8"
    },
    name: "pack_incident-response_last",
    action: "added",
    epoch: "0",
    counter: "1",
    pack: "incident-response"
  },
  rule: {
    firedtimes: 2,
    mail: false,
    level: 4,
    description: "osquery: incident-response last: User  host"
  }
}, {
  osquery: {
    calendarTime: new Date(),
    subquery: "open_files",
    columns: {
      path: "/var/osquery/osquery.db/MANIFEST-016679",
      pid: "18631"
    },
    name: "pack_incident-response_open_files",
    action: "added",
    epoch: "0",
    counter: "11",
    pack: "incident-response"
  },
  rule: {
    firedtimes: 2,
    mail: false,
    level: 4,
    description: "osquery: incident-response open_files: Process 18631 has file /var/osquery/osquery.db/MANIFEST-016679 opened"
  }
}];
exports.dataOsquery = dataOsquery;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIm9zcXVlcnkuanMiXSwibmFtZXMiOlsiZGF0YU9zcXVlcnkiLCJvc3F1ZXJ5IiwiY2FsZW5kYXJUaW1lIiwiRGF0ZSIsInN1YnF1ZXJ5IiwiY29sdW1ucyIsImNvdW50ZXIiLCJ1dWlkIiwidmVyc2lvbiIsIm5hbWUiLCJhY3Rpb24iLCJlcG9jaCIsInBhY2siLCJydWxlIiwiZmlyZWR0aW1lcyIsIm1haWwiLCJsZXZlbCIsImRlc2NyaXB0aW9uIiwiY2hhaW4iLCJmaWx0ZXJfbmFtZSIsImRzdF9tYXNrIiwibWF0Y2giLCJzcmNfbWFzayIsImRzdF9pcCIsInBhY2tldHMiLCJ0YXJnZXQiLCJzcmNfaXAiLCJwcm90b2NvbCIsIm91dGlmYWNlX21hc2siLCJieXRlcyIsImluaWZhY2UiLCJvdXRpZmFjZSIsInBvbGljeSIsImF2ZXJhZ2VfbWVtb3J5IiwiYXZnX3N5c3RlbV90aW1lIiwiZXhlY3V0aW9ucyIsIm91dHB1dF9zaXplIiwiaW50ZXJ2YWwiLCJhdmdfdXNlcl90aW1lIiwibGFzdF9leGVjdXRlZCIsIndhbGxfdGltZSIsIndhdGNoZXIiLCJzeXN0ZW1fdGltZSIsImNvbmZpZ192YWxpZCIsInBpZCIsImNvbmZpZ19oYXNoIiwiYnVpbGRfcGxhdGZvcm0iLCJzdGFydF90aW1lIiwiZXh0ZW5zaW9ucyIsImluc3RhbmNlX2lkIiwiYnVpbGRfZGlzdHJvIiwicmVzaWRlbnRfc2l6ZSIsInVzZXJfdGltZSIsInBhdGgiLCJibG9ja3MiLCJpbm9kZXMiLCJmbGFncyIsImlub2Rlc19mcmVlIiwiYmxvY2tzX3NpemUiLCJibG9ja3NfYXZhaWxhYmxlIiwidHlwZSIsImRldmljZSIsImRldmljZV9hbGlhcyIsImJsb2Nrc19mcmVlIiwibWVtb3J5X2ZyZWUiLCJtZW1vcnlfZnJlZV9wZXJjIiwidGhyZXNob2xkIiwibWVtb3J5X3RvdGFsIiwiaW5vZGUiLCJvZmZzZXQiLCJwZXJtaXNzaW9ucyIsInN0YXJ0IiwiZW5kIiwicHNldWRvIiwidmFsdWUiLCJrZXkiLCJtb2RlIiwidWlkIiwiYXRpbWUiLCJnaWQiLCJjdGltZSIsIm10aW1lIiwiYmxvY2tfc2l6ZSIsInR0eSIsInRpbWUiXSwibWFwcGluZ3MiOiI7Ozs7Ozs7QUFBQTs7Ozs7Ozs7Ozs7QUFZTyxNQUFNQSxXQUFXLEdBQUcsQ0FBQztBQUN4QkMsRUFBQUEsT0FBTyxFQUFFO0FBQ1BDLElBQUFBLFlBQVksRUFBRSxJQUFJQyxJQUFKLEVBRFA7QUFFUEMsSUFBQUEsUUFBUSxFQUFFLGNBRkg7QUFHUEMsSUFBQUEsT0FBTyxFQUFFO0FBQ1BDLE1BQUFBLE9BQU8sRUFBRSxJQURGO0FBRVBDLE1BQUFBLElBQUksRUFBRSxzQ0FGQztBQUdQQyxNQUFBQSxPQUFPLEVBQUU7QUFIRixLQUhGO0FBUVBDLElBQUFBLElBQUksRUFBRSxzQ0FSQztBQVNQQyxJQUFBQSxNQUFNLEVBQUUsT0FURDtBQVVQQyxJQUFBQSxLQUFLLEVBQUUsR0FWQTtBQVdQTCxJQUFBQSxPQUFPLEVBQUUsTUFYRjtBQVlQTSxJQUFBQSxJQUFJLEVBQUU7QUFaQyxHQURlO0FBZXhCQyxFQUFBQSxJQUFJLEVBQUU7QUFDSkMsSUFBQUEsVUFBVSxFQUFFLENBRFI7QUFFSkMsSUFBQUEsSUFBSSxFQUFFLEtBRkY7QUFHSkMsSUFBQUEsS0FBSyxFQUFFLENBSEg7QUFJSkMsSUFBQUEsV0FBVyxFQUFFO0FBSlQ7QUFma0IsQ0FBRCxFQXNCekI7QUFDRWhCLEVBQUFBLE9BQU8sRUFBRTtBQUNQQyxJQUFBQSxZQUFZLEVBQUUsSUFBSUMsSUFBSixFQURQO0FBRVBDLElBQUFBLFFBQVEsRUFBRSxVQUZIO0FBR1BDLElBQUFBLE9BQU8sRUFBRTtBQUNQYSxNQUFBQSxLQUFLLEVBQUUsYUFEQTtBQUVQQyxNQUFBQSxXQUFXLEVBQUUsS0FGTjtBQUdQQyxNQUFBQSxRQUFRLEVBQUUsU0FISDtBQUlQQyxNQUFBQSxLQUFLLEVBQUUsS0FKQTtBQUtQQyxNQUFBQSxRQUFRLEVBQUUsYUFMSDtBQU1QQyxNQUFBQSxNQUFNLEVBQUUsU0FORDtBQU9QQyxNQUFBQSxPQUFPLEVBQUUsT0FQRjtBQVFQQyxNQUFBQSxNQUFNLEVBQUUsWUFSRDtBQVNQQyxNQUFBQSxNQUFNLEVBQUUsWUFURDtBQVVQQyxNQUFBQSxRQUFRLEVBQUUsR0FWSDtBQVdQQyxNQUFBQSxhQUFhLEVBQUUsa0JBWFI7QUFZUEMsTUFBQUEsS0FBSyxFQUFFLFNBWkE7QUFhUEMsTUFBQUEsT0FBTyxFQUFFLEtBYkY7QUFjUEMsTUFBQUEsUUFBUSxFQUFFLFNBZEg7QUFlUEMsTUFBQUEsTUFBTSxFQUFFO0FBZkQsS0FIRjtBQW9CUHZCLElBQUFBLElBQUksRUFBRSxpQ0FwQkM7QUFxQlBDLElBQUFBLE1BQU0sRUFBRSxPQXJCRDtBQXNCUEMsSUFBQUEsS0FBSyxFQUFFLEdBdEJBO0FBdUJQTCxJQUFBQSxPQUFPLEVBQUUsS0F2QkY7QUF3QlBNLElBQUFBLElBQUksRUFBRTtBQXhCQyxHQURYO0FBMkJFQyxFQUFBQSxJQUFJLEVBQUU7QUFDSkMsSUFBQUEsVUFBVSxFQUFFLEVBRFI7QUFFSkMsSUFBQUEsSUFBSSxFQUFFLEtBRkY7QUFHSkMsSUFBQUEsS0FBSyxFQUFFLENBSEg7QUFJSkMsSUFBQUEsV0FBVyxFQUFFO0FBSlQ7QUEzQlIsQ0F0QnlCLEVBd0R6QjtBQUNFaEIsRUFBQUEsT0FBTyxFQUFFO0FBQ1BDLElBQUFBLFlBQVksRUFBRSxJQUFJQyxJQUFKLEVBRFA7QUFFUEMsSUFBQUEsUUFBUSxFQUFFLFVBRkg7QUFHUEMsSUFBQUEsT0FBTyxFQUFFO0FBQ1BhLE1BQUFBLEtBQUssRUFBRSxZQURBO0FBRVBDLE1BQUFBLFdBQVcsRUFBRSxLQUZOO0FBR1BDLE1BQUFBLFFBQVEsRUFBRSxTQUhIO0FBSVBDLE1BQUFBLEtBQUssRUFBRSxLQUpBO0FBS1BDLE1BQUFBLFFBQVEsRUFBRSxTQUxIO0FBTVBDLE1BQUFBLE1BQU0sRUFBRSxTQU5EO0FBT1BDLE1BQUFBLE9BQU8sRUFBRSxPQVBGO0FBUVBDLE1BQUFBLE1BQU0sRUFBRSxRQVJEO0FBU1BDLE1BQUFBLE1BQU0sRUFBRSxTQVREO0FBVVBDLE1BQUFBLFFBQVEsRUFBRSxHQVZIO0FBV1BFLE1BQUFBLEtBQUssRUFBRSxTQVhBO0FBWVBDLE1BQUFBLE9BQU8sRUFBRSxLQVpGO0FBYVBDLE1BQUFBLFFBQVEsRUFBRSxLQWJIO0FBY1BDLE1BQUFBLE1BQU0sRUFBRTtBQWRELEtBSEY7QUFtQlB2QixJQUFBQSxJQUFJLEVBQUUsaUNBbkJDO0FBb0JQQyxJQUFBQSxNQUFNLEVBQUUsT0FwQkQ7QUFxQlBDLElBQUFBLEtBQUssRUFBRSxHQXJCQTtBQXNCUEwsSUFBQUEsT0FBTyxFQUFFLEtBdEJGO0FBdUJQTSxJQUFBQSxJQUFJLEVBQUU7QUF2QkMsR0FEWDtBQTBCRUMsRUFBQUEsSUFBSSxFQUFFO0FBQ0pDLElBQUFBLFVBQVUsRUFBRSxFQURSO0FBRUpDLElBQUFBLElBQUksRUFBRSxLQUZGO0FBR0pDLElBQUFBLEtBQUssRUFBRSxDQUhIO0FBSUpDLElBQUFBLFdBQVcsRUFBRTtBQUpUO0FBMUJSLENBeER5QixFQXlGekI7QUFDRWhCLEVBQUFBLE9BQU8sRUFBRTtBQUNQQyxJQUFBQSxZQUFZLEVBQUUsSUFBSUMsSUFBSixFQURQO0FBRVBDLElBQUFBLFFBQVEsRUFBRSxVQUZIO0FBR1BDLElBQUFBLE9BQU8sRUFBRTtBQUNQNEIsTUFBQUEsY0FBYyxFQUFFLEdBRFQ7QUFFUEMsTUFBQUEsZUFBZSxFQUFFLEdBRlY7QUFHUEMsTUFBQUEsVUFBVSxFQUFFLEtBSEw7QUFJUEMsTUFBQUEsV0FBVyxFQUFFLEdBSk47QUFLUDNCLE1BQUFBLElBQUksRUFBRSwrQkFMQztBQU1QNEIsTUFBQUEsUUFBUSxFQUFFLE1BTkg7QUFPUEMsTUFBQUEsYUFBYSxFQUFFLEdBUFI7QUFRUEMsTUFBQUEsYUFBYSxFQUFFLFlBUlI7QUFTUEMsTUFBQUEsU0FBUyxFQUFFO0FBVEosS0FIRjtBQWNQL0IsSUFBQUEsSUFBSSxFQUFFLGtDQWRDO0FBZVBDLElBQUFBLE1BQU0sRUFBRSxPQWZEO0FBZ0JQQyxJQUFBQSxLQUFLLEVBQUUsR0FoQkE7QUFpQlBMLElBQUFBLE9BQU8sRUFBRSxLQWpCRjtBQWtCUE0sSUFBQUEsSUFBSSxFQUFFO0FBbEJDLEdBRFg7QUFxQkVDLEVBQUFBLElBQUksRUFBRTtBQUNKQyxJQUFBQSxVQUFVLEVBQUUsRUFEUjtBQUVKQyxJQUFBQSxJQUFJLEVBQUUsS0FGRjtBQUdKQyxJQUFBQSxLQUFLLEVBQUUsQ0FISDtBQUlKQyxJQUFBQSxXQUFXLEVBQUU7QUFKVDtBQXJCUixDQXpGeUIsRUFxSHpCO0FBQ0VoQixFQUFBQSxPQUFPLEVBQUU7QUFDUEMsSUFBQUEsWUFBWSxFQUFFLElBQUlDLElBQUosRUFEUDtBQUVQQyxJQUFBQSxRQUFRLEVBQUUsY0FGSDtBQUdQQyxJQUFBQSxPQUFPLEVBQUU7QUFDUG9DLE1BQUFBLE9BQU8sRUFBRSxPQURGO0FBRVBDLE1BQUFBLFdBQVcsRUFBRSxPQUZOO0FBR1BDLE1BQUFBLFlBQVksRUFBRSxHQUhQO0FBSVBDLE1BQUFBLEdBQUcsRUFBRSxPQUpFO0FBS1B0QyxNQUFBQSxPQUFPLEVBQUUsSUFMRjtBQU1QQyxNQUFBQSxJQUFJLEVBQUUsc0NBTkM7QUFPUEMsTUFBQUEsT0FBTyxFQUFFLE9BUEY7QUFRUHFDLE1BQUFBLFdBQVcsRUFBRSwwQ0FSTjtBQVNQQyxNQUFBQSxjQUFjLEVBQUUsUUFUVDtBQVVQQyxNQUFBQSxVQUFVLEVBQUUsWUFWTDtBQVdQQyxNQUFBQSxVQUFVLEVBQUUsUUFYTDtBQVlQQyxNQUFBQSxXQUFXLEVBQUUsc0NBWk47QUFhUEMsTUFBQUEsWUFBWSxFQUFFLFFBYlA7QUFjUEMsTUFBQUEsYUFBYSxFQUFFLFVBZFI7QUFlUEMsTUFBQUEsU0FBUyxFQUFFO0FBZkosS0FIRjtBQW9CUDNDLElBQUFBLElBQUksRUFBRSxzQ0FwQkM7QUFxQlBDLElBQUFBLE1BQU0sRUFBRSxPQXJCRDtBQXNCUEMsSUFBQUEsS0FBSyxFQUFFLEdBdEJBO0FBdUJQTCxJQUFBQSxPQUFPLEVBQUUsTUF2QkY7QUF3QlBNLElBQUFBLElBQUksRUFBRTtBQXhCQyxHQURYO0FBMkJFQyxFQUFBQSxJQUFJLEVBQUU7QUFDSkMsSUFBQUEsVUFBVSxFQUFFLEVBRFI7QUFFSkMsSUFBQUEsSUFBSSxFQUFFLEtBRkY7QUFHSkMsSUFBQUEsS0FBSyxFQUFFLENBSEg7QUFJSkMsSUFBQUEsV0FBVyxFQUFFO0FBSlQ7QUEzQlIsQ0FySHlCLEVBdUp6QjtBQUNFaEIsRUFBQUEsT0FBTyxFQUFFO0FBQ1BDLElBQUFBLFlBQVksRUFBRSxJQUFJQyxJQUFKLEVBRFA7QUFFUEMsSUFBQUEsUUFBUSxFQUFFLFFBRkg7QUFHUEMsSUFBQUEsT0FBTyxFQUFFO0FBQ1BnRCxNQUFBQSxJQUFJLEVBQUUsR0FEQztBQUVQQyxNQUFBQSxNQUFNLEVBQUUsU0FGRDtBQUdQQyxNQUFBQSxNQUFNLEVBQUUsVUFIRDtBQUlQQyxNQUFBQSxLQUFLLEVBQUUsNENBSkE7QUFLUEMsTUFBQUEsV0FBVyxFQUFFLFVBTE47QUFNUEMsTUFBQUEsV0FBVyxFQUFFLE1BTk47QUFPUEMsTUFBQUEsZ0JBQWdCLEVBQUUsU0FQWDtBQVFQQyxNQUFBQSxJQUFJLEVBQUUsS0FSQztBQVNQQyxNQUFBQSxNQUFNLEVBQUUsWUFURDtBQVVQQyxNQUFBQSxZQUFZLEVBQUUsWUFWUDtBQVdQQyxNQUFBQSxXQUFXLEVBQUU7QUFYTixLQUhGO0FBZ0JQdEQsSUFBQUEsSUFBSSxFQUFFLCtCQWhCQztBQWlCUEMsSUFBQUEsTUFBTSxFQUFFLE9BakJEO0FBa0JQQyxJQUFBQSxLQUFLLEVBQUUsR0FsQkE7QUFtQlBMLElBQUFBLE9BQU8sRUFBRSxLQW5CRjtBQW9CUE0sSUFBQUEsSUFBSSxFQUFFO0FBcEJDLEdBRFg7QUF1QkVDLEVBQUFBLElBQUksRUFBRTtBQUNKQyxJQUFBQSxVQUFVLEVBQUUsRUFEUjtBQUVKQyxJQUFBQSxJQUFJLEVBQUUsS0FGRjtBQUdKQyxJQUFBQSxLQUFLLEVBQUUsQ0FISDtBQUlKQyxJQUFBQSxXQUFXLEVBQUU7QUFKVDtBQXZCUixDQXZKeUIsRUFxTHpCO0FBQ0VoQixFQUFBQSxPQUFPLEVBQUU7QUFDUEMsSUFBQUEsWUFBWSxFQUFFLElBQUlDLElBQUosRUFEUDtBQUVQQyxJQUFBQSxRQUFRLEVBQUUsVUFGSDtBQUdQQyxJQUFBQSxPQUFPLEVBQUU7QUFDUDJELE1BQUFBLFdBQVcsRUFBRSxXQUROO0FBRVBDLE1BQUFBLGdCQUFnQixFQUFFLG1CQUZYO0FBR1BDLE1BQUFBLFNBQVMsRUFBRSxLQUhKO0FBSVBDLE1BQUFBLFlBQVksRUFBRTtBQUpQLEtBSEY7QUFTUDFELElBQUFBLElBQUksRUFBRSxpQkFUQztBQVVQQyxJQUFBQSxNQUFNLEVBQUUsT0FWRDtBQVdQQyxJQUFBQSxLQUFLLEVBQUUsR0FYQTtBQVlQTCxJQUFBQSxPQUFPLEVBQUU7QUFaRixHQURYO0FBZUVPLEVBQUFBLElBQUksRUFBRTtBQUNKQyxJQUFBQSxVQUFVLEVBQUUsRUFEUjtBQUVKQyxJQUFBQSxJQUFJLEVBQUUsS0FGRjtBQUdKQyxJQUFBQSxLQUFLLEVBQUUsQ0FISDtBQUlKQyxJQUFBQSxXQUFXLEVBQUU7QUFKVDtBQWZSLENBckx5QixFQTJNekI7QUFDRWhCLEVBQUFBLE9BQU8sRUFBRTtBQUNQQyxJQUFBQSxZQUFZLEVBQUUsSUFBSUMsSUFBSixFQURQO0FBRVBDLElBQUFBLFFBQVEsRUFBRSxVQUZIO0FBR1BDLElBQUFBLE9BQU8sRUFBRTtBQUNQMkQsTUFBQUEsV0FBVyxFQUFFLFdBRE47QUFFUEMsTUFBQUEsZ0JBQWdCLEVBQUUsbUJBRlg7QUFHUEMsTUFBQUEsU0FBUyxFQUFFLEtBSEo7QUFJUEMsTUFBQUEsWUFBWSxFQUFFO0FBSlAsS0FIRjtBQVNQMUQsSUFBQUEsSUFBSSxFQUFFLGlCQVRDO0FBVVBDLElBQUFBLE1BQU0sRUFBRSxPQVZEO0FBV1BDLElBQUFBLEtBQUssRUFBRSxHQVhBO0FBWVBMLElBQUFBLE9BQU8sRUFBRTtBQVpGLEdBRFg7QUFlRU8sRUFBQUEsSUFBSSxFQUFFO0FBQ0pDLElBQUFBLFVBQVUsRUFBRSxFQURSO0FBRUpDLElBQUFBLElBQUksRUFBRSxLQUZGO0FBR0pDLElBQUFBLEtBQUssRUFBRSxDQUhIO0FBSUpDLElBQUFBLFdBQVcsRUFBRTtBQUpUO0FBZlIsQ0EzTXlCLEVBaU96QjtBQUNFaEIsRUFBQUEsT0FBTyxFQUFFO0FBQ1BDLElBQUFBLFlBQVksRUFBRSxJQUFJQyxJQUFKLEVBRFA7QUFFUEMsSUFBQUEsUUFBUSxFQUFFLGdCQUZIO0FBR1BDLElBQUFBLE9BQU8sRUFBRTtBQUNQK0QsTUFBQUEsS0FBSyxFQUFFLEdBREE7QUFFUEMsTUFBQUEsTUFBTSxFQUFFLEdBRkQ7QUFHUEMsTUFBQUEsV0FBVyxFQUFFLE1BSE47QUFJUEMsTUFBQUEsS0FBSyxFQUFFLG9CQUpBO0FBS1BDLE1BQUFBLEdBQUcsRUFBRSxvQkFMRTtBQU1QNUIsTUFBQUEsR0FBRyxFQUFFLEtBTkU7QUFPUGlCLE1BQUFBLE1BQU0sRUFBRSxPQVBEO0FBUVBZLE1BQUFBLE1BQU0sRUFBRTtBQVJELEtBSEY7QUFhUGhFLElBQUFBLElBQUksRUFBRSx1Q0FiQztBQWNQQyxJQUFBQSxNQUFNLEVBQUUsT0FkRDtBQWVQQyxJQUFBQSxLQUFLLEVBQUUsR0FmQTtBQWdCUEwsSUFBQUEsT0FBTyxFQUFFO0FBaEJGLEdBRFg7QUFtQkVPLEVBQUFBLElBQUksRUFBRTtBQUNKQyxJQUFBQSxVQUFVLEVBQUUsSUFEUjtBQUVKQyxJQUFBQSxJQUFJLEVBQUUsS0FGRjtBQUdKQyxJQUFBQSxLQUFLLEVBQUUsQ0FISDtBQUlKQyxJQUFBQSxXQUFXLEVBQUU7QUFKVDtBQW5CUixDQWpPeUIsRUEyUHpCO0FBQ0VoQixFQUFBQSxPQUFPLEVBQUU7QUFDUEMsSUFBQUEsWUFBWSxFQUFFLElBQUlDLElBQUosRUFEUDtBQUVQQyxJQUFBQSxRQUFRLEVBQUUsVUFGSDtBQUdQQyxJQUFBQSxPQUFPLEVBQUU7QUFDUGEsTUFBQUEsS0FBSyxFQUFFLGFBREE7QUFFUEMsTUFBQUEsV0FBVyxFQUFFLEtBRk47QUFHUEMsTUFBQUEsUUFBUSxFQUFFLFNBSEg7QUFJUEMsTUFBQUEsS0FBSyxFQUFFLEtBSkE7QUFLUEMsTUFBQUEsUUFBUSxFQUFFLGFBTEg7QUFNUEMsTUFBQUEsTUFBTSxFQUFFLFNBTkQ7QUFPUEMsTUFBQUEsT0FBTyxFQUFFLE9BUEY7QUFRUEMsTUFBQUEsTUFBTSxFQUFFLFlBUkQ7QUFTUEMsTUFBQUEsTUFBTSxFQUFFLFlBVEQ7QUFVUEMsTUFBQUEsUUFBUSxFQUFFLEdBVkg7QUFXUEMsTUFBQUEsYUFBYSxFQUFFLGtCQVhSO0FBWVBDLE1BQUFBLEtBQUssRUFBRSxTQVpBO0FBYVBDLE1BQUFBLE9BQU8sRUFBRSxLQWJGO0FBY1BDLE1BQUFBLFFBQVEsRUFBRSxTQWRIO0FBZVBDLE1BQUFBLE1BQU0sRUFBRTtBQWZELEtBSEY7QUFvQlB2QixJQUFBQSxJQUFJLEVBQUUsaUNBcEJDO0FBcUJQQyxJQUFBQSxNQUFNLEVBQUUsT0FyQkQ7QUFzQlBDLElBQUFBLEtBQUssRUFBRSxHQXRCQTtBQXVCUEwsSUFBQUEsT0FBTyxFQUFFO0FBdkJGLEdBRFg7QUEwQkVPLEVBQUFBLElBQUksRUFBRTtBQUNKQyxJQUFBQSxVQUFVLEVBQUUsRUFEUjtBQUVKQyxJQUFBQSxJQUFJLEVBQUUsS0FGRjtBQUdKQyxJQUFBQSxLQUFLLEVBQUUsQ0FISDtBQUlKQyxJQUFBQSxXQUFXLEVBQUU7QUFKVDtBQTFCUixDQTNQeUIsRUE0UnpCO0FBQ0VoQixFQUFBQSxPQUFPLEVBQUU7QUFDUEMsSUFBQUEsWUFBWSxFQUFFLElBQUlDLElBQUosRUFEUDtBQUVQQyxJQUFBQSxRQUFRLEVBQUUsYUFGSDtBQUdQQyxJQUFBQSxPQUFPLEVBQUU7QUFDUHVDLE1BQUFBLEdBQUcsRUFBRSxPQURFO0FBRVA4QixNQUFBQSxLQUFLLEVBQUUsS0FGQTtBQUdQQyxNQUFBQSxHQUFHLEVBQUU7QUFIRSxLQUhGO0FBUVBsRSxJQUFBQSxJQUFJLEVBQUUsb0NBUkM7QUFTUEMsSUFBQUEsTUFBTSxFQUFFLE9BVEQ7QUFVUEMsSUFBQUEsS0FBSyxFQUFFLEdBVkE7QUFXUEwsSUFBQUEsT0FBTyxFQUFFO0FBWEYsR0FEWDtBQWNFTyxFQUFBQSxJQUFJLEVBQUU7QUFDSkMsSUFBQUEsVUFBVSxFQUFFLEVBRFI7QUFFSkMsSUFBQUEsSUFBSSxFQUFFLEtBRkY7QUFHSkMsSUFBQUEsS0FBSyxFQUFFLENBSEg7QUFJSkMsSUFBQUEsV0FBVyxFQUFFO0FBSlQ7QUFkUixDQTVSeUIsRUFpVHpCO0FBQ0VoQixFQUFBQSxPQUFPLEVBQUU7QUFDUEMsSUFBQUEsWUFBWSxFQUFFLElBQUlDLElBQUosRUFEUDtBQUVQQyxJQUFBQSxRQUFRLEVBQUUsY0FGSDtBQUdQQyxJQUFBQSxPQUFPLEVBQUU7QUFDUHVFLE1BQUFBLElBQUksRUFBRSxNQURDO0FBRVB2QixNQUFBQSxJQUFJLEVBQUUsV0FGQztBQUdQd0IsTUFBQUEsR0FBRyxFQUFFLEdBSEU7QUFJUEMsTUFBQUEsS0FBSyxFQUFFLEdBSkE7QUFLUEMsTUFBQUEsR0FBRyxFQUFFLEdBTEU7QUFNUEMsTUFBQUEsS0FBSyxFQUFFLFlBTkE7QUFPUEMsTUFBQUEsS0FBSyxFQUFFLFlBUEE7QUFRUHJCLE1BQUFBLElBQUksRUFBRSxXQVJDO0FBU1BzQixNQUFBQSxVQUFVLEVBQUU7QUFUTCxLQUhGO0FBY1B6RSxJQUFBQSxJQUFJLEVBQUUsdUNBZEM7QUFlUEMsSUFBQUEsTUFBTSxFQUFFLE9BZkQ7QUFnQlBDLElBQUFBLEtBQUssRUFBRSxHQWhCQTtBQWlCUEwsSUFBQUEsT0FBTyxFQUFFLEtBakJGO0FBa0JQTSxJQUFBQSxJQUFJLEVBQUU7QUFsQkMsR0FEWDtBQXFCRUMsRUFBQUEsSUFBSSxFQUFFO0FBQ0pDLElBQUFBLFVBQVUsRUFBRSxDQURSO0FBRUpDLElBQUFBLElBQUksRUFBRSxLQUZGO0FBR0pDLElBQUFBLEtBQUssRUFBRSxDQUhIO0FBSUpDLElBQUFBLFdBQVcsRUFBRTtBQUpUO0FBckJSLENBalR5QixFQTZVekI7QUFDRWhCLEVBQUFBLE9BQU8sRUFBRTtBQUNQQyxJQUFBQSxZQUFZLEVBQUUsSUFBSUMsSUFBSixFQURQO0FBRVBDLElBQUFBLFFBQVEsRUFBRSxNQUZIO0FBR1BDLElBQUFBLE9BQU8sRUFBRTtBQUNQOEUsTUFBQUEsR0FBRyxFQUFFLE9BREU7QUFFUHZDLE1BQUFBLEdBQUcsRUFBRSxPQUZFO0FBR1B3QyxNQUFBQSxJQUFJLEVBQUUsWUFIQztBQUlQeEIsTUFBQUEsSUFBSSxFQUFFO0FBSkMsS0FIRjtBQVNQbkQsSUFBQUEsSUFBSSxFQUFFLDZCQVRDO0FBVVBDLElBQUFBLE1BQU0sRUFBRSxPQVZEO0FBV1BDLElBQUFBLEtBQUssRUFBRSxHQVhBO0FBWVBMLElBQUFBLE9BQU8sRUFBRSxHQVpGO0FBYVBNLElBQUFBLElBQUksRUFBRTtBQWJDLEdBRFg7QUFnQkVDLEVBQUFBLElBQUksRUFBRTtBQUNKQyxJQUFBQSxVQUFVLEVBQUUsQ0FEUjtBQUVKQyxJQUFBQSxJQUFJLEVBQUUsS0FGRjtBQUdKQyxJQUFBQSxLQUFLLEVBQUUsQ0FISDtBQUlKQyxJQUFBQSxXQUFXLEVBQUU7QUFKVDtBQWhCUixDQTdVeUIsRUFvV3pCO0FBQ0VoQixFQUFBQSxPQUFPLEVBQUU7QUFDUEMsSUFBQUEsWUFBWSxFQUFFLElBQUlDLElBQUosRUFEUDtBQUVQQyxJQUFBQSxRQUFRLEVBQUUsWUFGSDtBQUdQQyxJQUFBQSxPQUFPLEVBQUU7QUFDUGdELE1BQUFBLElBQUksRUFBRSx5Q0FEQztBQUVQVCxNQUFBQSxHQUFHLEVBQUU7QUFGRSxLQUhGO0FBT1BuQyxJQUFBQSxJQUFJLEVBQUUsbUNBUEM7QUFRUEMsSUFBQUEsTUFBTSxFQUFFLE9BUkQ7QUFTUEMsSUFBQUEsS0FBSyxFQUFFLEdBVEE7QUFVUEwsSUFBQUEsT0FBTyxFQUFFLElBVkY7QUFXUE0sSUFBQUEsSUFBSSxFQUFFO0FBWEMsR0FEWDtBQWNFQyxFQUFBQSxJQUFJLEVBQUU7QUFDSkMsSUFBQUEsVUFBVSxFQUFFLENBRFI7QUFFSkMsSUFBQUEsSUFBSSxFQUFFLEtBRkY7QUFHSkMsSUFBQUEsS0FBSyxFQUFFLENBSEg7QUFJSkMsSUFBQUEsV0FBVyxFQUFFO0FBSlQ7QUFkUixDQXBXeUIsQ0FBcEIiLCJzb3VyY2VzQ29udGVudCI6WyIvKlxuICogV2F6dWggYXBwIC0gT3NxdWVyeSBzYW1wbGUgYWxlcnRzXG4gKiBDb3B5cmlnaHQgKEMpIDIwMTUtMjAyMiBXYXp1aCwgSW5jLlxuICpcbiAqIFRoaXMgcHJvZ3JhbSBpcyBmcmVlIHNvZnR3YXJlOyB5b3UgY2FuIHJlZGlzdHJpYnV0ZSBpdCBhbmQvb3IgbW9kaWZ5XG4gKiBpdCB1bmRlciB0aGUgdGVybXMgb2YgdGhlIEdOVSBHZW5lcmFsIFB1YmxpYyBMaWNlbnNlIGFzIHB1Ymxpc2hlZCBieVxuICogdGhlIEZyZWUgU29mdHdhcmUgRm91bmRhdGlvbjsgZWl0aGVyIHZlcnNpb24gMiBvZiB0aGUgTGljZW5zZSwgb3JcbiAqIChhdCB5b3VyIG9wdGlvbikgYW55IGxhdGVyIHZlcnNpb24uXG4gKlxuICogRmluZCBtb3JlIGluZm9ybWF0aW9uIGFib3V0IHRoaXMgb24gdGhlIExJQ0VOU0UgZmlsZS5cbiAqL1xuXG5leHBvcnQgY29uc3QgZGF0YU9zcXVlcnkgPSBbe1xuICAgIG9zcXVlcnk6IHtcbiAgICAgIGNhbGVuZGFyVGltZTogbmV3IERhdGUoKSxcbiAgICAgIHN1YnF1ZXJ5OiBcIm9zcXVlcnlfaW5mb1wiLFxuICAgICAgY29sdW1uczoge1xuICAgICAgICBjb3VudGVyOiBcIjQzXCIsXG4gICAgICAgIHV1aWQ6IFwiRUMyMzRBNUItRDIzQi1BN0FELUNGRjctQkMzRjI0Q0M1MzY2XCIsXG4gICAgICAgIHZlcnNpb246IFwiMy4zLjJcIixcbiAgICAgIH0sXG4gICAgICBuYW1lOiBcInBhY2tfb3NxdWVyeS1tb25pdG9yaW5nX29zcXVlcnlfaW5mb1wiLFxuICAgICAgYWN0aW9uOiBcImFkZGVkXCIsXG4gICAgICBlcG9jaDogXCIwXCIsXG4gICAgICBjb3VudGVyOiBcIjE4MzZcIixcbiAgICAgIHBhY2s6IFwib3NxdWVyeS1tb25pdG9yaW5nXCJcbiAgICB9LFxuICAgIHJ1bGU6IHtcbiAgICAgIGZpcmVkdGltZXM6IDIsXG4gICAgICBtYWlsOiBmYWxzZSxcbiAgICAgIGxldmVsOiA0LFxuICAgICAgZGVzY3JpcHRpb246ICdvc3F1ZXJ5OiBvc3F1ZXJ5LW1vbml0b3Jpbmcgb3NxdWVyeV9pbmZvOiBPc3F1ZXJ5IHZlcnNpb24gaXMgMy4zLjIgYnVpbGQgb24gdWJ1bnR1IHhlbmlhbCdcbiAgICB9XG4gIH0sXG4gIHtcbiAgICBvc3F1ZXJ5OiB7XG4gICAgICBjYWxlbmRhclRpbWU6IG5ldyBEYXRlKCksXG4gICAgICBzdWJxdWVyeTogXCJpcHRhYmxlc1wiLFxuICAgICAgY29sdW1uczoge1xuICAgICAgICBjaGFpbjogXCJQT1NUUk9VVElOR1wiLFxuICAgICAgICBmaWx0ZXJfbmFtZTogXCJuYXRcIixcbiAgICAgICAgZHN0X21hc2s6IFwiMC4wLjAuMFwiLFxuICAgICAgICBtYXRjaDogXCJ5ZXNcIixcbiAgICAgICAgc3JjX21hc2s6IFwiMjU1LjI1NS4wLjBcIixcbiAgICAgICAgZHN0X2lwOiBcIjAuMC4wLjBcIixcbiAgICAgICAgcGFja2V0czogXCI0MzA5MlwiLFxuICAgICAgICB0YXJnZXQ6IFwiTUFTUVVFUkFERVwiLFxuICAgICAgICBzcmNfaXA6IFwiMTcyLjE3LjAuMFwiLFxuICAgICAgICBwcm90b2NvbDogXCIwXCIsXG4gICAgICAgIG91dGlmYWNlX21hc2s6IFwiRkZGRkZGRkZGRkZGRkZGRlwiLFxuICAgICAgICBieXRlczogXCIzMjcxNjI4XCIsXG4gICAgICAgIGluaWZhY2U6IFwiYWxsXCIsXG4gICAgICAgIG91dGlmYWNlOiBcImRvY2tlcjBcIixcbiAgICAgICAgcG9saWN5OiBcIkFDQ0VQVFwiXG4gICAgICB9LFxuICAgICAgbmFtZTogXCJwYWNrX2luY2lkZW50LXJlc3BvbnNlX2lwdGFibGVzXCIsXG4gICAgICBhY3Rpb246IFwiYWRkZWRcIixcbiAgICAgIGVwb2NoOiBcIjBcIixcbiAgICAgIGNvdW50ZXI6IFwiMjgyXCIsXG4gICAgICBwYWNrOiBcImluY2lkZW50LXJlc3BvbnNlXCJcbiAgICB9LFxuICAgIHJ1bGU6IHtcbiAgICAgIGZpcmVkdGltZXM6IDE3LFxuICAgICAgbWFpbDogZmFsc2UsXG4gICAgICBsZXZlbDogNCxcbiAgICAgIGRlc2NyaXB0aW9uOiBcIm9zcXVlcnk6IGluY2lkZW50LXJlc3BvbnNlIGlwdGFibGVzOiBJcHRhYmxlIHNvdXJjZSBpcCAxNzIuMTcuMC4wIHdpdGggcG9saWN5IEFDQ0VQVCBhbmQgdGFyZ2V0IE1BU1FVRVJBREUgaGFzIGEgcGFja2V0IGNvdW50IG9mIDQzMDkyXCIsXG4gICAgfVxuICB9LFxuICB7XG4gICAgb3NxdWVyeToge1xuICAgICAgY2FsZW5kYXJUaW1lOiBuZXcgRGF0ZSgpLFxuICAgICAgc3VicXVlcnk6IFwiaXB0YWJsZXNcIixcbiAgICAgIGNvbHVtbnM6IHtcbiAgICAgICAgY2hhaW46IFwiUFJFUk9VVElOR1wiLFxuICAgICAgICBmaWx0ZXJfbmFtZTogXCJuYXRcIixcbiAgICAgICAgZHN0X21hc2s6IFwiMC4wLjAuMFwiLFxuICAgICAgICBtYXRjaDogXCJ5ZXNcIixcbiAgICAgICAgc3JjX21hc2s6IFwiMC4wLjAuMFwiLFxuICAgICAgICBkc3RfaXA6IFwiMC4wLjAuMFwiLFxuICAgICAgICBwYWNrZXRzOiBcIjM0NTUzXCIsXG4gICAgICAgIHRhcmdldDogXCJET0NLRVJcIixcbiAgICAgICAgc3JjX2lwOiBcIjAuMC4wLjBcIixcbiAgICAgICAgcHJvdG9jb2w6IFwiMFwiLFxuICAgICAgICBieXRlczogXCIyMDY1MDUwXCIsXG4gICAgICAgIGluaWZhY2U6IFwiYWxsXCIsXG4gICAgICAgIG91dGlmYWNlOiBcImFsbFwiLFxuICAgICAgICBwb2xpY3k6IFwiQUNDRVBUXCJcbiAgICAgIH0sXG4gICAgICBuYW1lOiBcInBhY2tfaW5jaWRlbnQtcmVzcG9uc2VfaXB0YWJsZXNcIixcbiAgICAgIGFjdGlvbjogXCJhZGRlZFwiLFxuICAgICAgZXBvY2g6IFwiMFwiLFxuICAgICAgY291bnRlcjogXCIyODJcIixcbiAgICAgIHBhY2s6IFwiaW5jaWRlbnQtcmVzcG9uc2VcIlxuICAgIH0sXG4gICAgcnVsZToge1xuICAgICAgZmlyZWR0aW1lczogMTcsXG4gICAgICBtYWlsOiBmYWxzZSxcbiAgICAgIGxldmVsOiA0LFxuICAgICAgZGVzY3JpcHRpb246IFwib3NxdWVyeTogaW5jaWRlbnQtcmVzcG9uc2UgaXB0YWJsZXM6IElwdGFibGUgc291cmNlIGlwIDAuMC4wLjAgd2l0aCBwb2xpY3kgQUNDRVBUIGFuZCB0YXJnZXQgRE9DS0VSIGhhcyBhIHBhY2tldCBjb3VudCBvZiAzNDU1M1wiLFxuICAgIH1cbiAgfSxcbiAge1xuICAgIG9zcXVlcnk6IHtcbiAgICAgIGNhbGVuZGFyVGltZTogbmV3IERhdGUoKSxcbiAgICAgIHN1YnF1ZXJ5OiBcInNjaGVkdWxlXCIsXG4gICAgICBjb2x1bW5zOiB7XG4gICAgICAgIGF2ZXJhZ2VfbWVtb3J5OiBcIjBcIixcbiAgICAgICAgYXZnX3N5c3RlbV90aW1lOiBcIjBcIixcbiAgICAgICAgZXhlY3V0aW9uczogXCIxNzdcIixcbiAgICAgICAgb3V0cHV0X3NpemU6IFwiMFwiLFxuICAgICAgICBuYW1lOiBcInBhY2tfb3NzZWMtcm9vdGtpdF96a19yb290a2l0XCIsXG4gICAgICAgIGludGVydmFsOiBcIjM2MDBcIixcbiAgICAgICAgYXZnX3VzZXJfdGltZTogXCIwXCIsXG4gICAgICAgIGxhc3RfZXhlY3V0ZWQ6IFwiMTU4NzQ4MjA3OVwiLFxuICAgICAgICB3YWxsX3RpbWU6IFwiMFwiXG4gICAgICB9LFxuICAgICAgbmFtZTogXCJwYWNrX29zcXVlcnktbW9uaXRvcmluZ19zY2hlZHVsZVwiLFxuICAgICAgYWN0aW9uOiBcImFkZGVkXCIsXG4gICAgICBlcG9jaDogXCIwXCIsXG4gICAgICBjb3VudGVyOiBcIjI4MlwiLFxuICAgICAgcGFjazogXCJvc3F1ZXJ5LW1vbml0b3JpbmdcIlxuICAgIH0sXG4gICAgcnVsZToge1xuICAgICAgZmlyZWR0aW1lczogODIsXG4gICAgICBtYWlsOiBmYWxzZSxcbiAgICAgIGxldmVsOiA0LFxuICAgICAgZGVzY3JpcHRpb246IFwib3NxdWVyeTogb3NxdWVyeS1tb25pdG9yaW5nIHNjaGVkdWxlOiBUaGUgcGFjayBleGVjdXRlZCBpcyBwYWNrX29zc2VjLXJvb3RraXRfemtfcm9vdGtpdCBhbmQgdGhlIGludGVydmFsIGlzIDM2MDAgXCIsXG4gICAgfVxuICB9LFxuICB7XG4gICAgb3NxdWVyeToge1xuICAgICAgY2FsZW5kYXJUaW1lOiBuZXcgRGF0ZSgpLFxuICAgICAgc3VicXVlcnk6IFwib3NxdWVyeV9pbmZvXCIsXG4gICAgICBjb2x1bW5zOiB7XG4gICAgICAgIHdhdGNoZXI6IFwiMTg1OTZcIixcbiAgICAgICAgc3lzdGVtX3RpbWU6IFwiODY3NDBcIixcbiAgICAgICAgY29uZmlnX3ZhbGlkOiBcIjFcIixcbiAgICAgICAgcGlkOiBcIjE4NjMxXCIsXG4gICAgICAgIGNvdW50ZXI6IFwiMzNcIixcbiAgICAgICAgdXVpZDogXCJFQzIzNEE1Qi1EMjNCLUE3QUQtQ0ZGNy1CQzNGMjRDQzUzNjZcIixcbiAgICAgICAgdmVyc2lvbjogXCIzLjMuMlwiLFxuICAgICAgICBjb25maWdfaGFzaDogXCI4NDIzYWYxODIwZTA5Y2VmMjFjOGVkNTU5NDgyN2IxM2VhOGFmOTBkXCIsXG4gICAgICAgIGJ1aWxkX3BsYXRmb3JtOiBcInVidW50dVwiLFxuICAgICAgICBzdGFydF90aW1lOiBcIjE1ODY4OTM2MTFcIixcbiAgICAgICAgZXh0ZW5zaW9uczogXCJhY3RpdmVcIixcbiAgICAgICAgaW5zdGFuY2VfaWQ6IFwiMjllYmMyNTAtNGQ5ZC00NDIwLWI0NmYtMTI3ZmY5ZTI0MzdkXCIsXG4gICAgICAgIGJ1aWxkX2Rpc3RybzogXCJ4ZW5pYWxcIixcbiAgICAgICAgcmVzaWRlbnRfc2l6ZTogXCI2NjY2NDAwMFwiLFxuICAgICAgICB1c2VyX3RpbWU6IFwiMTI0NDkwXCJcbiAgICAgIH0sXG4gICAgICBuYW1lOiBcInBhY2tfb3NxdWVyeS1tb25pdG9yaW5nX29zcXVlcnlfaW5mb1wiLFxuICAgICAgYWN0aW9uOiBcImFkZGVkXCIsXG4gICAgICBlcG9jaDogXCIwXCIsXG4gICAgICBjb3VudGVyOiBcIjE3ODlcIixcbiAgICAgIHBhY2s6IFwib3NxdWVyeS1tb25pdG9yaW5nXCJcbiAgICB9LFxuICAgIHJ1bGU6IHtcbiAgICAgIGZpcmVkdGltZXM6IDgyLFxuICAgICAgbWFpbDogZmFsc2UsXG4gICAgICBsZXZlbDogNCxcbiAgICAgIGRlc2NyaXB0aW9uOiBcIm9zcXVlcnk6IG9zcXVlcnktbW9uaXRvcmluZyBzY2hlZHVsZTogVGhlIHBhY2sgZXhlY3V0ZWQgaXMgcGFja19vc3NlYy1yb290a2l0X3prX3Jvb3RraXQgYW5kIHRoZSBpbnRlcnZhbCBpcyAzNjAwIFwiLFxuICAgIH1cbiAgfSxcbiAge1xuICAgIG9zcXVlcnk6IHtcbiAgICAgIGNhbGVuZGFyVGltZTogbmV3IERhdGUoKSxcbiAgICAgIHN1YnF1ZXJ5OiBcIm1vdW50c1wiLFxuICAgICAgY29sdW1uczoge1xuICAgICAgICBwYXRoOiBcIi9cIixcbiAgICAgICAgYmxvY2tzOiBcIjUyMzk4MDNcIixcbiAgICAgICAgaW5vZGVzOiBcIjEwNDg0NzIwXCIsXG4gICAgICAgIGZsYWdzOiBcInJ3LHNlY2xhYmVsLHJlbGF0aW1lLGF0dHIyLGlub2RlNjQsbm9xdW90YVwiLFxuICAgICAgICBpbm9kZXNfZnJlZTogXCIxMDQzNjI2MVwiLFxuICAgICAgICBibG9ja3Nfc2l6ZTogXCI0MDk2XCIsXG4gICAgICAgIGJsb2Nrc19hdmFpbGFibGU6IFwiMzk0MDc3NlwiLFxuICAgICAgICB0eXBlOiBcInhmc1wiLFxuICAgICAgICBkZXZpY2U6IFwiL2Rldi94dmRhMlwiLFxuICAgICAgICBkZXZpY2VfYWxpYXM6IFwiL2Rldi94dmRhMlwiLFxuICAgICAgICBibG9ja3NfZnJlZTogXCIzOTQwNzc2XCJcbiAgICAgIH0sXG4gICAgICBuYW1lOiBcInBhY2tfaW5jaWRlbnQtcmVzcG9uc2VfbW91bnRzXCIsXG4gICAgICBhY3Rpb246IFwiYWRkZWRcIixcbiAgICAgIGVwb2NoOiBcIjBcIixcbiAgICAgIGNvdW50ZXI6IFwiMjc4XCIsXG4gICAgICBwYWNrOiBcImluY2lkZW50LXJlc3BvbnNlXCJcbiAgICB9LFxuICAgIHJ1bGU6IHtcbiAgICAgIGZpcmVkdGltZXM6IDgyLFxuICAgICAgbWFpbDogZmFsc2UsXG4gICAgICBsZXZlbDogNCxcbiAgICAgIGRlc2NyaXB0aW9uOiBcIm9zcXVlcnk6IG9zcXVlcnktbW9uaXRvcmluZyBzY2hlZHVsZTogVGhlIHBhY2sgZXhlY3V0ZWQgaXMgcGFja19vc3NlYy1yb290a2l0X3prX3Jvb3RraXQgYW5kIHRoZSBpbnRlcnZhbCBpcyAzNjAwIFwiLFxuICAgIH1cbiAgfSxcbiAge1xuICAgIG9zcXVlcnk6IHtcbiAgICAgIGNhbGVuZGFyVGltZTogbmV3IERhdGUoKSxcbiAgICAgIHN1YnF1ZXJ5OiBcImlwdGFibGVzXCIsXG4gICAgICBjb2x1bW5zOiB7XG4gICAgICAgIG1lbW9yeV9mcmVlOiBcIjE1NjAxMjU0NFwiLFxuICAgICAgICBtZW1vcnlfZnJlZV9wZXJjOiBcIjAuMDM5MjcxMzAxODEyMzYzXCIsXG4gICAgICAgIHRocmVzaG9sZDogXCIxMCVcIixcbiAgICAgICAgbWVtb3J5X3RvdGFsOiBcIjM5NzI2ODU4MjRcIlxuICAgICAgfSxcbiAgICAgIG5hbWU6IFwibG93X2ZyZWVfbWVtb3J5XCIsXG4gICAgICBhY3Rpb246IFwiYWRkZWRcIixcbiAgICAgIGVwb2NoOiBcIjBcIixcbiAgICAgIGNvdW50ZXI6IFwiNTQ4XCIsXG4gICAgfSxcbiAgICBydWxlOiB7XG4gICAgICBmaXJlZHRpbWVzOiA4MixcbiAgICAgIG1haWw6IGZhbHNlLFxuICAgICAgbGV2ZWw6IDQsXG4gICAgICBkZXNjcmlwdGlvbjogXCJvc3F1ZXJ5OiBTeXN0ZW0gbWVtb3J5IGlzIHVuZGVyIDEwJVwiLFxuICAgIH1cbiAgfSxcbiAge1xuICAgIG9zcXVlcnk6IHtcbiAgICAgIGNhbGVuZGFyVGltZTogbmV3IERhdGUoKSxcbiAgICAgIHN1YnF1ZXJ5OiBcImlwdGFibGVzXCIsXG4gICAgICBjb2x1bW5zOiB7XG4gICAgICAgIG1lbW9yeV9mcmVlOiBcIjE1NjAxMjU0NFwiLFxuICAgICAgICBtZW1vcnlfZnJlZV9wZXJjOiBcIjAuMDM5MjcxMzAxODEyMzYzXCIsXG4gICAgICAgIHRocmVzaG9sZDogXCIxNSVcIixcbiAgICAgICAgbWVtb3J5X3RvdGFsOiBcIjM5NzI2ODU4MjRcIlxuICAgICAgfSxcbiAgICAgIG5hbWU6IFwibG93X2ZyZWVfbWVtb3J5XCIsXG4gICAgICBhY3Rpb246IFwiYWRkZWRcIixcbiAgICAgIGVwb2NoOiBcIjBcIixcbiAgICAgIGNvdW50ZXI6IFwiNTQ4XCIsXG4gICAgfSxcbiAgICBydWxlOiB7XG4gICAgICBmaXJlZHRpbWVzOiA4MixcbiAgICAgIG1haWw6IGZhbHNlLFxuICAgICAgbGV2ZWw6IDQsXG4gICAgICBkZXNjcmlwdGlvbjogXCJvc3F1ZXJ5OiBTeXN0ZW0gbWVtb3J5IGlzIHVuZGVyIDE1JVwiLFxuICAgIH1cbiAgfSxcbiAge1xuICAgIG9zcXVlcnk6IHtcbiAgICAgIGNhbGVuZGFyVGltZTogbmV3IERhdGUoKSxcbiAgICAgIHN1YnF1ZXJ5OiBcInByb2Nlc3NfbWVtb3J5XCIsXG4gICAgICBjb2x1bW5zOiB7XG4gICAgICAgIGlub2RlOiBcIjBcIixcbiAgICAgICAgb2Zmc2V0OiBcIjBcIixcbiAgICAgICAgcGVybWlzc2lvbnM6IFwici14cFwiLFxuICAgICAgICBzdGFydDogXCIweGZmZmZmZmZmZmY2MDAwMDBcIixcbiAgICAgICAgZW5kOiBcIjB4ZmZmZmZmZmZmZjYwMTAwMFwiLFxuICAgICAgICBwaWQ6IFwiNjQ0XCIsXG4gICAgICAgIGRldmljZTogXCIwMDowMFwiLFxuICAgICAgICBwc2V1ZG86IFwiMVwiXG4gICAgICB9LFxuICAgICAgbmFtZTogXCJwYWNrX2luY2lkZW50LXJlc3BvbnNlX3Byb2Nlc3NfbWVtb3J5XCIsXG4gICAgICBhY3Rpb246IFwiYWRkZWRcIixcbiAgICAgIGVwb2NoOiBcIjBcIixcbiAgICAgIGNvdW50ZXI6IFwiMTJcIixcbiAgICB9LFxuICAgIHJ1bGU6IHtcbiAgICAgIGZpcmVkdGltZXM6IDc2MjEsXG4gICAgICBtYWlsOiBmYWxzZSxcbiAgICAgIGxldmVsOiA0LFxuICAgICAgZGVzY3JpcHRpb246IFwib3NxdWVyeTogaW5jaWRlbnQtcmVzcG9uc2UgcHJvY2Vzc19tZW1vcnk6IFByb2Nlc3MgNjQ0IFt2c3lzY2FsbF0gbWVtb3J5IHN0YXJ0IDB4ZmZmZmZmZmZmZjYwMDAwMCwgbWVtb3J5IGVuZCAweGZmZmZmZmZmZmY2MDEwMDBcIixcbiAgICB9XG4gIH0sXG4gIHtcbiAgICBvc3F1ZXJ5OiB7XG4gICAgICBjYWxlbmRhclRpbWU6IG5ldyBEYXRlKCksXG4gICAgICBzdWJxdWVyeTogXCJpcHRhYmxlc1wiLFxuICAgICAgY29sdW1uczoge1xuICAgICAgICBjaGFpbjogXCJQT1NUUk9VVElOR1wiLFxuICAgICAgICBmaWx0ZXJfbmFtZTogXCJuYXRcIixcbiAgICAgICAgZHN0X21hc2s6IFwiMC4wLjAuMFwiLFxuICAgICAgICBtYXRjaDogXCJ5ZXNcIixcbiAgICAgICAgc3JjX21hc2s6IFwiMjU1LjI1NS4wLjBcIixcbiAgICAgICAgZHN0X2lwOiBcIjAuMC4wLjBcIixcbiAgICAgICAgcGFja2V0czogXCI0MzI5NFwiLFxuICAgICAgICB0YXJnZXQ6IFwiTUFTUVVFUkFERVwiLFxuICAgICAgICBzcmNfaXA6IFwiMTcyLjE3LjAuMFwiLFxuICAgICAgICBwcm90b2NvbDogXCIwXCIsXG4gICAgICAgIG91dGlmYWNlX21hc2s6IFwiRkZGRkZGRkZGRkZGRkZGRlwiLFxuICAgICAgICBieXRlczogXCIzMjg3MzcwXCIsXG4gICAgICAgIGluaWZhY2U6IFwiYWxsXCIsXG4gICAgICAgIG91dGlmYWNlOiBcImRvY2tlcjBcIixcbiAgICAgICAgcG9saWN5OiBcIkFDQ0VQVFwiXG4gICAgICB9LFxuICAgICAgbmFtZTogXCJwYWNrX2luY2lkZW50LXJlc3BvbnNlX2lwdGFibGVzXCIsXG4gICAgICBhY3Rpb246IFwiYWRkZWRcIixcbiAgICAgIGVwb2NoOiBcIjBcIixcbiAgICAgIGNvdW50ZXI6IFwiMjgzXCIsXG4gICAgfSxcbiAgICBydWxlOiB7XG4gICAgICBmaXJlZHRpbWVzOiAxOCxcbiAgICAgIG1haWw6IGZhbHNlLFxuICAgICAgbGV2ZWw6IDQsXG4gICAgICBkZXNjcmlwdGlvbjogXCJvc3F1ZXJ5OiBpbmNpZGVudC1yZXNwb25zZSBpcHRhYmxlczogSXB0YWJsZSBzb3VyY2UgaXAgMTcyLjE3LjAuMCB3aXRoIHBvbGljeSBBQ0NFUFQgYW5kIHRhcmdldCBNQVNRVUVSQURFIGhhcyBhIHBhY2tldCBjb3VudCBvZiA0MzI5NFwiLFxuICAgIH1cbiAgfSxcbiAge1xuICAgIG9zcXVlcnk6IHtcbiAgICAgIGNhbGVuZGFyVGltZTogbmV3IERhdGUoKSxcbiAgICAgIHN1YnF1ZXJ5OiBcInByb2Nlc3NfZW52XCIsXG4gICAgICBjb2x1bW5zOiB7XG4gICAgICAgIHBpZDogXCIyNjE1MVwiLFxuICAgICAgICB2YWx1ZTogXCIyNDRcIixcbiAgICAgICAga2V5OiBcIkdFTkVSQVRJT05cIlxuICAgICAgfSxcbiAgICAgIG5hbWU6IFwicGFja19pbmNpZGVudC1yZXNwb25zZV9wcm9jZXNzX2VudlwiLFxuICAgICAgYWN0aW9uOiBcImFkZGVkXCIsXG4gICAgICBlcG9jaDogXCIwXCIsXG4gICAgICBjb3VudGVyOiBcIjExXCIsXG4gICAgfSxcbiAgICBydWxlOiB7XG4gICAgICBmaXJlZHRpbWVzOiAxOCxcbiAgICAgIG1haWw6IGZhbHNlLFxuICAgICAgbGV2ZWw6IDQsXG4gICAgICBkZXNjcmlwdGlvbjogXCJvc3F1ZXJ5OiBpbmNpZGVudC1yZXNwb25zZSBwcm9jZXNzX2VudjogUHJvY2VzcyAyNjE1MSBFbnZpcm9ubWVudCB2YXJpYWJsZSBHRU5FUkFUSU9OIHZhbHVlIDI0NFwiLFxuICAgIH1cbiAgfSxcbiAge1xuICAgIG9zcXVlcnk6IHtcbiAgICAgIGNhbGVuZGFyVGltZTogbmV3IERhdGUoKSxcbiAgICAgIHN1YnF1ZXJ5OiBcImRldmljZV9ub2Rlc1wiLFxuICAgICAgY29sdW1uczoge1xuICAgICAgICBtb2RlOiBcIjA2NjZcIixcbiAgICAgICAgcGF0aDogXCIvZGV2L3B0bXhcIixcbiAgICAgICAgdWlkOiBcIjBcIixcbiAgICAgICAgYXRpbWU6IFwiMFwiLFxuICAgICAgICBnaWQ6IFwiNVwiLFxuICAgICAgICBjdGltZTogXCIxNTg2NDQ0MzQwXCIsXG4gICAgICAgIG10aW1lOiBcIjE1ODc0ODk1OTJcIixcbiAgICAgICAgdHlwZTogXCJjaGFyYWN0ZXJcIixcbiAgICAgICAgYmxvY2tfc2l6ZTogXCI0MDk2XCJcbiAgICAgIH0sXG4gICAgICBuYW1lOiBcInBhY2tfaGFyZHdhcmUtbW9uaXRvcmluZ19kZXZpY2Vfbm9kZXNcIixcbiAgICAgIGFjdGlvbjogXCJhZGRlZFwiLFxuICAgICAgZXBvY2g6IFwiMFwiLFxuICAgICAgY291bnRlcjogXCIxMzhcIixcbiAgICAgIHBhY2s6IFwiaGFyZHdhcmUtbW9uaXRvcmluZ1wiXG4gICAgfSxcbiAgICBydWxlOiB7XG4gICAgICBmaXJlZHRpbWVzOiA2LFxuICAgICAgbWFpbDogZmFsc2UsXG4gICAgICBsZXZlbDogNCxcbiAgICAgIGRlc2NyaXB0aW9uOiBcIm9zcXVlcnk6IGhhcmR3YXJlLW1vbml0b3JpbmcgZGV2aWNlX25vZGVzOiBEZXZpY2UgL2Rldi9wdG14LCBVSUQgMCwgR0lEIDUsIHR5cGUgY2hhcmFjdGVyXCIsXG4gICAgfVxuICB9LFxuICB7XG4gICAgb3NxdWVyeToge1xuICAgICAgY2FsZW5kYXJUaW1lOiBuZXcgRGF0ZSgpLFxuICAgICAgc3VicXVlcnk6IFwibGFzdFwiLFxuICAgICAgY29sdW1uczoge1xuICAgICAgICB0dHk6IFwicHRzLzBcIixcbiAgICAgICAgcGlkOiBcIjI1NzI4XCIsXG4gICAgICAgIHRpbWU6IFwiMTU4NzQ5NDc3N1wiLFxuICAgICAgICB0eXBlOiBcIjhcIlxuICAgICAgfSxcbiAgICAgIG5hbWU6IFwicGFja19pbmNpZGVudC1yZXNwb25zZV9sYXN0XCIsXG4gICAgICBhY3Rpb246IFwiYWRkZWRcIixcbiAgICAgIGVwb2NoOiBcIjBcIixcbiAgICAgIGNvdW50ZXI6IFwiMVwiLFxuICAgICAgcGFjazogXCJpbmNpZGVudC1yZXNwb25zZVwiXG4gICAgfSxcbiAgICBydWxlOiB7XG4gICAgICBmaXJlZHRpbWVzOiAyLFxuICAgICAgbWFpbDogZmFsc2UsXG4gICAgICBsZXZlbDogNCxcbiAgICAgIGRlc2NyaXB0aW9uOiBcIm9zcXVlcnk6IGluY2lkZW50LXJlc3BvbnNlIGxhc3Q6IFVzZXIgIGhvc3RcIixcbiAgICB9XG4gIH0sXG4gIHtcbiAgICBvc3F1ZXJ5OiB7XG4gICAgICBjYWxlbmRhclRpbWU6IG5ldyBEYXRlKCksXG4gICAgICBzdWJxdWVyeTogXCJvcGVuX2ZpbGVzXCIsXG4gICAgICBjb2x1bW5zOiB7XG4gICAgICAgIHBhdGg6IFwiL3Zhci9vc3F1ZXJ5L29zcXVlcnkuZGIvTUFOSUZFU1QtMDE2Njc5XCIsXG4gICAgICAgIHBpZDogXCIxODYzMVwiXG4gICAgICB9LFxuICAgICAgbmFtZTogXCJwYWNrX2luY2lkZW50LXJlc3BvbnNlX29wZW5fZmlsZXNcIixcbiAgICAgIGFjdGlvbjogXCJhZGRlZFwiLFxuICAgICAgZXBvY2g6IFwiMFwiLFxuICAgICAgY291bnRlcjogXCIxMVwiLFxuICAgICAgcGFjazogXCJpbmNpZGVudC1yZXNwb25zZVwiXG4gICAgfSxcbiAgICBydWxlOiB7XG4gICAgICBmaXJlZHRpbWVzOiAyLFxuICAgICAgbWFpbDogZmFsc2UsXG4gICAgICBsZXZlbDogNCxcbiAgICAgIGRlc2NyaXB0aW9uOiBcIm9zcXVlcnk6IGluY2lkZW50LXJlc3BvbnNlIG9wZW5fZmlsZXM6IFByb2Nlc3MgMTg2MzEgaGFzIGZpbGUgL3Zhci9vc3F1ZXJ5L29zcXVlcnkuZGIvTUFOSUZFU1QtMDE2Njc5IG9wZW5lZFwiLFxuICAgIH1cbiAgfSxcbl1cbiJdfQ==