"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.indexDate = indexDate;

/*
 * Wazuh app - Module to get the index name according to date interval
 * Copyright (C) 2015-2022 Wazuh, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Find more information about this on the LICENSE file.
 */
function indexDate(interval) {
  try {
    if (!interval) throw new Error('Creation interval not found');
    const d = new Date().toISOString().replace(/T/, '-').replace(/\..+/, '').replace(/-/g, '.').replace(/:/g, '');
    let date = '';

    switch (interval) {
      case 'h':
        date = d.slice(0, -4) + 'h';
        break;

      case 'd':
        date = d.slice(0, -7);
        break;

      case 'w':
        date = d.slice(0, -12) + weekOfYear() + 'w';
        break;

      case 'm':
        date = d.slice(0, -10);
        break;

      default:
        throw new Error('Creation interval not found');
    }

    return date;
  } catch (error) {
    return new Date().toISOString().replace(/T/, '-').replace(/\..+/, '').replace(/-/g, '.').replace(/:/g, '').slice(0, -7);
  }
}

function weekOfYear() {
  var d = new Date();
  d.setHours(0, 0, 0);
  d.setDate(d.getDate() + 4 - (d.getDay() || 7));
  return Math.ceil(((d - new Date(d.getFullYear(), 0, 1)) / 8.64e7 + 1) / 7);
}

;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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