"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SecurityObj = SecurityObj;

var _factories = require("./factories");

async function SecurityObj({
  security,
  opendistroSecurityKibana
}, context) {
  const params = {
    path: `/_security/user`,
    method: 'GET'
  };

  if (!!security) {
    try {
      const responseCurl = await context.core.elasticsearch.client.asInternalUser.transport.request(params);
      return new _factories.XpackFactory(security);
    } catch (error) {
      var _error$meta;

      // In case of an forbidden resource error it's still good to know if it uses xpack
      const validErrors = [403];
      if (validErrors.includes(error === null || error === void 0 ? void 0 : (_error$meta = error.meta) === null || _error$meta === void 0 ? void 0 : _error$meta.statusCode)) return new _factories.XpackFactory(security);
      return new _factories.DefaultFactory();
    }
  } else {
    return !!opendistroSecurityKibana ? new _factories.OpendistroFactory(opendistroSecurityKibana) : new _factories.DefaultFactory();
  }
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInNlY3VyaXR5LWZhY3RvcnkudHMiXSwibmFtZXMiOlsiU2VjdXJpdHlPYmoiLCJzZWN1cml0eSIsIm9wZW5kaXN0cm9TZWN1cml0eUtpYmFuYSIsImNvbnRleHQiLCJwYXJhbXMiLCJwYXRoIiwibWV0aG9kIiwicmVzcG9uc2VDdXJsIiwiY29yZSIsImVsYXN0aWNzZWFyY2giLCJjbGllbnQiLCJhc0ludGVybmFsVXNlciIsInRyYW5zcG9ydCIsInJlcXVlc3QiLCJYcGFja0ZhY3RvcnkiLCJlcnJvciIsInZhbGlkRXJyb3JzIiwiaW5jbHVkZXMiLCJtZXRhIiwic3RhdHVzQ29kZSIsIkRlZmF1bHRGYWN0b3J5IiwiT3BlbmRpc3Ryb0ZhY3RvcnkiXSwibWFwcGluZ3MiOiI7Ozs7Ozs7QUFBQTs7QUFjTyxlQUFlQSxXQUFmLENBQ0w7QUFBRUMsRUFBQUEsUUFBRjtBQUFZQyxFQUFBQTtBQUFaLENBREssRUFFTEMsT0FGSyxFQUdzQjtBQUMzQixRQUFNQyxNQUFNLEdBQUc7QUFDYkMsSUFBQUEsSUFBSSxFQUFHLGlCQURNO0FBRWJDLElBQUFBLE1BQU0sRUFBRTtBQUZLLEdBQWY7O0FBSUEsTUFBSSxDQUFDLENBQUNMLFFBQU4sRUFBZ0I7QUFDZCxRQUFJO0FBQ0YsWUFBTU0sWUFBWSxHQUFHLE1BQU1KLE9BQU8sQ0FBQ0ssSUFBUixDQUFhQyxhQUFiLENBQTJCQyxNQUEzQixDQUFrQ0MsY0FBbEMsQ0FBaURDLFNBQWpELENBQTJEQyxPQUEzRCxDQUN6QlQsTUFEeUIsQ0FBM0I7QUFHQSxhQUFPLElBQUlVLHVCQUFKLENBQWlCYixRQUFqQixDQUFQO0FBQ0QsS0FMRCxDQUtFLE9BQU9jLEtBQVAsRUFBYztBQUFBOztBQUVkO0FBQ0EsWUFBTUMsV0FBcUIsR0FBRyxDQUFDLEdBQUQsQ0FBOUI7QUFDQSxVQUFJQSxXQUFXLENBQUNDLFFBQVosQ0FBcUJGLEtBQXJCLGFBQXFCQSxLQUFyQixzQ0FBcUJBLEtBQUssQ0FBRUcsSUFBNUIsZ0RBQXFCLFlBQWFDLFVBQWxDLENBQUosRUFBbUQsT0FBTyxJQUFJTCx1QkFBSixDQUFpQmIsUUFBakIsQ0FBUDtBQUVuRCxhQUFPLElBQUltQix5QkFBSixFQUFQO0FBQ0Q7QUFDRixHQWRELE1BY087QUFDTCxXQUFPLENBQUMsQ0FBQ2xCLHdCQUFGLEdBQ0gsSUFBSW1CLDRCQUFKLENBQXNCbkIsd0JBQXRCLENBREcsR0FFSCxJQUFJa0IseUJBQUosRUFGSjtBQUdEO0FBQ0YiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBPcGVuZGlzdHJvRmFjdG9yeSwgWHBhY2tGYWN0b3J5LCBEZWZhdWx0RmFjdG9yeSB9IGZyb20gJy4vZmFjdG9yaWVzJztcbmltcG9ydCB7IEtpYmFuYVJlcXVlc3QsIFJlcXVlc3RIYW5kbGVyQ29udGV4dCB9IGZyb20gJ3NyYy9jb3JlL3NlcnZlcic7XG5pbXBvcnQgeyBQbHVnaW5TZXR1cCB9IGZyb20gJy4uLy4uL3R5cGVzJztcblxudHlwZSBDdXJyZW50VXNlciA9IHtcbiAgdXNlcm5hbWU/OiBzdHJpbmc7XG4gIGF1dGhDb250ZXh0OiB7IFtrZXk6IHN0cmluZ106IGFueSB9O1xufTtcblxuZXhwb3J0IGludGVyZmFjZSBJU2VjdXJpdHlGYWN0b3J5IHtcbiAgcGxhdGZvcm0/OiBzdHJpbmc7XG4gIGdldEN1cnJlbnRVc2VyKHJlcXVlc3Q6IEtpYmFuYVJlcXVlc3QsIGNvbnRleHQ/OiBSZXF1ZXN0SGFuZGxlckNvbnRleHQpOiBQcm9taXNlPEN1cnJlbnRVc2VyPjtcbn1cblxuZXhwb3J0IGFzeW5jIGZ1bmN0aW9uIFNlY3VyaXR5T2JqKFxuICB7IHNlY3VyaXR5LCBvcGVuZGlzdHJvU2VjdXJpdHlLaWJhbmEgfTogUGx1Z2luU2V0dXAsXG4gIGNvbnRleHQ/OiBSZXF1ZXN0SGFuZGxlckNvbnRleHRcbik6IFByb21pc2U8SVNlY3VyaXR5RmFjdG9yeT4ge1xuICBjb25zdCBwYXJhbXMgPSB7XG4gICAgcGF0aDogYC9fc2VjdXJpdHkvdXNlcmAsXG4gICAgbWV0aG9kOiAnR0VUJyxcbiAgfTtcbiAgaWYgKCEhc2VjdXJpdHkpIHtcbiAgICB0cnkge1xuICAgICAgY29uc3QgcmVzcG9uc2VDdXJsID0gYXdhaXQgY29udGV4dC5jb3JlLmVsYXN0aWNzZWFyY2guY2xpZW50LmFzSW50ZXJuYWxVc2VyLnRyYW5zcG9ydC5yZXF1ZXN0KFxuICAgICAgICBwYXJhbXNcbiAgICAgICk7XG4gICAgICByZXR1cm4gbmV3IFhwYWNrRmFjdG9yeShzZWN1cml0eSk7XG4gICAgfSBjYXRjaCAoZXJyb3IpIHtcblxuICAgICAgLy8gSW4gY2FzZSBvZiBhbiBmb3JiaWRkZW4gcmVzb3VyY2UgZXJyb3IgaXQncyBzdGlsbCBnb29kIHRvIGtub3cgaWYgaXQgdXNlcyB4cGFja1xuICAgICAgY29uc3QgdmFsaWRFcnJvcnM6IFtudW1iZXJdID0gWzQwM107XG4gICAgICBpZiAodmFsaWRFcnJvcnMuaW5jbHVkZXMoZXJyb3I/Lm1ldGE/LnN0YXR1c0NvZGUpKSByZXR1cm4gbmV3IFhwYWNrRmFjdG9yeShzZWN1cml0eSk7XG5cbiAgICAgIHJldHVybiBuZXcgRGVmYXVsdEZhY3RvcnkoKTtcbiAgICB9XG4gIH0gZWxzZSB7XG4gICAgcmV0dXJuICEhb3BlbmRpc3Ryb1NlY3VyaXR5S2liYW5hXG4gICAgICA/IG5ldyBPcGVuZGlzdHJvRmFjdG9yeShvcGVuZGlzdHJvU2VjdXJpdHlLaWJhbmEpXG4gICAgICA6IG5ldyBEZWZhdWx0RmFjdG9yeSgpO1xuICB9XG59XG4iXX0=