"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WazuhHostsRoutes = WazuhHostsRoutes;

var _controllers = require("../controllers");

var _configSchema = require("@kbn/config-schema");

/*
 * Wazuh app - Module for Wazuh-API routes
 * Copyright (C) 2015-2022 Wazuh, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Find more information about this on the LICENSE file.
 */
function WazuhHostsRoutes(router) {
  const ctrl = new _controllers.WazuhHostsCtrl(); // Get Wazuh-API entries list (Multimanager) from elasticsearch index

  router.get({
    path: '/hosts/apis',
    validate: false
  }, async (context, request, response) => ctrl.getHostsEntries(context, request, response)); // Updates the cluster-info or manager-info

  router.put({
    path: '/hosts/update-hostname/{id}',
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      body: _configSchema.schema.object({
        cluster_info: _configSchema.schema.any()
      })
    }
  }, async (context, request, response) => ctrl.updateClusterInfo(context, request, response)); // Checks the orphan hosts in the registry in order to delete them

  router.post({
    path: '/hosts/remove-orphan-entries',
    validate: {
      body: _configSchema.schema.object({
        entries: _configSchema.schema.arrayOf(_configSchema.schema.any())
      })
    }
  }, async (context, request, response) => ctrl.removeOrphanEntries(context, request, response));
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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