"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WazuhUtilsRoutes = WazuhUtilsRoutes;

var _controllers = require("../../controllers");

var _configSchema = require("@kbn/config-schema");

/*
 * Wazuh app - Module for Wazuh utils routes
 * Copyright (C) 2015-2022 Wazuh, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Find more information about this on the LICENSE file.
 */
function WazuhUtilsRoutes(router) {
  const ctrl = new _controllers.WazuhUtilsCtrl(); // Returns the wazuh.yml file parsed

  router.get({
    path: '/utils/configuration',
    validate: false
  }, async (context, request, response) => ctrl.getConfigurationFile(context, request, response)); // Returns the wazuh.yml file in raw

  router.put({
    path: '/utils/configuration',
    validate: {
      body: _configSchema.schema.object({
        key: _configSchema.schema.string(),
        value: _configSchema.schema.any()
      })
    }
  }, async (context, request, response) => ctrl.updateConfigurationFile(context, request, response)); // Returns Wazuh app logs

  router.get({
    path: '/utils/logs',
    validate: false
  }, async (context, request, response) => ctrl.getAppLogs(context, request, response));
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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