"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.pciRequirementsFile = void 0;

/*
 * Wazuh app - Module for PCI requirements
 * Copyright (C) 2015-2022 Wazuh, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Find more information about this on the LICENSE file.
 */
const pciRequirementsFile = {
  '1.1.1': 'A formal process for approving and testing all network connections and changes to the firewall and router configurations',
  '1.3.4': 'Do not allow unauthorized outbound traffic from the cardholder data environment to the Internet.',
  '1.4': 'Install personal firewall software or equivalent functionality on any portable computing devices (including company and/or employee-owned) that connect to the Internet when outside the network (for example, laptops used by employees), and which are also used to access the CDE. Firewall (or equivalent) configurations include:Specific configuration settings are defined. Personal firewall (or equivalent functionality) is actively running. Personal firewall (or equivalent functionality) is not alterable by users of the portable computing devices. ',
  '2.2': 'Develop configuration standards for all system components. Assure that these standards address all known security vulnerabilities and are consistent with industry accepted system hardening standards (CIS, ISO, SANS, NIST).',
  '2.2.2': 'Enable only necessary services, protocols, daemons, etc., as required for the function of the system. ',
  '2.2.3': 'Implement additional security features for any required services, protocols, or daemons that are considered to be insecure',
  '2.2.4': 'Configure system security parameters to prevent misuse.',
  '4.1': 'Use strong cryptography and security protocols (for example, SSL/TLS, IPSEC, SSH, etc.) to safeguard sensitive cardholder data during transmission over open, public networks, including the following:Only trusted keys and certificates are accepted. The protocol in use only supports secure versions or configurations. The encryption strength is appropriate for the encryption methodology in use. ',
  '5.1': 'Deploy anti-virus software on all systems commonly affected by malicious software (particularly personal computers and servers).',
  '5.2': 'Ensure that all anti-virus mechanisms are maintained as follows:Are kept current. Perform periodic scans. Generate audit logs which are retained per PCI DSS Requirement 10.7. ',
  '6.2': 'Ensure that all system components and software are protected from known vulnerabilities by installing applicable vendor-supplied security patches. Install critical security patches within one month of release.',
  '6.5': 'Address common coding vulnerabilities in software development processes as follows:Train developers in secure coding techniques, including how to avoid common coding vulnerabilities, and understanding how sensitive data is handled in memory. Develop applications based on secure coding guidelines. ',
  '6.5.1': 'Injection flaws, particularly SQL injection. Also consider OS Command Injection, LDAP and XPath injection flaws as well as other injection flaws.',
  '6.5.2': 'Buffer overflows',
  '6.5.5': 'Improper error handling',
  '6.5.7': 'Cross-site scripting (XSS)',
  '6.5.8': 'Improper access control (such an insecure direct object references, failure to restrict URL access, directory traversal, and failure to restrict user access to functions).',
  '6.5.10': 'Broken authentication and session management.',
  '6.6': 'For public-facing web applications, address new threats and vulnerabilities on an ongoing basis and ensure these applications are protected against known attacks by either of the following methods:Reviewing public-facing web applications via manual or automated application vulnerability security assessment tools or methods, at least annually and after any changes. Installing an automated technical solution that detects and prevents web-based attacks (for example, a web-application firewall) in front of public-facing web applications, to continually check all traffic. ',
  '8.1.2': 'Control addition, deletion, and modification of user IDs, credentials, and other identifier objects.',
  '8.1.4': 'Remove/disable inactive user accounts within 90 days.',
  '8.1.5': 'Manage IDs used by third parties to access, support, or maintain system components via remote access as follows:Enabled only during the time period needed and disabled when not in use. Monitored when in use. ',
  '8.1.6': 'Limit repeated access attempts by locking out the user ID after not more than six attempts.',
  '8.1.8': 'If a session has been idle for more than 15 minutes, require the user to reauthenticate to re-activate the terminal or session.',
  '8.2.4': 'Change user passwords/passphrases at least once every 90 days.',
  '8.5.1': 'Additional requirement for service providers: Service providers with remote access to customer premises (for example, for support of POS systems or servers) must use a unique authentication credential (such as a password/phrase) for each customer.',
  '8.7': 'All access to any database containing cardholder data (including access by applications, administrators, and all other users) is restricted as follows:All user access to, user queries of, and user actions on databases are through programmatic methods. Only database administrators have the ability to directly access or query databases. Application IDs for database applications can only be used by the applications (and not by individual users or other non-application processes).',
  '10.1': 'Implement audit trails to link all access to system components to each individual user.',
  '10.2.1': 'All individual user accesses to cardholder data',
  '10.2.2': 'All actions taken by any individual with root or administrative privileges.',
  '10.2.4': 'Invalid logical access attempts',
  '10.2.5': 'Use of and changes to identification and authentication mechanisms including but not limited to creation of new accounts and elevation of privileges and all changes, additions, or deletions to accounts with root or administrative privileges.',
  '10.2.6': 'Initialization, stopping, or pausing of the audit logs',
  '10.2.7': 'Creation and deletion of system level objects',
  '10.5.2': 'Protect audit trail files from unauthorized modifications',
  '10.5.5': 'Use file integrity monitoring or change detection software on logs to ensure that existing log data cannot be changed without generating alerts (although new data being added should not cause an alert).',
  '10.4': 'Using time-synchronization technology, synchronize all critical system clocks and times and ensure that the following is implemented for acquiring, distributing, and storing time.',
  '10.6': 'Review logs and security events for all system components to identify anomalies or suspicious activity',
  '10.6.1': 'Review the following at least daily: All security events. Logs of all system components that store, process, or transmit CHD and/or SAD, or that could. impact the security of CHD and/or SAD. Logs of all critical system components. Logs of all servers and system components that perform security functions (for example, firewalls, intrusion detection systems/intrusion prevention systems (IDS/IPS), authentication servers, ecommerce redirection servers, etc.). ',
  '11.4': 'Use intrusion detection and/or intrusion prevention techniques to detect and/or prevent intrusions into the network.Monitor all traffic at the perimeter of the cardholder data environment as well as at critical points in the cardholder data environment, and alert personnel to suspected compromises. Keep all intrusion detection and prevention engines, baselines, and signatures up to date.',
  '11.5': 'Deploy a change detection mechanism (for example, file integrity monitoring tools) to alert personnel to unauthorized modification of critical system files, configuration files, or content files; and configure the software to perform critical file comparisons at least weekly.',
  '11.2.1': 'Perform quarterly internal vulnerability scans. Address vulnerabilities and perform rescans to verify all “high risk” vulnerabilities are resolved in accordance with the entity’s vulnerability ranking. Scans must be performed by qualified personnel.',
  '11.2.3': 'Perform internal and external scans, and rescans as needed, after any significant change. Scans must be performed by qualified personnel.'
};
exports.pciRequirementsFile = pciRequirementsFile;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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