"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.nameEquivalence = exports.formEquivalence = exports.configEquivalences = exports.categoriesNames = exports.categoriesEquivalence = void 0;

var _constants = require("./constants");

const configEquivalences = {
  pattern: "Default index pattern to use on the app. If there's no valid index pattern, the app will automatically create one with the name indicated in this option.",
  'customization.logo.app': `Set the name of the app logo stored at ${_constants.ASSETS_PUBLIC_URL}`,
  'customization.logo.sidebar': `Set the name of the sidebar logo stored at ${_constants.ASSETS_PUBLIC_URL}`,
  'customization.logo.healthcheck': `Set the name of the health-check logo stored at ${_constants.ASSETS_PUBLIC_URL}`,
  'customization.logo.reports': `Set the name of the reports logo (.png) stored at ${_constants.ASSETS_PUBLIC_URL}`,
  'checks.pattern': 'Enable or disable the index pattern health check when opening the app.',
  'checks.template': 'Enable or disable the template health check when opening the app.',
  'checks.api': 'Enable or disable the API health check when opening the app.',
  'checks.setup': 'Enable or disable the setup health check when opening the app.',
  'checks.fields': 'Enable or disable the known fields health check when opening the app.',
  'checks.metaFields': `Change the default value of the ${_constants.PLUGIN_PLATFORM_NAME} metaField configuration`,
  'checks.timeFilter': `Change the default value of the ${_constants.PLUGIN_PLATFORM_NAME} timeFilter configuration`,
  'checks.maxBuckets': `Change the default value of the ${_constants.PLUGIN_PLATFORM_NAME} max buckets configuration`,
  'extensions.pci': 'Enable or disable the PCI DSS tab on Overview and Agents.',
  'extensions.gdpr': 'Enable or disable the GDPR tab on Overview and Agents.',
  'extensions.hipaa': 'Enable or disable the HIPAA tab on Overview and Agents.',
  'extensions.nist': 'Enable or disable the NIST 800-53 tab on Overview and Agents.',
  'extensions.tsc': 'Enable or disable the TSC tab on Overview and Agents.',
  'extensions.audit': 'Enable or disable the Audit tab on Overview and Agents.',
  'extensions.oscap': 'Enable or disable the Open SCAP tab on Overview and Agents.',
  'extensions.ciscat': 'Enable or disable the CIS-CAT tab on Overview and Agents.',
  'extensions.aws': 'Enable or disable the Amazon (AWS) tab on Overview.',
  'extensions.gcp': 'Enable or disable the Google Cloud Platform tab on Overview.',
  'extensions.virustotal': 'Enable or disable the VirusTotal tab on Overview and Agents.',
  'extensions.osquery': 'Enable or disable the Osquery tab on Overview and Agents.',
  'extensions.mitre': 'Enable or disable the MITRE tab on Overview and Agents.',
  'extensions.docker': 'Enable or disable the Docker listener tab on Overview and Agents.',
  timeout: 'Maximum time, in milliseconds, the app will wait for an API response when making requests to it. It will be ignored if the value is set under 1500 milliseconds.',
  'ip.selector': 'Define if the user is allowed to change the selected index pattern directly from the top menu bar.',
  'ip.ignore': 'Disable certain index pattern names from being available in index pattern selector from the Wazuh app.',
  'wazuh.monitoring.enabled': 'Enable or disable the wazuh-monitoring index creation and/or visualization.',
  'wazuh.monitoring.frequency': 'Frequency, in seconds, of API requests to get the state of the agents and create a new document in the wazuh-monitoring index with this data.',
  'wazuh.monitoring.shards': 'Define the number of shards to use for the wazuh-monitoring-* indices.',
  'wazuh.monitoring.replicas': 'Define the number of replicas to use for the wazuh-monitoring-* indices.',
  'wazuh.monitoring.creation': 'Define the interval in which a new wazuh-monitoring index will be created.',
  'wazuh.monitoring.pattern': 'Default index pattern to use for Wazuh monitoring.',
  hideManagerAlerts: 'Hide the alerts of the manager in every dashboard.',
  'logs.level': 'Logging level of the App.',
  'enrollment.dns': 'Specifies the Wazuh registration server, used for the agent enrollment.',
  'enrollment.password': 'Specifies the password used to authenticate during the agent enrollment.',
  'cron.prefix': 'Define the index prefix of predefined jobs.',
  'cron.statistics.status': 'Enable or disable the statistics tasks.',
  'cron.statistics.apis': 'Enter the ID of the hosts you want to save data from, leave this empty to run the task on every host.',
  'cron.statistics.interval': 'Define the frequency of task execution using cron schedule expressions.',
  'cron.statistics.index.name': 'Define the name of the index in which the documents will be saved.',
  'cron.statistics.index.creation': 'Define the interval in which a new index will be created.',
  'cron.statistics.index.shards': 'Define the number of shards to use for the statistics indices.',
  'cron.statistics.index.replicas': 'Define the number of replicas to use for the statistics indices.',
  'alerts.sample.prefix': 'Define the index name prefix of sample alerts. It must match the template used by the index pattern to avoid unknown fields in dashboards.'
};
exports.configEquivalences = configEquivalences;
const nameEquivalence = {
  pattern: 'Index pattern',
  'customization.logo.app': 'Logo App',
  'customization.logo.sidebar': 'Logo Sidebar',
  'customization.logo.healthcheck': 'Logo Health Check',
  'customization.logo.reports': 'Logo Reports',
  'checks.pattern': 'Index pattern',
  'checks.template': 'Index template',
  'checks.api': 'API connection',
  'checks.setup': 'API version',
  'checks.fields': 'Known fields',
  'checks.metaFields': 'Remove meta fields',
  'checks.timeFilter': 'Set time filter to 24h',
  'checks.maxBuckets': 'Set max buckets to 200000',
  timeout: 'Request timeout',
  'ip.selector': 'IP selector',
  'ip.ignore': 'IP ignore',
  'xpack.rbac.enabled': 'X-Pack RBAC',
  'wazuh.monitoring.enabled': 'Status',
  'wazuh.monitoring.frequency': 'Frequency',
  'wazuh.monitoring.shards': 'Index shards',
  'wazuh.monitoring.replicas': 'Index replicas',
  'wazuh.monitoring.creation': 'Index creation',
  'wazuh.monitoring.pattern': 'Index pattern',
  hideManagerAlerts: 'Hide manager alerts',
  'logs.level': 'Log level',
  'enrollment.dns': 'Enrollment DNS',
  'cron.prefix': 'Cron prefix',
  'cron.statistics.status': 'Status',
  'cron.statistics.apis': 'Includes apis',
  'cron.statistics.interval': 'Interval',
  'cron.statistics.index.name': 'Index name',
  'cron.statistics.index.creation': 'Index creation',
  'cron.statistics.index.shards': 'Index shards',
  'cron.statistics.index.replicas': 'Index replicas',
  'alerts.sample.prefix': 'Sample alerts prefix'
};
exports.nameEquivalence = nameEquivalence;
const HEALTH_CHECK = 'Health Check';
const GENERAL = 'General';
const SECURITY = 'Security';
const MONITORING = 'Monitoring';
const STATISTICS = 'Statistics';
const CUSTOMIZATION = 'Logo Customization';
const categoriesNames = [HEALTH_CHECK, GENERAL, SECURITY, MONITORING, STATISTICS, CUSTOMIZATION];
exports.categoriesNames = categoriesNames;
const categoriesEquivalence = {
  pattern: GENERAL,
  'customization.logo.app': CUSTOMIZATION,
  'customization.logo.sidebar': CUSTOMIZATION,
  'customization.logo.healthcheck': CUSTOMIZATION,
  'customization.logo.reports': CUSTOMIZATION,
  'checks.pattern': HEALTH_CHECK,
  'checks.template': HEALTH_CHECK,
  'checks.api': HEALTH_CHECK,
  'checks.setup': HEALTH_CHECK,
  'checks.fields': HEALTH_CHECK,
  'checks.metaFields': HEALTH_CHECK,
  'checks.timeFilter': HEALTH_CHECK,
  'checks.maxBuckets': HEALTH_CHECK,
  timeout: GENERAL,
  'ip.selector': GENERAL,
  'ip.ignore': GENERAL,
  'wazuh.monitoring.enabled': MONITORING,
  'wazuh.monitoring.frequency': MONITORING,
  'wazuh.monitoring.shards': MONITORING,
  'wazuh.monitoring.replicas': MONITORING,
  'wazuh.monitoring.creation': MONITORING,
  'wazuh.monitoring.pattern': MONITORING,
  hideManagerAlerts: GENERAL,
  'logs.level': GENERAL,
  'enrollment.dns': GENERAL,
  'cron.prefix': GENERAL,
  'cron.statistics.status': STATISTICS,
  'cron.statistics.apis': STATISTICS,
  'cron.statistics.interval': STATISTICS,
  'cron.statistics.index.name': STATISTICS,
  'cron.statistics.index.creation': STATISTICS,
  'cron.statistics.index.shards': STATISTICS,
  'cron.statistics.index.replicas': STATISTICS,
  'alerts.sample.prefix': GENERAL
};
exports.categoriesEquivalence = categoriesEquivalence;
const TEXT = 'text';
const NUMBER = 'number';
const LIST = 'list';
const BOOLEAN = 'boolean';
const ARRAY = 'array';
const INTERVAL = 'interval';
const formEquivalence = {
  pattern: {
    type: TEXT
  },
  'customization.logo.app': {
    type: TEXT
  },
  'customization.logo.sidebar': {
    type: TEXT
  },
  'customization.logo.healthcheck': {
    type: TEXT
  },
  'customization.logo.reports': {
    type: TEXT
  },
  'checks.pattern': {
    type: BOOLEAN
  },
  'checks.template': {
    type: BOOLEAN
  },
  'checks.api': {
    type: BOOLEAN
  },
  'checks.setup': {
    type: BOOLEAN
  },
  'checks.fields': {
    type: BOOLEAN
  },
  'checks.metaFields': {
    type: BOOLEAN
  },
  'checks.timeFilter': {
    type: BOOLEAN
  },
  'checks.maxBuckets': {
    type: BOOLEAN
  },
  timeout: {
    type: NUMBER
  },
  'ip.selector': {
    type: BOOLEAN
  },
  'ip.ignore': {
    type: ARRAY
  },
  'xpack.rbac.enabled': {
    type: BOOLEAN
  },
  'wazuh.monitoring.enabled': {
    type: BOOLEAN
  },
  'wazuh.monitoring.frequency': {
    type: NUMBER
  },
  'wazuh.monitoring.shards': {
    type: NUMBER
  },
  'wazuh.monitoring.replicas': {
    type: NUMBER
  },
  'wazuh.monitoring.creation': {
    type: LIST,
    params: {
      options: [{
        text: 'Hourly',
        value: 'h'
      }, {
        text: 'Daily',
        value: 'd'
      }, {
        text: 'Weekly',
        value: 'w'
      }, {
        text: 'Monthly',
        value: 'm'
      }]
    }
  },
  'wazuh.monitoring.pattern': {
    type: TEXT
  },
  hideManagerAlerts: {
    type: BOOLEAN
  },
  'logs.level': {
    type: LIST,
    params: {
      options: [{
        text: 'Info',
        value: 'info'
      }, {
        text: 'Debug',
        value: 'debug'
      }]
    }
  },
  'enrollment.dns': {
    type: TEXT
  },
  'cron.prefix': {
    type: TEXT
  },
  'cron.statistics.status': {
    type: BOOLEAN
  },
  'cron.statistics.apis': {
    type: ARRAY
  },
  'cron.statistics.interval': {
    type: INTERVAL
  },
  'cron.statistics.index.name': {
    type: TEXT
  },
  'cron.statistics.index.creation': {
    type: LIST,
    params: {
      options: [{
        text: 'Hourly',
        value: 'h'
      }, {
        text: 'Daily',
        value: 'd'
      }, {
        text: 'Weekly',
        value: 'w'
      }, {
        text: 'Monthly',
        value: 'm'
      }]
    }
  },
  'cron.statistics.index.shards': {
    type: NUMBER
  },
  'cron.statistics.index.replicas': {
    type: NUMBER
  },
  'alerts.sample.prefix': {
    type: TEXT
  }
};
exports.formEquivalence = formEquivalence;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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