"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dataOsquery = void 0;

/*
 * Wazuh app - Osquery sample alerts
 * Copyright (C) 2015-2022 Wazuh, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Find more information about this on the LICENSE file.
 */
const dataOsquery = [{
  osquery: {
    calendarTime: new Date(),
    subquery: "osquery_info",
    columns: {
      counter: "43",
      uuid: "EC234A5B-D23B-A7AD-CFF7-BC3F24CC5366",
      version: "3.3.2"
    },
    name: "pack_osquery-monitoring_osquery_info",
    action: "added",
    epoch: "0",
    counter: "1836",
    pack: "osquery-monitoring"
  },
  rule: {
    firedtimes: 2,
    mail: false,
    level: 4,
    description: 'osquery: osquery-monitoring osquery_info: Osquery version is 3.3.2 build on ubuntu xenial'
  }
}, {
  osquery: {
    calendarTime: new Date(),
    subquery: "iptables",
    columns: {
      chain: "POSTROUTING",
      filter_name: "nat",
      dst_mask: "0.0.0.0",
      match: "yes",
      src_mask: "255.255.0.0",
      dst_ip: "0.0.0.0",
      packets: "43092",
      target: "MASQUERADE",
      src_ip: "172.17.0.0",
      protocol: "0",
      outiface_mask: "FFFFFFFFFFFFFFFF",
      bytes: "3271628",
      iniface: "all",
      outiface: "docker0",
      policy: "ACCEPT"
    },
    name: "pack_incident-response_iptables",
    action: "added",
    epoch: "0",
    counter: "282",
    pack: "incident-response"
  },
  rule: {
    firedtimes: 17,
    mail: false,
    level: 4,
    description: "osquery: incident-response iptables: Iptable source ip 172.17.0.0 with policy ACCEPT and target MASQUERADE has a packet count of 43092"
  }
}, {
  osquery: {
    calendarTime: new Date(),
    subquery: "iptables",
    columns: {
      chain: "PREROUTING",
      filter_name: "nat",
      dst_mask: "0.0.0.0",
      match: "yes",
      src_mask: "0.0.0.0",
      dst_ip: "0.0.0.0",
      packets: "34553",
      target: "DOCKER",
      src_ip: "0.0.0.0",
      protocol: "0",
      bytes: "2065050",
      iniface: "all",
      outiface: "all",
      policy: "ACCEPT"
    },
    name: "pack_incident-response_iptables",
    action: "added",
    epoch: "0",
    counter: "282",
    pack: "incident-response"
  },
  rule: {
    firedtimes: 17,
    mail: false,
    level: 4,
    description: "osquery: incident-response iptables: Iptable source ip 0.0.0.0 with policy ACCEPT and target DOCKER has a packet count of 34553"
  }
}, {
  osquery: {
    calendarTime: new Date(),
    subquery: "schedule",
    columns: {
      average_memory: "0",
      avg_system_time: "0",
      executions: "177",
      output_size: "0",
      name: "pack_ossec-rootkit_zk_rootkit",
      interval: "3600",
      avg_user_time: "0",
      last_executed: "1587482079",
      wall_time: "0"
    },
    name: "pack_osquery-monitoring_schedule",
    action: "added",
    epoch: "0",
    counter: "282",
    pack: "osquery-monitoring"
  },
  rule: {
    firedtimes: 82,
    mail: false,
    level: 4,
    description: "osquery: osquery-monitoring schedule: The pack executed is pack_ossec-rootkit_zk_rootkit and the interval is 3600 "
  }
}, {
  osquery: {
    calendarTime: new Date(),
    subquery: "osquery_info",
    columns: {
      watcher: "18596",
      system_time: "86740",
      config_valid: "1",
      pid: "18631",
      counter: "33",
      uuid: "EC234A5B-D23B-A7AD-CFF7-BC3F24CC5366",
      version: "3.3.2",
      config_hash: "8423af1820e09cef21c8ed5594827b13ea8af90d",
      build_platform: "ubuntu",
      start_time: "1586893611",
      extensions: "active",
      instance_id: "29ebc250-4d9d-4420-b46f-127ff9e2437d",
      build_distro: "xenial",
      resident_size: "66664000",
      user_time: "124490"
    },
    name: "pack_osquery-monitoring_osquery_info",
    action: "added",
    epoch: "0",
    counter: "1789",
    pack: "osquery-monitoring"
  },
  rule: {
    firedtimes: 82,
    mail: false,
    level: 4,
    description: "osquery: osquery-monitoring schedule: The pack executed is pack_ossec-rootkit_zk_rootkit and the interval is 3600 "
  }
}, {
  osquery: {
    calendarTime: new Date(),
    subquery: "mounts",
    columns: {
      path: "/",
      blocks: "5239803",
      inodes: "10484720",
      flags: "rw,seclabel,relatime,attr2,inode64,noquota",
      inodes_free: "10436261",
      blocks_size: "4096",
      blocks_available: "3940776",
      type: "xfs",
      device: "/dev/xvda2",
      device_alias: "/dev/xvda2",
      blocks_free: "3940776"
    },
    name: "pack_incident-response_mounts",
    action: "added",
    epoch: "0",
    counter: "278",
    pack: "incident-response"
  },
  rule: {
    firedtimes: 82,
    mail: false,
    level: 4,
    description: "osquery: osquery-monitoring schedule: The pack executed is pack_ossec-rootkit_zk_rootkit and the interval is 3600 "
  }
}, {
  osquery: {
    calendarTime: new Date(),
    subquery: "iptables",
    columns: {
      memory_free: "156012544",
      memory_free_perc: "0.039271301812363",
      threshold: "10%",
      memory_total: "3972685824"
    },
    name: "low_free_memory",
    action: "added",
    epoch: "0",
    counter: "548"
  },
  rule: {
    firedtimes: 82,
    mail: false,
    level: 4,
    description: "osquery: System memory is under 10%"
  }
}, {
  osquery: {
    calendarTime: new Date(),
    subquery: "iptables",
    columns: {
      memory_free: "156012544",
      memory_free_perc: "0.039271301812363",
      threshold: "15%",
      memory_total: "3972685824"
    },
    name: "low_free_memory",
    action: "added",
    epoch: "0",
    counter: "548"
  },
  rule: {
    firedtimes: 82,
    mail: false,
    level: 4,
    description: "osquery: System memory is under 15%"
  }
}, {
  osquery: {
    calendarTime: new Date(),
    subquery: "process_memory",
    columns: {
      inode: "0",
      offset: "0",
      permissions: "r-xp",
      start: "0xffffffffff600000",
      end: "0xffffffffff601000",
      pid: "644",
      device: "00:00",
      pseudo: "1"
    },
    name: "pack_incident-response_process_memory",
    action: "added",
    epoch: "0",
    counter: "12"
  },
  rule: {
    firedtimes: 7621,
    mail: false,
    level: 4,
    description: "osquery: incident-response process_memory: Process 644 [vsyscall] memory start 0xffffffffff600000, memory end 0xffffffffff601000"
  }
}, {
  osquery: {
    calendarTime: new Date(),
    subquery: "iptables",
    columns: {
      chain: "POSTROUTING",
      filter_name: "nat",
      dst_mask: "0.0.0.0",
      match: "yes",
      src_mask: "255.255.0.0",
      dst_ip: "0.0.0.0",
      packets: "43294",
      target: "MASQUERADE",
      src_ip: "172.17.0.0",
      protocol: "0",
      outiface_mask: "FFFFFFFFFFFFFFFF",
      bytes: "3287370",
      iniface: "all",
      outiface: "docker0",
      policy: "ACCEPT"
    },
    name: "pack_incident-response_iptables",
    action: "added",
    epoch: "0",
    counter: "283"
  },
  rule: {
    firedtimes: 18,
    mail: false,
    level: 4,
    description: "osquery: incident-response iptables: Iptable source ip 172.17.0.0 with policy ACCEPT and target MASQUERADE has a packet count of 43294"
  }
}, {
  osquery: {
    calendarTime: new Date(),
    subquery: "process_env",
    columns: {
      pid: "26151",
      value: "244",
      key: "GENERATION"
    },
    name: "pack_incident-response_process_env",
    action: "added",
    epoch: "0",
    counter: "11"
  },
  rule: {
    firedtimes: 18,
    mail: false,
    level: 4,
    description: "osquery: incident-response process_env: Process 26151 Environment variable GENERATION value 244"
  }
}, {
  osquery: {
    calendarTime: new Date(),
    subquery: "device_nodes",
    columns: {
      mode: "0666",
      path: "/dev/ptmx",
      uid: "0",
      atime: "0",
      gid: "5",
      ctime: "1586444340",
      mtime: "1587489592",
      type: "character",
      block_size: "4096"
    },
    name: "pack_hardware-monitoring_device_nodes",
    action: "added",
    epoch: "0",
    counter: "138",
    pack: "hardware-monitoring"
  },
  rule: {
    firedtimes: 6,
    mail: false,
    level: 4,
    description: "osquery: hardware-monitoring device_nodes: Device /dev/ptmx, UID 0, GID 5, type character"
  }
}, {
  osquery: {
    calendarTime: new Date(),
    subquery: "last",
    columns: {
      tty: "pts/0",
      pid: "25728",
      time: "1587494777",
      type: "8"
    },
    name: "pack_incident-response_last",
    action: "added",
    epoch: "0",
    counter: "1",
    pack: "incident-response"
  },
  rule: {
    firedtimes: 2,
    mail: false,
    level: 4,
    description: "osquery: incident-response last: User  host"
  }
}, {
  osquery: {
    calendarTime: new Date(),
    subquery: "open_files",
    columns: {
      path: "/var/osquery/osquery.db/MANIFEST-016679",
      pid: "18631"
    },
    name: "pack_incident-response_open_files",
    action: "added",
    epoch: "0",
    counter: "11",
    pack: "incident-response"
  },
  rule: {
    firedtimes: 2,
    mail: false,
    level: 4,
    description: "osquery: incident-response open_files: Process 18631 has file /var/osquery/osquery.db/MANIFEST-016679 opened"
  }
}];
exports.dataOsquery = dataOsquery;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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