"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Base = Base;

/*
 * Wazuh app - Base query for reporting queries
 * Copyright (C) 2015-2022 Wazuh, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Find more information about this on the LICENSE file.
 */
function Base(pattern, filters, gte, lte) {
  return {
    // index: pattern,
    from: 0,
    size: 500,
    aggs: {},
    sort: [],
    script_fields: {},
    query: {
      bool: {
        must: [{
          query_string: {
            query: filters,
            analyze_wildcard: true,
            default_field: '*'
          }
        }, {
          range: {
            timestamp: {
              gte: gte,
              lte: lte,
              format: 'epoch_millis'
            }
          }
        }],
        must_not: []
      }
    }
  };
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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