"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WazuhElasticRoutes = WazuhElasticRoutes;

var _controllers = require("../controllers");

var _configSchema = require("@kbn/config-schema");

var _constants = require("../../common/constants");

/*
 * Wazuh app - Module for Wazuh-Elastic routes
 * Copyright (C) 2015-2022 Wazuh, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Find more information about this on the LICENSE file.
 */
function WazuhElasticRoutes(router) {
  const ctrl = new _controllers.WazuhElasticCtrl();

  const schemaSampleAlertsCategories = _configSchema.schema.oneOf([_constants.WAZUH_SAMPLE_ALERTS_CATEGORY_SECURITY, _constants.WAZUH_SAMPLE_ALERTS_CATEGORY_AUDITING_POLICY_MONITORING, _constants.WAZUH_SAMPLE_ALERTS_CATEGORY_THREAT_DETECTION].map(category => _configSchema.schema.literal(category))); // Endpoints


  router.get({
    path: '/elastic/security/current-platform',
    validate: false
  }, async (context, request, response) => ctrl.getCurrentPlatform(context, request, response));
  router.get({
    path: '/elastic/visualizations/{tab}/{pattern}',
    validate: {
      params: _configSchema.schema.object({
        tab: _configSchema.schema.string(),
        pattern: _configSchema.schema.string()
      })
    }
  }, async (context, request, response) => ctrl.createVis(context, request, response));
  router.post({
    path: '/elastic/visualizations/{tab}/{pattern}',
    validate: {
      params: _configSchema.schema.object({
        tab: _configSchema.schema.string(),
        pattern: _configSchema.schema.string()
      }),
      body: _configSchema.schema.any()
    }
  }, async (context, request, response) => ctrl.createClusterVis(context, request, response));
  router.get({
    path: '/elastic/template/{pattern}',
    validate: {
      params: _configSchema.schema.object({
        pattern: _configSchema.schema.string()
      })
    }
  }, async (context, request, response) => ctrl.getTemplate(context, request, response));
  router.get({
    path: '/elastic/index-patterns/{pattern}',
    validate: {
      params: _configSchema.schema.object({
        pattern: _configSchema.schema.string()
      })
    }
  }, async (context, request, response) => ctrl.checkPattern(context, request, response));
  router.get({
    path: '/elastic/top/{mode}/{cluster}/{field}/{pattern}',
    validate: {
      params: _configSchema.schema.object({
        mode: _configSchema.schema.string(),
        cluster: _configSchema.schema.string(),
        field: _configSchema.schema.string(),
        pattern: _configSchema.schema.string()
      }),
      query: _configSchema.schema.object({
        agentsList: _configSchema.schema.string()
      })
    }
  }, async (context, request, response) => ctrl.getFieldTop(context, request, response));
  router.get({
    path: '/elastic/samplealerts',
    validate: false
  }, async (context, request, response) => ctrl.haveSampleAlerts(context, request, response));
  router.get({
    path: '/elastic/samplealerts/{category}',
    validate: {
      params: _configSchema.schema.object({
        category: schemaSampleAlertsCategories
      })
    }
  }, async (context, request, response) => ctrl.haveSampleAlertsOfCategory(context, request, response));
  router.post({
    path: '/elastic/samplealerts/{category}',
    validate: {
      params: _configSchema.schema.object({
        category: schemaSampleAlertsCategories
      }),
      body: _configSchema.schema.any()
    }
  }, async (context, request, response) => ctrl.createSampleAlerts(context, request, response));
  router.delete({
    path: '/elastic/samplealerts/{category}',
    validate: {
      params: _configSchema.schema.object({
        category: schemaSampleAlertsCategories
      })
    }
  }, async (context, request, response) => ctrl.deleteSampleAlerts(context, request, response));
  router.post({
    path: '/elastic/alerts',
    validate: {
      body: _configSchema.schema.any()
    }
  }, async (context, request, response) => ctrl.alerts(context, request, response));
  router.get({
    path: '/elastic/statistics',
    validate: false
  }, async (context, request, response) => ctrl.existStatisticsIndices(context, request, response));
  router.get({
    path: '/elastic/monitoring',
    validate: false
  }, async (context, request, response) => ctrl.existMonitoringIndices(context, request, response));
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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