"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WazuhHostsRoutes = WazuhHostsRoutes;

var _controllers = require("../controllers");

var _configSchema = require("@kbn/config-schema");

/*
 * Wazuh app - Module for Wazuh-API routes
 * Copyright (C) 2015-2022 Wazuh, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Find more information about this on the LICENSE file.
 */
function WazuhHostsRoutes(router) {
  const ctrl = new _controllers.WazuhHostsCtrl(); // Get Wazuh-API entries list (Multimanager) from elasticsearch index

  router.get({
    path: '/hosts/apis',
    validate: false
  }, async (context, request, response) => ctrl.getHostsEntries(context, request, response)); // Updates the cluster-info or manager-info

  router.put({
    path: '/hosts/update-hostname/{id}',
    validate: {
      params: _configSchema.schema.object({
        id: _configSchema.schema.string()
      }),
      body: _configSchema.schema.object({
        cluster_info: _configSchema.schema.any()
      })
    }
  }, async (context, request, response) => ctrl.updateClusterInfo(context, request, response)); // Checks the orphan hosts in the registry in order to delete them

  router.post({
    path: '/hosts/remove-orphan-entries',
    validate: {
      body: _configSchema.schema.object({
        entries: _configSchema.schema.arrayOf(_configSchema.schema.any())
      })
    }
  }, async (context, request, response) => ctrl.removeOrphanEntries(context, request, response));
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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