"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.pciRequirementsFile = void 0;

/*
 * Wazuh app - Module for PCI requirements
 * Copyright (C) 2015-2022 Wazuh, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Find more information about this on the LICENSE file.
 */
const pciRequirementsFile = {
  '1.1.1': 'A formal process for approving and testing all network connections and changes to the firewall and router configurations',
  '1.3.4': 'Do not allow unauthorized outbound traffic from the cardholder data environment to the Internet.',
  '1.4': 'Install personal firewall software or equivalent functionality on any portable computing devices (including company and/or employee-owned) that connect to the Internet when outside the network (for example, laptops used by employees), and which are also used to access the CDE. Firewall (or equivalent) configurations include:Specific configuration settings are defined. Personal firewall (or equivalent functionality) is actively running. Personal firewall (or equivalent functionality) is not alterable by users of the portable computing devices. ',
  '2.2': 'Develop configuration standards for all system components. Assure that these standards address all known security vulnerabilities and are consistent with industry accepted system hardening standards (CIS, ISO, SANS, NIST).',
  '2.2.2': 'Enable only necessary services, protocols, daemons, etc., as required for the function of the system. ',
  '2.2.3': 'Implement additional security features for any required services, protocols, or daemons that are considered to be insecure',
  '2.2.4': 'Configure system security parameters to prevent misuse.',
  '4.1': 'Use strong cryptography and security protocols (for example, SSL/TLS, IPSEC, SSH, etc.) to safeguard sensitive cardholder data during transmission over open, public networks, including the following:Only trusted keys and certificates are accepted. The protocol in use only supports secure versions or configurations. The encryption strength is appropriate for the encryption methodology in use. ',
  '5.1': 'Deploy anti-virus software on all systems commonly affected by malicious software (particularly personal computers and servers).',
  '5.2': 'Ensure that all anti-virus mechanisms are maintained as follows:Are kept current. Perform periodic scans. Generate audit logs which are retained per PCI DSS Requirement 10.7. ',
  '6.2': 'Ensure that all system components and software are protected from known vulnerabilities by installing applicable vendor-supplied security patches. Install critical security patches within one month of release.',
  '6.5': 'Address common coding vulnerabilities in software development processes as follows:Train developers in secure coding techniques, including how to avoid common coding vulnerabilities, and understanding how sensitive data is handled in memory. Develop applications based on secure coding guidelines. ',
  '6.5.1': 'Injection flaws, particularly SQL injection. Also consider Operating System Command Injection, LDAP and XPath injection flaws as well as other injection flaws.',
  '6.5.2': 'Buffer overflows',
  '6.5.5': 'Improper error handling',
  '6.5.7': 'Cross-site scripting (XSS)',
  '6.5.8': 'Improper access control (such an insecure direct object references, failure to restrict URL access, directory traversal, and failure to restrict user access to functions).',
  '6.5.10': 'Broken authentication and session management.',
  '6.6': 'For public-facing web applications, address new threats and vulnerabilities on an ongoing basis and ensure these applications are protected against known attacks by either of the following methods:Reviewing public-facing web applications via manual or automated application vulnerability security assessment tools or methods, at least annually and after any changes. Installing an automated technical solution that detects and prevents web-based attacks (for example, a web-application firewall) in front of public-facing web applications, to continually check all traffic. ',
  '8.1.2': 'Control addition, deletion, and modification of user IDs, credentials, and other identifier objects.',
  '8.1.4': 'Remove/disable inactive user accounts within 90 days.',
  '8.1.5': 'Manage IDs used by third parties to access, support, or maintain system components via remote access as follows:Enabled only during the time period needed and disabled when not in use. Monitored when in use. ',
  '8.1.6': 'Limit repeated access attempts by locking out the user ID after not more than six attempts.',
  '8.1.8': 'If a session has been idle for more than 15 minutes, require the user to reauthenticate to re-activate the terminal or session.',
  '8.2.4': 'Change user passwords/passphrases at least once every 90 days.',
  '8.5.1': 'Additional requirement for service providers: Service providers with remote access to customer premises (for example, for support of POS systems or servers) must use a unique authentication credential (such as a password/phrase) for each customer.',
  '8.7': 'All access to any database containing cardholder data (including access by applications, administrators, and all other users) is restricted as follows:All user access to, user queries of, and user actions on databases are through programmatic methods. Only database administrators have the ability to directly access or query databases. Application IDs for database applications can only be used by the applications (and not by individual users or other non-application processes).',
  '10.1': 'Implement audit trails to link all access to system components to each individual user.',
  '10.2.1': 'All individual user accesses to cardholder data',
  '10.2.2': 'All actions taken by any individual with root or administrative privileges.',
  '10.2.4': 'Invalid logical access attempts',
  '10.2.5': 'Use of and changes to identification and authentication mechanisms including but not limited to creation of new accounts and elevation of privileges and all changes, additions, or deletions to accounts with root or administrative privileges.',
  '10.2.6': 'Initialization, stopping, or pausing of the audit logs',
  '10.2.7': 'Creation and deletion of system level objects',
  '10.5.2': 'Protect audit trail files from unauthorized modifications',
  '10.5.5': 'Use file integrity monitoring or change detection software on logs to ensure that existing log data cannot be changed without generating alerts (although new data being added should not cause an alert).',
  '10.4': 'Using time-synchronization technology, synchronize all critical system clocks and times and ensure that the following is implemented for acquiring, distributing, and storing time.',
  '10.6': 'Review logs and security events for all system components to identify anomalies or suspicious activity',
  '10.6.1': 'Review the following at least daily: All security events. Logs of all system components that store, process, or transmit CHD and/or SAD, or that could. impact the security of CHD and/or SAD. Logs of all critical system components. Logs of all servers and system components that perform security functions (for example, firewalls, intrusion detection systems/intrusion prevention systems (IDS/IPS), authentication servers, ecommerce redirection servers, etc.). ',
  '11.4': 'Use intrusion detection and/or intrusion prevention techniques to detect and/or prevent intrusions into the network.Monitor all traffic at the perimeter of the cardholder data environment as well as at critical points in the cardholder data environment, and alert personnel to suspected compromises. Keep all intrusion detection and prevention engines, baselines, and signatures up to date.',
  '11.5': 'Deploy a change detection mechanism (for example, file integrity monitoring tools) to alert personnel to unauthorized modification of critical system files, configuration files, or content files; and configure the software to perform critical file comparisons at least weekly.',
  '11.2.1': 'Perform quarterly internal vulnerability scans. Address vulnerabilities and perform rescans to verify all “high risk” vulnerabilities are resolved in accordance with the entity’s vulnerability ranking. Scans must be performed by qualified personnel.',
  '11.2.3': 'Perform internal and external scans, and rescans as needed, after any significant change. Scans must be performed by qualified personnel.'
};
exports.pciRequirementsFile = pciRequirementsFile;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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