"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formatBytes = formatBytes;

/**
 * Format the number the bytes to the higher unit.
 * @param bytes Bytes
 * @param decimals Number of decimals
 * @returns Formatted value with the unit
 */
function formatBytes(bytes, decimals = 2) {
  if (!+bytes) return '0 Bytes';
  const k = 1024;
  const dm = decimals < 0 ? 0 : decimals;
  const sizes = ['Bytes', 'KB', 'MB', 'GB', 'TB', 'PB', 'EB', 'ZB', 'YB'];
  const i = Math.floor(Math.log(bytes) / Math.log(k));
  return `${parseFloat((bytes / Math.pow(k, i)).toFixed(dm))} ${sizes[i]}`;
}

;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImZpbGUtc2l6ZS50cyJdLCJuYW1lcyI6WyJmb3JtYXRCeXRlcyIsImJ5dGVzIiwiZGVjaW1hbHMiLCJrIiwiZG0iLCJzaXplcyIsImkiLCJNYXRoIiwiZmxvb3IiLCJsb2ciLCJwYXJzZUZsb2F0IiwicG93IiwidG9GaXhlZCJdLCJtYXBwaW5ncyI6Ijs7Ozs7OztBQUFBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNPLFNBQVNBLFdBQVQsQ0FBcUJDLEtBQXJCLEVBQW9DQyxRQUFnQixHQUFHLENBQXZELEVBQWtFO0FBQ3hFLE1BQUksQ0FBQyxDQUFDRCxLQUFOLEVBQWEsT0FBTyxTQUFQO0FBRWIsUUFBTUUsQ0FBQyxHQUFHLElBQVY7QUFDQSxRQUFNQyxFQUFFLEdBQUdGLFFBQVEsR0FBRyxDQUFYLEdBQWUsQ0FBZixHQUFtQkEsUUFBOUI7QUFDQSxRQUFNRyxLQUFLLEdBQUcsQ0FBQyxPQUFELEVBQVUsSUFBVixFQUFnQixJQUFoQixFQUFzQixJQUF0QixFQUE0QixJQUE1QixFQUFrQyxJQUFsQyxFQUF3QyxJQUF4QyxFQUE4QyxJQUE5QyxFQUFvRCxJQUFwRCxDQUFkO0FBRUEsUUFBTUMsQ0FBQyxHQUFHQyxJQUFJLENBQUNDLEtBQUwsQ0FBV0QsSUFBSSxDQUFDRSxHQUFMLENBQVNSLEtBQVQsSUFBa0JNLElBQUksQ0FBQ0UsR0FBTCxDQUFTTixDQUFULENBQTdCLENBQVY7QUFFQSxTQUFRLEdBQUVPLFVBQVUsQ0FBQyxDQUFDVCxLQUFLLEdBQUdNLElBQUksQ0FBQ0ksR0FBTCxDQUFTUixDQUFULEVBQVlHLENBQVosQ0FBVCxFQUF5Qk0sT0FBekIsQ0FBaUNSLEVBQWpDLENBQUQsQ0FBdUMsSUFBR0MsS0FBSyxDQUFDQyxDQUFELENBQUksRUFBdkU7QUFDQTs7QUFBQSIsInNvdXJjZXNDb250ZW50IjpbIi8qKlxuICogRm9ybWF0IHRoZSBudW1iZXIgdGhlIGJ5dGVzIHRvIHRoZSBoaWdoZXIgdW5pdC5cbiAqIEBwYXJhbSBieXRlcyBCeXRlc1xuICogQHBhcmFtIGRlY2ltYWxzIE51bWJlciBvZiBkZWNpbWFsc1xuICogQHJldHVybnMgRm9ybWF0dGVkIHZhbHVlIHdpdGggdGhlIHVuaXRcbiAqL1xuZXhwb3J0IGZ1bmN0aW9uIGZvcm1hdEJ5dGVzKGJ5dGVzOiBudW1iZXIsIGRlY2ltYWxzOiBudW1iZXIgPSAyKTogc3RyaW5nIHtcblx0aWYgKCErYnl0ZXMpIHJldHVybiAnMCBCeXRlcyc7XG5cblx0Y29uc3QgayA9IDEwMjQ7XG5cdGNvbnN0IGRtID0gZGVjaW1hbHMgPCAwID8gMCA6IGRlY2ltYWxzO1xuXHRjb25zdCBzaXplcyA9IFsnQnl0ZXMnLCAnS0InLCAnTUInLCAnR0InLCAnVEInLCAnUEInLCAnRUInLCAnWkInLCAnWUInXTtcblxuXHRjb25zdCBpID0gTWF0aC5mbG9vcihNYXRoLmxvZyhieXRlcykgLyBNYXRoLmxvZyhrKSk7XG5cblx0cmV0dXJuIGAke3BhcnNlRmxvYXQoKGJ5dGVzIC8gTWF0aC5wb3coaywgaSkpLnRvRml4ZWQoZG0pKX0gJHtzaXplc1tpXX1gO1xufTsiXX0=