"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UiLogsRoutes = void 0;

var _controllers = require("../../controllers");

var _configSchema = require("@kbn/config-schema");

/*
 * Wazuh app - Module for UI Logs routes
 * Copyright (C) 2015-2022 Wazuh, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Find more information about this on the LICENSE file.
 */
const UiLogsRoutes = router => {
  const ctrl = new _controllers.UiLogsCtrl();
  router.get({
    path: '/utils/logs/ui',
    validate: false
  }, async (context, request, response) => await ctrl.getUiLogs(response));
  router.post({
    path: '/utils/logs/ui',
    validate: {
      body: _configSchema.schema.object({
        message: _configSchema.schema.string(),
        level: _configSchema.schema.string(),
        location: _configSchema.schema.string()
      })
    }
  }, async (context, request, response) => await ctrl.createUiLogs(request, response));
};

exports.UiLogsRoutes = UiLogsRoutes;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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