"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _aggregation_fields = require("../aggregation_fields");

const generalAlertsSummary = {
  title: 'Alerts summary',
  aggs: [_aggregation_fields.AggregationFields['rule.id'], _aggregation_fields.AggregationFields['rule.description'], _aggregation_fields.AggregationFields['rule.level']]
};
const generalGroupsSummary = {
  title: 'Groups summary',
  aggs: [_aggregation_fields.AggregationFields['rule.groups']]
};
const awsAlertsSummary = {
  title: 'Alerts summary',
  aggs: [_aggregation_fields.AggregationFields['rule.id'], _aggregation_fields.AggregationFields['rule.description'], _aggregation_fields.AggregationFields['rule.level']]
};
const fimAlertsSummary = {
  title: 'Alerts summary',
  aggs: [_aggregation_fields.AggregationFields['syscheck.path'], _aggregation_fields.AggregationFields['rule.description']]
};
const gcpAlertsSummary = {
  title: 'Alerts summary',
  aggs: [_aggregation_fields.AggregationFields['rule.id'], _aggregation_fields.AggregationFields['rule.description'], _aggregation_fields.AggregationFields['rule.level']]
};
const virustotalAlertsSummary = {
  title: 'Alerts summary',
  aggs: [_aggregation_fields.AggregationFields['rule.id'], _aggregation_fields.AggregationFields['rule.description'], _aggregation_fields.AggregationFields['rule.level']]
};
const osqueryAlertsSummary = {
  title: 'Alerts summary',
  aggs: [_aggregation_fields.AggregationFields['data.osquery.name'], _aggregation_fields.AggregationFields['data.osquery.action'], _aggregation_fields.AggregationFields['agent.name'], _aggregation_fields.AggregationFields['data.osquery.pack'], _aggregation_fields.AggregationFields['data.osquery.calendarTime']]
};
const mitreAlertsSummary = {
  title: 'Alerts summary',
  aggs: [_aggregation_fields.AggregationFields['rule.id'], _aggregation_fields.AggregationFields['rule.description'], _aggregation_fields.AggregationFields['rule.level']]
};
const ciscatAlertsSummary = {
  title: 'Alerts summary',
  aggs: [_aggregation_fields.AggregationFields['data.cis.rule_title'], _aggregation_fields.AggregationFields['data.cis.group'], _aggregation_fields.AggregationFields['data.cis.result']]
};
const pmAlertsSummary = {
  title: 'Alerts summary',
  aggs: [_aggregation_fields.AggregationFields['rule.description'], _aggregation_fields.AggregationFields['data.title']]
};
const tscAlertsSummary = {
  title: 'Alerts summary',
  aggs: [_aggregation_fields.AggregationFields['agent.name'], _aggregation_fields.AggregationFields['rule.tsc'], _aggregation_fields.AggregationFields['rule.description']]
};
const githubAlertsSummary = {
  title: 'Alerts summary',
  aggs: [_aggregation_fields.AggregationFields['agent.name'], _aggregation_fields.AggregationFields['data.github.org'], _aggregation_fields.AggregationFields['rule.description']]
}; // 'Wazuh-App-Agents-GDPR-Last-alerts'

const gdprLastAlerts = {
  title: 'Last alerts',
  aggs: [_aggregation_fields.AggregationFields['rule.gdpr'], _aggregation_fields.AggregationFields['rule.description']]
}; // 'Wazuh-App-Agents-PCI-Last-alerts'

const pciLastAlerts = {
  title: 'Last alerts',
  aggs: [_aggregation_fields.AggregationFields['rule.pci_dss'], _aggregation_fields.AggregationFields['rule.description']]
}; // 'Wazuh-App-Agents-NIST-Last-alerts'

const nistLastAlerts = {
  title: 'Alerts summary',
  aggs: [_aggregation_fields.AggregationFields['rule.nist_800_53'], _aggregation_fields.AggregationFields['rule.level'], _aggregation_fields.AggregationFields['rule.description']]
}; // 'Wazuh-App-Agents-HIPAA-Last-alerts'

const hipaaLastAlerts = {
  title: 'Alerts summary',
  aggs: [_aggregation_fields.AggregationFields['rule.hipaa'], _aggregation_fields.AggregationFields['rule.level'], _aggregation_fields.AggregationFields['rule.description']]
}; // 'Wazuh-App-Agents-OSCAP-Last-alerts'

const oscapLastAlerts = {
  title: 'Last alerts',
  aggs: [_aggregation_fields.AggregationFields['data.oscap.check.title'], _aggregation_fields.AggregationFields['data.oscap.scan.profile.title']]
}; // 'Wazuh-App-Agents-Audit-Last-alerts'

const auditLastAlerts = {
  title: 'Last alerts',
  aggs: [_aggregation_fields.AggregationFields['rule.description'], _aggregation_fields.AggregationFields['data.audit.exe'], _aggregation_fields.AggregationFields['data.audit.type']]
};
const dockerAlertsSummary = {
  title: 'Events summary',
  aggs: [_aggregation_fields.AggregationFields['data.docker.Actor.Attributes.name'], _aggregation_fields.AggregationFields['data.docker.Action'], _aggregation_fields.AggregationFields['timestamp']]
};
var _default = {
  general: [generalAlertsSummary, generalGroupsSummary],
  aws: [awsAlertsSummary],
  fim: [fimAlertsSummary],
  github: [githubAlertsSummary],
  hipaa: [hipaaLastAlerts],
  nist: [nistLastAlerts],
  gcp: [gcpAlertsSummary],
  tsc: [tscAlertsSummary],
  virustotal: [virustotalAlertsSummary],
  osquery: [osqueryAlertsSummary],
  mitre: [mitreAlertsSummary],
  ciscat: [ciscatAlertsSummary],
  pm: [pmAlertsSummary],
  audit: [auditLastAlerts],
  oscap: [oscapLastAlerts],
  gdpr: [gdprLastAlerts],
  pci: [pciLastAlerts],
  docker: [dockerAlertsSummary]
};
exports.default = _default;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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