define(['../../module'], function(controllers) {
  'use strict'

  class OverviewWelcome {
    /**
     * Class Welcome
     * @param {*} $scope
     * @param {Object} agentsInfo
     * @param {Object} extensions
     */
    constructor(
      $scope,
      agentsInfo,
      extensions,
      $notificationService,
      $currentDataService
    ) {
      this.scope = $scope
      this.notificationService = $notificationService
      this.currentDataService = $currentDataService
      this.currentApi = this.currentDataService.getApi()
      this.scope.extensionsLists = {
        security: false,
        auditing: false,
        threadDetection: false,
        regulatory: false
      }
      try {
        this.scope.agentsCountTotal = agentsInfo.data.data.total
        this.scope.agentsCountActive = agentsInfo.data.data.active
        this.scope.agentsCountDisconnected = agentsInfo.data.data.disconnected
        this.scope.agentsCountNeverConnected =
          agentsInfo.data.data.never_connected
      } catch (error) {} //eslint-disable-line
      try {
        this.extensions = extensions
        this.scope.extensions = angular.copy(this.extensions)
        this.api = this.currentApi['_key']
      } catch (error) {} //eslint-disable-line
    }

    /**
     * On controller loads
     */
    $onInit() {
      this.refreshExtensions()
      this.scope.showExtensionsLists = card => this.showExtensionsLists(card)
      this.scope.toggleExtension = (extension, state) =>
        this.toggleExtension(extension, state)
      this.scope.$applyAsync()
    }

    /**
     * Shows the extensions list to enable or disable them
     */
    showExtensionsLists(card) {
      try {
        this.scope.extensionsLists[card]
          ? (this.scope.extensionsLists[card] = false)
          : (this.scope.extensionsLists[card] = true)
      } catch (error) {
        console.error('Error showing or hiding the extensions list ', error)
      }
    }

    /**
     * Enable or disable extension
     * @param {String} extension
     * @param {String} state
     */
    async toggleExtension(extension, state) {
      try {
        this.extensions[extension] = state.toString()
        await this.currentDataService.setExtensionsById(this.api, this.extensions)
        this.extensions = await this.currentDataService.getExtensionsById(this.api)
        this.refreshExtensions()
      } catch (error) {
        console.error(error)
        this.notificationService.showErrorToast(error)
      }
    }

    /**
     * Refresh the extensions
     */
    refreshExtensions() {
      const keys = Object.keys(this.extensions)
      keys.map(
        key => (this.scope.extensions[key] = this.extensions[key] === 'true')
      )
      /*
      keys.map(key =>
        this.scope.extensions[key] =  this.extensions[key] === 'true'
      )
      */
      this.scope.$applyAsync()
    }
  }
  controllers.controller('overviewWelcomeCtrl', OverviewWelcome)
})
