module.exports = function (kibana) {
  return new kibana.Plugin({
    id: 'wazuh',
    name: 'wazuh',
    require: ['kibana', 'elasticsearch'],
    uiExports: {
      app: {
        id: 'wazuh',
        title: 'Wazuh',
        description: 'Wazuh App for Kibana',
		icon: 'plugins/wazuh/img/icon.png',
        main: 'plugins/wazuh/app',
        injectVars: function (server, options) {
		  const serverConfig = server.config();
		  const configuredUrl = server.config().get('tilemap.url');
          const isOverridden = typeof configuredUrl === 'string' && configuredUrl !== '';
          const tilemapConfig = serverConfig.get('tilemap');
          return {
            kbnIndex: serverConfig.get('kibana.index'),
            esApiVersion: serverConfig.get('elasticsearch.apiVersion'),
            esShardTimeout: serverConfig.get('elasticsearch.shardTimeout'),
			tilemapsConfig: {
              deprecated: {
                isOverridden: isOverridden,
                config: tilemapConfig,
              },
              manifestServiceUrl: serverConfig.get('tilemap.manifestServiceUrl')
            }
          };
        }
      }
    },
    init: require('./init.js')
  });
};

