/*!
 * Angular Material Design
 * https://github.com/angular/material
 * @license MIT
 * v1.1.0-master-2b98560
 */
function MdPanelService(t,n,e,i){this._defaultConfigOptions={bindToController:!0,clickOutsideToClose:!1,disableParentScroll:!1,escapeToClose:!1,focusOnOpen:!0,fullscreen:!1,hasBackdrop:!1,propagateContainerEvents:!1,transformTemplate:angular.bind(this,this._wrapTemplate),trapFocus:!1,zIndex:defaultZIndex},this._config={},this._$rootElement=t,this._$rootScope=n,this._$injector=e,this._$window=i,this._trackedPanels={},this.animation=MdPanelAnimation.animation,this.xPosition=MdPanelPosition.xPosition,this.yPosition=MdPanelPosition.yPosition}function MdPanelRef(t,n){this._$q=n.get("$q"),this._$mdCompiler=n.get("$mdCompiler"),this._$mdConstant=n.get("$mdConstant"),this._$mdUtil=n.get("$mdUtil"),this._$rootScope=n.get("$rootScope"),this._$animate=n.get("$animate"),this._$mdPanel=n.get("$mdPanel"),this._$log=n.get("$log"),this._$window=n.get("$window"),this._$$rAF=n.get("$$rAF"),this.id=t.id,this.config=t,this.panelContainer,this.panelEl,this.isAttached=!1,this._removeListeners=[],this._topFocusTrap,this._bottomFocusTrap,this._backdropRef,this._restoreScroll=null}function MdPanelPosition(t){this._$window=t.get("$window"),this._isRTL="rtl"===t.get("$mdUtil").bidi(),this._absolute=!1,this._relativeToEl,this._top="",this._bottom="",this._left="",this._right="",this._translateX=[],this._translateY=[],this._positions=[],this._actualPosition}function MdPanelAnimation(t){this._$mdUtil=t.get("$mdUtil"),this._openFrom,this._closeTo,this._animationClass=""}function getElement(t){var n=angular.isString(t)?document.querySelector(t):t;return angular.element(n)}goog.provide("ngmaterial.components.panel"),goog.require("ngmaterial.components.backdrop"),goog.require("ngmaterial.core"),MdPanelService.$inject=["$rootElement","$rootScope","$injector","$window"],angular.module("material.components.panel",["material.core","material.components.backdrop"]).service("$mdPanel",MdPanelService);var defaultZIndex=80,MD_PANEL_HIDDEN="_md-panel-hidden",FOCUS_TRAP_TEMPLATE=angular.element('<div class="_md-panel-focus-trap" tabindex="0"></div>');MdPanelService.prototype.create=function(t){if(t=t||{},angular.isDefined(t.id)&&this._trackedPanels[t.id])return this._trackedPanels[t.id];this._config={id:t.id||"panel_"+this._$injector.get("$mdUtil").nextUid(),scope:this._$rootScope.$new(!0),attachTo:this._$rootElement},angular.extend(this._config,this._defaultConfigOptions,t);var n=new MdPanelRef(this._config,this._$injector);return this._trackedPanels[t.id]=n,n},MdPanelService.prototype.open=function(t){var n=this.create(t);return n.open().then(function(){return n})},MdPanelService.prototype.newPanelPosition=function(){return new MdPanelPosition(this._$injector)},MdPanelService.prototype.newPanelAnimation=function(){return new MdPanelAnimation(this._$injector)},MdPanelService.prototype._wrapTemplate=function(t){var n=t||"";return'<div class="md-panel-outer-wrapper">  <div class="md-panel" style="left: -9999px;">'+n+"</div></div>"},MdPanelRef.prototype.open=function(){var t=this;return this._$q(function(n,e){var i=t._done(n,t),o=t._simpleBind(t.show,t);t.attach().then(o).then(i)["catch"](e)})},MdPanelRef.prototype.close=function(){var t=this;return this._$q(function(n,e){var i=t._done(n,t),o=t._simpleBind(t.detach,t);t.hide().then(o).then(i)["catch"](e)})},MdPanelRef.prototype.attach=function(){if(this.isAttached&&this.panelEl)return this._$q.when(this);var t=this;return this._$q(function(n,e){var i=t._done(n,t),o=t.config.onDomAdded||angular.noop,a=function(n){return t.isAttached=!0,t._addEventListeners(),n};t._$q.all([t._createBackdrop(),t._createPanel().then(a)["catch"](e)]).then(o).then(i)["catch"](e)})},MdPanelRef.prototype.detach=function(){if(!this.isAttached)return this._$q.when(this);var t=this,n=t.config.onDomRemoved||angular.noop,e=function(){return t._removeEventListeners(),t._topFocusTrap&&t._topFocusTrap.parentNode&&t._topFocusTrap.parentNode.removeChild(t._topFocusTrap),t._bottomFocusTrap&&t._bottomFocusTrap.parentNode&&t._bottomFocusTrap.parentNode.removeChild(t._bottomFocusTrap),t.panelContainer.remove(),t.isAttached=!1,t._$q.when(t)};return this._restoreScroll&&(this._restoreScroll(),this._restoreScroll=null),this._$q(function(i,o){var a=t._done(i,t);t._$q.all([e(),!t._backdropRef||t._backdropRef.detach()]).then(n).then(a)["catch"](o)})},MdPanelRef.prototype.destroy=function(){this.config.scope.$destroy(),this.config.locals=null},MdPanelRef.prototype.show=function(){if(!this.panelContainer)return this._$q(function(t,n){n("Panel does not exist yet. Call open() or attach().")});if(!this.panelContainer.hasClass(MD_PANEL_HIDDEN))return this._$q.when(this);var t=this,n=function(){return t.panelContainer.removeClass(MD_PANEL_HIDDEN),t._animateOpen()};return this._$q(function(e,i){var o=t._done(e,t),a=t.config.onOpenComplete||angular.noop;t._$q.all([t._backdropRef?t._backdropRef.show():t,n().then(function(){t._focusOnOpen()},i)]).then(a).then(o)["catch"](i)})},MdPanelRef.prototype.hide=function(){if(!this.panelContainer)return this._$q(function(t,n){n("Panel does not exist yet. Call open() or attach().")});if(this.panelContainer.hasClass(MD_PANEL_HIDDEN))return this._$q.when(this);var t=this;return this._$q(function(n,e){var i=t._done(n,t),o=t.config.onRemoving||angular.noop,a=function(){var n=t.config.origin;n&&getElement(n).focus()},s=function(){t.panelContainer.addClass(MD_PANEL_HIDDEN)};t._$q.all([t._backdropRef?t._backdropRef.hide():t,t._animateClose().then(o).then(s).then(a)["catch"](e)]).then(i,e)})},MdPanelRef.prototype.addClass=function(t,n){if(this._$log.warn("The addClass method is in the process of being deprecated. Full deprecation is scheduled for the Angular Material 1.2 release. To achieve the same results, use the panelContainer or panelEl JQLite elements that are referenced in MdPanelRef."),!this.panelContainer)throw new Error("Panel does not exist yet. Call open() or attach().");n||this.panelContainer.hasClass(t)?n&&!this.panelEl.hasClass(t)&&this.panelEl.addClass(t):this.panelContainer.addClass(t)},MdPanelRef.prototype.removeClass=function(t,n){if(this._$log.warn("The removeClass method is in the process of being deprecated. Full deprecation is scheduled for the Angular Material 1.2 release. To achieve the same results, use the panelContainer or panelEl JQLite elements that are referenced in MdPanelRef."),!this.panelContainer)throw new Error("Panel does not exist yet. Call open() or attach().");!n&&this.panelContainer.hasClass(t)?this.panelContainer.removeClass(t):n&&this.panelEl.hasClass(t)&&this.panelEl.removeClass(t)},MdPanelRef.prototype.toggleClass=function(t,n){if(this._$log.warn("The toggleClass method is in the process of being deprecated. Full deprecation is scheduled for the Angular Material 1.2 release. To achieve the same results, use the panelContainer or panelEl JQLite elements that are referenced in MdPanelRef."),!this.panelContainer)throw new Error("Panel does not exist yet. Call open() or attach().");n?this.panelEl.toggleClass(t):this.panelContainer.toggleClass(t)},MdPanelRef.prototype._createPanel=function(){var t=this;return this._$q(function(n,e){t.config.locals||(t.config.locals={}),t.config.locals.mdPanelRef=t,t._$mdCompiler.compile(t.config).then(function(i){t.panelContainer=i.link(t.config.scope),getElement(t.config.attachTo).append(t.panelContainer),t.config.disableParentScroll&&(t._restoreScroll=t._$mdUtil.disableScrollAround(null,t.panelContainer,{disableScrollMask:!0})),t.panelEl=angular.element(t.panelContainer[0].querySelector(".md-panel")),t.config.panelClass&&t.panelEl.addClass(t.config.panelClass),t.config.propagateContainerEvents&&t.panelContainer.css("pointer-events","none"),t._$animate.pin&&t._$animate.pin(t.panelContainer,getElement(t.config.attachTo)),t._configureTrapFocus(),t._addStyles().then(function(){n(t)},e)},e)})},MdPanelRef.prototype._addStyles=function(){var t=this;return this._$q(function(n){t.panelContainer.css("z-index",t.config.zIndex),t.panelEl.css("z-index",t.config.zIndex+1);var e=function(){t.panelEl.css("left",""),t.panelContainer.addClass(MD_PANEL_HIDDEN),n(t)};if(t.config.fullscreen)return t.panelEl.addClass("_md-panel-fullscreen"),void e();var i=t.config.position;return i?void t._$rootScope.$$postDigest(function(){t._updatePosition(!0),n(t)}):void e()})},MdPanelRef.prototype.updatePosition=function(t){if(!this.panelContainer)throw new Error("Panel does not exist yet. Call open() or attach().");this.config.position=t,this._updatePosition()},MdPanelRef.prototype._updatePosition=function(t){var n=this.config.position;if(n){n._setPanelPosition(this.panelEl),t&&this.panelContainer.addClass(MD_PANEL_HIDDEN),this.panelEl.css(MdPanelPosition.absPosition.TOP,n.getTop()),this.panelEl.css(MdPanelPosition.absPosition.BOTTOM,n.getBottom()),this.panelEl.css(MdPanelPosition.absPosition.LEFT,n.getLeft()),this.panelEl.css(MdPanelPosition.absPosition.RIGHT,n.getRight());var e=this._$mdConstant.CSS.TRANSFORM;this.panelEl.css(e,n.getTransform())}},MdPanelRef.prototype._focusOnOpen=function(){if(this.config.focusOnOpen){var t=this;this._$rootScope.$$postDigest(function(){var n=t._$mdUtil.findFocusTarget(t.panelEl)||t.panelEl;n.focus()})}},MdPanelRef.prototype._createBackdrop=function(){if(this.config.hasBackdrop){if(!this._backdropRef){var t=this._$mdPanel.newPanelAnimation().openFrom(this.config.attachTo).withAnimation({open:"_md-opaque-enter",close:"_md-opaque-leave"}),n={animation:t,attachTo:this.config.attachTo,focusOnOpen:!1,panelClass:"_md-panel-backdrop",zIndex:this.config.zIndex-1};this._backdropRef=this._$mdPanel.create(n)}if(!this._backdropRef.isAttached)return this._backdropRef.attach()}},MdPanelRef.prototype._addEventListeners=function(){this._configureEscapeToClose(),this._configureClickOutsideToClose(),this._configureScrollListener()},MdPanelRef.prototype._removeEventListeners=function(){this._removeListeners&&this._removeListeners.forEach(function(t){t()}),this._removeListeners=[]},MdPanelRef.prototype._configureEscapeToClose=function(){if(this.config.escapeToClose){var t=getElement(this.config.attachTo),n=this,e=function(t){t.keyCode===n._$mdConstant.KEY_CODE.ESCAPE&&(t.stopPropagation(),t.preventDefault(),n.close())};this.panelContainer.on("keydown",e),t.on("keydown",e),this._removeListeners.push(function(){n.panelContainer.off("keydown",e),t.off("keydown",e)})}},MdPanelRef.prototype._configureClickOutsideToClose=function(){if(this.config.clickOutsideToClose){var t,n=this.panelContainer,e=function(n){t=n.target},i=this,o=function(e){t===n[0]&&e.target===n[0]&&(e.stopPropagation(),e.preventDefault(),i.close())};n.on("mousedown",e),n.on("mouseup",o),this._removeListeners.push(function(){n.off("mousedown",e),n.off("mouseup",o)})}},MdPanelRef.prototype._configureScrollListener=function(){var t=angular.bind(this,this._updatePosition),n=this._$$rAF.throttle(t),e=this,i=function(){e.config.disableParentScroll||n()};this._$window.addEventListener("scroll",i,!0),this._removeListeners.push(function(){e._$window.removeEventListener("scroll",i,!0)})},MdPanelRef.prototype._configureTrapFocus=function(){if(this.panelEl.attr("tabIndex","-1"),this.config.trapFocus){var t=this.panelEl;this._topFocusTrap=FOCUS_TRAP_TEMPLATE.clone()[0],this._bottomFocusTrap=FOCUS_TRAP_TEMPLATE.clone()[0];var n=function(){t.focus()};this._topFocusTrap.addEventListener("focus",n),this._bottomFocusTrap.addEventListener("focus",n),this._removeListeners.push(this._simpleBind(function(){this._topFocusTrap.removeEventListener("focus",n),this._bottomFocusTrap.removeEventListener("focus",n)},this)),t[0].parentNode.insertBefore(this._topFocusTrap,t[0]),t.after(this._bottomFocusTrap)}},MdPanelRef.prototype._animateOpen=function(){this.panelContainer.addClass("md-panel-is-showing");var t=this.config.animation;if(!t)return this.panelContainer.addClass("_md-panel-shown"),this._$q.when(this);var n=this;return this._$q(function(e){var i=n._done(e,n),o=function(){n._$log.warn("MdPanel Animations failed. Showing panel without animating."),i()};t.animateOpen(n.panelEl).then(i,o)})},MdPanelRef.prototype._animateClose=function(){var t=this.config.animation;if(!t)return this.panelContainer.removeClass("md-panel-is-showing"),this.panelContainer.removeClass("_md-panel-shown"),this._$q.when(this);var n=this;return this._$q(function(e){var i=function(){n.panelContainer.removeClass("md-panel-is-showing"),e(n)},o=function(){n._$log.warn("MdPanel Animations failed. Hiding panel without animating."),i()};t.animateClose(n.panelEl).then(i,o)})},MdPanelRef.prototype._simpleBind=function(t,n){return function(e){return t.apply(n,e)}},MdPanelRef.prototype._done=function(t,n){return function(){t(n)}},MdPanelPosition.xPosition={CENTER:"center",ALIGN_START:"align-start",ALIGN_END:"align-end",OFFSET_START:"offset-start",OFFSET_END:"offset-end"},MdPanelPosition.yPosition={CENTER:"center",ALIGN_TOPS:"align-tops",ALIGN_BOTTOMS:"align-bottoms",ABOVE:"above",BELOW:"below"},MdPanelPosition.absPosition={TOP:"top",RIGHT:"right",BOTTOM:"bottom",LEFT:"left"},MdPanelPosition.prototype.absolute=function(){return this._absolute=!0,this},MdPanelPosition.prototype._setPosition=function(t,n){if(t===MdPanelPosition.absPosition.RIGHT||t===MdPanelPosition.absPosition.LEFT)this._left=this._right="";else{if(t!==MdPanelPosition.absPosition.BOTTOM&&t!==MdPanelPosition.absPosition.TOP){var e=Object.keys(MdPanelPosition.absPosition).join().toLowerCase();throw new Error("Position must be one of "+e+".")}this._top=this._bottom=""}return this["_"+t]=angular.isString(n)?n:"0",this},MdPanelPosition.prototype.top=function(t){return this._setPosition(MdPanelPosition.absPosition.TOP,t)},MdPanelPosition.prototype.bottom=function(t){return this._setPosition(MdPanelPosition.absPosition.BOTTOM,t)},MdPanelPosition.prototype.start=function(t){var n=this._isRTL?MdPanelPosition.absPosition.RIGHT:MdPanelPosition.absPosition.LEFT;return this._setPosition(n,t)},MdPanelPosition.prototype.end=function(t){var n=this._isRTL?MdPanelPosition.absPosition.LEFT:MdPanelPosition.absPosition.RIGHT;return this._setPosition(n,t)},MdPanelPosition.prototype.left=function(t){return this._setPosition(MdPanelPosition.absPosition.LEFT,t)},MdPanelPosition.prototype.right=function(t){return this._setPosition(MdPanelPosition.absPosition.RIGHT,t)},MdPanelPosition.prototype.centerHorizontally=function(){return this._left="50%",this._right="",this._translateX=["-50%"],this},MdPanelPosition.prototype.centerVertically=function(){return this._top="50%",this._bottom="",this._translateY=["-50%"],this},MdPanelPosition.prototype.center=function(){return this.centerHorizontally().centerVertically()},MdPanelPosition.prototype.relativeTo=function(t){return this._absolute=!1,this._relativeToEl=getElement(t),this},MdPanelPosition.prototype.addPanelPosition=function(t,n){if(!this._relativeToEl)throw new Error("addPanelPosition can only be used with relative positioning. Set relativeTo first.");return this._validateXPosition(t),this._validateYPosition(n),this._positions.push({x:t,y:n}),this},MdPanelPosition.prototype._validateYPosition=function(t){if(null!=t){for(var n,e=Object.keys(MdPanelPosition.yPosition),i=[],o=0;n=e[o];o++){var a=MdPanelPosition.yPosition[n];if(i.push(a),a===t)return}throw new Error("Panel y position only accepts the following values:\n"+i.join(" | "))}},MdPanelPosition.prototype._validateXPosition=function(t){if(null!=t){for(var n,e=Object.keys(MdPanelPosition.xPosition),i=[],o=0;n=e[o];o++){var a=MdPanelPosition.xPosition[n];if(i.push(a),a===t)return}throw new Error("Panel x Position only accepts the following values:\n"+i.join(" | "))}},MdPanelPosition.prototype.withOffsetX=function(t){return this._translateX.push(t),this},MdPanelPosition.prototype.withOffsetY=function(t){return this._translateY.push(t),this},MdPanelPosition.prototype.getTop=function(){return this._top},MdPanelPosition.prototype.getBottom=function(){return this._bottom},MdPanelPosition.prototype.getLeft=function(){return this._left},MdPanelPosition.prototype.getRight=function(){return this._right},MdPanelPosition.prototype.getTransform=function(){var t=this._reduceTranslateValues("translateX",this._translateX),n=this._reduceTranslateValues("translateY",this._translateY);return(t+" "+n).trim()},MdPanelPosition.prototype._isOnscreen=function(t){var n=parseInt(this.getLeft()),e=parseInt(this.getTop()),i=n+t[0].offsetWidth,o=e+t[0].offsetHeight;return n>=0&&e>=0&&o<=this._$window.innerHeight&&i<=this._$window.innerWidth},MdPanelPosition.prototype.getActualPosition=function(){return this._actualPosition},MdPanelPosition.prototype._reduceTranslateValues=function(t,n){return n.map(function(n){return t+"("+n+")"}).join(" ")},MdPanelPosition.prototype._setPanelPosition=function(t){if(!this._absolute){if(this._actualPosition)return void this._calculatePanelPosition(t,this._actualPosition);for(var n=0;n<this._positions.length&&(this._actualPosition=this._positions[n],this._calculatePanelPosition(t,this._actualPosition),!this._isOnscreen(t));n++);}},MdPanelPosition.prototype._reverseXPosition=function(t){if(t!==MdPanelPosition.xPosition.CENTER){var n="start",e="end";return t.indexOf(n)>-1?t.replace(n,e):t.replace(e,n)}},MdPanelPosition.prototype._bidi=function(t){return this._isRTL?this._reverseXPosition(t):t},MdPanelPosition.prototype._calculatePanelPosition=function(t,n){var e=t[0].getBoundingClientRect(),i=e.width,o=e.height,a=this._relativeToEl[0].getBoundingClientRect(),s=a.left,r=a.right,l=a.width;switch(this._bidi(n.x)){case MdPanelPosition.xPosition.OFFSET_START:this._left=s-i+"px";break;case MdPanelPosition.xPosition.ALIGN_END:this._left=r-i+"px";break;case MdPanelPosition.xPosition.CENTER:var h=s+.5*l-.5*i;this._left=h+"px";break;case MdPanelPosition.xPosition.ALIGN_START:this._left=s+"px";break;case MdPanelPosition.xPosition.OFFSET_END:this._left=r+"px"}var c=a.top,p=a.bottom,d=a.height;switch(n.y){case MdPanelPosition.yPosition.ABOVE:this._top=c-o+"px";break;case MdPanelPosition.yPosition.ALIGN_BOTTOMS:this._top=p-o+"px";break;case MdPanelPosition.yPosition.CENTER:var u=c+.5*d-.5*o;this._top=u+"px";break;case MdPanelPosition.yPosition.ALIGN_TOPS:this._top=c+"px";break;case MdPanelPosition.yPosition.BELOW:this._top=p+"px"}},MdPanelAnimation.animation={SLIDE:"md-panel-animate-slide",SCALE:"md-panel-animate-scale",FADE:"md-panel-animate-fade"},MdPanelAnimation.prototype.openFrom=function(t){return t=t.target?t.target:t,this._openFrom=this._getPanelAnimationTarget(t),this._closeTo||(this._closeTo=this._openFrom),this},MdPanelAnimation.prototype.closeTo=function(t){return this._closeTo=this._getPanelAnimationTarget(t),this},MdPanelAnimation.prototype._getPanelAnimationTarget=function(t){return angular.isDefined(t.top)||angular.isDefined(t.left)?{element:void 0,bounds:{top:t.top||0,left:t.left||0}}:this._getBoundingClientRect(getElement(t))},MdPanelAnimation.prototype.withAnimation=function(t){return this._animationClass=t,this},MdPanelAnimation.prototype.animateOpen=function(t){var n=this._$mdUtil.dom.animator;this._fixBounds(t);var e={},i=t[0].style.transform||"",o=n.toTransformCss(i),a=n.toTransformCss(i);switch(this._animationClass){case MdPanelAnimation.animation.SLIDE:t.css("opacity","1"),e={transitionInClass:"_md-panel-animate-enter"};var s=n.calculateSlideToOrigin(t,this._openFrom)||"";o=n.toTransformCss(s+" "+i);break;case MdPanelAnimation.animation.SCALE:e={transitionInClass:"_md-panel-animate-enter"};var r=n.calculateZoomToOrigin(t,this._openFrom)||"";o=n.toTransformCss(r+" "+i);break;case MdPanelAnimation.animation.FADE:e={transitionInClass:"_md-panel-animate-enter"};break;default:e=angular.isString(this._animationClass)?{transitionInClass:this._animationClass}:{transitionInClass:this._animationClass.open,transitionOutClass:this._animationClass.close}}return n.translate3d(t,o,a,e)},MdPanelAnimation.prototype.animateClose=function(t){var n=this._$mdUtil.dom.animator,e={},i=t[0].style.transform||"",o=n.toTransformCss(i),a=n.toTransformCss(i);switch(this._animationClass){case MdPanelAnimation.animation.SLIDE:t.css("opacity","1"),e={transitionInClass:"_md-panel-animate-leave"};var s=n.calculateSlideToOrigin(t,this._closeTo)||"";a=n.toTransformCss(s+" "+i);break;case MdPanelAnimation.animation.SCALE:e={transitionInClass:"_md-panel-animate-scale-out _md-panel-animate-leave"};var r=n.calculateZoomToOrigin(t,this._closeTo)||"";a=n.toTransformCss(r+" "+i);break;case MdPanelAnimation.animation.FADE:e={transitionInClass:"_md-panel-animate-fade-out _md-panel-animate-leave"};break;default:e=angular.isString(this._animationClass)?{transitionOutClass:this._animationClass}:{transitionInClass:this._animationClass.close,transitionOutClass:this._animationClass.open}}return n.translate3d(t,o,a,e)},MdPanelAnimation.prototype._fixBounds=function(t){var n=t[0].offsetWidth,e=t[0].offsetHeight;this._openFrom&&null==this._openFrom.bounds.height&&(this._openFrom.bounds.height=e),this._openFrom&&null==this._openFrom.bounds.width&&(this._openFrom.bounds.width=n),this._closeTo&&null==this._closeTo.bounds.height&&(this._closeTo.bounds.height=e),this._closeTo&&null==this._closeTo.bounds.width&&(this._closeTo.bounds.width=n)},MdPanelAnimation.prototype._getBoundingClientRect=function(t){if(t instanceof angular.element)return{element:t,bounds:t[0].getBoundingClientRect()}},ngmaterial.components.panel=angular.module("material.components.panel");